/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.model;

import edu.csus.ecs.pc2.core.model.ClarificationAnswer;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Submission;
import java.util.ArrayList;

public class Clarification
extends Submission {
    private static final long serialVersionUID = -6913818225948370496L;
    private boolean deleted = false;
    private ClientId whoCheckedItOutId = null;
    private String question = null;
    private ArrayList<ClarificationAnswer> answerList = new ArrayList();
    private ClarificationStates state = ClarificationStates.NEW;

    public Clarification(ClientId submitter, Problem problemId, String question) {
        this.setSubmitter(submitter);
        this.setProblemId(problemId.getElementId());
        this.question = question;
        this.setElementId(new ElementId("Clarification"));
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getAnswer() {
        if (this.answerList.size() == 0) {
            return null;
        }
        return this.getFirstAnswer().getAnswer();
    }

    private ClarificationAnswer getFirstAnswer() {
        return this.answerList.get(0);
    }

    public void setAnswer(String answer, ClientId client, ContestTime contestTime, boolean sendToAll) {
        this.state = ClarificationStates.ANSWERED;
        ClarificationAnswer clarificationAnswer = new ClarificationAnswer(answer, client, sendToAll, contestTime);
        this.addAnswer(clarificationAnswer);
    }

    public boolean isAnswered() {
        return this.state == ClarificationStates.ANSWERED;
    }

    public boolean isNew() {
        return this.state == ClarificationStates.NEW;
    }

    public String getQuestion() {
        return this.question;
    }

    public ClarificationStates getState() {
        return this.state;
    }

    public void setState(ClarificationStates state) {
        this.state = state;
    }

    public boolean isSendToAll() {
        if (this.answerList.size() == 0) {
            return false;
        }
        return this.getFirstAnswer().isSendToAll();
    }

    public String toString() {
        return "Clarification " + this.getNumber() + " " + (Object)((Object)this.getState()) + " from " + this.getSubmitter() + " at " + this.getElapsedMins() + " id=" + this.getElementId();
    }

    public ClientId getWhoJudgedItId() {
        if (this.answerList.size() == 0) {
            return null;
        }
        return this.getFirstAnswer().getAnswerClient();
    }

    public boolean isSameAs(Clarification clarification) {
        block11: {
            block10: {
                block9: {
                    block8: {
                        block7: {
                            try {
                                if (this.deleted == clarification.isDeleted()) break block7;
                                return false;
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        if (this.getWhoJudgedItId().equals(clarification.getWhoJudgedItId())) break block8;
                        return false;
                    }
                    if (this.question.equals(clarification.getQuestion())) break block9;
                    return false;
                }
                if (this.getAnswer().equals(clarification.getAnswer())) break block10;
                return false;
            }
            if (this.state == clarification.getState()) break block11;
            return false;
        }
        return this.isSendToAll() == clarification.isSendToAll();
    }

    public ClientId getWhoCheckedItOutId() {
        return this.whoCheckedItOutId;
    }

    public void setWhoCheckedItOutId(ClientId whoCheckedItOut) {
        this.whoCheckedItOutId = whoCheckedItOut;
    }

    public void addAnswer(ClarificationAnswer clarificationAnswer) {
        this.state = ClarificationStates.ANSWERED;
        this.answerList.add(clarificationAnswer);
    }

    public ClarificationAnswer[] getClarificationAnswers() {
        return this.answerList.toArray(new ClarificationAnswer[this.answerList.size()]);
    }

    public static enum ClarificationStates {
        NEW,
        BEING_ANSWERED,
        HOLD,
        ANSWERED;

    }
}

