/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.log;

import edu.csus.ecs.pc2.core.log.MessageFactory;
import edu.csus.ecs.pc2.core.model.InternalContest;
import edu.csus.ecs.pc2.core.packet.Packet;
import java.io.Serializable;
import java.util.Date;

public class LogEvent
implements Serializable {
    private static final long serialVersionUID = -7120130020057851256L;
    private Severity severity = Severity.NORMAL;
    private String message;
    private String eventType;
    private Date whenOcurred;

    public LogEvent(Severity severity, InternalContest contest, Packet packet) {
        this.severity = severity;
        this.eventType = packet.getType().toString();
        this.message = MessageFactory.createMessage(contest, packet);
    }

    public LogEvent(Severity severity, Packet packet) {
        this.severity = severity;
        this.eventType = packet.getType().toString();
        this.message = MessageFactory.createMessage(null, packet);
    }

    public LogEvent(Severity severity, String eventType, String message) {
        this.severity = severity;
        this.message = message;
        this.eventType = eventType;
    }

    public String toString() {
        return this.whenOcurred + " " + (Object)((Object)this.severity) + " " + this.eventType + " " + this.message;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Date getWhenOcurred() {
        return this.whenOcurred;
    }

    public void setWhenOcurred(Date whenOcurred) {
        this.whenOcurred = whenOcurred;
    }

    public static enum Severity {
        NORMAL,
        SEVERE;

    }
}

