/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.imports;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.imports.ccs.CCSListUtilities;
import edu.csus.ecs.pc2.ui.InvalidFieldValue;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class SubmissionsTSVFile
implements UIPlugin {
    private static final long serialVersionUID = -967846946268411808L;
    private boolean checkRunSubmissionFiles = false;
    private Problem[] problems = new Problem[0];
    private IInternalContest internalContest;
    private Language[] languages = new Language[0];
    private String sourceDirectoryName = ".";

    public Run[] loadRuns(String filename) throws IOException {
        String[] contents = Utilities.loadFile(filename);
        String[] lines = CCSListUtilities.filterOutCommentLines(contents);
        Run[] runs = this.createRuns(lines);
        return runs;
    }

    public Run createRun(String line) throws FileNotFoundException {
        String[] fields = line.split("\t");
        int fieldNo = 0;
        int runNumber = Integer.parseInt(fields[fieldNo++]);
        ClientId clientId = this.determineClient(fields[fieldNo++]);
        Problem problem = this.determineProblem(fields[fieldNo++]);
        long submittedMS = Long.parseLong(fields[fieldNo++]);
        Language language = this.getContest().getLanguages()[0];
        if (this.checkRunSubmissionFiles) {
            String mainfilename = this.fetchSubmissionFilename(runNumber);
            language = this.determineLanguage(mainfilename);
        }
        Run run = new Run(clientId, language, problem);
        run.setNumber(runNumber);
        run.setElapsedMS(submittedMS);
        return run;
    }

    public Problem determineProblem(String string) {
        Problem[] problemArray = this.problems;
        int n = this.problems.length;
        int n2 = 0;
        while (n2 < n) {
            int offset;
            char let;
            Problem problem = problemArray[n2];
            if (problem.getDisplayName().equalsIgnoreCase(string)) {
                return problem;
            }
            if (string.length() == 1 && Character.isLetter(let = string.toUpperCase().charAt(0)) && (offset = let - 65) >= 0 && offset < this.problems.length) {
                return this.problems[offset];
            }
            if (problem.getShortName().equalsIgnoreCase(string)) {
                return problem;
            }
            ++n2;
        }
        throw new InvalidFieldValue("Problem " + string + " not matched/found");
    }

    int getSiteNumber() {
        if (this.getContest() != null) {
            return this.getContest().getSiteNumber();
        }
        return 1;
    }

    private ClientId determineClient(String string) {
        int teamNumber = Integer.parseInt(string);
        return new ClientId(this.getSiteNumber(), ClientType.Type.TEAM, teamNumber);
    }

    private IInternalContest getContest() {
        return this.internalContest;
    }

    public Language determineLanguage(String mainfilename) {
        String[] langDefs = new String[]{".cpp=GNU C++", ".C=GNU C++", ".java=Java", ".c=GNU C", ".c=C", ".cpp=C++", ".C=C++", ".dpr=Pascal/Kylix", ".pas=Pascal/Kylix"};
        int lastOccurIndex = mainfilename.lastIndexOf(46);
        if (lastOccurIndex == -1) {
            return null;
        }
        String extension = mainfilename.substring(lastOccurIndex);
        String[] stringArray = langDefs;
        int n = langDefs.length;
        int n2 = 0;
        while (n2 < n) {
            Language language;
            String string = stringArray[n2];
            String[] fields = string.split("=");
            if (fields[0].trim().equals(extension) && (language = this.findMatchingLanguage(fields[1])) != null) {
                return language;
            }
            ++n2;
        }
        throw new InvalidFieldValue("Unable to determine language for file " + mainfilename);
    }

    public final Language findMatchingLanguage(String name) {
        Language[] languageArray = this.languages;
        int n = this.languages.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            if (language.getDisplayName().equalsIgnoreCase(name)) {
                return language;
            }
            ++n2;
        }
        return null;
    }

    public String getSubmissionDirctoryName(int runNumber) {
        return String.valueOf(this.sourceDirectoryName) + File.separator + "run" + String.format("%04d", runNumber);
    }

    public String fetchSubmissionFilename(int runNumber) throws FileNotFoundException {
        String submissonFileDirectoryname = this.getSubmissionDirctoryName(runNumber);
        File dir = new File(submissonFileDirectoryname);
        if (dir.isDirectory()) {
            File[] list;
            File[] fileArray = list = dir.listFiles();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    return file.getAbsolutePath();
                }
                ++n2;
            }
        } else {
            throw new FileNotFoundException("No directory for submission files found at " + submissonFileDirectoryname);
        }
        throw new FileNotFoundException("No submission files found for run " + runNumber + " in dir " + submissonFileDirectoryname);
    }

    public Run[] createRuns(String[] lines) throws FileNotFoundException {
        ArrayList<Run> runList = new ArrayList<Run>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Run run = this.createRun(line);
            runList.add(run);
            ++n2;
        }
        return runList.toArray(new Run[runList.size()]);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.setContest(this.internalContest);
    }

    public String fetchSubmissionFilename(Run run) throws FileNotFoundException {
        return this.fetchSubmissionFilename(run.getNumber());
    }

    @Override
    public String getPluginTitle() {
        return "Load submissions.tsv";
    }

    public boolean isCheckRunSubmissionFiles() {
        return this.checkRunSubmissionFiles;
    }

    public void setCheckRunSubmissionFiles(boolean checkRunSubmissionFiles) {
        this.checkRunSubmissionFiles = checkRunSubmissionFiles;
    }

    public void setContest(IInternalContest inContest) {
        this.internalContest = inContest;
        this.languages = this.getContest().getLanguages();
        this.problems = this.getContest().getProblems();
    }

    public void setSourceDirectoryName(String sourceDirectoryName) {
        this.sourceDirectoryName = sourceDirectoryName;
    }

    public String getSourceDirectoryName() {
        return this.sourceDirectoryName;
    }
}

