/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.imports;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.imports.ccs.ICPCTSVLoader;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;

public class LoadICPCTSVData
implements UIPlugin {
    private static final long serialVersionUID = 1611218320856176033L;
    public static final String TEAMS_FILENAME = "teams.tsv";
    public static final String GROUPS_FILENAME = "groups.tsv";
    private String teamsFilename = "";
    private String groupsFilename = "";
    private IInternalContest contest;
    private IInternalController controller;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    public boolean loadFiles(String filename) throws Exception {
        if (this.checkFiles(filename)) {
            Group[] groups;
            Group[] groupArray = groups = ICPCTSVLoader.loadGroups(this.groupsFilename);
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Group group = groupArray[n2];
                group.setSite(this.getContest().getSites()[0].getElementId());
                ++n2;
            }
            Account[] accounts = ICPCTSVLoader.loadAccounts(this.teamsFilename);
            String nl = System.getProperty("line.separator");
            String message = "Add " + nl + accounts.length + " accounts and " + nl + groups.length + " groups?";
            int result = FrameUtilities.yesNoCancelDialog(null, message, "Load TSV files");
            if (result == 0) {
                Group[] updatedGroups;
                List<Group> groupList = Arrays.asList(groups);
                List<Account> accountList = Arrays.asList(accounts);
                this.updateGroupsAndAccounts(this.contest, groupList, accountList);
                Group[] groupArray2 = updatedGroups = groupList.toArray(new Group[groupList.size()]);
                int n3 = updatedGroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    Group group = groupArray2[n4];
                    this.getController().updateGroup(group);
                    ++n4;
                }
                Account[] updatedAccounts = accountList.toArray(new Account[accountList.size()]);
                this.getController().updateAccounts(updatedAccounts);
                this.info("Load from file " + this.groupsFilename);
                this.info("Load from file " + this.teamsFilename);
                this.info("Added " + accounts.length + " accounts and " + groups.length + " groups.");
                return true;
            }
            return false;
        }
        return false;
    }

    private void info(String message) {
        this.getController().getLog().info(message);
    }

    protected void updateGroupsAndAccounts(IInternalContest inContest, List<Group> groupList, List<Account> accountList) {
        int i = 0;
        for (Group group : groupList) {
            Group existingGroup = this.lookupGroup(inContest, group.getGroupId());
            if (existingGroup != null) {
                existingGroup.updateFrom(group);
            } else {
                existingGroup = group;
            }
            groupList.set(i, existingGroup);
            ++i;
        }
        i = 0;
        for (Account account : accountList) {
            Account existingAccount = inContest.getAccount(account.getClientId());
            if (existingAccount != null) {
                existingAccount.updateFrom(account);
            } else {
                existingAccount = account;
            }
            accountList.set(i, existingAccount);
            ++i;
        }
    }

    private Group lookupGroup(IInternalContest contest2, int externalId) {
        Group[] groups;
        Group[] groupArray = groups = contest2.getGroups();
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            Group group = groupArray[n2];
            if (group.getGroupId() == externalId) {
                return group;
            }
            ++n2;
        }
        return null;
    }

    protected boolean checkFiles(String filename) throws Exception {
        File file = new File(filename);
        if (!file.isFile()) {
            throw new FileNotFoundException("File not found: " + filename);
        }
        if (filename.endsWith(TEAMS_FILENAME)) {
            this.teamsFilename = filename;
            this.groupsFilename = filename;
            this.groupsFilename = this.groupsFilename.replaceFirst(TEAMS_FILENAME, GROUPS_FILENAME);
        } else if (filename.endsWith(GROUPS_FILENAME)) {
            this.teamsFilename = filename;
            this.groupsFilename = filename;
            this.teamsFilename = this.teamsFilename.replaceFirst(GROUPS_FILENAME, TEAMS_FILENAME);
        } else {
            throw new Exception("Must select either teams.tsv or groups.tsv");
        }
        file = new File(this.teamsFilename);
        if (!file.isFile()) {
            throw new FileNotFoundException("File not found: " + this.teamsFilename);
        }
        file = new File(this.groupsFilename);
        if (!file.isFile()) {
            throw new FileNotFoundException("File not found: " + this.groupsFilename);
        }
        return true;
    }

    @Override
    public String getPluginTitle() {
        return "Load TSV Files";
    }

    public IInternalController getController() {
        return this.controller;
    }

    public final String getGroupsFilename() {
        return this.groupsFilename;
    }

    public final String getTeamsFilename() {
        return this.teamsFilename;
    }
}

