/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.export;

import edu.csus.ecs.pc2.core.XMLUtilities;
import edu.csus.ecs.pc2.core.list.RunComparator;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import edu.csus.ecs.pc2.exports.ccs.EventFeedXML;
import java.io.IOException;
import java.util.Arrays;

public class RunStatisticsXML {
    public static final String ROOT_TAG = "run_statistics";

    public String toXML(IInternalContest contest, Filter filter) throws IOException {
        IMemento memento;
        EventFeedXML eventFeedXML = new EventFeedXML();
        XMLMemento mementoRoot = XMLMemento.createWriteRoot(ROOT_TAG);
        int idx = 1;
        IElementObject[] iElementObjectArray = contest.getLanguages();
        int n = iElementObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = iElementObjectArray[n2];
            if (filter.matches(language)) {
                memento = mementoRoot.createChild("language");
                eventFeedXML.addMemento(memento, contest, language, idx);
            }
            eventFeedXML.addMemento((IMemento)mementoRoot, contest, language, idx);
            ++idx;
            ++n2;
        }
        idx = 1;
        iElementObjectArray = contest.getProblems();
        n = iElementObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            IElementObject problem = iElementObjectArray[n2];
            if (filter.matches((Problem)problem)) {
                memento = mementoRoot.createChild("problem");
                eventFeedXML.addMemento(memento, contest, (Problem)problem, idx);
            }
            ++idx;
            ++n2;
        }
        Run[] runs = contest.getRuns();
        Arrays.sort(runs, new RunComparator());
        Run[] runArray = runs;
        int n3 = runs.length;
        n = 0;
        while (n < n3) {
            Run run = runArray[n];
            if (filter.matches(run)) {
                IMemento memento2 = mementoRoot.createChild("run");
                this.addMemento(memento2, contest, run);
            }
            ++n;
        }
        return mementoRoot.saveToString();
    }

    protected String getProblemLetter(int id) {
        char let = 'A';
        let = (char)(let + (id - 1));
        return Character.toString(let);
    }

    private int getProblemIndex(IInternalContest contest, Problem inProblem) {
        int idx = 0;
        Problem[] problemArray = contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problem.getElementId().equals(inProblem.getElementId())) {
                return idx + 1;
            }
            ++idx;
            ++n2;
        }
        return -1;
    }

    protected IMemento addMemento(IMemento memento, IInternalContest contest, Run run) {
        memento.putInteger("id", run.getNumber());
        memento.putInteger("team-id", run.getSubmitter().getClientNumber());
        Problem problem = contest.getProblem(run.getProblemId());
        int problemIndex = this.getProblemIndex(contest, problem);
        memento.putInteger("problem-id", problemIndex);
        memento.putString("problem-name", problem.getDisplayName());
        Language language = contest.getLanguage(run.getLanguageId());
        XMLUtilities.addChild(memento, "language", language.getDisplayName());
        if (run.isJudged()) {
            ElementId judgementId = run.getJudgementRecord().getJudgementId();
            String judgement = contest.getJudgement(judgementId).getAcronym();
            XMLUtilities.addChild(memento, "judgement", judgement.toUpperCase().substring(0, 2));
            XMLUtilities.addChild(memento, "result", judgement.toUpperCase().substring(0, 2));
            XMLUtilities.addChild(memento, "solved", run.isSolved());
            XMLUtilities.addChild(memento, "execute-time-ms", run.getJudgementRecord().getExecuteMS());
        }
        XMLUtilities.addChild(memento, "elapsed-Mins", run.getElapsedMins());
        XMLUtilities.addChild(memento, "contest-time", XMLUtilities.formatSeconds(run.getElapsedMS()));
        XMLUtilities.addChild(memento, "timestamp", XMLUtilities.getTimeStamp());
        return memento;
    }
}

