/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;

public final class JudgementUtilites {
    private JudgementUtilites() {
    }

    public static JudgementRecord createJudgementRecord(IInternalContest contest, Run run, ExecutionData executionData, String validationResults) {
        JudgementRecord judgementRecord = null;
        if (executionData.getExecutionException() != null) {
            ElementId elementId = contest.getJudgements()[1].getElementId();
            judgementRecord = new JudgementRecord(elementId, contest.getClientId(), false, true, true);
            Judgement judgement = JudgementUtilites.findJudgementByAcronym(contest, "JE");
            if (judgement == null) {
                judgement = contest.getJudgements()[1];
            }
            judgementRecord.setValidatorResultString("Execption during execution " + executionData.getExecutionException().getMessage());
        } else if (!executionData.isCompileSuccess()) {
            ElementId elementId = contest.getJudgements()[1].getElementId();
            judgementRecord = new JudgementRecord(elementId, contest.getClientId(), false, true, true);
            judgementRecord.setValidatorResultString("No - Compilation Error");
        } else if (executionData.isValidationSuccess()) {
            String results = validationResults;
            if (results == null) {
                results = "Undetermined";
            }
            if (results.trim().length() == 0) {
                results = "Undetermined";
            }
            boolean solved = false;
            ElementId elementId = contest.getJudgements()[1].getElementId();
            Judgement[] judgementArray = contest.getJudgements();
            int n = judgementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Judgement judgement = judgementArray[n2];
                if (judgement.getDisplayName().equals(results)) {
                    elementId = judgement.getElementId();
                }
                ++n2;
            }
            Judgement yesJudgement = contest.getJudgements()[0];
            if (results.trim().equalsIgnoreCase("accepted")) {
                results = yesJudgement.getDisplayName();
            }
            if (yesJudgement.getDisplayName().equalsIgnoreCase(results)) {
                elementId = yesJudgement.getElementId();
                solved = true;
            }
            judgementRecord = new JudgementRecord(elementId, contest.getClientId(), solved, true, true);
            judgementRecord.setValidatorResultString(results);
        } else {
            ElementId elementId = contest.getJudgements()[1].getElementId();
            judgementRecord = new JudgementRecord(elementId, contest.getClientId(), false, true, true);
            judgementRecord.setValidatorResultString("Undetermined");
        }
        return judgementRecord;
    }

    private static Judgement findJudgementByAcronym(IInternalContest contest, String acronym) {
        Judgement[] judgements;
        Judgement[] judgementArray = judgements = contest.getJudgements();
        int n = judgements.length;
        int n2 = 0;
        while (n2 < n) {
            Judgement judgement = judgementArray[n2];
            if (judgement.getAcronym().equals(acronym)) {
                return judgement;
            }
            ++n2;
        }
        return null;
    }
}

