/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core.execute;

import edu.csus.ecs.pc2.core.execute.ExecuteTimer;
import edu.csus.ecs.pc2.core.log.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;

public class IOCollector
extends Thread {
    private BufferedInputStream bufReader;
    private BufferedOutputStream outWriter;
    private boolean stopIt = false;
    private ExecuteTimer localTimer = null;
    private long maxFileSize;
    private Log log = null;
    private static final String NL = System.getProperty("line.separator");

    public IOCollector(Log log, BufferedInputStream inReader, BufferedOutputStream printer, ExecuteTimer myTimer, long newMaxFileSize) {
        this.log = log;
        this.maxFileSize = newMaxFileSize;
        this.bufReader = inReader;
        this.outWriter = printer;
        this.localTimer = myTimer;
    }

    protected void finalize() throws Throwable {
        this.bufReader = null;
        this.outWriter = null;
        this.localTimer = null;
    }

    public void haltMe() {
        this.stopIt = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        long offset = 0L;
        byte[] cbuf = new byte[32768];
        try {
            int c = this.bufReader.read(cbuf);
            while (true) {
                if (this.stopIt || c == -1 || offset >= this.maxFileSize) {
                    if (this.stopIt) {
                        this.outWriter.write((String.valueOf(NL) + "Output halted by operator" + NL).getBytes());
                    }
                    if (offset >= this.maxFileSize) {
                        this.outWriter.write((String.valueOf(NL) + "Output exceeds maximum file size " + new Long(this.maxFileSize).toString() + NL).getBytes());
                    }
                    try {
                        c = this.bufReader.read(cbuf);
                        while (!this.stopIt) {
                            if (c == -1) {
                                return;
                            }
                            c = this.bufReader.read(cbuf);
                        }
                        return;
                    }
                    catch (Exception exception) {
                        this.log.log(Log.DEBUG, "IOCollector:Run: caught notImportant exception");
                        return;
                    }
                }
                offset += (long)c;
                this.outWriter.write(cbuf, 0, c);
                c = this.bufReader.read(cbuf);
            }
        }
        catch (Exception ex) {
            this.log.log(Log.CONFIG, "ioCollector - Exception in run() ", ex);
        }
    }
}

