/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import java.io.Serializable;

public final class StringUtilities
implements Serializable {
    private static final long serialVersionUID = -4197938292232525730L;
    private static final String ELLIPSIS = "...";

    private StringUtilities() {
    }

    public static boolean stringSame(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean stringArraySame(String[] s1, String[] s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        int i = 0;
        while (i < s1.length) {
            if (!StringUtilities.stringSame(s1[i], s2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String cloneString(String s) {
        if (s != null) {
            return new String(s);
        }
        return s;
    }

    public static String join(String delimit, String[] strings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buffer.append(strings[i]);
            if (i < strings.length - 1) {
                buffer.append(delimit);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String[] appendString(String[] originalArray, String string) {
        String[] newArray = new String[originalArray.length + 1];
        System.arraycopy(originalArray, 0, newArray, 0, originalArray.length);
        newArray[originalArray.length] = string;
        return newArray;
    }

    public static String trunc(String string, int maxlen) {
        if (string.length() <= maxlen) {
            return string;
        }
        return String.valueOf(string.substring(0, maxlen - ELLIPSIS.length())) + ELLIPSIS;
    }

    public static boolean isEmpty(String name) {
        return name == null || "".equals(name.trim());
    }

    public static String[] cloneStringArray(String[] strings) {
        String[] names = new String[strings.length];
        int i = 0;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            names[i] = StringUtilities.cloneString(name);
            ++i;
            ++n2;
        }
        return names;
    }
}

