/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.ContestLoader;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IStorage;
import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.exception.ClarificationUnavailableException;
import edu.csus.ecs.pc2.core.exception.ContestSecurityException;
import edu.csus.ecs.pc2.core.exception.ProfileCloneException;
import edu.csus.ecs.pc2.core.exception.ProfileException;
import edu.csus.ecs.pc2.core.exception.RunUnavailableException;
import edu.csus.ecs.pc2.core.exception.UnableToUncheckoutRunException;
import edu.csus.ecs.pc2.core.list.ClientIdComparator;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.list.RunFilesList;
import edu.csus.ecs.pc2.core.log.EvaluationLog;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Category;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.CloneException;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestLoginSuccessData;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.InternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.MessageEvent;
import edu.csus.ecs.pc2.core.model.PlaybackInfo;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.ProfileChangeStatus;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunExecutionStatus;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.RunUtilities;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.Submission;
import edu.csus.ecs.pc2.core.model.playback.PlaybackManager;
import edu.csus.ecs.pc2.core.model.playback.PlaybackRecord;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.core.packet.PacketType;
import edu.csus.ecs.pc2.core.security.FileSecurity;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import edu.csus.ecs.pc2.profile.ProfileCloneSettings;
import edu.csus.ecs.pc2.profile.ProfileManager;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class PacketHandler {
    private IInternalContest contest = null;
    private IInternalController controller = null;
    private EvaluationLog evaluationLog = null;

    public PacketHandler(IInternalController controller, IInternalContest contest) {
        this.controller = controller;
        this.contest = contest;
    }

    public PacketHandler(InternalController controller, IInternalContest contest) {
        this.controller = controller;
        this.contest = contest;
    }

    public void handlePacket(Packet packet, ConnectionHandlerID connectionHandlerID) throws Exception {
        PacketType.Type packetType = packet.getType();
        this.info("handlePacket start " + packet);
        PacketFactory.dumpPacket(this.controller.getLog(), packet, "handlePacket");
        if (Utilities.isDebugMode()) {
            PacketFactory.dumpPacket(System.out, packet, "handlePacket");
        }
        ClientId fromId = packet.getSourceId();
        switch (packetType) {
            case MESSAGE: {
                PacketFactory.dumpPacket(System.err, packet, null);
                this.handleMessagePacket(packet);
                break;
            }
            case RUN_SUBMISSION_CONFIRM: {
                this.handleRunSubmissionConfirmation(packet);
                break;
            }
            case RUN_SUBMISSION: {
                this.runSubmission(packet, fromId);
                break;
            }
            case RUN_SUBMISSION_CONFIRM_SERVER: {
                this.handleRunSubmissionConfirmationServer(packet, fromId);
                break;
            }
            case CLARIFICATION_SUBMISSION: {
                this.confirmSubmission(packet, fromId);
                break;
            }
            case CLARIFICATION_ANSWER: {
                this.answerClarification(packet, connectionHandlerID);
                break;
            }
            case CLARIFICATION_ANSWER_UPDATE: {
                this.sendAnswerClarification(packet);
                break;
            }
            case CLARIFICATION_SUBMISSION_CONFIRM: {
                Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
                this.contest.addClarification(clarification);
                if (!this.isServer()) break;
                this.controller.sendToJudgesAndOthers(packet, this.isThisSite(clarification));
                break;
            }
            case CLARIFICATION_UNCHECKOUT: {
                this.cancelClarificationCheckOut(packet, connectionHandlerID);
                break;
            }
            case CLARIFICATION_CHECKOUT: {
                this.checkoutClarification(packet, connectionHandlerID);
                break;
            }
            case CLARIFICATION_AVAILABLE: {
                this.sendClarificationAvailable(packet);
                break;
            }
            case LOGIN_FAILED: {
                String message = PacketFactory.getStringValue(packet, "MESSAGE_STRING");
                this.contest.loginDenied(packet.getDestinationId(), connectionHandlerID, message);
                break;
            }
            case CLARIFICATION_NOT_AVAILABLE: {
                Clarification clar = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
                this.contest.clarificationNotAvailable(clar);
                if (!this.isServer()) break;
                this.controller.sendToJudgesAndOthers(packet, this.isThisSite(clar));
                break;
            }
            case RUN_NOTAVAILABLE: {
                this.handleRunNotAvailable(packet);
                break;
            }
            case FORCE_DISCONNECTION: {
                this.sendForceDisconnection(packet);
                break;
            }
            case ESTABLISHED_CONNECTION: {
                this.establishConnection(packet, connectionHandlerID);
                break;
            }
            case DROPPED_CONNECTION: {
                this.droppedConnection(packet, connectionHandlerID);
                break;
            }
            case RUN_AVAILABLE: {
                this.runAvailable(packet);
                break;
            }
            case RUN_JUDGEMENT: {
                this.acceptRunJudgement(packet, connectionHandlerID);
                break;
            }
            case RUN_JUDGEMENT_UPDATE: {
                this.sendJudgementUpdate(packet);
                break;
            }
            case RUN_UPDATE: {
                this.updateRun(packet, connectionHandlerID);
                break;
            }
            case RUN_UPDATE_NOTIFICATION: {
                this.sendRunUpdateNotification(packet);
                break;
            }
            case RUN_UNCHECKOUT: {
                this.handleRunUnCheckout(packet, connectionHandlerID);
                break;
            }
            case START_ALL_CLOCKS: {
                this.startContest(packet, connectionHandlerID);
                if (!this.isThisSite(packet.getSourceId())) break;
                this.controller.sendToServers(packet);
                break;
            }
            case STOP_ALL_CLOCKS: {
                this.stopContest(packet, connectionHandlerID);
                if (!this.isThisSite(packet.getSourceId())) break;
                this.controller.sendToServers(packet);
                break;
            }
            case START_CONTEST_CLOCK: {
                this.startContest(packet, connectionHandlerID);
                break;
            }
            case STOP_CONTEST_CLOCK: {
                this.stopContest(packet, connectionHandlerID);
                break;
            }
            case UPDATE_CONTEST_CLOCK: {
                this.updateContestClock(packet);
                break;
            }
            case CLOCK_STARTED: {
                this.startClock(packet);
                break;
            }
            case CLOCK_STOPPED: {
                this.clockStopped(packet);
                break;
            }
            default: {
                this.handleOtherPacketTypes(packetType, fromId, packet, connectionHandlerID);
            }
        }
    }

    private void handleOtherPacketTypes(PacketType.Type packetType, ClientId fromId, Packet packet, ConnectionHandlerID connectionHandlerID) throws Exception {
        switch (packetType) {
            case ADD_SETTING: {
                this.addNewSetting(packet);
                break;
            }
            case DELETE_SETTING: {
                this.deleteSetting(packet);
                break;
            }
            case GENERATE_ACCOUNTS: {
                this.generateAccounts(packet);
                break;
            }
            case UPDATE_SETTING: {
                this.updateSetting(packet);
                break;
            }
            case RUN_CHECKOUT: 
            case RUN_CHECKOUT_NOTIFICATION: {
                this.runCheckout(packet, packetType);
                break;
            }
            case RUN_REJUDGE_CHECKOUT: {
                this.runCheckout(packet, packetType);
                break;
            }
            case CLARIFICATION_REQUEST: {
                this.requestClarification(packet, connectionHandlerID);
                break;
            }
            case RUN_REQUEST: {
                this.runRequest(packet, connectionHandlerID);
                break;
            }
            case RUN_REJUDGE_REQUEST: {
                this.requestRejudgeRun(packet, connectionHandlerID);
                break;
            }
            case LOGOUT: {
                this.logoutClient(packet);
                break;
            }
            case LOGIN: {
                this.loginClient(packet);
                break;
            }
            case PASSWORD_CHANGE_REQUEST: {
                this.attemptChangePassword(packet);
                break;
            }
            case PASSWORD_CHANGE_RESULTS: {
                this.handlePasswordChangeResults(packet);
                break;
            }
            case LOGIN_SUCCESS: {
                this.loginSuccess(packet, connectionHandlerID, fromId);
                break;
            }
            case SERVER_SETTINGS: {
                this.handleServerSettings(packet, connectionHandlerID);
                break;
            }
            case RECONNECT_SITE_REQUEST: {
                this.reconnectSite(packet);
                break;
            }
            case SECURITY_MESSAGE: {
                this.handleSecurityMessage(packet);
                break;
            }
            case FETCH_RUN: {
                this.requestFetchedRun(packet, connectionHandlerID);
                break;
            }
            case FETCHED_REQUESTED_RUN: {
                this.handleFetchedRun(packet, connectionHandlerID);
                break;
            }
            case RUN_EXECUTION_STATUS: {
                this.handleRunExecutionStatus(packet, connectionHandlerID);
                break;
            }
            case RESET_ALL_CONTESTS: {
                this.resetAllSites(packet, connectionHandlerID);
                break;
            }
            case CLONE_PROFILE: {
                this.handleCloneProfile(packet, connectionHandlerID);
                break;
            }
            case SWITCH_PROFILE: {
                this.handleSwitchProfile(packet, connectionHandlerID);
                break;
            }
            case UPDATE_CLIENT_PROFILE: {
                this.handleUpdateClientProfile(packet, connectionHandlerID);
                break;
            }
            case FETCH_RUN_FILES: {
                this.handleFetchRunFiles(packet, connectionHandlerID);
            }
            case UPDATE_RUN_FILES: {
                this.handleRunFilesList(packet, connectionHandlerID);
                break;
            }
            case REQUEST_SERVER_STATUS: {
                this.handleRequestServerStatus(packet, connectionHandlerID);
                break;
            }
            case SERVER_STATUS: {
                this.handleServerStatus(packet, connectionHandlerID);
                break;
            }
            case SYNCHRONIZE_REMOTE_DATA: {
                this.handleSynchronizeRemoteData(packet, connectionHandlerID);
                break;
            }
            case REQUEST_REMOTE_DATA: {
                this.handleRequestRemoteData(packet, connectionHandlerID);
                break;
            }
            case UPDATE_REMOTE_DATA: {
                this.loginSuccess(packet, connectionHandlerID, fromId);
                break;
            }
            case SHUTDOWN: {
                this.handleServerShutdown(packet, connectionHandlerID, fromId);
                break;
            }
            case SHUTDOWN_ALL: {
                this.handleShutdownAllServers(packet, connectionHandlerID, fromId);
                break;
            }
            case START_PLAYBACK: {
                this.handleStartPlayback(packet, connectionHandlerID, fromId);
                break;
            }
            case STOP_PLAYBACK: {
                this.handleStopPlayback(packet, connectionHandlerID, fromId);
                break;
            }
            case AUTO_REGISTRATION_SUCCESS: {
                this.handleAutoRegistratioSuccess(packet, connectionHandlerID);
                break;
            }
            default: {
                Exception exception = new Exception("PacketHandler.handlePacket Unhandled packet " + packet);
                this.controller.getLog().log(Log.WARNING, "Unhandled Packet ", exception);
            }
        }
        this.info("handlePacket end " + packet);
    }

    private void handleAutoRegistratioSuccess(Packet packet, ConnectionHandlerID connectionHandlerID) {
        Account account = (Account)PacketFactory.getObjectValue(packet, "ACCOUNT");
        String message = String.valueOf(account.getDisplayName()) + ":;" + account.getClientId().getName() + ":;" + account.getPassword();
        this.contest.addMessage(MessageEvent.Area.AUTOREG, packet.getSourceId(), packet.getDestinationId(), message);
    }

    private void handleStopPlayback(Packet packet, ConnectionHandlerID connectionHandlerID, ClientId fromId) throws Exception {
        this.securityCheck(Permission.Type.STOP_PLAYBACK, fromId, connectionHandlerID);
        PlaybackInfo playbackInfo = (PlaybackInfo)PacketFactory.getObjectValue(packet, "PLAYBACK_INFO");
        this.contest.stopReplayPlaybackInfo(playbackInfo);
    }

    private void handleStartPlayback(Packet packet, ConnectionHandlerID connectionHandlerID, ClientId fromId) throws Exception {
        PlaybackInfo playbackInfo = (PlaybackInfo)PacketFactory.getObjectValue(packet, "PLAYBACK_INFO");
        if (this.isServer()) {
            if (playbackInfo.isStarted()) {
                this.securityCheck(Permission.Type.START_PLAYBACK, fromId, connectionHandlerID);
            } else {
                this.securityCheck(Permission.Type.STOP_PLAYBACK, fromId, connectionHandlerID);
            }
            PlaybackManager manager = this.contest.getPlaybackManager();
            PlaybackInfo currentPlaybackInfo = manager.getPlaybackInfo();
            if (currentPlaybackInfo.getReplayList().length == 0) {
                currentPlaybackInfo = manager.createPlaybackInfo(playbackInfo.getFilename(), this.contest);
            }
            currentPlaybackInfo.setWaitBetweenEventsMS(playbackInfo.getWaitBetweenEventsMS());
            currentPlaybackInfo.setMinimumPlaybackRecords(playbackInfo.getMinimumPlaybackRecords());
            this.contest.getPlaybackManager().insureMinimumPlaybackRecords(currentPlaybackInfo.getMinimumPlaybackRecords());
            if (!manager.isPlaybackRunning() && playbackInfo.isStarted()) {
                manager.startPlayback(this.contest, this.controller, new Runnable(){

                    @Override
                    public void run() {
                        PlaybackManager manager = PacketHandler.this.contest.getPlaybackManager();
                        PlaybackRecord record = manager.getCurrentPlaybackRecord();
                        PacketHandler.this.controller.getLog().info("Playback started running=" + manager.isPlaybackRunning() + " sequence " + manager.getSequenceNumber() + " status=" + (Object)((Object)record.getEventStatus()) + " " + record.getReplayEvent());
                    }
                });
            }
            if (manager.isPlaybackRunning() && !playbackInfo.isStarted()) {
                manager.setPlaybackRunning(false);
                currentPlaybackInfo.setStarted(false);
            }
            this.contest.updatePlaybackInfo(currentPlaybackInfo);
            PlaybackInfo newPlaybackInfo = currentPlaybackInfo.cloneShallow();
            if (currentPlaybackInfo.isStarted()) {
                Packet startPacket = PacketFactory.createStartAllClocks(this.getServerClientId(), PacketFactory.ALL_SERVERS, fromId);
                this.startContest(startPacket, connectionHandlerID);
            }
            Packet updatePacket = PacketFactory.createUpdateSetting(this.getServerClientId(), PacketFactory.ALL_SERVERS, newPlaybackInfo);
            this.controller.sendToAdministrators(updatePacket);
            this.controller.sendToServers(updatePacket);
        } else {
            this.contest.updatePlaybackInfo(playbackInfo);
        }
    }

    private void handleSynchronizeRemoteData(Packet packet, ConnectionHandlerID connectionHandlerID) {
        Packet requestPacket = PacketFactory.createRequestRemoteDataPacket(this.getServerClientId(), PacketFactory.ALL_SERVERS);
        this.controller.sendToServers(requestPacket);
    }

    private void handleRequestRemoteData(Packet packet, ConnectionHandlerID connectionHandlerID) {
        int targetSiteId = packet.getSourceId().getSiteNumber();
        this.info("Start send remote data to site " + targetSiteId);
        ClientId remoteServerId = new ClientId(targetSiteId, ClientType.Type.SERVER, 0);
        Packet requestedPacket = this.createLoginSuccessPacket(remoteServerId, this.contest.getContestPassword());
        Packet remoteDataPacket = PacketFactory.clonePacket(PacketType.Type.UPDATE_REMOTE_DATA, this.getServerClientId(), remoteServerId, requestedPacket);
        this.controller.sendToClient(remoteDataPacket);
        this.info("Sent remote data to site " + targetSiteId);
    }

    private void handleRunSubmissionConfirmationServer(Packet packet, ClientId fromId) throws IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        RunFiles runFiles = (RunFiles)PacketFactory.getObjectValue(packet, "RUN_FILES");
        this.contest.addRun(run, runFiles);
        if (this.isServer()) {
            Packet confirmPacket = PacketFactory.createRunSubmissionConfirm(this.contest.getClientId(), fromId, run);
            this.controller.sendToJudgesAndOthers(confirmPacket, false);
        } else if (Utilities.isDebugMode()) {
            Exception ex = new Exception("Non server was send a " + (Object)((Object)packet.getType()) + " packet");
            ex.printStackTrace();
            this.controller.logWarning("Unexpected packet on client", ex);
        }
    }

    private void handleSwitchProfile(Packet packet, ConnectionHandlerID connectionHandlerID) throws ProfileException, IOException, ClassNotFoundException, FileSecurityException {
        IInternalContest newContest;
        Profile newProfile = (Profile)PacketFactory.getObjectValue(packet, "NEW_PROFILE");
        String contestPassword = (String)PacketFactory.getObjectValue(packet, "CONTEST_PASSWORD");
        if (newProfile.getSiteNumber() == 0) {
            newProfile.setSiteNumber(this.contest.getSiteNumber());
        }
        if (contestPassword == null) {
            contestPassword = this.contest.getContestPassword();
        }
        if (!new File(newProfile.getProfilePath()).isDirectory()) {
            throw new ProfileException("Unable to switch - can not find profile on disk");
        }
        ProfileManager manager = new ProfileManager();
        if (!manager.isProfileAvailable(newProfile, this.contest.getSiteNumber(), contestPassword.toCharArray())) {
            throw new ProfileException("Can not switch profiles, invalid contest password");
        }
        this.contest = newContest = this.switchProfile(this.contest, newProfile, contestPassword.toCharArray(), true);
        this.sendStatusToServers(packet, newProfile);
    }

    protected IInternalContest switchProfile(IInternalContest currentContest, Profile newProfile, char[] contestPassword, boolean sendToOtherServers) throws ProfileException, IOException, ClassNotFoundException, FileSecurityException {
        return this.switchProfile(currentContest, newProfile, contestPassword, sendToOtherServers, null, sendToOtherServers);
    }

    protected IInternalContest switchProfile(IInternalContest currentContest, Profile newProfile, char[] contestPassword, boolean sendToOtherServers, Packet packet, boolean sendToServers) throws ProfileException, IOException, ClassNotFoundException, FileSecurityException {
        if (this.contest.getProfile().getName().equals(newProfile.getName())) {
            PacketFactory.dumpPacket(System.out, packet, "switch packet, tried to switch to same profile");
            throw new ProfileException("Attempted to switch to the same profile: " + newProfile.getName());
        }
        ProfileManager manager = new ProfileManager();
        InternalContest newContest = new InternalContest();
        this.info("Start switching to profile " + this.contest.getProfile().getName() + " contest id = " + this.contest.getContestIdentifier());
        newContest.setClientId(this.contest.getClientId());
        if (newContest.getSiteNumber() == 0) {
            newContest.setSiteNumber(this.contest.getSiteNumber());
        }
        this.info("switchProfile start - to " + newProfile + " as Site " + this.contest.getSiteNumber() + " as user " + newContest.getClientId());
        IStorage storage = manager.getProfileStorage(newProfile, this.contest.getSiteNumber(), contestPassword);
        newContest.setStorage(storage);
        this.info("switchProfile save config to " + storage.getDirectoryName());
        newContest.setContestPassword(new String(contestPassword));
        try {
            newContest.readConfiguration(this.contest.getSiteNumber(), this.controller.getLog());
        }
        catch (Exception e) {
            throw new ProfileException(newProfile, "Unable to read configuration ", e);
        }
        if (newContest.getProfile() == null) {
            newContest.setProfile(newProfile);
        }
        try {
            newContest.storeConfiguration(this.controller.getLog());
        }
        catch (Exception e) {
            throw new ProfileException(newProfile, "Unable to store configuration ", e);
        }
        this.contest.removeAllListeners();
        try {
            this.contest.cloneAllLoginAndConnections(newContest);
        }
        catch (CloneException e) {
            this.info(e);
        }
        this.controller.updateContestController(newContest, this.controller);
        this.contest = newContest;
        if (packet != null) {
            this.updateSitesToModel(packet);
            ContestLoader loader = new ContestLoader();
            this.loadSettingsFromRemoteServer(loader, packet, null);
            loader = null;
            this.contest.storeConfiguration(this.controller.getLog());
        }
        this.contest.fireAllRefreshEvents();
        this.storeProfiles();
        this.sendOutChangeProfileToAllClients(this.contest, currentContest.getProfile(), this.contest.getProfile(), new String(contestPassword), sendToServers);
        this.info("switchProfile done - to " + this.contest.getProfile() + " as Site " + this.contest.getSiteNumber() + " as user " + newContest.getClientId());
        this.info("Switched to profile " + this.contest.getProfile().getName() + " contest id = " + this.contest.getContestIdentifier());
        if (!this.controller.isUsingGUI() || Utilities.isDebugMode()) {
            System.out.println(new Date() + " Switched to profile " + this.contest.getProfile().getName() + " contest id = " + this.contest.getContestIdentifier());
        }
        Profile profile = this.contest.getProfile();
        if (!this.controller.isUsingGUI()) {
            System.out.println(new Date() + " Switch to Profile: " + profile.getName() + " @ " + profile.getProfilePath());
        }
        this.info("Switch to Profile: " + profile.getName() + " @ " + profile.getProfilePath());
        return this.contest;
    }

    protected void sendOutChangeProfileToAllClients(IInternalContest newContest, Profile currentProfile, Profile switchToProfile, String contestPassword, boolean sendToServers) {
        ClientId[] teams;
        ClientType.Type[] typeList;
        Packet packet;
        ContestLoginSuccessData data;
        if (sendToServers) {
            data = this.createContestLoginSuccessData(newContest, this.getServerClientId(), contestPassword);
            packet = PacketFactory.createUpdateProfileClientPacket(this.getServerClientId(), PacketFactory.ALL_SERVERS, currentProfile, switchToProfile, data);
            this.sendClonePacketToUsers(packet, ClientType.Type.SERVER, newContest, false);
        }
        data = this.createContestLoginSuccessData(newContest, this.getServerClientId(), null);
        packet = PacketFactory.createUpdateProfileClientPacket(this.getServerClientId(), PacketFactory.ALL_SERVERS, currentProfile, switchToProfile, data);
        ClientType.Type[] typeArray = typeList = new ClientType.Type[]{ClientType.Type.ADMINISTRATOR, ClientType.Type.JUDGE, ClientType.Type.SCOREBOARD};
        int n = typeList.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type type = typeArray[n2];
            this.sendClonePacketToUsers(packet, type, newContest, true);
            ++n2;
        }
        ClientId[] clientIdArray = teams = this.contest.getLocalLoggedInClients(ClientType.Type.TEAM);
        int n3 = teams.length;
        n = 0;
        while (n < n3) {
            ClientId clientId = clientIdArray[n];
            if (newContest.getAccount(clientId) != null) {
                data = this.createContestLoginSuccessData(newContest, clientId, null);
                packet = PacketFactory.createUpdateProfileClientPacket(this.getServerClientId(), clientId, currentProfile, switchToProfile, data);
                this.controller.sendToClient(packet);
            } else {
                this.controller.getLog().info("Not sending UPDATE_CLIENT_PROFILE to client not found in new profile/account list " + clientId);
            }
            ++n;
        }
    }

    private void sendClonePacketToUsers(Packet packet, ClientType.Type type, IInternalContest newContest, boolean confirmUserExists) {
        ClientId[] users;
        ClientId[] clientIdArray = users = this.contest.getLocalLoggedInClients(type);
        int n = users.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId clientId = clientIdArray[n2];
            try {
                if (!confirmUserExists) {
                    packet = PacketFactory.clonePacket(this.getServerClientId(), clientId, packet);
                    this.controller.sendToClient(packet);
                } else if (newContest.getAccount(clientId) != null) {
                    packet = PacketFactory.clonePacket(this.getServerClientId(), clientId, packet);
                    this.controller.sendToClient(packet);
                } else {
                    this.controller.getLog().info("Not sending UPDATE_CLIENT_PROFILE to client not found in new profile/account list " + clientId);
                }
            }
            catch (Exception e) {
                this.controller.logWarning("Trouble sending clone packet to " + clientId, e);
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleUpdateClientProfile(Packet packet, ConnectionHandlerID connectionHandlerID) throws IOException, ClassNotFoundException, FileSecurityException, ProfileException, ProfileCloneException {
        if (this.isServer()) {
            IInternalContest newContest;
            ProfileManager manager;
            Profile newProfile = (Profile)PacketFactory.getObjectValue(packet, "NEW_PROFILE");
            String contestPassword = (String)PacketFactory.getObjectValue(packet, "CONTEST_PASSWORD");
            newProfile.setSiteNumber(this.contest.getSiteNumber());
            if (contestPassword == null) {
                contestPassword = this.contest.getContestPassword();
            }
            if ((manager = new ProfileManager()).createProfilesPathandFiles(newProfile, this.contest.getSiteNumber(), contestPassword)) {
                IStorage storage = this.createStorage(newProfile, contestPassword);
                int siteNumber = this.contest.getSiteNumber();
                IInternalContest contest2 = this.initializeContest(storage, siteNumber);
                this.createProfileFromPacket(newProfile, contest2, packet, connectionHandlerID);
                contest2.storeConfiguration(this.controller.getLog());
            }
            if (!manager.isProfileAvailable(newProfile, this.contest.getSiteNumber(), contestPassword.toCharArray())) throw new ProfileException("Can not switch profiles, invalid contest password");
            PacketFactory.dumpPacket(System.out, packet, "handleUpdateClientProfile switchProfile");
            this.contest = newContest = this.switchProfile(this.contest, newProfile, contestPassword.toCharArray(), false, packet, false);
            this.sendStatusToServers(packet, newProfile);
            return;
        } else {
            this.contest.resetSubmissionData();
            this.contest.resetConfigurationData();
            this.unRegisterPlugins();
            ContestLoader loader = new ContestLoader();
            loader.loadDataIntoModel(this.contest, this.controller, packet, connectionHandlerID);
            loader = null;
            this.reRegisterPlugins();
            this.info("handleUpdateClientProfile fireAllRefreshEvents start");
            long start = new Date().getTime();
            System.err.println("debug22 handleUpdateClientProfile fireAllRefreshEvents start " + new Date());
            this.contest.fireAllRefreshEvents();
            long elapsed = (new Date().getTime() - start) / 1000L;
            System.err.println("debug22 handleUpdateClientProfile fireAllRefreshEvents done " + new Date());
            System.err.println("debug22 handleUpdateClientProfile fireAllRefreshEvents elapsed " + elapsed);
        }
    }

    private void unRegisterPlugins() {
        this.contest.removeAllListeners();
    }

    private void reRegisterPlugins() {
        UIPlugin[] uIPluginArray = this.controller.getPluginList();
        int n = uIPluginArray.length;
        int n2 = 0;
        while (n2 < n) {
            UIPlugin plugin = uIPluginArray[n2];
            try {
                plugin.setContestAndController(this.contest, this.controller);
                this.controller.getLog().info("plugin.setContestAndController for " + plugin.getPluginTitle());
            }
            catch (Exception e) {
                this.controller.logWarning("Problem registering plugin " + plugin.getPluginTitle(), e);
            }
            ++n2;
        }
    }

    private IInternalContest initializeContest(IStorage storage, int siteNumber) {
        InternalContest newContest = new InternalContest();
        newContest.setSiteNumber(siteNumber);
        newContest.setStorage(storage);
        newContest.initializeSubmissions(siteNumber);
        return newContest;
    }

    private IStorage createStorage(Profile newProfile, String contestPassword) throws ProfileCloneException {
        String profilePath = newProfile.getProfilePath();
        try {
            new File(profilePath).mkdirs();
        }
        catch (Exception e) {
            throw new ProfileCloneException("Unable to create profile dir " + profilePath, e);
        }
        if (!new File(profilePath).isDirectory()) {
            throw new ProfileCloneException("Unable to use profile dir " + profilePath);
        }
        String databaseDirectoryName = String.valueOf(profilePath) + File.separator + "db." + this.contest.getSiteNumber();
        try {
            new File(databaseDirectoryName).mkdirs();
        }
        catch (Exception e) {
            throw new ProfileCloneException("Unable to create DB dir " + profilePath, e);
        }
        FileSecurity fileSecurity = new FileSecurity(databaseDirectoryName);
        try {
            fileSecurity.saveSecretKey(contestPassword.toCharArray());
        }
        catch (Exception e) {
            throw new ProfileCloneException(e);
        }
        return fileSecurity;
    }

    private void createProfileFromPacket(Profile newProfile, IInternalContest contest2, Packet packet, ConnectionHandlerID connectionHandlerID) throws IOException, ClassNotFoundException, FileSecurityException {
        if (packet.getType().equals((Object)PacketType.Type.UPDATE_CLIENT_PROFILE)) {
            ContestLoader loader = new ContestLoader();
            loader.loadDataIntoModel(contest2, this.controller, packet, connectionHandlerID);
            loader = null;
        } else {
            new ProfileException("Can not create profile from packet type " + packet.getType().toString());
        }
    }

    private void handleRunFilesList(Packet packet, ConnectionHandlerID connectionHandlerID) throws Exception {
        RunFiles[] files = (RunFiles[])PacketFactory.getObjectValue(packet, "RUN_FILES_LIST");
        if (files != null) {
            RunFiles[] runFilesArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    RunFiles runFiles = runFilesArray[n2];
                    try {
                        Run run = this.contest.getRun(runFiles.getRunId());
                        if (!this.isThisSite(run.getSiteNumber())) {
                            this.contest.updateRunFiles(run, runFiles);
                            break block6;
                        }
                        throw new Exception("Will not update local run files " + run);
                    }
                    catch (Exception e) {
                        this.controller.logWarning("Unable to save run files", e);
                    }
                }
                ++n2;
            }
        } else {
            throw new Exception("RUN_FILES are null from packet " + packet);
        }
    }

    private void handleFetchRunFiles(Packet packet, ConnectionHandlerID connectionHandlerID) {
        int siteNumber = packet.getSourceId().getSiteNumber();
        int lastRunId = (Integer)PacketFactory.getObjectValue(packet, "RUN_ID");
        this.sendRunFilesToServer(siteNumber, lastRunId);
        this.info("Send Sync RunFiles to site " + siteNumber);
    }

    private void handleCloneProfile(Packet packet, ConnectionHandlerID connectionHandlerID) {
        try {
            ProfileCloneSettings settings = (ProfileCloneSettings)PacketFactory.getObjectValue(packet, "PROFILE_CLONE_SETTINGS");
            boolean switchProfileNow = (Boolean)PacketFactory.getObjectValue(packet, "SWITCH_PROFILE");
            Profile newProfile = this.cloneContest(packet, settings, switchProfileNow);
            settings.setProfilePath(newProfile.getProfilePath());
            this.notifyAllOfClonedContest(packet, newProfile, settings);
        }
        catch (Exception e) {
            this.sendMessage(MessageEvent.Area.PROFILES, "Unable to clone profile", e);
            this.info(e);
        }
    }

    private Profile cloneContest(Packet packet, ProfileCloneSettings settings, boolean switchProfileNow) {
        Profile newProfile = new Profile(settings.getName());
        newProfile.setDescription(settings.getDescription());
        newProfile.setSiteNumber(this.contest.getSiteNumber());
        if (settings.getProfilePath() != null) {
            newProfile.setProfilePath(settings.getProfilePath());
        }
        this.info("Start clone to profile " + newProfile.getName());
        Profile addedProfile = this.contest.addProfile(newProfile);
        InternalContest newContest = new InternalContest();
        newContest.setSiteNumber(this.contest.getSiteNumber());
        try {
            this.contest.clone(newContest, addedProfile, settings);
            this.contest.storeConfiguration(this.controller.getLog());
            this.storeProfiles();
            if (switchProfileNow) {
                this.switchProfile(this.contest, newProfile, this.contest.getContestPassword().toCharArray(), true);
            }
            this.info("Done clone to profile " + newProfile.getName());
        }
        catch (Exception e) {
            this.sendMessage(MessageEvent.Area.PROFILES, "Unable to clone using packet " + packet, e);
            this.info("Failed to clone to profile");
            this.info(e);
        }
        return newProfile;
    }

    private void handleServerSettings(Packet packet, ConnectionHandlerID connectionHandlerID) {
        ContestLoader loader = new ContestLoader();
        this.loadSettingsFromRemoteServer(loader, packet, connectionHandlerID);
        loader = null;
        this.info(" handlePacket SERVER_SETTINGS - from another site -- all settings loaded " + packet);
        if (this.isServer()) {
            this.controller.sendToJudgesAndOthers(packet, false);
        }
    }

    private void handleRunNotAvailable(Packet packet) {
        ClientId clientId;
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        this.contest.runNotAvailable(run);
        if (this.isServer() && this.isThisSite(clientId = packet.getDestinationId())) {
            this.controller.sendToClient(packet);
        }
    }

    private void handleRunUnCheckout(Packet packet, ConnectionHandlerID connectionHandlerID) throws IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoCanceledId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        this.cancelRun(packet, run, whoCanceledId, connectionHandlerID);
    }

    private void handleRunSubmissionConfirmation(Packet packet) throws IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        this.contest.addRun(run);
        if (this.isServer()) {
            this.controller.sendToJudgesAndOthers(packet, this.isThisSite(run));
        }
    }

    private void resetAllSites(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, ProfileCloneException, ProfileException, IOException, ClassNotFoundException, FileSecurityException {
        ClientId sourceId = packet.getSourceId();
        ClientId adminClientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        this.securityCheck(Permission.Type.RESET_CONTEST, adminClientId, connectionHandlerID);
        if (!this.isServer()) {
            throw new ContestSecurityException(sourceId, connectionHandlerID, sourceId + " not allowed to " + (Object)((Object)Permission.Type.RESET_CONTEST));
        }
        Profile profile = (Profile)PacketFactory.getObjectValue(packet, "PROFILE");
        this.resetContest(packet, profile);
    }

    private void resetContest(Packet packet, Profile profile) throws ProfileCloneException, ProfileException, IOException, ClassNotFoundException, FileSecurityException {
        Boolean eraseProblems = (Boolean)PacketFactory.getObjectValue(packet, "DELETE_PROBLEM_DEFINITIONS");
        Boolean eraseLanguages = (Boolean)PacketFactory.getObjectValue(packet, "DELETE_LANGUAGE_DEFINITIONS");
        if (this.isServer()) {
            ClientId adminClientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
            if (!this.contest.isAllowed(adminClientId, Permission.Type.SWITCH_PROFILE)) {
                this.info("permission is not granted to " + adminClientId + " to reset");
            } else {
                this.info("permission is granted to " + adminClientId + " to reset");
            }
            Profile updatedProfile = this.contest.getProfile();
            updatedProfile.setActive(false);
            updatedProfile.setName("Backup of " + updatedProfile.getName());
            InternalContest newContest = new InternalContest();
            newContest.setClientId(this.contest.getClientId());
            if (newContest.getSiteNumber() == 0) {
                newContest.setSiteNumber(this.contest.getSiteNumber());
            }
            newContest.addProfile(updatedProfile);
            String title = this.contest.getContestInformation().getContestTitle();
            String description = profile.getDescription();
            String password = this.contest.getContestPassword();
            ProfileCloneSettings settings = new ProfileCloneSettings(profile.getName(), description, password.toCharArray(), this.contest.getProfile());
            settings.setContestTitle(title);
            settings.setResetContestTimes(true);
            settings.setCopyAccounts(true);
            settings.setCopyContestSettings(true);
            settings.setCopyGroups(true);
            settings.setCopyJudgements(true);
            settings.setCopyNotifications(true);
            settings.setCopyLanguages(eraseLanguages == false);
            settings.setCopyProblems(eraseProblems == false);
            settings.setCopyRuns(false);
            settings.setCopyClarifications(false);
            settings.setCopyCategories(false);
            settings.setContestPassword(this.contest.getContestPassword().toCharArray());
            Profile newProfile = this.cloneContest(packet, settings, true);
            settings.setProfilePath(newProfile.getProfilePath());
            this.notifyAllOfClonedContest(packet, newProfile, settings);
        } else {
            this.contest.setProfile(profile);
            this.resetContestData(eraseProblems, eraseLanguages);
            this.contest.fireAllRefreshEvents();
        }
    }

    private void notifyAllOfClonedContest(Packet packet, Profile newProfile, ProfileCloneSettings settings) {
        this.contest.addProfile(newProfile);
        Packet addPacket = PacketFactory.createAddSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, newProfile);
        this.controller.sendToJudgesAndOthers(addPacket, false);
        if (this.isThisSite(packet.getSourceId())) {
            this.controller.sendToServers(packet);
        }
    }

    private void removeAllProblemsFromAutoJudging() {
        Account[] accounts;
        Vector<Account> vectorAccounts = this.contest.getAccounts(ClientType.Type.JUDGE, this.contest.getSiteNumber());
        Account[] accountArray = accounts = vectorAccounts.toArray(new Account[vectorAccounts.size()]);
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            ClientSettings clientSettings = new ClientSettings(account.getClientId());
            clientSettings.setAutoJudging(false);
            clientSettings.setAutoJudgeFilter(new Filter());
            ++n2;
        }
    }

    private void resetContestData(Boolean eraseProblems, Boolean eraseLanguages) {
        int n;
        int n2;
        IElementObject[] iElementObjectArray;
        this.contest.resetSubmissionData();
        if (eraseProblems != null && eraseProblems.booleanValue()) {
            iElementObjectArray = this.contest.getProblems();
            n2 = iElementObjectArray.length;
            n = 0;
            while (n < n2) {
                IElementObject problem = iElementObjectArray[n];
                this.contest.deleteProblem((Problem)problem);
                ++n;
            }
            this.removeAllProblemsFromAutoJudging();
        }
        if (eraseLanguages != null && eraseLanguages.booleanValue()) {
            iElementObjectArray = this.contest.getLanguages();
            n2 = iElementObjectArray.length;
            n = 0;
            while (n < n2) {
                IElementObject language = iElementObjectArray[n];
                this.contest.deleteLanguage((Language)language);
                ++n;
            }
        }
    }

    private ClientId getServerClientId() {
        return new ClientId(this.contest.getSiteNumber(), ClientType.Type.SERVER, 0);
    }

    private void handleRunExecutionStatus(Packet packet, ConnectionHandlerID connectionHandlerID) {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId judgeClientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        RunExecutionStatus status = (RunExecutionStatus)((Object)PacketFactory.getObjectValue(packet, "RUN_STATUS"));
        if (this.isServer()) {
            if (!this.isThisSite(judgeClientId)) {
                this.sendToSpectatorsAndSites(packet, false);
            } else {
                Packet runExecuteStatusPacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, packet);
                this.sendToSpectatorsAndSites(runExecuteStatusPacket, true);
            }
        } else {
            this.contest.updateRunStatus(run, status, judgeClientId);
        }
    }

    private void requestFetchedRun(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoRequestsRunId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        this.securityCheck(Permission.Type.ALLOWED_TO_FETCH_RUN, whoRequestsRunId, connectionHandlerID);
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                ClientId serverClientId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                if (this.contest.isLocalLoggedIn(serverClientId)) {
                    Packet fetchRunPacket = PacketFactory.createFetchRun(serverClientId, whoRequestsRunId, run, serverClientId);
                    this.controller.sendToRemoteServer(run.getSiteNumber(), fetchRunPacket);
                } else {
                    Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, run);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            } else {
                Run theRun = this.contest.getRun(run.getElementId());
                theRun = this.contest.getRun(run.getElementId());
                RunFiles runFiles = this.contest.getRunFiles(run);
                RunResultFiles[] runResultFiles = this.contest.getRunResultFiles(run);
                Packet fetchedRunPacket = PacketFactory.createFetchedRun(this.contest.getClientId(), whoRequestsRunId, theRun, runFiles, whoRequestsRunId, runResultFiles);
                this.controller.sendToClient(fetchedRunPacket);
            }
        } else {
            throw new SecurityException("requestRun - sent to client " + this.contest.getClientId());
        }
    }

    private void runAvailable(Packet packet) throws IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        this.contest.availableRun(run);
        if (this.isServer()) {
            this.controller.sendToJudgesAndOthers(packet, this.isThisSite(run));
        }
    }

    private void runSubmission(Packet packet, ClientId fromId) throws IOException, ClassNotFoundException, FileSecurityException {
        Long overrideRunId;
        Run submittedRun = (Run)PacketFactory.getObjectValue(packet, "RUN");
        RunFiles runFiles = (RunFiles)PacketFactory.getObjectValue(packet, "RUN_FILES");
        Long overrideElapsedTime = (Long)PacketFactory.getObjectValue(packet, "ELAPSED_TIME");
        if (overrideElapsedTime != null) {
            if (this.contest.getContestInformation().isCcsTestMode()) {
                submittedRun.setOverRideElapsedTimeMS(overrideElapsedTime);
                this.controller.getLog().info("Elapsed time override (-t) " + overrideElapsedTime + " used for run " + submittedRun);
            } else {
                this.controller.getLog().info("Note elapsed time override not used, not in CCS test mode run=" + submittedRun);
                throw new SecurityException("Attempted to use time override in submit run when not in CCS Test Mode");
            }
        }
        if ((overrideRunId = (Long)PacketFactory.getObjectValue(packet, "OVERRIDE_RUN_ID")) != null) {
            if (this.contest.getContestInformation().isCcsTestMode()) {
                submittedRun.setOverRideNumber(overrideRunId.intValue());
                this.controller.getLog().info("Run id override (-i) " + overrideElapsedTime + " used for run " + submittedRun);
            } else {
                this.controller.getLog().info("Note run id override not used, not in CCS test mode run=" + submittedRun);
                throw new SecurityException("Attempted to use run id override in submit run when not in CCS Test Mode");
            }
        }
        Run run = this.contest.acceptRun(submittedRun, runFiles);
        ContestTime contestTime = this.contest.getContestTime();
        if (contestTime.isPastEndOfContest() || !contestTime.isContestRunning() || submittedRun.getOverRideElapsedTimeMS() > contestTime.getContestLengthMS()) {
            run.setDeleted(true);
            submittedRun.setDeleted(true);
            this.contest.updateRun(run, this.getServerClientId());
        }
        Packet confirmPacket = PacketFactory.createRunSubmissionConfirm(this.contest.getClientId(), fromId, run);
        this.controller.sendToClient(confirmPacket);
        if (this.isServer()) {
            this.controller.sendToJudgesAndOthers(confirmPacket, false);
            Packet dupSubmissionPacket = PacketFactory.createRunSubmissionConfirmation(this.contest.getClientId(), fromId, run, runFiles);
            this.controller.sendToServers(dupSubmissionPacket);
        }
        this.controller.sendRunToSubmissionInterface(run, runFiles);
    }

    private void confirmSubmission(Packet packet, ClientId fromId) {
        Clarification submittedClarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        Clarification clarification = this.contest.acceptClarification(submittedClarification);
        Packet confirmPacket = PacketFactory.createClarSubmissionConfirm(this.contest.getClientId(), fromId, clarification);
        this.controller.sendToClient(confirmPacket);
        if (this.isServer()) {
            this.controller.sendToJudgesAndOthers(confirmPacket, true);
        }
    }

    private void runRequest(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId requestFromId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Boolean readOnly = (Boolean)PacketFactory.getObjectValue(packet, "READ_ONLY");
        Boolean computerJudge = (Boolean)PacketFactory.getObjectValue(packet, "COMPUTER_JUDGE");
        if (readOnly != null) {
            this.checkoutRun(packet, run, requestFromId, readOnly, computerJudge, connectionHandlerID);
        } else {
            this.requestRun(packet, run, requestFromId, connectionHandlerID, computerJudge);
        }
    }

    private void clockStopped(Packet packet) {
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        this.contest.stopContest(siteNumber);
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        ContestTime contestTime = this.contest.getContestTime(siteNumber);
        this.info("Clock for site " + contestTime.getSiteNumber() + " stopped by " + clientId + " elapsed " + contestTime.getElapsedTimeStr());
        if (this.isServer()) {
            this.controller.sendToTeams(packet);
            this.controller.sendToJudgesAndOthers(packet, false);
        }
    }

    private void startClock(Packet packet) {
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        this.contest.startContest(siteNumber);
        ContestTime contestTime = this.contest.getContestTime(siteNumber);
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        this.info("Clock for site " + contestTime.getSiteNumber() + " started by " + clientId + " elapsed " + contestTime.getElapsedTimeStr());
        if (this.isServer()) {
            this.controller.sendToTeams(packet);
            this.controller.sendToJudgesAndOthers(packet, false);
        }
    }

    private void handlePasswordChangeResults(Packet packet) {
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Boolean passwordChanged = (Boolean)PacketFactory.getObjectValue(packet, "PASSWORD_CHANGED");
        String message = (String)PacketFactory.getObjectValue(packet, "MESSAGE_STRING");
        String mess = passwordChanged != false ? "Password changed " + message : "Password NOT changed " + message;
        this.controller.getLog().log(Log.INFO, mess);
        this.contest.passwordChanged(passwordChanged, clientId, message);
    }

    private void attemptChangePassword(Packet packet) {
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        String password = (String)PacketFactory.getObjectValue(packet, "PASSWORD");
        String newPassword = (String)PacketFactory.getObjectValue(packet, "NEW_PASSWORD");
        if (clientId == null || password == null || newPassword == null) {
            String mess = "Invalid request ";
            if (password == null) {
                mess = String.valueOf(mess) + " password not specified";
            }
            if (newPassword == null) {
                mess = String.valueOf(mess) + " no new password specified ";
            }
            this.sendPasswordResultsBackToClient(packet.getSourceId(), false, mess);
        } else if (!this.isThisSite(clientId)) {
            String mess = "Security Warning client from other site tried to change password " + clientId;
            this.controller.getLog().log(Log.WARNING, mess);
            Packet violationPacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, mess, packet.getSourceId(), null, null, packet);
            this.controller.sendToAdministrators(violationPacket);
            this.controller.sendToServers(violationPacket);
            this.sendPasswordResultsBackToClient(clientId, false, "Can not change password from site " + clientId);
        } else {
            try {
                if (this.contest.isValidLoginAndPassword(clientId, password)) {
                    Account account = this.contest.getAccount(clientId);
                    account.setPassword(newPassword);
                    this.contest.updateAccount(account);
                    account = this.contest.getAccount(clientId);
                    this.sendPasswordResultsBackToClient(clientId, true, "Password changed");
                    Packet updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), account.getClientId(), this.contest.getAccount(account.getClientId()));
                    this.controller.sendToAdministrators(updatePacket);
                    this.controller.sendToServers(updatePacket);
                }
            }
            catch (Exception exception) {
                this.sendPasswordResultsBackToClient(clientId, false, "Login password does not match, try again");
            }
        }
    }

    private void sendPasswordResultsBackToClient(ClientId clientId, boolean changed, String message) {
        Packet passwordChangeResult = PacketFactory.createPasswordChangeResult(clientId, clientId, changed, message);
        this.controller.sendToClient(passwordChangeResult);
    }

    protected void droppedConnection(Packet packet, ConnectionHandlerID connectionHandlerID) {
        ConnectionHandlerID inConnectionHandlerID = (ConnectionHandlerID)PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID");
        if (this.isServer()) {
            if (this.isThisSite(packet.getSourceId())) {
                this.controller.sendToServers(packet);
            }
            this.controller.sendToJudgesAndOthers(packet, false);
            this.contest.connectionDropped(inConnectionHandlerID);
        } else {
            this.contest.connectionDropped(inConnectionHandlerID);
        }
    }

    private void handleSecurityMessage(Packet inPacket) {
        String message = (String)PacketFactory.getObjectValue(inPacket, "MESSAGE");
        ContestSecurityException contestSecurityException = (ContestSecurityException)PacketFactory.getObjectValue(inPacket, "EXCEPTION");
        this.contest.newSecurityMessage(contestSecurityException.getClientId(), "", message, contestSecurityException);
        if (this.isServer()) {
            Packet forwardPacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, inPacket);
            this.controller.sendToAdministrators(forwardPacket);
        }
    }

    private void establishConnection(Packet packet, ConnectionHandlerID connectionHandlerID) {
        ConnectionHandlerID inConnectionHandlerID = (ConnectionHandlerID)PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID");
        if (this.isServer()) {
            this.controller.sendToAdministrators(packet);
            if (this.isThisSite(packet.getSourceId())) {
                this.controller.sendToServers(packet);
            }
            this.contest.connectionEstablished(inConnectionHandlerID);
        } else {
            this.contest.connectionEstablished(inConnectionHandlerID);
        }
    }

    protected void checkoutClarification(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoCheckedOut = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.securityCheck(Permission.Type.ANSWER_CLARIFICATION, whoCheckedOut, connectionHandlerID);
        }
        this.contest.updateClarification(clarification, whoCheckedOut);
        if (this.isServer()) {
            this.controller.sendToJudgesAndOthers(packet, false);
        }
    }

    protected void securityCheck(Permission.Type type, ClientId clientId, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        if (this.controller.getSecurityLevel() < 10) {
            return;
        }
        if (!this.contest.isAllowed(clientId, type)) {
            throw new ContestSecurityException(clientId, connectionHandlerID, clientId + " not allowed to " + (Object)((Object)type));
        }
    }

    private void acceptRunJudgement(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        JudgementRecord judgementRecord = (JudgementRecord)PacketFactory.getObjectValue(packet, "JUDGEMENT_RECORD");
        RunResultFiles runResultFiles = (RunResultFiles)PacketFactory.getObjectValue(packet, "RUN_RESULTS_FILE");
        ClientId whoJudgedRunId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        this.judgeRun(run, judgementRecord, runResultFiles, whoJudgedRunId, connectionHandlerID, packet);
    }

    private void runCheckout(Packet packet, PacketType.Type packetType) throws IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoCheckedOut = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        switch (packetType) {
            case RUN_CHECKOUT: 
            case RUN_REJUDGE_CHECKOUT: {
                RunFiles runFiles = (RunFiles)PacketFactory.getObjectValue(packet, "RUN_FILES");
                RunResultFiles[] runResultFiles = (RunResultFiles[])PacketFactory.getObjectValue(packet, "RUN_RESULTS_FILE");
                this.contest.updateRun(run, runFiles, whoCheckedOut, runResultFiles);
                break;
            }
            case RUN_CHECKOUT_NOTIFICATION: {
                if (this.contest.getClientId().equals(whoCheckedOut)) break;
                this.contest.updateRun(run, whoCheckedOut);
                break;
            }
            default: {
                this.controller.getLog().log(Log.WARNING, "Attempted to runCheckout with packet: " + packet);
            }
        }
        if (this.isServer()) {
            this.controller.sendToJudgesAndOthers(packet, false);
        }
    }

    private void handleFetchedRun(Packet packet, ConnectionHandlerID connectionHandlerID) throws IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        RunFiles runFiles = (RunFiles)PacketFactory.getObjectValue(packet, "RUN_FILES");
        ClientId whoCheckedOut = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        RunResultFiles[] runResultFiles = (RunResultFiles[])PacketFactory.getObjectValue(packet, "RUN_RESULTS_FILE");
        this.contest.updateRun(run, runFiles, whoCheckedOut, runResultFiles);
    }

    private void requestRejudgeRun(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoRequestsRunId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                ClientId serverClientId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                if (this.contest.isLocalLoggedIn(serverClientId)) {
                    Packet requestPacket = PacketFactory.createRunRejudgeRequest(this.contest.getClientId(), serverClientId, run, whoRequestsRunId);
                    this.controller.sendToRemoteServer(run.getSiteNumber(), requestPacket);
                } else {
                    Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, run);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            } else {
                Run theRun = this.contest.getRun(run.getElementId());
                try {
                    this.securityCheck(Permission.Type.REJUDGE_RUN, whoRequestsRunId, connectionHandlerID);
                    theRun = this.contest.checkoutRun(run, whoRequestsRunId, true, false);
                    RunFiles runFiles = this.contest.getRunFiles(run);
                    Packet checkOutPacket = PacketFactory.createRejudgeCheckedOut(this.contest.getClientId(), whoRequestsRunId, theRun, runFiles, whoRequestsRunId);
                    this.controller.sendToClient(checkOutPacket);
                    this.controller.sendToJudgesAndOthers(checkOutPacket, true);
                }
                catch (RunUnavailableException runUnavailableException) {
                    theRun = this.contest.getRun(run.getElementId());
                    Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, theRun);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            }
        } else {
            throw new SecurityException("requestRun - sent to client " + this.contest.getClientId());
        }
    }

    private void reconnectSite(Packet packet) {
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        if (siteNumber != null) {
            try {
                this.controller.getLog().log(Log.INFO, "Client " + packet.getSourceId() + " requests reconnection to site " + siteNumber);
                this.controller.sendServerLoginRequest(siteNumber);
            }
            catch (Exception e) {
                this.controller.getLog().log(Log.WARNING, "Unable to send reconnection request to ", e);
            }
        }
    }

    private void handleMessagePacket(Packet packet) throws Exception {
        if (this.isServer()) {
            String message = (String)PacketFactory.getObjectValue(packet, "MESSAGE_STRING");
            MessageEvent.Area area = (MessageEvent.Area)((Object)PacketFactory.getObjectValue(packet, "MESSAGE_AREA"));
            if (this.isThisSite(packet.getDestinationId().getSiteNumber())) {
                if (!packet.getDestinationId().getClientType().equals((Object)ClientType.Type.SERVER)) {
                    this.controller.sendToClient(packet);
                }
            } else {
                Packet messagePacket = PacketFactory.createMessage(this.contest.getClientId(), packet.getDestinationId(), area, message);
                int siteNumber = packet.getDestinationId().getSiteNumber();
                this.controller.sendToRemoteServer(siteNumber, messagePacket);
            }
            this.contest.addMessage(area, packet.getSourceId(), packet.getDestinationId(), message);
        } else {
            String message = (String)PacketFactory.getObjectValue(packet, "MESSAGE_STRING");
            MessageEvent.Area area = (MessageEvent.Area)((Object)PacketFactory.getObjectValue(packet, "MESSAGE_AREA"));
            if (message == null) {
                throw new Exception("Message null in packet " + packet);
            }
            this.contest.addMessage(area, packet.getSourceId(), packet.getDestinationId(), message);
        }
    }

    private void insureDirectory(String directoryName) {
        if (!new File(directoryName).isDirectory()) {
            new File(directoryName).mkdirs();
        }
    }

    private synchronized void loginSuccess(Packet packet, ConnectionHandlerID connectionHandlerID, ClientId fromId) throws IOException, ClassNotFoundException, FileSecurityException {
        ClientId clientId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (!this.contest.isLoggedIn()) {
            if (this.isServer(clientId)) {
                Profile theProfile;
                String uberSecretatPassworden = (String)PacketFactory.getObjectValue(packet, "CONTEST_PASSWORD");
                if (uberSecretatPassworden == null) {
                    StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ");
                    System.err.println("FATAL ERROR - Contest Security Password is null ");
                    System.exit(44);
                }
                if ((theProfile = (Profile)PacketFactory.getObjectValue(packet, "PROFILE")) == null) {
                    StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR - Profile is null");
                    System.err.println("FATAL ERROR - Profile is null ");
                    System.exit(44);
                }
                this.insureDirectory(theProfile.getProfilePath());
                theProfile.setSiteNumber(clientId.getSiteNumber());
                String baseDirectoryName = String.valueOf(theProfile.getProfilePath()) + File.separator + "db." + clientId.getSiteNumber();
                this.insureDirectory(baseDirectoryName);
                FileSecurity fileSecurity = new FileSecurity(baseDirectoryName);
                this.controller.initializeStorage(fileSecurity);
                try {
                    fileSecurity.verifyPassword(uberSecretatPassworden.toCharArray());
                }
                catch (FileSecurityException fileSecurityException) {
                    if (fileSecurityException.getMessage().equals("KEY_FILE_NOT_FOUND")) {
                        try {
                            fileSecurity.saveSecretKey(uberSecretatPassworden.toCharArray());
                        }
                        catch (Exception e) {
                            StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", e);
                            System.err.println("FATAL ERROR " + e.getMessage() + " check logs");
                            System.exit(44);
                        }
                    } else {
                        StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", fileSecurityException);
                        System.err.println("FATAL ERROR " + fileSecurityException.getMessage() + " check logs");
                        System.exit(44);
                    }
                }
                catch (Exception e) {
                    StaticLog.getLog().log(Log.SEVERE, "FATAL ERROR ", e);
                    System.err.println("FATAL ERROR " + e.getMessage() + " check logs");
                    System.exit(44);
                }
                this.contest.setStorage(fileSecurity);
                this.contest.setContestPassword(uberSecretatPassworden);
            }
            this.contest.setSiteNumber(clientId.getSiteNumber());
            ContestLoader loader = new ContestLoader();
            loader.loadDataIntoModel(this.contest, this.controller, packet, connectionHandlerID);
            if (this.isServer()) {
                this.storeProfiles();
                loader.loadIfMissingAccountToModel(this.contest, this.controller, packet, ClientType.Type.TEAM);
                loader.loadIfMissingAccountToModel(this.contest, this.controller, packet, ClientType.Type.JUDGE);
                loader.loadIfMissingAccountToModel(this.contest, this.controller, packet, ClientType.Type.SCOREBOARD);
            }
            loader = null;
            this.otherLoginActivities(packet, connectionHandlerID);
            this.startEvalLog();
            this.info(" handlePacket original LOGIN_SUCCESS after -- all settings loaded ");
            if (this.isServer()) {
                if (this.contest.isLocalLoggedIn(fromId)) {
                    this.contest.removeLogin(fromId);
                }
                if (this.contest.isRemoteLoggedIn(fromId)) {
                    this.contest.removeRemoteLogin(fromId);
                }
                this.contest.addLocalLogin(fromId, connectionHandlerID);
                this.controller.sendToClient(this.createContestSettingsPacket(packet.getSourceId()));
                this.sendRequestForRunfFiles(packet, packet.getSourceId().getSiteNumber());
            }
        } else if (this.isServer(packet.getDestinationId())) {
            if (this.contest.isRemoteLoggedIn(fromId)) {
                this.contest.removeRemoteLogin(fromId);
            }
            this.contest.addLocalLogin(fromId, connectionHandlerID);
            ContestLoader loader = new ContestLoader();
            this.loadSettingsFromRemoteServer(loader, packet, connectionHandlerID);
            loader = null;
            this.contest.storeConfiguration(this.controller.getLog());
            this.controller.sendToClient(this.createContestSettingsPacket(packet.getSourceId()));
        } else {
            Exception ex = new Exception("Client " + this.contest.getClientId() + " received unexpected packet, not logged in but got a " + packet);
            this.controller.getLog().log(Log.WARNING, ex.getMessage(), ex);
        }
    }

    private void startEvalLog() {
        try {
            if (this.evaluationLog == null && this.isServer()) {
                Utilities.insureDir("logs");
                this.evaluationLog = new EvaluationLog("logs" + File.separator + "evals.log", this.contest, this.controller);
                this.evaluationLog.getEvalLog().println("# Log opened " + new Date());
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void dumpServerLoginLists(String comment) {
        ClientId clientId;
        this.info("dumpLoginLists (Site " + this.contest.getSiteNumber() + ") " + comment);
        ClientId[] clientIds = this.contest.getLocalLoggedInClients(ClientType.Type.SERVER);
        String message = "   " + clientIds.length + "  local logins:";
        ClientId[] clientIdArray = clientIds;
        int n = clientIds.length;
        int n2 = 0;
        while (n2 < n) {
            clientId = clientIdArray[n2];
            message = String.valueOf(message) + " Site " + clientId.getSiteNumber();
            ++n2;
        }
        this.info(String.valueOf(message) + ".");
        clientIds = this.contest.getRemoteLoggedInClients(ClientType.Type.SERVER);
        message = "   " + clientIds.length + " remote logins:";
        clientIdArray = clientIds;
        n = clientIds.length;
        n2 = 0;
        while (n2 < n) {
            clientId = clientIdArray[n2];
            message = String.valueOf(message) + " Site " + clientId.getSiteNumber();
            ++n2;
        }
        this.info(String.valueOf(message) + ".");
    }

    private void updateContestClock(Packet packet) throws IOException, ClassNotFoundException, FileSecurityException {
        ClientId who = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        ContestTime contestTime = (ContestTime)PacketFactory.getObjectValue(packet, "CONTEST_TIME");
        if (this.isServer()) {
            if (this.isThisSite(contestTime.getSiteNumber())) {
                this.contest.updateContestTime(contestTime);
                ContestTime updatedContestTime = this.contest.getContestTime(siteNumber);
                this.controller.getLog().info("Contest Settings updated by " + who + " running=" + updatedContestTime.isContestRunning() + " elapsed = " + updatedContestTime.getElapsedTimeStr() + " remaining= " + updatedContestTime.getRemainingTimeStr() + " length=" + updatedContestTime.getContestLengthStr());
                Packet updatePacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, packet);
                this.controller.sendToTeams(updatePacket);
                this.controller.sendToJudgesAndOthers(updatePacket, true);
            } else {
                this.controller.sendToRemoteServer(siteNumber, packet);
            }
        } else {
            this.controller.sendToTeams(packet);
            if (this.isServer()) {
                this.controller.sendToJudgesAndOthers(packet, true);
            }
        }
        if (this.isServer()) {
            this.contest.storeConfiguration(this.controller.getLog());
        }
    }

    private boolean isThisSite(ClientId sourceId) {
        return this.isThisSite(sourceId.getSiteNumber());
    }

    private void sendForceDisconnection(Packet packet) {
        ConnectionHandlerID connectionHandlerID = (ConnectionHandlerID)PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID");
        ClientId clientToLogoffId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (clientToLogoffId != null) {
                if (this.contest.isLocalLoggedIn(clientToLogoffId)) {
                    this.controller.removeConnection(connectionHandlerID);
                } else if (!this.isServer(clientToLogoffId)) {
                    this.controller.sendToRemoteServer(clientToLogoffId.getSiteNumber(), packet);
                }
            } else if (connectionHandlerID != null) {
                if (this.contest.isConnected(connectionHandlerID)) {
                    this.controller.forceConnectionDrop(connectionHandlerID);
                } else {
                    this.controller.sendToServers(packet);
                }
            }
        } else if (clientToLogoffId != null) {
            this.controller.removeLogin(clientToLogoffId);
        } else if (connectionHandlerID != null) {
            this.controller.removeConnection(connectionHandlerID);
        }
    }

    private void updateRun(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        JudgementRecord judgementRecord = (JudgementRecord)PacketFactory.getObjectValue(packet, "JUDGEMENT_RECORD");
        ClientId whoChangedRun = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (this.isThisSite(run)) {
                this.securityCheck(Permission.Type.EDIT_RUN, packet.getSourceId(), connectionHandlerID);
                if (this.isSuperUser(packet.getSourceId())) {
                    this.info("updateRun by " + packet.getSourceId() + " " + run);
                    if (judgementRecord != null) {
                        RunResultFiles[] runResultFilesArray = this.contest.getRunResultFiles(run);
                        RunResultFiles runResultFiles = null;
                        if (runResultFilesArray != null && runResultFilesArray.length > 0) {
                            runResultFiles = runResultFilesArray[runResultFilesArray.length - 1];
                        }
                        this.contest.addRunJudgement(run, judgementRecord, runResultFiles, packet.getSourceId());
                        run.addJudgement(judgementRecord);
                        this.contest.updateRun(run, whoChangedRun);
                    } else {
                        this.contest.updateRun(run, whoChangedRun);
                    }
                } else {
                    throw new SecurityException("Non-admin user " + packet.getSourceId() + " attempted to update run " + run);
                }
                Run theRun = this.contest.getRun(run.getElementId());
                Packet runUpdatedPacket = PacketFactory.createRunUpdateNotification(this.contest.getClientId(), PacketFactory.ALL_SERVERS, theRun, whoChangedRun);
                this.controller.sendToJudgesAndOthers(runUpdatedPacket, true);
                if (theRun.isJudged() && theRun.getJudgementRecord().isSendToTeam()) {
                    Packet notifyPacket = PacketFactory.clonePacket(this.contest.getClientId(), run.getSubmitter(), runUpdatedPacket);
                    this.sendJudgementToTeam(notifyPacket, theRun);
                }
            } else {
                this.controller.sendToRemoteServer(run.getSiteNumber(), packet);
            }
        } else {
            if (this.contest.isLocalLoggedIn(run.getSubmitter())) {
                this.controller.sendToClient(packet);
            }
            this.controller.sendToJudgesAndOthers(packet, false);
        }
    }

    private void loginClient(Packet packet) {
        if (this.contest.isLoggedIn()) {
            ClientId whoLoggedIn = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
            ConnectionHandlerID connectionHandlerID = (ConnectionHandlerID)PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID");
            ClientSettings clientSettings = (ClientSettings)PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS");
            if (this.isServer()) {
                this.info("LOGIN from other site " + whoLoggedIn);
                if (!this.contest.isLocalLoggedIn(whoLoggedIn)) {
                    if (!this.isThisSite(whoLoggedIn)) {
                        if (this.isServer(whoLoggedIn)) {
                            if (!this.contest.isRemoteLoggedIn(whoLoggedIn)) {
                                this.contest.addRemoteLogin(whoLoggedIn, connectionHandlerID);
                                this.controller.sendToJudgesAndOthers(packet, false);
                            }
                        } else {
                            this.contest.addRemoteLogin(whoLoggedIn, connectionHandlerID);
                            this.controller.sendToJudgesAndOthers(packet, false);
                        }
                        this.contest.addClientSettings(clientSettings);
                    }
                } else {
                    this.controller.getLog().log(Log.DEBUG, "LOGIN packet, server site " + whoLoggedIn + " logged onto " + packet.getSourceId() + ", already logged in on this site");
                }
            } else {
                this.contest.addLogin(whoLoggedIn, connectionHandlerID);
                this.contest.addClientSettings(clientSettings);
            }
        } else {
            this.info("Note: got a LOGIN packet before this site was logged in " + packet);
        }
    }

    private void logoutClient(Packet packet) {
        ClientId whoLoggedOff = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (this.isServer(whoLoggedOff)) {
                this.controller.getLog().info("No logoff server allowed, logoff packet " + packet + " ignored");
            } else if (this.contest.isLocalLoggedIn(whoLoggedOff)) {
                this.controller.logoffUser(whoLoggedOff);
            } else if (this.isServer(packet.getSourceId()) && whoLoggedOff.getSiteNumber() == packet.getSourceId().getSiteNumber()) {
                this.contest.removeRemoteLogin(whoLoggedOff);
                this.controller.sendToJudgesAndOthers(packet, false);
            } else {
                this.controller.sendToRemoteServer(whoLoggedOff.getSiteNumber(), packet);
            }
        } else {
            this.contest.removeLogin(whoLoggedOff);
        }
    }

    private void sendJudgementUpdate(Packet packet) throws IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoModifiedRun = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.contest.updateRun(run, whoModifiedRun);
            this.controller.sendToJudgesAndOthers(packet, false);
        } else {
            this.contest.updateRun(run, whoModifiedRun);
        }
    }

    private void sendAnswerClarification(Packet packet) {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoModifiedClarification = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.contest.answerClarification(clarification, clarification.getAnswer(), whoModifiedClarification, clarification.isSendToAll());
            this.controller.sendToJudgesAndOthers(packet, false);
            if (clarification.isSendToAll()) {
                this.controller.sendToTeams(packet);
            } else if (this.isThisSite(clarification)) {
                Packet answerPacket = PacketFactory.clonePacket(this.contest.getClientId(), clarification.getSubmitter(), packet);
                this.controller.sendToClient(answerPacket);
            }
        } else {
            this.contest.answerClarification(clarification, clarification.getAnswer(), whoModifiedClarification, clarification.isSendToAll());
        }
    }

    private void sendRunUpdateNotification(Packet packet) throws IOException, ClassNotFoundException, FileSecurityException {
        Run run = (Run)PacketFactory.getObjectValue(packet, "RUN");
        ClientId whoModifiedRun = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.contest.updateRun(run, whoModifiedRun);
            this.controller.sendToJudgesAndOthers(packet, false);
        } else {
            this.contest.updateRun(run, whoModifiedRun);
        }
    }

    private void generateAccounts(Packet packet) throws IOException, ClassNotFoundException, FileSecurityException {
        ClientType.Type type = (ClientType.Type)((Object)PacketFactory.getObjectValue(packet, "CLIENT_TYPE"));
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        Integer count = (Integer)PacketFactory.getObjectValue(packet, "COUNT");
        Integer startCount = (Integer)PacketFactory.getObjectValue(packet, "START_COUNT");
        Boolean active = (Boolean)PacketFactory.getObjectValue(packet, "CREATE_ACCOUNT_ACTIVE");
        if (this.isServer()) {
            if (this.isThisSite(siteNumber)) {
                Vector<Account> accountVector = this.contest.generateNewAccounts(type.toString(), count, startCount, active);
                Account[] accounts = accountVector.toArray(new Account[accountVector.size()]);
                this.contest.storeConfiguration(this.controller.getLog());
                Packet newAccountsPacket = PacketFactory.createAddSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, accounts);
                this.controller.sendToJudgesAndOthers(newAccountsPacket, true);
            } else {
                this.controller.sendToRemoteServer(siteNumber, packet);
            }
        } else {
            throw new SecurityException("Client " + this.contest.getClientId() + " was sent generate account packet " + packet);
        }
    }

    private void startContest(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        ClientId who = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        if (packet.getType().equals((Object)PacketType.Type.START_ALL_CLOCKS)) {
            siteNumber = new Integer(this.contest.getSiteNumber());
        }
        if (this.isThisSite(siteNumber)) {
            this.securityCheck(Permission.Type.START_CONTEST_CLOCK, packet.getSourceId(), connectionHandlerID);
            this.contest.startContest(siteNumber);
            ContestTime updatedContestTime = this.contest.getContestTime(siteNumber);
            this.controller.getLog().info("Clock STARTED by " + who + " elapsed = " + updatedContestTime.getElapsedTimeStr());
            Packet startContestPacket = PacketFactory.createContestStarted(this.contest.getClientId(), PacketFactory.ALL_SERVERS, updatedContestTime.getSiteNumber(), who);
            this.controller.sendToTeams(startContestPacket);
            this.controller.sendToJudgesAndOthers(startContestPacket, true);
        } else if (packet.getType().equals((Object)PacketType.Type.START_ALL_CLOCKS)) {
            ClientId[] clientIds;
            ClientId[] clientIdArray = clientIds = this.contest.getLocalLoggedInClients(ClientType.Type.SERVER);
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId = clientIdArray[n2];
                Packet startContestPacket = PacketFactory.createStartContestClock(this.contest.getClientId(), PacketFactory.ALL_SERVERS, siteNumber, packet.getSourceId());
                this.controller.sendToRemoteServer(clientId.getSiteNumber(), startContestPacket);
                ++n2;
            }
        } else {
            this.controller.sendToRemoteServer(siteNumber, packet);
        }
        if (this.isServer()) {
            this.contest.storeConfiguration(this.controller.getLog());
        }
    }

    private void stopContest(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        ClientId who = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        Integer siteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        if (packet.getType().equals((Object)PacketType.Type.STOP_ALL_CLOCKS)) {
            siteNumber = new Integer(this.contest.getSiteNumber());
        }
        if (this.isThisSite(siteNumber)) {
            this.securityCheck(Permission.Type.STOP_CONTEST_CLOCK, who, connectionHandlerID);
            this.contest.stopContest(siteNumber);
            ContestTime updatedContestTime = this.contest.getContestTime(siteNumber);
            this.controller.getLog().info("Clock STOPPED by " + who + " elapsed = " + updatedContestTime.getElapsedTimeStr());
            Packet stopContestPacket = PacketFactory.createContestStopped(this.contest.getClientId(), PacketFactory.ALL_SERVERS, updatedContestTime.getSiteNumber(), who);
            this.controller.sendToTeams(stopContestPacket);
            this.controller.sendToJudgesAndOthers(stopContestPacket, true);
        } else if (packet.getType().equals((Object)PacketType.Type.STOP_ALL_CLOCKS)) {
            ClientId[] clientIds;
            ClientId[] clientIdArray = clientIds = this.contest.getLocalLoggedInClients(ClientType.Type.SERVER);
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId = clientIdArray[n2];
                Packet startContestPacket = PacketFactory.createStopContestClock(this.contest.getClientId(), PacketFactory.ALL_SERVERS, siteNumber, packet.getSourceId());
                this.controller.sendToRemoteServer(clientId.getSiteNumber(), startContestPacket);
                ++n2;
            }
        } else {
            this.controller.sendToRemoteServer(siteNumber, packet);
        }
        if (this.isServer()) {
            this.contest.storeConfiguration(this.controller.getLog());
        }
    }

    private void deleteSetting(Packet packet) {
    }

    private void addNewSetting(Packet packet) throws IOException, ClassNotFoundException, FileSecurityException {
        ClientSettings clientSettings;
        Account[] accounts;
        Profile profile;
        BalloonSettings balloonSettings;
        ContestTime contestTime;
        Problem[] problems;
        Language language;
        Judgement judgement;
        Category category;
        boolean sendToTeams = false;
        Site site = (Site)PacketFactory.getObjectValue(packet, "SITE");
        if (site != null) {
            this.contest.addSite(site);
            sendToTeams = true;
        }
        if ((category = (Category)PacketFactory.getObjectValue(packet, "CATEGORY")) != null) {
            this.contest.addCategory(category);
            sendToTeams = true;
        }
        if ((judgement = (Judgement)PacketFactory.getObjectValue(packet, "JUDGEMENT")) != null) {
            this.contest.addJudgement(judgement);
            sendToTeams = true;
        }
        if ((language = (Language)PacketFactory.getObjectValue(packet, "LANGUAGE")) != null) {
            this.contest.addLanguage(language);
            sendToTeams = true;
        }
        Language[] languages = (Language[])PacketFactory.getObjectValue(packet, "LANGUAGE_LIST");
        sendToTeams |= this.handleLanguageList(languages);
        Group group = (Group)PacketFactory.getObjectValue(packet, "GROUP");
        if (group != null) {
            this.contest.addGroup(group);
            sendToTeams = true;
        }
        Group[] groups = (Group[])PacketFactory.getObjectValue(packet, "GROUP_LIST");
        sendToTeams |= this.handleGroupList(groups);
        Problem problem = (Problem)PacketFactory.getObjectValue(packet, "PROBLEM");
        ProblemDataFiles problemDataFiles = (ProblemDataFiles)PacketFactory.getObjectValue(packet, "PROBLEM_DATA_FILES");
        if (problem != null) {
            if (problemDataFiles != null) {
                this.contest.addProblem(problem, problemDataFiles);
            } else {
                this.contest.addProblem(problem);
            }
            sendToTeams = true;
        }
        if ((problems = (Problem[])PacketFactory.getObjectValue(packet, "PROBLEM_LIST")) != null) {
            this.addNewProblems(this.contest, packet, problems);
            sendToTeams = true;
        }
        if ((contestTime = (ContestTime)PacketFactory.getObjectValue(packet, "CONTEST_TIME")) != null) {
            this.contest.addContestTime(contestTime);
            sendToTeams = true;
        }
        if ((balloonSettings = (BalloonSettings)PacketFactory.getObjectValue(packet, "BALLOON_SETTINGS")) != null) {
            this.contest.addBalloonSettings(balloonSettings);
            sendToTeams = true;
        }
        if ((profile = (Profile)PacketFactory.getObjectValue(packet, "PROFILE")) != null) {
            this.contest.addProfile(profile);
        }
        Packet updatePacket = null;
        Account oneAccount = (Account)PacketFactory.getObjectValue(packet, "ACCOUNT");
        if (oneAccount != null) {
            if (this.isServer()) {
                if (this.isThisSite(oneAccount)) {
                    ClientId clientId = oneAccount.getClientId();
                    Vector<Account> accountVector = this.contest.generateNewAccounts(clientId.getClientType().toString(), 1, true);
                    Account addedAccount = accountVector.firstElement();
                    addedAccount.setDisplayName(oneAccount.getDisplayName());
                    addedAccount.setPassword(oneAccount.getPassword());
                    addedAccount.clearListAndLoadPermissions(oneAccount.getPermissionList());
                    this.contest.updateAccount(addedAccount);
                    updatePacket = PacketFactory.createUpdateSetting(this.contest.getClientId(), PacketFactory.ALL_SERVERS, this.contest.getAccount(addedAccount.getClientId()));
                }
            } else {
                this.contest.updateAccount(oneAccount);
            }
        }
        if ((accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY")) != null) {
            Account account;
            Vector<Account> addAccountsVector = new Vector<Account>();
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                account = accountArray[n2];
                if (this.contest.getAccount(account.getClientId()) == null) {
                    addAccountsVector.add(account);
                }
                ++n2;
            }
            if (addAccountsVector.size() > 0) {
                this.contest.addAccounts(addAccountsVector.toArray(new Account[addAccountsVector.size()]));
            }
            if (this.isServer()) {
                accountArray = accounts;
                n = accounts.length;
                n2 = 0;
                while (n2 < n) {
                    account = accountArray[n2];
                    if (this.contest.isLocalLoggedIn(account.getClientId())) {
                        Packet newPacket = account.getClientId().getClientType().equals((Object)ClientType.Type.TEAM) ? PacketFactory.createUpdateSetting(this.contest.getClientId(), account.getClientId(), this.contest.getAccount(account.getClientId())) : PacketFactory.clonePacket(this.contest.getClientId(), account.getClientId(), packet);
                        this.controller.sendToClient(newPacket);
                    }
                    ++n2;
                }
            }
        }
        if ((clientSettings = (ClientSettings)PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS")) != null) {
            this.contest.addClientSettings(clientSettings);
            ClientId toId = clientSettings.getClientId();
            if (this.isJudge(toId)) {
                try {
                    this.controller.sendToJudgesAndOthers(packet, this.isThisSite(toId));
                }
                catch (Exception e) {
                    this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
                }
            }
            if (this.contest.isLocalLoggedIn(clientSettings.getClientId())) {
                try {
                    Packet newSettingsPacket = PacketFactory.clonePacket(this.contest.getClientId(), toId, packet);
                    this.controller.sendToClient(newSettingsPacket);
                }
                catch (Exception e) {
                    this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
                }
            }
        }
        if (this.isServer()) {
            this.contest.storeConfiguration(this.controller.getLog());
            this.storeProfiles();
            boolean sendToOtherServers = this.isThisSite(packet.getSourceId().getSiteNumber());
            if (updatePacket != null) {
                this.controller.sendToJudgesAndOthers(updatePacket, sendToOtherServers);
            } else {
                Packet addPacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, packet);
                this.controller.sendToJudgesAndOthers(addPacket, sendToOtherServers);
                if (sendToTeams) {
                    this.controller.sendToTeams(addPacket);
                }
            }
        }
    }

    protected void addNewProblems(IInternalContest iContest, Packet packet, Problem[] problems) {
        ProblemDataFiles[] problemDataFileList = (ProblemDataFiles[])PacketFactory.getObjectValue(packet, "PROBLEM_DATA_FILES_LIST");
        int idx = 0;
        Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problems != null) {
                ProblemDataFiles problemDataFiles = problemDataFileList[idx];
                if (problemDataFiles != null) {
                    iContest.addProblem(problem, problemDataFiles);
                } else {
                    iContest.addProblem(problem);
                }
            }
            ++idx;
            ++n2;
        }
    }

    private void updateSetting(Packet packet) throws IOException, ClassNotFoundException, FileSecurityException {
        Category[] categories;
        FinalizeData finalizeData;
        ClientSettings clientSettings;
        ContestInformation contestInformation;
        PlaybackInfo playbackInfo;
        Packet updatePacket;
        Account[] accounts;
        Account oneAccount;
        Profile profile;
        BalloonSettings balloonSettings;
        ContestTime contestTime;
        Language language;
        Judgement judgement;
        Category oneCategory;
        boolean sendToTeams = false;
        Packet oneUpdatePacket = null;
        Site site = (Site)PacketFactory.getObjectValue(packet, "SITE");
        if (site != null) {
            this.contest.updateSite(site);
            sendToTeams = true;
        }
        if ((oneCategory = (Category)PacketFactory.getObjectValue(packet, "CATEGORY")) != null) {
            this.contest.updateCategory(oneCategory);
            sendToTeams = true;
        }
        if ((judgement = (Judgement)PacketFactory.getObjectValue(packet, "JUDGEMENT")) != null) {
            this.contest.updateJudgement(judgement);
            sendToTeams = true;
        }
        if ((language = (Language)PacketFactory.getObjectValue(packet, "LANGUAGE")) != null) {
            this.contest.updateLanguage(language);
            sendToTeams = true;
        }
        Language[] languages = (Language[])PacketFactory.getObjectValue(packet, "LANGUAGE_LIST");
        sendToTeams |= this.handleLanguageList(languages);
        Group group = (Group)PacketFactory.getObjectValue(packet, "GROUP");
        if (group != null) {
            this.contest.updateGroup(group);
            sendToTeams = true;
        }
        Group[] groups = (Group[])PacketFactory.getObjectValue(packet, "GROUP_LIST");
        sendToTeams |= this.handleGroupList(groups);
        Problem problem = (Problem)PacketFactory.getObjectValue(packet, "PROBLEM");
        ProblemDataFiles problemDataFiles = (ProblemDataFiles)PacketFactory.getObjectValue(packet, "PROBLEM_DATA_FILES");
        if (problem != null) {
            if (problemDataFiles != null) {
                this.contest.updateProblem(problem, problemDataFiles);
            } else {
                this.contest.updateProblem(problem);
            }
            sendToTeams = true;
        }
        if ((contestTime = (ContestTime)PacketFactory.getObjectValue(packet, "CONTEST_TIME")) != null) {
            this.contest.updateContestTime(contestTime);
            sendToTeams = true;
        }
        if ((balloonSettings = (BalloonSettings)PacketFactory.getObjectValue(packet, "BALLOON_SETTINGS")) != null) {
            this.contest.updateBalloonSettings(balloonSettings);
            sendToTeams = true;
        }
        if ((profile = (Profile)PacketFactory.getObjectValue(packet, "PROFILE")) != null) {
            this.contest.updateProfile(profile);
            if (this.contest.getProfile().equals(profile)) {
                this.contest.setProfile(profile);
            }
            if (this.isServer()) {
                this.storeProfiles();
            }
        }
        if ((oneAccount = (Account)PacketFactory.getObjectValue(packet, "ACCOUNT")) != null) {
            this.contest.updateAccount(oneAccount);
            if (this.isThisSite(oneAccount.getClientId().getSiteNumber()) && this.isServer()) {
                oneUpdatePacket = PacketFactory.clonePacket(this.contest.getClientId(), oneAccount.getClientId(), packet);
                this.controller.sendToClient(oneUpdatePacket);
            }
        }
        if ((accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY")) != null) {
            Account account;
            Vector<Account> addAccountsVector = new Vector<Account>();
            Vector<Account> updateAccountsVector = new Vector<Account>();
            Account[] accountArray = accounts;
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                account = accountArray[n2];
                if (this.contest.getAccount(account.getClientId()) == null) {
                    addAccountsVector.add(account);
                } else {
                    updateAccountsVector.add(account);
                }
                ++n2;
            }
            if (addAccountsVector.size() > 0) {
                this.contest.addAccounts(addAccountsVector.toArray(new Account[addAccountsVector.size()]));
            }
            if (updateAccountsVector.size() > 0) {
                this.contest.updateAccounts(updateAccountsVector.toArray(new Account[updateAccountsVector.size()]));
            }
            if (this.isServer()) {
                accountArray = accounts;
                n = accounts.length;
                n2 = 0;
                while (n2 < n) {
                    account = accountArray[n2];
                    if (this.contest.isLocalLoggedIn(account.getClientId())) {
                        updatePacket = account.getClientId().getClientType().equals((Object)ClientType.Type.TEAM) ? PacketFactory.createUpdateSetting(this.contest.getClientId(), account.getClientId(), this.contest.getAccount(account.getClientId())) : PacketFactory.clonePacket(this.contest.getClientId(), account.getClientId(), packet);
                        this.controller.sendToClient(updatePacket);
                    }
                    ++n2;
                }
            }
        }
        if ((playbackInfo = (PlaybackInfo)PacketFactory.getObjectValue(packet, "PLAYBACK_INFO")) != null) {
            if (this.isServer()) {
                PlaybackInfo currentPlaybackInfo;
                boolean isStarted = this.contest.getPlaybackManager().getPlaybackInfo().isStarted();
                if (isStarted != (currentPlaybackInfo = this.updatePlaybackInfo(playbackInfo)).isStarted()) {
                    if (currentPlaybackInfo.isStarted()) {
                        this.contest.startReplayPlaybackInfo(currentPlaybackInfo);
                    } else {
                        this.contest.stopReplayPlaybackInfo(currentPlaybackInfo);
                    }
                } else {
                    this.contest.updatePlaybackInfo(currentPlaybackInfo);
                }
            } else {
                this.contest.updatePlaybackInfo(playbackInfo);
            }
        }
        if ((contestInformation = (ContestInformation)PacketFactory.getObjectValue(packet, "CONTEST_INFORMATION")) != null) {
            this.contest.updateContestInformation(contestInformation);
            sendToTeams = true;
        }
        if ((clientSettings = (ClientSettings)PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS")) != null) {
            ClientId toId;
            this.contest.updateClientSettings(clientSettings);
            if (this.isServer() && !this.isJudge(toId = clientSettings.getClientId()) && this.contest.isLocalLoggedIn(toId)) {
                Packet updatePacket2 = PacketFactory.clonePacket(this.contest.getClientId(), toId, packet);
                this.controller.sendToClient(updatePacket2);
            }
        }
        if ((finalizeData = (FinalizeData)PacketFactory.getObjectValue(packet, "FINALIZE_DATA")) != null) {
            this.contest.setFinalizeData(finalizeData);
            if (finalizeData.isCertified()) {
                this.controller.getLog().log(Log.INFO, "Contest Certified by '" + finalizeData.getComment() + "'");
            }
        }
        if ((categories = (Category[])PacketFactory.getObjectValue(packet, "CATEGORY_LIST")) != null) {
            int i = 0;
            while (i < categories.length) {
                Category category = categories[i];
                if (this.contest.getCategory(category.getElementId()) == null) {
                    this.contest.addCategory(category);
                } else {
                    this.contest.updateCategory(category);
                }
                ++i;
            }
            sendToTeams = true;
        }
        if (this.isServer()) {
            this.contest.storeConfiguration(this.controller.getLog());
            boolean sendToOtherServers = this.isThisSite(packet.getSourceId().getSiteNumber());
            if (oneUpdatePacket != null) {
                this.controller.sendToJudgesAndOthers(oneUpdatePacket, sendToOtherServers);
            } else {
                updatePacket = PacketFactory.clonePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, packet);
                this.controller.sendToJudgesAndOthers(updatePacket, sendToOtherServers);
                if (sendToTeams) {
                    this.controller.sendToTeams(updatePacket);
                }
            }
        }
    }

    private boolean handleLanguageList(Language[] languages) {
        boolean sendToTeams = false;
        if (languages != null) {
            ArrayList<Language> addLangList = new ArrayList<Language>();
            ArrayList<Language> updateLangList = new ArrayList<Language>();
            Language[] languageArray = languages;
            int n = languages.length;
            int n2 = 0;
            while (n2 < n) {
                Language language = languageArray[n2];
                if (this.contest.getLanguage(language.getElementId()) == null) {
                    addLangList.add(language);
                } else {
                    updateLangList.add(language);
                }
                sendToTeams = true;
                ++n2;
            }
            if (addLangList.size() > 0) {
                this.contest.addLanguages(addLangList.toArray(new Language[addLangList.size()]));
            }
            if (updateLangList.size() > 0) {
                this.contest.updateLanguages(updateLangList.toArray(new Language[updateLangList.size()]));
            }
        }
        return sendToTeams;
    }

    private boolean handleGroupList(Group[] groups) {
        boolean sendToTeams = false;
        if (groups != null) {
            ArrayList<Group> addLangList = new ArrayList<Group>();
            ArrayList<Group> updateLangList = new ArrayList<Group>();
            Group[] groupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                Group group = groupArray[n2];
                if (this.contest.getGroup(group.getElementId()) == null) {
                    addLangList.add(group);
                } else {
                    updateLangList.add(group);
                }
                sendToTeams = true;
                ++n2;
            }
            if (addLangList.size() > 0) {
                this.contest.addLanguages(addLangList.toArray(new Language[addLangList.size()]));
            }
            if (updateLangList.size() > 0) {
                this.contest.updateLanguages(updateLangList.toArray(new Language[updateLangList.size()]));
            }
        }
        return sendToTeams;
    }

    private PlaybackInfo updatePlaybackInfo(PlaybackInfo newPlaybackInfo) {
        PlaybackInfo playbackInfo = this.contest.getPlaybackManager().getPlaybackInfo();
        playbackInfo.setStarted(newPlaybackInfo.isStarted());
        playbackInfo.setMinimumPlaybackRecords(newPlaybackInfo.getMinimumPlaybackRecords());
        playbackInfo.setWaitBetweenEventsMS(newPlaybackInfo.getWaitBetweenEventsMS());
        String filename = newPlaybackInfo.getFilename();
        if (filename != null && filename.length() > 0) {
            playbackInfo.setFilename(newPlaybackInfo.getFilename());
        }
        return playbackInfo;
    }

    private boolean isThisSite(int siteNumber) {
        return siteNumber == this.contest.getSiteNumber();
    }

    private boolean isThisSite(Submission submission) {
        return submission.getSiteNumber() == this.contest.getSiteNumber();
    }

    public void sendToSpectatorsAndSites(Packet packet, boolean sendToServers) {
        if (this.isServer()) {
            this.controller.sendToSpectators(packet);
            if (sendToServers) {
                this.controller.sendToServers(packet);
            }
        } else {
            this.info("Warning - tried to send packet to others (as non server) " + packet);
            Exception ex = new Exception("User " + packet.getSourceId() + " tried to send packet to judges and others");
            this.controller.getLog().log(Log.WARNING, "Warning - tried to send packet to others (as non server) " + packet, ex);
        }
    }

    private boolean isSuperUser(ClientId id) {
        return id.getClientType().equals((Object)ClientType.Type.ADMINISTRATOR);
    }

    public void cancelRun(Packet packet, Run run, ClientId whoCanceledRun, ConnectionHandlerID connectionHandlerID) throws IOException, ClassNotFoundException, FileSecurityException {
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                ClientId destinationId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                Packet cancelPacket = PacketFactory.clonePacket(this.contest.getClientId(), destinationId, packet);
                this.controller.sendToRemoteServer(run.getSiteNumber(), cancelPacket);
            } else {
                try {
                    this.contest.cancelRunCheckOut(run, whoCanceledRun);
                    Run availableRun = this.contest.getRun(run.getElementId());
                    Packet availableRunPacket = PacketFactory.createRunAvailable(this.contest.getClientId(), whoCanceledRun, availableRun);
                    this.controller.sendToJudgesAndOthers(availableRunPacket, true);
                }
                catch (UnableToUncheckoutRunException e) {
                    this.controller.getLog().log(Log.WARNING, "Security Warning " + e.getMessage(), e);
                    Packet violationPacket = PacketFactory.createSecurityMessagePacket(this.contest.getClientId(), PacketFactory.ALL_SERVERS, e.getMessage(), whoCanceledRun, connectionHandlerID, null, packet);
                    this.controller.sendToAdministrators(violationPacket);
                    this.controller.sendToServers(violationPacket);
                }
            }
        } else {
            this.contest.updateRun(run, whoCanceledRun);
        }
    }

    public void cancelClarificationCheckOut(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoCancelledIt = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (!this.isThisSite(clarification)) {
                ClientId destinationId = new ClientId(clarification.getSiteNumber(), ClientType.Type.SERVER, 0);
                Packet cancelPacket = PacketFactory.clonePacket(this.contest.getClientId(), destinationId, packet);
                this.controller.sendToRemoteServer(clarification.getSiteNumber(), cancelPacket);
            } else {
                this.contest.cancelClarificationCheckOut(clarification, whoCancelledIt);
                Clarification theClarification = this.contest.getClarification(clarification.getElementId());
                Packet cancelPacket = PacketFactory.createClarificationAvailable(this.contest.getClientId(), PacketFactory.ALL_SERVERS, theClarification);
                if (this.isServer()) {
                    this.controller.sendToJudgesAndOthers(cancelPacket, true);
                }
            }
        } else {
            this.contest.cancelClarificationCheckOut(clarification, whoCancelledIt);
        }
    }

    private void sendClarificationAvailable(Packet packet) throws IOException, ClassNotFoundException, FileSecurityException {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoCancelledIt = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            this.contest.cancelClarificationCheckOut(clarification, whoCancelledIt);
            this.controller.sendToJudgesAndOthers(packet, false);
        } else {
            this.contest.cancelClarificationCheckOut(clarification, whoCancelledIt);
        }
    }

    private void answerClarification(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException {
        Clarification clarification = (Clarification)PacketFactory.getObjectValue(packet, "CLARIFICATION");
        ClientId whoAnsweredIt = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        if (this.isServer()) {
            if (!this.isThisSite(clarification)) {
                ClientId destinationId = new ClientId(clarification.getSiteNumber(), ClientType.Type.SERVER, 0);
                Packet answerPacket = PacketFactory.clonePacket(this.contest.getClientId(), destinationId, packet);
                this.controller.sendToRemoteServer(clarification.getSiteNumber(), answerPacket);
            } else {
                this.securityCheck(Permission.Type.ANSWER_CLARIFICATION, whoAnsweredIt, connectionHandlerID);
                this.contest.answerClarification(clarification, clarification.getAnswer(), whoAnsweredIt, clarification.isSendToAll());
                Clarification theClarification = this.contest.getClarification(clarification.getElementId());
                Packet answerPacket = PacketFactory.createAnsweredClarificationUpdate(this.contest.getClientId(), PacketFactory.ALL_SERVERS, theClarification, theClarification.getAnswer(), whoAnsweredIt);
                this.controller.sendToJudgesAndOthers(answerPacket, true);
                if (clarification.isSendToAll()) {
                    this.controller.sendToTeams(answerPacket);
                } else {
                    Packet answerForTeamPacket = PacketFactory.clonePacket(this.contest.getClientId(), clarification.getSubmitter(), answerPacket);
                    this.controller.sendToClient(answerForTeamPacket);
                }
            }
        } else {
            this.contest.answerClarification(clarification, clarification.getAnswer(), whoAnsweredIt, clarification.isSendToAll());
        }
    }

    protected void judgeRun(Run run, JudgementRecord judgementRecord, RunResultFiles runResultFiles, ClientId whoJudgedId, ConnectionHandlerID connectionHandlerID, Packet packet) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                ClientId serverClientId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                Packet judgementPacket = PacketFactory.clonePacket(this.contest.getClientId(), serverClientId, packet);
                this.controller.sendToRemoteServer(run.getSiteNumber(), judgementPacket);
            } else {
                RunResultFiles rrf;
                this.securityCheck(Permission.Type.JUDGE_RUN, whoJudgedId, connectionHandlerID);
                judgementRecord.setWhenJudgedTime(this.contest.getContestTime().getElapsedMins());
                this.contest.addRunJudgement(run, judgementRecord, runResultFiles, whoJudgedId);
                Run theRun = this.contest.getRun(run.getElementId());
                if (judgementRecord.isComputerJudgement()) {
                    if (this.contest.getProblem(theRun.getProblemId()).isManualReview()) {
                        if (this.contest.getProblem(theRun.getProblemId()).isPrelimaryNotification()) {
                            rrf = runResultFiles;
                            if (run.getSubmitter().getClientType().equals((Object)ClientType.Type.TEAM)) {
                                rrf = null;
                            }
                            Packet judgementPacket = PacketFactory.createRunJudgement(this.contest.getClientId(), run.getSubmitter(), theRun, judgementRecord, rrf);
                            this.sendJudgementToTeam(judgementPacket, theRun);
                        }
                    } else {
                        rrf = runResultFiles;
                        if (run.getSubmitter().getClientType().equals((Object)ClientType.Type.TEAM)) {
                            rrf = null;
                        }
                        Packet judgementPacket = PacketFactory.createRunJudgement(this.contest.getClientId(), run.getSubmitter(), theRun, judgementRecord, rrf);
                        this.sendJudgementToTeam(judgementPacket, theRun);
                    }
                } else {
                    rrf = runResultFiles;
                    if (run.getSubmitter().getClientType().equals((Object)ClientType.Type.TEAM)) {
                        rrf = null;
                    }
                    Packet judgementPacket = PacketFactory.createRunJudgement(this.contest.getClientId(), run.getSubmitter(), theRun, judgementRecord, rrf);
                    this.sendJudgementToTeam(judgementPacket, theRun);
                }
                Packet judgementUpdatePacket = PacketFactory.createRunJudgmentUpdate(this.contest.getClientId(), PacketFactory.ALL_SERVERS, theRun, whoJudgedId);
                this.controller.sendToJudgesAndOthers(judgementUpdatePacket, true);
            }
        } else {
            this.contest.updateRun(run, judgementRecord.getJudgerClientId());
        }
    }

    private void sendJudgementToTeam(Packet judgementPacket, Run run) {
        if (run.isJudged() && run.getJudgementRecord().isSendToTeam()) {
            JudgementNotificationsList judgementNotificationsList = this.contest.getContestInformation().getJudgementNotificationsList();
            if (!RunUtilities.supppressJudgement(judgementNotificationsList, run, this.contest.getContestTime())) {
                this.controller.sendToClient(judgementPacket);
            } else {
                this.controller.getLog().info("Notification not sent to " + run.getSubmitter() + " for run " + run);
            }
        } else {
            this.controller.getLog().warning("Attempted to send back unjudged run to team " + run);
        }
    }

    private void requestRun(Packet packet, Run run, ClientId whoRequestsRunId, ConnectionHandlerID connectionHandlerID, boolean computerJudge) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        this.checkoutRun(packet, run, whoRequestsRunId, false, computerJudge, connectionHandlerID);
    }

    private void requestClarification(Packet packet, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        ElementId clarificationId = (ElementId)PacketFactory.getObjectValue(packet, "REQUESTED_CLARIFICATION_ELEMENT_ID");
        ClientId requestFromId = (ClientId)PacketFactory.getObjectValue(packet, "CLIENT_ID");
        boolean readOnly = false;
        if (this.isServer()) {
            Clarification clarification = this.contest.getClarification(clarificationId);
            if (!this.isThisSite(clarification)) {
                ClientId serverClientId = new ClientId(clarification.getSiteNumber(), ClientType.Type.SERVER, 0);
                if (this.contest.isLocalLoggedIn(serverClientId)) {
                    Packet requestPacket = PacketFactory.clonePacket(this.contest.getClientId(), serverClientId, packet);
                    this.controller.sendToRemoteServer(clarification.getSiteNumber(), requestPacket);
                } else {
                    Packet notAvailableRunPacket = PacketFactory.createClarificationNotAvailable(this.contest.getClientId(), requestFromId, clarification, requestFromId);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            } else {
                Clarification theClarification = this.contest.getClarification(clarification.getElementId());
                if (readOnly) {
                    this.info("requestClarification read-only not implemented, yet");
                } else {
                    try {
                        this.securityCheck(Permission.Type.ANSWER_CLARIFICATION, requestFromId, connectionHandlerID);
                        theClarification = this.contest.checkoutClarification(clarification, requestFromId);
                        Packet checkOutPacket = PacketFactory.createCheckedOutClarification(this.contest.getClientId(), requestFromId, theClarification, requestFromId);
                        this.controller.sendToClient(checkOutPacket);
                        this.controller.sendToJudgesAndOthers(checkOutPacket, true);
                    }
                    catch (ClarificationUnavailableException clarUnavailableException) {
                        this.controller.getLog().info("clarUnavailableException " + clarUnavailableException.getMessage());
                        Packet notAvailableRunPacket = PacketFactory.createClarificationNotAvailable(this.contest.getClientId(), requestFromId, clarification, requestFromId);
                        this.controller.sendToClient(notAvailableRunPacket);
                    }
                }
            }
        } else {
            throw new SecurityException("requestClarification - sent to client " + this.contest.getClientId());
        }
    }

    private void checkoutRun(Packet packet, Run run, ClientId whoRequestsRunId, boolean readOnly, boolean computerJudge, ConnectionHandlerID connectionHandlerID) throws ContestSecurityException, IOException, ClassNotFoundException, FileSecurityException {
        if (this.isServer()) {
            if (!this.isThisSite(run)) {
                ClientId serverClientId = new ClientId(run.getSiteNumber(), ClientType.Type.SERVER, 0);
                if (this.contest.isLocalLoggedIn(serverClientId)) {
                    Packet requestPacket = PacketFactory.createRunRequest(this.contest.getClientId(), serverClientId, run, whoRequestsRunId, readOnly, computerJudge);
                    this.controller.sendToRemoteServer(run.getSiteNumber(), requestPacket);
                } else {
                    Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, run);
                    this.controller.sendToClient(notAvailableRunPacket);
                }
            } else {
                Run theRun = this.contest.getRun(run.getElementId());
                if (readOnly) {
                    theRun = this.contest.getRun(run.getElementId());
                    RunFiles runFiles = this.contest.getRunFiles(run);
                    RunResultFiles[] runResultFiles = this.contest.getRunResultFiles(run);
                    Packet checkOutPacket = PacketFactory.createCheckedOutRun(this.contest.getClientId(), whoRequestsRunId, theRun, runFiles, whoRequestsRunId, runResultFiles);
                    this.controller.sendToClient(checkOutPacket);
                } else {
                    try {
                        this.securityCheck(Permission.Type.JUDGE_RUN, whoRequestsRunId, connectionHandlerID);
                        theRun = this.contest.checkoutRun(run, whoRequestsRunId, false, computerJudge);
                        RunFiles runFiles = this.contest.getRunFiles(run);
                        if (runFiles == null) {
                            try {
                                this.contest.cancelRunCheckOut(run, whoRequestsRunId);
                            }
                            catch (UnableToUncheckoutRunException unableToUncheckoutRunException) {
                                this.controller.getLog().severe("Problem canceling run checkout after error getting run files.");
                            }
                            throw new RunUnavailableException("Error retrieving files.");
                        }
                        RunResultFiles[] runResultFiles = this.contest.getRunResultFiles(run);
                        Packet checkOutPacket = PacketFactory.createCheckedOutRun(this.contest.getClientId(), whoRequestsRunId, theRun, runFiles, whoRequestsRunId, runResultFiles);
                        this.controller.sendToClient(checkOutPacket);
                        Packet checkOutNotificationPacket = PacketFactory.createCheckedOutRunNotification(this.contest.getClientId(), whoRequestsRunId, theRun, whoRequestsRunId);
                        this.controller.sendToJudgesAndOthers(checkOutNotificationPacket, true);
                    }
                    catch (RunUnavailableException runUnavailableException) {
                        this.controller.getLog().info("runUnavailableException " + runUnavailableException.getMessage());
                        theRun = this.contest.getRun(run.getElementId());
                        Packet notAvailableRunPacket = PacketFactory.createRunNotAvailable(this.contest.getClientId(), whoRequestsRunId, theRun);
                        this.controller.sendToClient(notAvailableRunPacket);
                    }
                }
            }
        } else {
            throw new SecurityException("requestRun - sent to client " + this.contest.getClientId());
        }
    }

    private void dumpClientList(ClientId[] clientIds, String comment) {
        if (clientIds == null || clientIds.length == 0) {
            this.info(String.valueOf(comment) + " no clients in list ");
        } else {
            Arrays.sort(clientIds, new ClientIdComparator());
            ClientId[] clientIdArray = clientIds;
            int n = clientIds.length;
            int n2 = 0;
            while (n2 < n) {
                ClientId clientId = clientIdArray[n2];
                this.info(String.valueOf(comment) + " " + clientId);
                ++n2;
            }
        }
    }

    private boolean isThisSite(Account account) {
        return account.getSiteNumber() == this.contest.getSiteNumber();
    }

    public void loadSettingsFromRemoteServer(ContestLoader loader, Packet packet, ConnectionHandlerID connectionHandlerID) {
        int remoteSiteNumber = packet.getSourceId().getSiteNumber();
        this.info("Start loading settings from remote site " + remoteSiteNumber);
        loader.addRemoteContestTimesToModel(this.contest, this.controller, packet, remoteSiteNumber);
        loader.addRemoteRunsToModel(this.contest, this.controller, packet);
        this.sendRequestForRunfFiles(packet, remoteSiteNumber);
        loader.addRemoteClarificationsToModel(this.contest, this.controller, packet, remoteSiteNumber);
        loader.addRemoteAccountsToModel(this.contest, this.controller, packet, remoteSiteNumber);
        loader.loadIfMissingAccountToModel(this.contest, this.controller, packet, ClientType.Type.TEAM);
        loader.loadIfMissingAccountToModel(this.contest, this.controller, packet, ClientType.Type.JUDGE);
        loader.loadIfMissingAccountToModel(this.contest, this.controller, packet, ClientType.Type.SCOREBOARD);
        loader.addRemoteAllClientSettingsToModel(this.contest, this.controller, packet, remoteSiteNumber);
        loader.addAllConnectionIdsToModel(this.contest, this.controller, packet);
        loader.addRemoteLoginsToModel(this.contest, this.controller, packet, remoteSiteNumber);
        this.info("Done loading settings from remote site " + remoteSiteNumber);
    }

    public void sendRequestForRunfFiles(Packet packet, int remoteSiteNumber) {
        int lastRemoteRunId;
        RunFilesList list;
        int localLastRunId;
        this.info("sendRequestForRunfFiles for  " + remoteSiteNumber);
        Run[] runs = (Run[])PacketFactory.getObjectValue(packet, "RUN_LIST");
        if (runs != null && (localLastRunId = (list = new RunFilesList(this.contest.getStorage())).getLastRunFilesRunId(remoteSiteNumber)) < (lastRemoteRunId = this.getLastRunId(runs, remoteSiteNumber))) {
            this.sendRunFilesRequestToServer(remoteSiteNumber, localLastRunId);
            this.info("sendRequestForRunfFiles to " + remoteSiteNumber + " starting at run id # " + localLastRunId);
        }
    }

    private int getLastRunId(Run[] runs, int siteNumber) {
        int maxRunId = 0;
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (run.getSiteNumber() == siteNumber) {
                maxRunId = Math.max(run.getNumber(), maxRunId);
            }
            ++n2;
        }
        return maxRunId;
    }

    private void sendRunFilesRequestToServer(int siteNumber, int lastRunId) {
        ClientId remoteServerId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
        Packet fetchPacket = PacketFactory.createFetchRunFilesPacket(this.contest.getClientId(), remoteServerId, lastRunId);
        System.out.println("Send req for run files " + fetchPacket);
        this.controller.sendToClient(fetchPacket);
    }

    private void sendRunFilesToServer(int siteNumber, int lastRunId) {
        Run[] runs = this.getLocalRunsStartingAt(lastRunId);
        RunFiles[] files = this.getRunFiles(runs);
        ClientId remoteServerId = new ClientId(siteNumber, ClientType.Type.SERVER, 0);
        Packet runFilesPacket = PacketFactory.createRunFilesPacket(this.contest.getClientId(), remoteServerId, files);
        this.controller.sendToClient(runFilesPacket);
    }

    private RunFiles[] getRunFiles(Run[] runs) {
        Vector<RunFiles> runFilesList = new Vector<RunFiles>();
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            try {
                RunFiles runfiles = this.contest.getRunFiles(run);
                runFilesList.add(runfiles);
            }
            catch (Exception e) {
                this.controller.logWarning("Unable to get RunFiles for run " + run, e);
            }
            ++n2;
        }
        return runFilesList.toArray(new RunFiles[runFilesList.size()]);
    }

    private Run[] getLocalRunsStartingAt(int lastRunId) {
        Filter filter = new Filter();
        filter.setSiteNumber(this.contest.getSiteNumber());
        Run[] runs = filter.getRuns(this.contest.getRuns());
        Vector<Run> listOfRuns = new Vector<Run>();
        Run[] runArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            Run run = runArray[n2];
            if (run.getNumber() > lastRunId) {
                listOfRuns.add(run);
            }
            ++n2;
        }
        return listOfRuns.toArray(new Run[listOfRuns.size()]);
    }

    private void otherLoginActivities(Packet packet, ConnectionHandlerID connectionHandlerID) {
        if (this.contest.isLoggedIn()) {
            if (this.contest.getContestTime() == null) {
                ContestTime contestTime = new ContestTime();
                contestTime.setSiteNumber(this.contest.getSiteNumber());
                this.contest.addContestTime(contestTime);
            }
            this.controller.startMainUI(this.contest.getClientId());
            if (this.isServer()) {
                this.loginToOtherSites(packet);
            }
        } else {
            String message = "Trouble logging in, check logs";
            this.contest.loginDenied(packet.getDestinationId(), connectionHandlerID, message);
        }
    }

    private void storeProfiles() {
        ProfileManager manager = new ProfileManager();
        try {
            Profile[] list = new Profile[]{};
            if (manager.hasDefaultProfile()) {
                list = manager.load();
            }
            if (list.length <= 1 && this.contest.getProfiles().length == 1) {
                manager.storeDefaultProfile(this.contest.getProfile());
            } else {
                manager.mergeProfiles(this.contest);
                manager.store(this.contest.getProfiles(), this.contest.getProfile());
            }
        }
        catch (Exception e) {
            this.controller.logWarning("Problem saving/loading profiles from profile properties file", e);
            e.printStackTrace();
        }
    }

    private void updateSitesToModel(Packet packet) {
        try {
            Site[] sites = (Site[])PacketFactory.getObjectValue(packet, "SITE_LIST");
            if (sites != null) {
                Site[] siteArray = sites;
                int n = sites.length;
                int n2 = 0;
                while (n2 < n) {
                    Site site = siteArray[n2];
                    this.info("updateSitesToModel " + site);
                    this.contest.updateSite(site);
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            this.controller.getLog().log(Log.WARNING, "Exception logged ", e);
        }
    }

    private void loginToOtherSites(Packet packet) {
        this.dumpServerLoginLists("loginToOtherSites");
        Site[] siteArray = this.contest.getSites();
        int n = siteArray.length;
        int n2 = 0;
        while (n2 < n) {
            Site site = siteArray[n2];
            ClientId remoteServerId = new ClientId(site.getSiteNumber(), ClientType.Type.SERVER, 0);
            if (this.contest.isLocalLoggedIn(remoteServerId)) {
                this.info("loginToOtherSites site " + site.getSiteNumber() + " already logged in, not attempting to login");
            } else if (!this.isThisSite(site.getSiteNumber())) {
                try {
                    if (this.contest.isRemoteLoggedIn(remoteServerId)) {
                        this.controller.sendServerLoginRequest(site.getSiteNumber());
                    } else if (this.contest.isLocalLoggedIn(remoteServerId)) {
                        this.info("Not logging into site " + site.getSiteNumber() + ", site already logged in");
                    } else {
                        this.info("Not logging into site " + site.getSiteNumber() + ", site is not connected to contest.");
                    }
                }
                catch (Exception e) {
                    this.controller.getLog().log(Log.WARNING, "Exception logging into other site ", e);
                }
            }
            ++n2;
        }
    }

    private Account[] getAllAccounts() {
        Vector<Account> allAccounts = new Vector<Account>();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientType.Type ctype = typeArray[n2];
            if (this.contest.getAccounts(ctype).size() > 0) {
                Vector<Account> accounts = this.contest.getAccounts(ctype);
                allAccounts.addAll(accounts);
            }
            ++n2;
        }
        Account[] accountList = allAccounts.toArray(new Account[allAccounts.size()]);
        return accountList;
    }

    private ClientId[] getAllRemoteLoggedInUsers() {
        Vector<ClientId> clientList = new Vector<ClientId>();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId[] users;
            ClientType.Type ctype = typeArray[n2];
            ClientId[] clientIdArray = users = this.contest.getRemoteLoggedInClients(ctype);
            int n3 = users.length;
            int n4 = 0;
            while (n4 < n3) {
                ClientId clientId = clientIdArray[n4];
                clientList.addElement(clientId);
                ++n4;
            }
            ++n2;
        }
        if (clientList.size() == 0) {
            return new ClientId[0];
        }
        ClientId[] clients = clientList.toArray(new ClientId[clientList.size()]);
        return clients;
    }

    private ClientId[] getAllLocalLoggedInUsers() {
        Vector<ClientId> clientList = new Vector<ClientId>();
        ClientType.Type[] typeArray = ClientType.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientId[] users;
            ClientType.Type ctype = typeArray[n2];
            ClientId[] clientIdArray = users = this.contest.getLocalLoggedInClients(ctype);
            int n3 = users.length;
            int n4 = 0;
            while (n4 < n3) {
                ClientId clientId = clientIdArray[n4];
                clientList.addElement(clientId);
                ++n4;
            }
            ++n2;
        }
        if (clientList.size() == 0) {
            return new ClientId[0];
        }
        ClientId[] clients = clientList.toArray(new ClientId[clientList.size()]);
        return clients;
    }

    Packet createContestSettingsPacket(ClientId clientId, Packet packet) {
        return PacketFactory.createContestSettingsPacket(this.contest.getClientId(), clientId, packet);
    }

    public Packet createContestSettingsPacket(ClientId clientId) {
        return PacketFactory.createContestSettingsPacket(this.contest.getClientId(), clientId, this.createLoginSuccessPacket(clientId, null));
    }

    public ContestLoginSuccessData createContestLoginSuccessData(IInternalContest inContest, ClientId clientId, String contestSecurityPassword) {
        Run[] runs = null;
        Clarification[] clarifications = null;
        ProblemDataFiles[] problemDataFiles = new ProblemDataFiles[]{};
        ClientSettings[] clientSettings = null;
        Account[] accounts = null;
        Site[] sites = null;
        Profile[] profiles = null;
        FinalizeData finalizeData = null;
        if (inContest.getClientSettings(clientId) == null) {
            ClientSettings clientSettings2 = new ClientSettings(clientId);
            clientSettings2.put("LoginDate", new Date().toString());
            inContest.addClientSettings(clientSettings2);
        }
        if (clientId.getClientType().equals((Object)ClientType.Type.TEAM)) {
            runs = inContest.getRuns(clientId);
            clarifications = inContest.getClarifications(clientId);
            clientSettings = new ClientSettings[]{inContest.getClientSettings(clientId)};
            accounts = new Account[]{inContest.getAccount(clientId)};
            Site[] realSites = inContest.getSites();
            sites = new Site[realSites.length];
            int i = 0;
            while (i < realSites.length) {
                sites[i] = new Site(realSites[i].getDisplayName(), realSites[i].getSiteNumber());
                ++i;
            }
            Profile profile = inContest.getProfile();
            profiles = new Profile[]{profile};
        } else {
            runs = inContest.getRuns();
            clarifications = inContest.getClarifications();
            problemDataFiles = inContest.getProblemDataFiles();
            clientSettings = inContest.getClientSettingsList();
            accounts = this.getAllAccounts();
            sites = inContest.getSites();
            profiles = inContest.getProfiles();
            finalizeData = inContest.getFinalizeData();
        }
        ContestLoginSuccessData contestLoginSuccessData = new ContestLoginSuccessData();
        contestLoginSuccessData.setAccounts(accounts);
        contestLoginSuccessData.setBalloonSettingsArray(inContest.getBalloonSettings());
        contestLoginSuccessData.setClarifications(clarifications);
        contestLoginSuccessData.setClientSettings(clientSettings);
        contestLoginSuccessData.setConnectionHandlerIDs(inContest.getConnectionHandleIDs());
        contestLoginSuccessData.setContestTimes(inContest.getContestTimes());
        contestLoginSuccessData.setGroups(inContest.getGroups());
        contestLoginSuccessData.setJudgements(inContest.getJudgements());
        contestLoginSuccessData.setLanguages(inContest.getLanguages());
        contestLoginSuccessData.setRemoteLoggedInUsers(this.getAllRemoteLoggedInUsers());
        contestLoginSuccessData.setLocalLoggedInUsers(this.getAllLocalLoggedInUsers());
        contestLoginSuccessData.setProblemDataFiles(problemDataFiles);
        contestLoginSuccessData.setProblems(inContest.getProblems());
        contestLoginSuccessData.setRuns(runs);
        contestLoginSuccessData.setSites(sites);
        contestLoginSuccessData.setGeneralProblem(inContest.getGeneralProblem());
        contestLoginSuccessData.setContestIdentifier(inContest.getContestIdentifier().toString());
        contestLoginSuccessData.setProfile(inContest.getProfile());
        contestLoginSuccessData.setProfiles(inContest.getProfiles());
        contestLoginSuccessData.setContestTime(inContest.getContestTime());
        contestLoginSuccessData.setSiteNumber(inContest.getSiteNumber());
        contestLoginSuccessData.setContestInformation(inContest.getContestInformation());
        contestLoginSuccessData.setFinalizeData(finalizeData);
        if (this.isServer(clientId)) {
            contestLoginSuccessData.setContestSecurityPassword(contestSecurityPassword);
        }
        if (inContest.getCategories() != null) {
            contestLoginSuccessData.setCategories(inContest.getCategories());
        }
        return contestLoginSuccessData;
    }

    public Packet createLoginSuccessPacket(ClientId targetClientId, String contestSecurityPassword) {
        ContestLoginSuccessData data = this.createContestLoginSuccessData(this.contest, targetClientId, contestSecurityPassword);
        Packet loginSuccessPacket = PacketFactory.createLoginSuccess(this.contest.getClientId(), targetClientId, this.contest.getContestTime(), this.contest.getSiteNumber(), this.contest.getContestInformation(), data);
        return loginSuccessPacket;
    }

    private void handleServerStatus(Packet packet, ConnectionHandlerID connectionHandlerID) {
        Site site = (Site)PacketFactory.getObjectValue(packet, "SITE");
        Profile inProfile = (Profile)PacketFactory.getObjectValue(packet, "PROFILE");
        ProfileChangeStatus.Status status = (ProfileChangeStatus.Status)((Object)PacketFactory.getObjectValue(packet, "PROFILE_STATUS"));
        this.contest.updateSiteStatus(site, inProfile, status);
        if (this.isServer()) {
            this.controller.sendToJudgesAndOthers(packet, false);
        }
    }

    private void handleRequestServerStatus(Packet packet, ConnectionHandlerID connectionHandlerID) {
        int targetSiteNumber = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        ClientId remoteServerId = new ClientId(targetSiteNumber, ClientType.Type.SERVER, 0);
        if (this.isThisSite(targetSiteNumber)) {
            Profile expectedProfile = (Profile)PacketFactory.getObjectValue(packet, "PROFILE");
            this.sendStatusToServers(packet, expectedProfile);
        } else {
            Packet clonePacket = PacketFactory.clonePacket(this.getServerClientId(), remoteServerId, packet);
            this.controller.sendToClient(clonePacket);
        }
    }

    private void sendStatusToServers(Packet packet, Profile expectedProfile) {
        ProfileChangeStatus.Status status = ProfileChangeStatus.Status.NOTREADY;
        if (this.contest.getProfile().getProfilePath().equals(expectedProfile.getProfilePath())) {
            status = ProfileChangeStatus.Status.READY_TO_SWITCH;
        }
        Site site = this.contest.getSite(this.contest.getSiteNumber());
        Packet statusPacket = PacketFactory.createServerStatusPacket(this.getServerClientId(), PacketFactory.ALL_SERVERS, this.contest.getProfile(), status, site);
        this.controller.sendToServers(statusPacket);
    }

    private boolean isServer(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    private boolean isJudge(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.JUDGE);
    }

    private boolean isServer() {
        return this.isServer(this.contest.getClientId());
    }

    private void info(Exception e) {
        this.controller.getLog().log(Log.INFO, e.getMessage(), e);
        Utilities.debugPrint(e);
    }

    public void info(String s) {
        this.controller.getLog().info(s);
        Utilities.debugPrint(s);
    }

    private void handleShutdownAllServers(Packet packet, ConnectionHandlerID connectionHandlerID, ClientId fromId) {
        ClientId requestor = packet.getSourceId();
        if (!this.contest.isAllowed(requestor, Permission.Type.SHUTDOWN_ALL_SERVERS)) {
            throw new SecurityException("User " + requestor + " not allowed to shutdown all servers");
        }
        this.controller.shutdownRemoteServers(requestor);
        this.sleepSecs(2);
        this.controller.shutdownServer(packet.getSourceId());
    }

    private void sleepSecs(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (Exception exception) {
            System.out.println("Ignore exception during Thread.sleep.");
        }
    }

    private void handleServerShutdown(Packet packet, ConnectionHandlerID connectionHandlerID, ClientId fromId) {
        int siteToShutdown = (Integer)PacketFactory.getObjectValue(packet, "SITE_NUMBER");
        ClientId requestor = packet.getSourceId();
        if (this.contest.isAllowed(requestor, Permission.Type.SHUTDOWN_ALL_SERVERS) || this.contest.isAllowed(requestor, Permission.Type.SHUTDOWN_SERVER)) {
            if (this.isThisSite(siteToShutdown)) {
                this.controller.shutdownServer(packet.getSourceId());
            } else {
                ClientId serverClientId = new ClientId(siteToShutdown, ClientType.Type.SERVER, 0);
                Packet shutdownPacket = PacketFactory.createShutdownPacket(requestor, serverClientId, serverClientId.getSiteNumber());
                this.controller.sendToClient(shutdownPacket);
            }
        } else {
            throw new SecurityException("User " + requestor + " not allowed to shutdown Server at site " + siteToShutdown);
        }
    }

    private void sendMessage(MessageEvent.Area area, String message, Exception ex) {
        this.contest.addMessage(area, this.contest.getClientId(), PacketFactory.ALL_SERVERS, message);
        this.info(ex);
        message = String.valueOf(message) + " " + ex.getMessage();
        Packet messPacket = PacketFactory.createMessage(this.getServerClientId(), PacketFactory.ALL_SERVERS, area, message, ex);
        if (this.isServer()) {
            this.controller.sendToServers(messPacket);
        } else {
            this.controller.sendToLocalServer(messPacket);
        }
    }
}

