/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import java.io.File;

public class CommandVariableReplacer {
    public static final String OPTIONS = "{:options}";
    public static final String FILELIST = "{:filelist}";
    public static final String MAINFILE = "{:mainfile}";
    public static final String BASENAME = "{:basename}";
    public static final String RUNID = "{:runid}";
    public static final String INTERNAL_RUNID = "{:irunid}";
    public static final String PROBLEMSHORTNAME = "{:problemshort}";
    public static final String LANGUAGENAME = "{:languagename}";
    public static final String CLIENTID = "{:clientid}";
    public static final String TEAMID = "{:teamid}";
    public static final String ELAPSEDMS = "{:elapsedms}";
    public static final String ELAPSEDMINUTES = "{:elapsedmins}";
    public static final String ELAPSEDSECONDS = "{:elapsedsecs}";
    public static final String CLIENTTYPE = "{:clienttype}";
    public static final String LANGUAGE = "{:language}";
    public static final String[] VARIABLE_NAMES = new String[]{"{:basename}", "{:clientid}", "{:clienttype}", "{:elapsedmins}", "{:elapsedms}", "{:elapsedsecs}", "{:filelist}", "{:irunid}", "{:language}", "{:languagename}", "{:mainfile}", "{:options}", "{:problemshort}", "{:runid}", "{:teamid}", "{:ansfile}", "{:executetime}", "{:exitvalue}", "{:infile}", "{:languageletter}", "{:outfile}", "{:pc2home}", "{:problemletter}", "{:problem}", "{:siteid}", "{:timelimit}", "{:validator}"};

    public static String replaceString(String origString, String beforeString, String afterString) {
        if (origString == null || afterString == null) {
            return origString;
        }
        int startIdx = origString.lastIndexOf(beforeString);
        if (startIdx == -1) {
            return origString;
        }
        StringBuffer buf = new StringBuffer(origString);
        while (startIdx != -1) {
            buf.replace(startIdx, startIdx + beforeString.length(), afterString);
            startIdx = origString.lastIndexOf(beforeString, startIdx - 1);
        }
        return buf.toString();
    }

    protected String replaceString(String origString, String beforeString, int afterInt) {
        String afterString = new Integer(afterInt).toString();
        return CommandVariableReplacer.replaceString(origString, beforeString, afterString);
    }

    public String substituteExecutableVariables(IInternalContest contest, Run run, RunFiles runFiles, String origString, ExecutionData executionData, ProblemDataFiles problemDataFiles) {
        String pc2home;
        int index;
        Language language;
        int index2;
        SerializedFile validatorFile;
        String newString = "";
        String nullArgument = "-";
        if (run == null) {
            throw new IllegalArgumentException("Run is null");
        }
        if (runFiles == null) {
            throw new IllegalArgumentException("RunFiles is null");
        }
        if (runFiles.getMainFile() == null) {
            throw new IllegalArgumentException("RunFiles.getMainFile is null");
        }
        newString = CommandVariableReplacer.replaceString(origString, MAINFILE, runFiles.getMainFile().getName());
        newString = CommandVariableReplacer.replaceString(newString, BASENAME, this.removeExtension(runFiles.getMainFile().getName()));
        String validatorCommand = null;
        Problem problem = contest.getProblem(run.getProblemId());
        if (problem.getValidatorProgramName() != null) {
            validatorCommand = problem.getValidatorProgramName();
        }
        if (problemDataFiles != null && (validatorFile = problemDataFiles.getValidatorFile()) != null) {
            validatorCommand = validatorFile.getName();
        }
        if (validatorCommand != null) {
            newString = CommandVariableReplacer.replaceString(newString, "{:validator}", validatorCommand);
        }
        if (run.getLanguageId() != null && (index2 = this.getLanguageIndex(contest, language = contest.getLanguage(run.getLanguageId()))) > 0) {
            newString = this.replaceString(newString, LANGUAGE, index2);
            newString = CommandVariableReplacer.replaceString(newString, "{:languageletter}", Utilities.convertNumber(index2));
        }
        if (run.getProblemId() != null && (index = this.getProblemIndex(contest, problem)) > 0) {
            newString = this.replaceString(newString, "{:problem}", index);
            newString = CommandVariableReplacer.replaceString(newString, "{:problemletter}", Utilities.convertNumber(index));
        }
        if (run.getSubmitter() != null) {
            newString = this.replaceString(newString, TEAMID, run.getSubmitter().getClientNumber());
            newString = this.replaceString(newString, "{:siteid}", run.getSubmitter().getSiteNumber());
        }
        if (problem != null) {
            newString = problem.getDataFileName() != null && !problem.getDataFileName().equals("") ? CommandVariableReplacer.replaceString(newString, "{:infile}", problem.getDataFileName()) : CommandVariableReplacer.replaceString(newString, "{:infile}", nullArgument);
            newString = problem.getAnswerFileName() != null && !problem.getAnswerFileName().equals("") ? CommandVariableReplacer.replaceString(newString, "{:ansfile}", problem.getAnswerFileName()) : CommandVariableReplacer.replaceString(newString, "{:ansfile}", nullArgument);
            newString = CommandVariableReplacer.replaceString(newString, "{:timelimit}", Long.toString(problem.getTimeOutInSeconds()));
        }
        if (executionData != null) {
            if (executionData.getExecuteProgramOutput() != null) {
                newString = executionData.getExecuteProgramOutput().getName() != null ? CommandVariableReplacer.replaceString(newString, "{:outfile}", executionData.getExecuteProgramOutput().getName()) : CommandVariableReplacer.replaceString(newString, "{:outfile}", nullArgument);
            }
            newString = CommandVariableReplacer.replaceString(newString, "{:exitvalue}", Integer.toString(executionData.getExecuteExitValue()));
            newString = CommandVariableReplacer.replaceString(newString, "{:executetime}", Long.toString(executionData.getExecuteTimeMS()));
        }
        if ((pc2home = new VersionInfo().locateHome()) != null && pc2home.length() > 0) {
            newString = CommandVariableReplacer.replaceString(newString, "{:pc2home}", pc2home);
        }
        return newString;
    }

    public int getProblemIndex(IInternalContest contest, Problem inProblem) {
        int idx = 0;
        Problem[] problemArray = contest.getProblems();
        int n = problemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            if (problem.isActive()) {
                if (problem.getElementId().equals(inProblem.getElementId())) {
                    return idx + 1;
                }
                ++idx;
            }
            ++n2;
        }
        return -1;
    }

    public int getLanguageIndex(IInternalContest contest, Language inLanguage) {
        int idx = 0;
        Language[] languageArray = contest.getLanguages();
        int n = languageArray.length;
        int n2 = 0;
        while (n2 < n) {
            Language language = languageArray[n2];
            if (language.isActive()) {
                if (language.getElementId().equals(inLanguage.getElementId())) {
                    return idx + 1;
                }
                ++idx;
            }
            ++n2;
        }
        return -1;
    }

    public String removeExtension(String original) {
        String outString = new String(original);
        int dotIndex = outString.lastIndexOf(46, outString.length() - 1);
        if (dotIndex != -1) {
            outString = outString.substring(0, dotIndex);
        }
        return outString;
    }

    public static String replaceInteger(String origString, String beforeString, int integer) {
        return CommandVariableReplacer.replaceString(origString, beforeString, Integer.toString(integer));
    }

    public static String replaceLong(String origString, String beforeString, long longValue) {
        return CommandVariableReplacer.replaceString(origString, beforeString, Long.toString(longValue));
    }

    public String substituteVariables(String command, IInternalContest contest, Run run, RunFiles runFiles, String runDir, ExecutionData executionData, ProblemDataFiles problemDataFiles) throws Exception {
        Problem problem;
        String mainfileName;
        String fileList = mainfileName = this.getMainFileName(runDir, runFiles);
        if (runFiles.getOtherFiles() != null) {
            SerializedFile[] serializedFileArray = runFiles.getOtherFiles();
            int n = serializedFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                SerializedFile file = serializedFileArray[n2];
                String outfilename = String.valueOf(runDir) + File.separator + file.getName();
                fileList = String.valueOf(fileList) + " " + outfilename;
                ++n2;
            }
        }
        if ((problem = contest.getProblem(run.getProblemId())) == null) {
            throw new Exception("Could not find problem for id=" + run.getProblemId() + " " + run);
        }
        Language language = contest.getLanguage(run.getLanguageId());
        if (language == null) {
            throw new Exception("Could not find language for id=" + run.getLanguageId() + " " + run);
        }
        Account account = contest.getAccount(run.getSubmitter());
        if (account == null) {
            throw new Exception("Could not find account for id=" + run.getSubmitter() + " " + run);
        }
        String newCommand = command;
        newCommand = CommandVariableReplacer.replaceString(newCommand, FILELIST, fileList);
        StringBuffer buffer = new StringBuffer();
        buffer.append(" -p ").append(problem.getShortName()).append(" -l ").append(language.getDisplayName()).append(" -u ").append(run.getSubmitter().getClientNumber()).append(" -m ").append(mainfileName).append(" -i ").append(run.getNumber()).append(" -t ").append(run.getElapsedMS());
        newCommand = CommandVariableReplacer.replaceString(newCommand, MAINFILE, mainfileName);
        newCommand = CommandVariableReplacer.replaceString(newCommand, BASENAME, this.removeExtension(mainfileName));
        newCommand = CommandVariableReplacer.replaceString(newCommand, OPTIONS, buffer.toString());
        newCommand = CommandVariableReplacer.replaceInteger(newCommand, RUNID, run.getNumber());
        newCommand = CommandVariableReplacer.replaceInteger(newCommand, INTERNAL_RUNID, run.internalRunId());
        newCommand = CommandVariableReplacer.replaceString(newCommand, PROBLEMSHORTNAME, problem.getShortName());
        newCommand = CommandVariableReplacer.replaceString(newCommand, LANGUAGENAME, language.getDisplayName());
        ClientId submitter = run.getSubmitter();
        newCommand = CommandVariableReplacer.replaceInteger(newCommand, CLIENTID, submitter.getClientNumber());
        newCommand = CommandVariableReplacer.replaceString(newCommand, CLIENTTYPE, submitter.getClientType().toString());
        newCommand = CommandVariableReplacer.replaceLong(newCommand, ELAPSEDMS, run.getElapsedMS());
        newCommand = CommandVariableReplacer.replaceLong(newCommand, ELAPSEDMINUTES, run.getElapsedMins());
        newCommand = CommandVariableReplacer.replaceLong(newCommand, ELAPSEDSECONDS, run.getElapsedMS() / 1000L);
        newCommand = this.substituteExecutableVariables(contest, run, runFiles, newCommand, executionData, problemDataFiles);
        return newCommand;
    }

    public String getMainFileName(String runDir, RunFiles runFiles) {
        if (runDir != null) {
            return String.valueOf(runDir) + File.separator + runFiles.getMainFile().getName();
        }
        return runFiles.getMainFile().getName();
    }
}

