/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.reports;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IProblemDetails;
import edu.csus.ecs.pc2.api.IStanding;
import edu.csus.ecs.pc2.api.ITeam;
import edu.csus.ecs.pc2.api.reports.APIAbstractTest;

public class PrintStandingForUser
extends APIAbstractTest {
    @Override
    public void printTest() {
        ITeam team = this.lookupTeam(this.getContest().getMyClient());
        if (team == null) {
            this.println("No team found for user " + this.getContest().getMyClient().getLoginName());
        } else {
            IStanding standing = this.getContest().getStanding(team);
            IClient client = standing.getClient();
            this.println("Rank " + standing.getRank() + " solved= " + standing.getNumProblemsSolved() + " pts= " + standing.getPenaltyPoints() + " " + "s" + client.getSiteNumber() + "t" + client.getAccountNumber() + " " + client.getDisplayName());
            IProblemDetails[] details = standing.getProblemDetails();
            this.println("There are " + details.length + " scoreboard details ");
            IProblemDetails[] iProblemDetailsArray = details;
            int n = details.length;
            int n2 = 0;
            while (n2 < n) {
                IProblemDetails det = iProblemDetailsArray[n2];
                boolean solved = det.getSolutionTime() != 0L;
                this.println("  solved=" + solved + " solutionTime=" + det.getSolutionTime() + " points=" + det.getPenaltyPoints() + " attempts=" + det.getAttempts());
                ++n2;
            }
        }
        this.println();
    }

    private ITeam lookupTeam(IClient client) {
        ITeam[] teams;
        ITeam[] iTeamArray = teams = this.getContest().getTeams();
        int n = teams.length;
        int n2 = 0;
        while (n2 < n) {
            ITeam team = iTeamArray[n2];
            if (this.sameAs(team, client)) {
                return team;
            }
            ++n2;
        }
        return null;
    }

    private boolean sameAs(IClient client1, IClient client2) {
        return client1.equals(client2);
    }

    @Override
    public String getTitle() {
        return "getStandings(user)";
    }
}

