/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.reports;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IRun;
import edu.csus.ecs.pc2.api.IRunComparator;
import edu.csus.ecs.pc2.api.reports.APIAbstractTest;
import java.util.Arrays;

public class PrintRuns
extends APIAbstractTest {
    @Override
    public void printTest() {
        if (this.getContest().getRuns().length == 0) {
            this.println("No runs in system");
            return;
        }
        IRun[] runs = this.getContest().getRuns();
        Arrays.sort(runs, new IRunComparator());
        this.println("There are " + runs.length + " runs.");
        IRun[] iRunArray = runs;
        int n = runs.length;
        int n2 = 0;
        while (n2 < n) {
            IRun run = iRunArray[n2];
            this.print("Run " + run.getNumber() + " Site " + run.getSiteNumber());
            this.print(" @ " + run.getSubmissionTime() + " by " + run.getTeam().getLoginName());
            this.print(" problem: " + run.getProblem().getName());
            this.print(" in " + run.getLanguage().getName());
            if (run.isFinalJudged()) {
                this.println("  Final Judgement: " + run.getJudgementName());
            } else if (run.isPreliminaryJudged()) {
                this.println("  Preliminary Judgement: " + run.getJudgementName());
            } else {
                this.println("  Judgement: not judged yet ");
            }
            this.println();
            ++n2;
        }
    }

    @Override
    public String getTitle() {
        return "getRuns, IRun, etc.";
    }

    public void printClient(APIAbstractTest abstractTest, String title, IClient client) {
        abstractTest.print(String.valueOf(title) + " login=" + client.getLoginName());
        abstractTest.print(", name=" + client.getDisplayName());
        abstractTest.print(", type=" + (Object)((Object)client.getType()));
        abstractTest.print(", account#=" + client.getAccountNumber());
        abstractTest.print(", site=" + client.getSiteNumber());
        abstractTest.println();
    }
}

