/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.reports;

import edu.csus.ecs.pc2.api.IClarification;
import edu.csus.ecs.pc2.api.reports.APIAbstractTest;
import edu.csus.ecs.pc2.api.reports.APIPrintReports;

public class PrintClarification
extends APIAbstractTest {
    @Override
    public void printTest() {
        int clarificationNumber = this.getNumber();
        if (clarificationNumber < 1) {
            this.println("getRun() Select a run number");
        } else {
            int siteNum = this.getSiteNumber();
            if (siteNum == 0) {
                siteNum = this.getContest().getMyClient().getSiteNumber();
            }
            boolean foundClarification = false;
            IClarification[] iClarificationArray = this.getContest().getClarifications();
            int n = iClarificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClarification clarification = iClarificationArray[n2];
                if (clarification.getNumber() == clarificationNumber && clarification.getSiteNumber() == siteNum) {
                    foundClarification = true;
                    this.print("Clar " + clarification.getNumber() + " Site " + clarification.getSiteNumber());
                    this.print(" @ " + clarification.getSubmissionTime() + " by " + clarification.getTeam().getLoginName());
                    this.print(" problem: " + clarification.getProblem().getName());
                    this.print(" " + APIPrintReports.trueFalseString(clarification.isAnswered(), "ANSWERED", "NOT ANSWERED"));
                    this.print(" " + APIPrintReports.trueFalseString(clarification.isDeleted(), "DELETED", ""));
                    this.print(" " + APIPrintReports.trueFalseString(clarification.isSendToAll(), "SEND TO ALL", "NOT SENT TO ALL"));
                    this.println();
                    this.println("  Question: " + clarification.getQuestion());
                    if (clarification.isAnswered()) {
                        this.println("    Answer: " + clarification.getAnswer());
                    }
                    this.println();
                    break;
                }
                ++n2;
            }
            if (!foundClarification) {
                this.println("No such clarification " + clarificationNumber + " eists at site " + siteNum);
            }
        }
    }

    @Override
    public String getTitle() {
        return "getClarification";
    }
}

