/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IGroup;
import edu.csus.ecs.pc2.api.ITeam;
import edu.csus.ecs.pc2.api.implementation.ClientImplementation;
import edu.csus.ecs.pc2.api.implementation.GroupImplementation;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.IInternalContest;

public class TeamImplementation
extends ClientImplementation
implements ITeam {
    private String displayName;
    private String shortName;
    private IGroup group = null;

    public TeamImplementation(ClientId submitter, IInternalContest internalContest) {
        super(submitter, internalContest);
        Account account = internalContest.getAccount(submitter);
        if (account != null) {
            this.setAccountValues(account, internalContest);
        } else {
            this.displayName = submitter.getName();
            this.shortName = submitter.getName();
        }
    }

    private void setAccountValues(Account account, IInternalContest contest) {
        this.displayName = account.getDisplayName();
        this.shortName = account.getClientId().getName();
        if (account.getGroupId() != null && contest.getGroup(account.getGroupId()) != null) {
            this.group = new GroupImplementation(account.getGroupId(), contest);
        }
    }

    public TeamImplementation(Account account, IInternalContest contest) {
        super(account.getClientId(), contest);
        this.setAccountValues(account, contest);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public IGroup getGroup() {
        return this.group;
    }

    @Override
    public String getLoginName() {
        return this.shortName;
    }
}

