/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.ui.FrameUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class ScrollyFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JScrollPane scrollPane = null;
    private JList<String> listOfStuff = null;
    private DefaultListModel<String> defaultListModel = new DefaultListModel();
    private JPanel mainPanel = null;
    private JPanel buttonPane = null;
    private JButton clearButton = null;

    public ScrollyFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(481, 291));
        this.setContentPane(this.getMainPanel());
        this.setTitle("List");
        this.setHeightScreenLength(120);
        FrameUtilities.setFramePosition(this, FrameUtilities.HorizontalPosition.RIGHT, FrameUtilities.VerticalPosition.CENTER);
    }

    private void setHeightScreenLength(int pixelBuffer) {
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameDim = this.getSize();
        frameDim.height = screenDim.height - pixelBuffer / 2;
        this.setSize(frameDim);
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getListOfStuff());
        }
        return this.scrollPane;
    }

    private JList<String> getListOfStuff() {
        if (this.listOfStuff == null) {
            this.listOfStuff = new JList<String>(this.defaultListModel);
            this.listOfStuff.setFont(new Font("Courier New", 1, 12));
        }
        return this.listOfStuff;
    }

    public void addLine(final String line) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScrollyFrame.this.defaultListModel.addElement(line);
            }
        });
    }

    @Override
    public void removeAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScrollyFrame.this.defaultListModel.removeAllElements();
            }
        });
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getScrollPane(), "Center");
            this.mainPanel.add((Component)this.getButtonPane(), "South");
        }
        return this.mainPanel;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getClearButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setText("Clear");
            this.clearButton.setMnemonic(67);
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScrollyFrame.this.removeAll();
                }
            });
        }
        return this.clearButton;
    }

    public static void main(String[] args) {
        ScrollyFrame scrollyFrame = new ScrollyFrame();
        scrollyFrame.setDefaultCloseOperation(3);
        scrollyFrame.setVisible(true);
        int i = 0;
        while (i < 34) {
            scrollyFrame.addLine("Line " + i);
            ++i;
        }
    }
}

