/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IJudgement;
import edu.csus.ecs.pc2.api.IRunJudgement;
import edu.csus.ecs.pc2.api.implementation.ClientImplementation;
import edu.csus.ecs.pc2.api.implementation.JudgementImplementation;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;

public class RunJudgementImplemenation
implements IRunJudgement {
    private JudgementRecord record = null;
    private IInternalContest internalContest = null;
    private IInternalController controller = null;

    public RunJudgementImplemenation(JudgementRecord record, Run run, IInternalContest internalContest, IInternalController controller) {
        this.record = record;
        this.internalContest = internalContest;
        this.controller = controller;
    }

    @Override
    public IJudgement getJudgement() {
        Judgement judgement = this.internalContest.getJudgement(this.record.getJudgementId());
        return new JudgementImplementation(judgement);
    }

    @Override
    public boolean isActive() {
        return this.record.isActive();
    }

    @Override
    public boolean isComputerJudgement() {
        return this.record.isComputerJudgement();
    }

    @Override
    public boolean isSendToTeam() {
        return this.record.isSendToTeam();
    }

    @Override
    public boolean isPreliminaryJudgement() {
        return this.record.isPreliminaryJudgement();
    }

    @Override
    public boolean isSolved() {
        return this.record.isSolved();
    }

    @Override
    public IClient getJudge() {
        return new ClientImplementation(this.record.getJudgerClientId(), this.internalContest);
    }
}

