/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.ILanguage;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Language;

public class LanguageImplementation
implements ILanguage {
    private String name;
    private ElementId elementId;
    private String compilerCommandLine;
    private String executionCommandLine;
    private boolean interpreted;
    private String executableMask;

    public LanguageImplementation(ElementId languageId, IInternalContest internalContest) {
        this(internalContest.getLanguage(languageId));
    }

    public LanguageImplementation(Language language) {
        this.name = language.getDisplayName();
        this.elementId = language.getElementId();
        this.compilerCommandLine = language.getCompileCommandLine();
        this.executionCommandLine = language.getProgramExecuteCommandLine();
        this.interpreted = language.isInterpreted();
        this.executableMask = language.getExecutableIdentifierMask();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof LanguageImplementation) {
            LanguageImplementation languageImplementation = (LanguageImplementation)obj;
            return languageImplementation.elementId.equals(this.elementId);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.elementId.toString().hashCode();
    }

    public ElementId getElementId() {
        return this.elementId;
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    @Override
    public String getCompilerCommandLine() {
        return this.compilerCommandLine;
    }

    @Override
    public boolean isInterpreted() {
        return this.interpreted;
    }

    @Override
    public String getExecutionCommandLine() {
        return this.executionCommandLine;
    }

    @Override
    public String getExecutableMask() {
        return this.executableMask;
    }
}

