/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IProblemDetails;
import edu.csus.ecs.pc2.api.IStanding;
import edu.csus.ecs.pc2.api.implementation.ClientImplementation;
import edu.csus.ecs.pc2.api.implementation.ProblemDetailsComparator;
import edu.csus.ecs.pc2.api.implementation.ProblemDetailsImplementation;
import edu.csus.ecs.pc2.api.implementation.ProblemImplementation;
import edu.csus.ecs.pc2.api.implementation.StandingImplementation;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenerateStandings {
    private ProblemDetailsComparator detailsComparator = new ProblemDetailsComparator();

    private String[] fetchStandingRow(Node node) {
        String[] outArray = new String[7];
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node standingNode = attributes.item(i);
            String value = standingNode.getNodeValue();
            String name = standingNode.getNodeName();
            if (name.equals("rank")) {
                outArray[0] = value;
            } else if (name.equals("teamName")) {
                outArray[1] = value;
            } else if (name.equals("solved")) {
                outArray[2] = value;
            } else if (name.equals("points")) {
                outArray[3] = value;
            } else if (name.equals("teamId")) {
                outArray[4] = value;
            } else if (name.equals("teamSiteId")) {
                outArray[5] = value;
            } else if (name.equals("teamKey")) {
                outArray[6] = value;
            }
            ++i;
        }
        return outArray;
    }

    IProblemDetails[] getDetails(IClient client, IProblemDetails[] detailList) {
        Vector<IProblemDetails> outvect = new Vector<IProblemDetails>();
        IProblemDetails[] iProblemDetailsArray = detailList;
        int n = detailList.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemDetails d = iProblemDetailsArray[n2];
            if (d.getClient().getAccountNumber() == client.getAccountNumber() && d.getClient().getSiteNumber() == client.getSiteNumber()) {
                outvect.add(d);
            }
            ++n2;
        }
        IProblemDetails[] details = outvect.toArray(new IProblemDetails[outvect.size()]);
        Arrays.sort(details, this.detailsComparator);
        return details;
    }

    public void updateProblemDetails(StandingImplementation[] standingsList, IProblemDetails[] detailsList) {
        StandingImplementation[] standingImplementationArray = standingsList;
        int n = standingsList.length;
        int n2 = 0;
        while (n2 < n) {
            StandingImplementation standings = standingImplementationArray[n2];
            IProblemDetails[] details = this.getDetails(standings.getClient(), detailsList);
            standings.setProblemDetails(details);
            ++n2;
        }
    }

    public IProblemDetails[] getProblemDetails(IInternalContest contest, String xmlString, Log log) throws ParserConfigurationException, SAXException, IOException {
        Vector<IProblemDetails> details = new Vector<IProblemDetails>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
        NodeList list = document.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            String name = node.getNodeName();
            if (name.equals("teamStanding")) {
                try {
                    IProblemDetails[] clientProblemDetails;
                    String[] cols = this.fetchStandingRow(node);
                    int clientNumber = Integer.parseInt(cols[4]);
                    int siteNumber = Integer.parseInt(cols[5]);
                    ClientId clientId = new ClientId(siteNumber, ClientType.Type.TEAM, clientNumber);
                    ClientImplementation client = new ClientImplementation(clientId, contest);
                    IProblemDetails[] iProblemDetailsArray = clientProblemDetails = this.getClientProblemDetails(contest, client, node);
                    int n = clientProblemDetails.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProblemDetails problemDetails = iProblemDetailsArray[n2];
                        details.add(problemDetails);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.log(Log.WARNING, "Exception while parsing/generating standings row ", e);
                }
            }
            ++i;
        }
        return details.toArray(new IProblemDetails[details.size()]);
    }

    public IProblemDetails[] getProblemDetails(IInternalContest contest, Log log) {
        String xmlString = null;
        try {
            DefaultScoringAlgorithm defaultScoringAlgorithm = new DefaultScoringAlgorithm();
            xmlString = defaultScoringAlgorithm.getStandings(contest, new Properties(), log);
            return this.getProblemDetails(contest, xmlString, log);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Log.WARNING, "Exception logged ", e);
            return new IProblemDetails[0];
        }
    }

    private IProblemDetails[] getClientProblemDetails(IInternalContest contest, IClient clientId, Node parentNode) {
        Vector<ProblemDetailsImplementation> detailsList = new Vector<ProblemDetailsImplementation>();
        NodeList nodeList = parentNode.getChildNodes();
        Problem[] problems = contest.getProblems();
        int i = 0;
        while (i < nodeList.getLength()) {
            ProblemDetailsImplementation problemDetails;
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("problemSummaryInfo") && (problemDetails = this.getClientProblemDetails(node, clientId)).getProblemId() != -1) {
                int problemIndex = problemDetails.getProblemId() - 1;
                ElementId elementId = problems[problemIndex].getElementId();
                ProblemImplementation problemImplementation = new ProblemImplementation(elementId, contest);
                problemDetails.setProblem(problemImplementation);
                detailsList.add(problemDetails);
            }
            ++i;
        }
        return detailsList.toArray(new IProblemDetails[detailsList.size()]);
    }

    ProblemDetailsImplementation getClientProblemDetails(Node parentNode, IClient clientId) {
        ProblemDetailsImplementation problemDetailsImplementation = new ProblemDetailsImplementation(clientId);
        NamedNodeMap attributes = parentNode.getAttributes();
        int j = 0;
        while (j < attributes.getLength()) {
            Node problemNode = attributes.item(j);
            String name = problemNode.getNodeName();
            String value = problemNode.getNodeValue();
            int intvalue = 0;
            try {
                intvalue = Integer.parseInt(value);
            }
            catch (Exception exception) {
                intvalue = -1;
            }
            if (name.equals("index")) {
                problemDetailsImplementation.setProblemId(intvalue);
            } else if (name.equals("attempts")) {
                problemDetailsImplementation.setAttempts(intvalue);
            } else if (name.equals("isSolved")) {
                problemDetailsImplementation.setSolved(value.equals("true"));
            } else if (name.equals("points")) {
                problemDetailsImplementation.setPenaltyPoints(intvalue);
            } else if (name.equals("solutionTime")) {
                problemDetailsImplementation.setSolutionTime(intvalue);
            }
            ++j;
        }
        return problemDetailsImplementation;
    }

    public IStanding[] getStandings(IInternalContest contest, Log log) {
        Document document = null;
        String xmlString = null;
        Vector<StandingImplementation> standings = new Vector<StandingImplementation>();
        try {
            DefaultScoringAlgorithm defaultScoringAlgorithm = new DefaultScoringAlgorithm();
            xmlString = defaultScoringAlgorithm.getStandings(contest, new Properties(), log);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
            NodeList list = document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("teamStanding")) {
                    try {
                        String[] cols = this.fetchStandingRow(node);
                        int rank = Integer.parseInt(cols[0]);
                        int numProblemsSolved = Integer.parseInt(cols[2]);
                        int penaltyPoints = Integer.parseInt(cols[3]);
                        int clientNumber = Integer.parseInt(cols[4]);
                        int siteNumber = Integer.parseInt(cols[5]);
                        ClientId clientId = new ClientId(siteNumber, ClientType.Type.TEAM, clientNumber);
                        ClientImplementation client = new ClientImplementation(clientId, contest);
                        IProblemDetails[] clientProblemDetails = this.getClientProblemDetails(contest, client, node);
                        StandingImplementation standingImplementation = new StandingImplementation(contest, clientId, rank, numProblemsSolved, penaltyPoints);
                        standingImplementation.setProblemDetails(clientProblemDetails);
                        standings.addElement(standingImplementation);
                    }
                    catch (Exception e) {
                        log.log(Log.WARNING, "Exception while parsing/generating standings row ", e);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception logged ", e);
        }
        return standings.toArray(new StandingImplementation[standings.size()]);
    }
}

