/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.implementation.ClientImplementation;
import edu.csus.ecs.pc2.api.implementation.ContestTimeImplementation;
import edu.csus.ecs.pc2.api.implementation.GroupImplementation;
import edu.csus.ecs.pc2.api.implementation.JudgementImplementation;
import edu.csus.ecs.pc2.api.implementation.LanguageImplementation;
import edu.csus.ecs.pc2.api.implementation.ProblemImplementation;
import edu.csus.ecs.pc2.api.implementation.SiteImplementation;
import edu.csus.ecs.pc2.api.listener.ContestEvent;
import edu.csus.ecs.pc2.api.listener.IConfigurationUpdateListener;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.GroupEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IGroupListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IJudgementListener;
import edu.csus.ecs.pc2.core.model.ILanguageListener;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.JudgementEvent;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageEvent;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import java.util.Vector;

public class ConfigurationListenerList {
    private IInternalContest contest = null;
    private Vector<IConfigurationUpdateListener> listenerList = new Vector();

    public void addContestUpdateConfigurationListener(IConfigurationUpdateListener contestUpdateConfigurationListener) {
        this.listenerList.addElement(contestUpdateConfigurationListener);
    }

    public void removeContestUpdateConfigurationListener(IConfigurationUpdateListener contestUpdateConfigurationListener) {
        this.listenerList.remove(contestUpdateConfigurationListener);
    }

    private void fireProblemListener(ProblemEvent problemEvent) {
        int i = 0;
        while (i < this.listenerList.size()) {
            ProblemImplementation problem = new ProblemImplementation(problemEvent.getProblem().getElementId(), this.contest);
            ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.PROBLEM, problem);
            switch (problemEvent.getAction()) {
                case ADDED: {
                    this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                    break;
                }
                case DELETED: {
                    this.listenerList.elementAt(i).configurationItemRemoved(contestEvent);
                    break;
                }
                default: {
                    this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                }
            }
            ++i;
        }
    }

    private void fireLanguageListener(LanguageEvent languageEvent) {
        int i = 0;
        while (i < this.listenerList.size()) {
            LanguageImplementation language = new LanguageImplementation(languageEvent.getLanguage().getElementId(), this.contest);
            ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.LANGUAGE, language);
            switch (languageEvent.getAction()) {
                case ADDED: {
                    this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                    break;
                }
                case DELETED: {
                    this.listenerList.elementAt(i).configurationItemRemoved(contestEvent);
                    break;
                }
                case ADDED_LANGUAGES: {
                    Language language2;
                    Language[] languageArray = languageEvent.getLanguages();
                    int n = languageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        language2 = languageArray[n2];
                        language = new LanguageImplementation(language2.getElementId(), this.contest);
                        contestEvent = new ContestEvent(ContestEvent.EventType.LANGUAGE, language);
                        this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                        ++n2;
                    }
                    break;
                }
                case CHANGED_LANGUAGES: {
                    Language language2;
                    Language[] languageArray = languageEvent.getLanguages();
                    int n = languageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        language2 = languageArray[n2];
                        language = new LanguageImplementation(language2.getElementId(), this.contest);
                        contestEvent = new ContestEvent(ContestEvent.EventType.LANGUAGE, language);
                        this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                        ++n2;
                    }
                    break;
                }
                default: {
                    this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                }
            }
            ++i;
        }
    }

    private void fireGroupListener(GroupEvent groupEvent) {
        int i = 0;
        while (i < this.listenerList.size()) {
            GroupImplementation group = new GroupImplementation(groupEvent.getGroup().getElementId(), this.contest);
            ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.GROUP, group);
            switch (groupEvent.getAction()) {
                case ADDED: {
                    this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                    break;
                }
                case DELETED: {
                    this.listenerList.elementAt(i).configurationItemRemoved(contestEvent);
                    break;
                }
                case ADDED_GROUPS: {
                    Group group2;
                    Group[] groupArray = groupEvent.getGroups();
                    int n = groupArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        group2 = groupArray[n2];
                        group = new GroupImplementation(group2.getElementId(), this.contest);
                        contestEvent = new ContestEvent(ContestEvent.EventType.GROUP, group);
                        this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                        ++n2;
                    }
                    break;
                }
                case CHANGED_GROUPS: {
                    Group group2;
                    Group[] groupArray = groupEvent.getGroups();
                    int n = groupArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        group2 = groupArray[n2];
                        group = new GroupImplementation(group2.getElementId(), this.contest);
                        contestEvent = new ContestEvent(ContestEvent.EventType.GROUP, group);
                        this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                        ++n2;
                    }
                    break;
                }
                default: {
                    this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                }
            }
            ++i;
        }
    }

    private void fireContestTimeListener(ContestTimeEvent contestTimeEvent) {
        int i = 0;
        while (i < this.listenerList.size()) {
            ContestTimeImplementation contestTime = new ContestTimeImplementation(contestTimeEvent.getContestTime());
            ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.CONTEST_CLOCK, contestTime);
            switch (contestTimeEvent.getAction()) {
                case ADDED: {
                    this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                    break;
                }
                case DELETED: {
                    this.listenerList.elementAt(i).configurationItemRemoved(contestEvent);
                    break;
                }
                default: {
                    this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                }
            }
            ++i;
        }
    }

    private void fireJudgementListener(JudgementEvent judgementEvent) {
        int i = 0;
        while (i < this.listenerList.size()) {
            JudgementImplementation judgement = new JudgementImplementation(judgementEvent.getJudgement());
            ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.JUDGEMENT, judgement);
            switch (judgementEvent.getAction()) {
                case ADDED: {
                    this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                    break;
                }
                case DELETED: {
                    this.listenerList.elementAt(i).configurationItemRemoved(contestEvent);
                    break;
                }
                default: {
                    this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                }
            }
            ++i;
        }
    }

    private void fireAccountListener(AccountEvent accountEvent) {
        int i = 0;
        while (i < this.listenerList.size()) {
            switch (accountEvent.getAction()) {
                case ADDED: {
                    ClientImplementation client = new ClientImplementation(accountEvent.getAccount().getClientId(), this.contest);
                    ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.CLIENT, client);
                    this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                    break;
                }
                case DELETED: {
                    ClientImplementation client = new ClientImplementation(accountEvent.getAccount().getClientId(), this.contest);
                    ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.CLIENT, client);
                    this.listenerList.elementAt(i).configurationItemRemoved(contestEvent);
                    break;
                }
                case ADDED_ACCOUNTS: {
                    Account account;
                    ContestEvent contestEvent;
                    ClientImplementation client;
                    Account[] accountArray = accountEvent.getAccounts();
                    int n = accountArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        account = accountArray[n2];
                        client = new ClientImplementation(account.getClientId(), this.contest);
                        contestEvent = new ContestEvent(ContestEvent.EventType.CLIENT, client);
                        this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                        ++n2;
                    }
                    break;
                }
                case CHANGED_ACCOUNTS: {
                    Account account;
                    ContestEvent contestEvent;
                    ClientImplementation client;
                    Account[] accountArray = accountEvent.getAccounts();
                    int n = accountArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        account = accountArray[n2];
                        client = new ClientImplementation(account.getClientId(), this.contest);
                        contestEvent = new ContestEvent(ContestEvent.EventType.CLIENT, client);
                        this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                        ++n2;
                    }
                    break;
                }
                default: {
                    ClientImplementation client = new ClientImplementation(accountEvent.getAccount().getClientId(), this.contest);
                    ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.CLIENT, client);
                    this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                }
            }
            ++i;
        }
    }

    private void fireContestInformationListener(ContestInformationEvent contestInformationEvent) {
        int i = 0;
        while (i < this.listenerList.size()) {
            ContestInformation contestInformation = contestInformationEvent.getContestInformation();
            String title = contestInformation.getContestTitle();
            if (title != null) {
                ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.CONTEST_TITLE, title);
                switch (contestInformationEvent.getAction()) {
                    case ADDED: {
                        this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                        break;
                    }
                    case DELETED: {
                        this.listenerList.elementAt(i).configurationItemRemoved(contestEvent);
                        break;
                    }
                    default: {
                        this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                    }
                }
            }
            ++i;
        }
    }

    private void fireSiteListener(SiteEvent event) {
        int i = 0;
        while (i < this.listenerList.size()) {
            SiteImplementation site = new SiteImplementation(event.getSite());
            ContestEvent contestEvent = new ContestEvent(ContestEvent.EventType.SITE, site);
            switch (event.getAction()) {
                case ADDED: {
                    this.listenerList.elementAt(i).configurationItemAdded(contestEvent);
                    break;
                }
                case DELETED: {
                    this.listenerList.elementAt(i).configurationItemRemoved(contestEvent);
                    break;
                }
                case CHANGED: {
                    this.listenerList.elementAt(i).configurationItemUpdated(contestEvent);
                    break;
                }
                case LOGIN: {
                    break;
                }
                case LOGOFF: {
                    break;
                }
            }
            ++i;
        }
    }

    public void setContest(IInternalContest contest) {
        this.contest = contest;
        contest.addProblemListener(new ProblemListener());
        contest.addLanguageListener(new LanguageListener());
        contest.addAccountListener(new AccountListener());
        contest.addGroupListener(new GroupListener());
        contest.addContestTimeListener(new ContestTimeListener());
        contest.addContestInformationListener(new ContestInformationListener());
        contest.addJudgementListener(new JudgementListener());
        contest.addSiteListener(new SiteListener());
    }

    class AccountListener
    implements IAccountListener {
        AccountListener() {
        }

        @Override
        public void accountAdded(AccountEvent event) {
            ConfigurationListenerList.this.fireAccountListener(event);
        }

        @Override
        public void accountModified(AccountEvent event) {
            ConfigurationListenerList.this.fireAccountListener(event);
        }

        @Override
        public void accountsAdded(AccountEvent event) {
            ConfigurationListenerList.this.fireAccountListener(event);
        }

        @Override
        public void accountsModified(AccountEvent event) {
            ConfigurationListenerList.this.fireAccountListener(event);
        }

        @Override
        public void accountsRefreshAll(AccountEvent event) {
        }
    }

    class ContestInformationListener
    implements IContestInformationListener {
        ContestInformationListener() {
        }

        @Override
        public void contestInformationAdded(ContestInformationEvent event) {
            ConfigurationListenerList.this.fireContestInformationListener(event);
        }

        @Override
        public void contestInformationChanged(ContestInformationEvent event) {
            ConfigurationListenerList.this.fireContestInformationListener(event);
        }

        @Override
        public void contestInformationRemoved(ContestInformationEvent event) {
            ConfigurationListenerList.this.fireContestInformationListener(event);
        }

        @Override
        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
        }

        @Override
        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
        }
    }

    class ContestTimeListener
    implements IContestTimeListener {
        ContestTimeListener() {
        }

        @Override
        public void contestStarted(ContestTimeEvent event) {
            ConfigurationListenerList.this.fireContestTimeListener(event);
        }

        @Override
        public void contestStopped(ContestTimeEvent event) {
            ConfigurationListenerList.this.fireContestTimeListener(event);
        }

        @Override
        public void contestTimeAdded(ContestTimeEvent event) {
            ConfigurationListenerList.this.fireContestTimeListener(event);
        }

        @Override
        public void contestTimeChanged(ContestTimeEvent event) {
            ConfigurationListenerList.this.fireContestTimeListener(event);
        }

        @Override
        public void contestTimeRemoved(ContestTimeEvent event) {
            ConfigurationListenerList.this.fireContestTimeListener(event);
        }

        @Override
        public void refreshAll(ContestTimeEvent event) {
        }
    }

    class GroupListener
    implements IGroupListener {
        GroupListener() {
        }

        @Override
        public void groupAdded(GroupEvent event) {
            ConfigurationListenerList.this.fireGroupListener(event);
        }

        @Override
        public void groupChanged(GroupEvent event) {
            ConfigurationListenerList.this.fireGroupListener(event);
        }

        @Override
        public void groupRemoved(GroupEvent event) {
            ConfigurationListenerList.this.fireGroupListener(event);
        }

        @Override
        public void groupRefreshAll(GroupEvent groupEvent) {
        }

        @Override
        public void groupsAdded(GroupEvent event) {
            ConfigurationListenerList.this.fireGroupListener(event);
        }

        @Override
        public void groupsChanged(GroupEvent event) {
            ConfigurationListenerList.this.fireGroupListener(event);
        }
    }

    class JudgementListener
    implements IJudgementListener {
        JudgementListener() {
        }

        @Override
        public void judgementAdded(JudgementEvent event) {
            ConfigurationListenerList.this.fireJudgementListener(event);
        }

        @Override
        public void judgementChanged(JudgementEvent event) {
            ConfigurationListenerList.this.fireJudgementListener(event);
        }

        @Override
        public void judgementRemoved(JudgementEvent event) {
            ConfigurationListenerList.this.fireJudgementListener(event);
        }

        @Override
        public void judgementRefreshAll(JudgementEvent judgementEvent) {
        }
    }

    class LanguageListener
    implements ILanguageListener {
        LanguageListener() {
        }

        @Override
        public void languageAdded(LanguageEvent event) {
            ConfigurationListenerList.this.fireLanguageListener(event);
        }

        @Override
        public void languageChanged(LanguageEvent event) {
            ConfigurationListenerList.this.fireLanguageListener(event);
        }

        @Override
        public void languageRemoved(LanguageEvent event) {
            ConfigurationListenerList.this.fireLanguageListener(event);
        }

        @Override
        public void languageRefreshAll(LanguageEvent event) {
        }

        @Override
        public void languagesAdded(LanguageEvent event) {
            ConfigurationListenerList.this.fireLanguageListener(event);
        }

        @Override
        public void languagesChanged(LanguageEvent event) {
            ConfigurationListenerList.this.fireLanguageListener(event);
        }
    }

    class ProblemListener
    implements IProblemListener {
        ProblemListener() {
        }

        @Override
        public void problemAdded(ProblemEvent event) {
            ConfigurationListenerList.this.fireProblemListener(event);
        }

        @Override
        public void problemChanged(ProblemEvent event) {
            ConfigurationListenerList.this.fireProblemListener(event);
        }

        @Override
        public void problemRemoved(ProblemEvent event) {
            ConfigurationListenerList.this.fireProblemListener(event);
        }

        @Override
        public void problemRefreshAll(ProblemEvent event) {
        }
    }

    class SiteListener
    implements ISiteListener {
        SiteListener() {
        }

        @Override
        public void siteProfileStatusChanged(SiteEvent event) {
        }

        @Override
        public void siteAdded(SiteEvent event) {
            ConfigurationListenerList.this.fireSiteListener(event);
        }

        @Override
        public void siteRemoved(SiteEvent event) {
            ConfigurationListenerList.this.fireSiteListener(event);
        }

        @Override
        public void siteChanged(SiteEvent event) {
            ConfigurationListenerList.this.fireSiteListener(event);
        }

        @Override
        public void siteLoggedOn(SiteEvent event) {
            ConfigurationListenerList.this.fireSiteListener(event);
        }

        @Override
        public void siteLoggedOff(SiteEvent event) {
        }

        @Override
        public void sitesRefreshAll(SiteEvent siteEvent) {
        }
    }
}

