/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IClarificationEventListener;
import edu.csus.ecs.pc2.api.implementation.ClarificationImplementation;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.ClarificationEvent;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import java.util.Vector;

public class ClarificationListenerList {
    private Vector<IClarificationEventListener> listenerList = new Vector();
    private IInternalContest contest = null;
    private IInternalController controller = null;

    private void fireClarificationListener(ClarificationEvent clarificationEvent) {
        int i = 0;
        while (i < this.listenerList.size()) {
            ClarificationImplementation clarification = new ClarificationImplementation(clarificationEvent.getClarification(), this.contest, this.controller);
            switch (clarificationEvent.getAction()) {
                case ADDED: {
                    this.listenerList.elementAt(i).clarificationAdded(clarification);
                    break;
                }
                case DELETED: {
                    this.listenerList.elementAt(i).clarificationRemoved(clarification);
                    break;
                }
                case ANSWERED_CLARIFICATION: {
                    this.listenerList.elementAt(i).clarificationAnswered(clarification);
                    break;
                }
                case CHANGED: 
                case CHECKEDOUT_CLARIFICATION: 
                case CHECKEDOUT_REANSWER_CLARIFICATION: 
                case CLARIFICATION_AVAILABLE: 
                case CLARIFICATION_HELD: 
                case CLARIFICATION_NOT_AVAILABLE: 
                case CLARIFICATION_REVOKED: 
                case REFRESH_ALL: {
                    break;
                }
            }
            ++i;
        }
    }

    public void addClarificationListener(IClarificationEventListener clarificationEventListener) {
        this.listenerList.add(clarificationEventListener);
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.contest.addClarificationListener(new Listener());
    }

    public void removeClarificationListener(IClarificationEventListener clarificationEventListener) {
        this.listenerList.remove(clarificationEventListener);
    }

    class Listener
    implements IClarificationListener {
        Listener() {
        }

        @Override
        public void clarificationAdded(ClarificationEvent event) {
            ClarificationListenerList.this.fireClarificationListener(event);
        }

        @Override
        public void refreshClarfications(ClarificationEvent event) {
            ClarificationListenerList.this.fireClarificationListener(event);
        }

        @Override
        public void clarificationChanged(ClarificationEvent event) {
            ClarificationListenerList.this.fireClarificationListener(event);
        }

        @Override
        public void clarificationRemoved(ClarificationEvent event) {
            ClarificationListenerList.this.fireClarificationListener(event);
        }
    }
}

