/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IContest;
import edu.csus.ecs.pc2.api.ILanguage;
import edu.csus.ecs.pc2.api.IProblem;
import edu.csus.ecs.pc2.api.exceptions.LoginFailureException;
import edu.csus.ecs.pc2.api.exceptions.NotLoggedInException;
import edu.csus.ecs.pc2.api.implementation.Contest;
import edu.csus.ecs.pc2.api.implementation.LanguageImplementation;
import edu.csus.ecs.pc2.api.implementation.ProblemImplementation;
import edu.csus.ecs.pc2.api.listener.IConnectionEventListener;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.ParseArguments;
import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.exception.IllegalContestState;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.InternalContest;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.LanguageAutoFill;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.security.Permission;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

public class ServerConnection {
    private String[] problemPropertyNames = new String[]{"JUDGING_TYPE", "VALIDATOR_PROGRAM", "VALIDATOR_COMMAND_LINE"};
    protected IInternalController controller;
    protected IInternalContest internalContest;
    private Contest contest = null;

    public IContest login(String login, String password) throws LoginFailureException {
        boolean overrideContestUsed = false;
        if (this.contest != null) {
            throw new LoginFailureException("Already logged in as: " + this.contest.getMyClient().getLoginName());
        }
        if (this.internalContest == null) {
            this.internalContest = new InternalContest();
        } else {
            overrideContestUsed = true;
        }
        if (this.controller == null) {
            this.controller = new InternalController(this.internalContest);
        }
        this.controller.setUsingGUI(false);
        if (this.controller instanceof InternalController) {
            ((InternalController)this.controller).setUsingMainUI(false);
            ((InternalController)this.controller).setHaltOnFatalError(false);
        }
        this.controller.setClientAutoShutdown(false);
        try {
            this.controller.start(new String[0]);
            if (!overrideContestUsed) {
                this.internalContest = this.controller.clientLogin(this.internalContest, login, password);
            }
            this.contest = new Contest(this.internalContest, this.controller, this.controller.getLog());
            this.contest.addConnectionListener(new ConnectionEventListener());
            this.controller.register(this.contest);
            return this.contest;
        }
        catch (Exception e) {
            throw new LoginFailureException(e.getMessage());
        }
    }

    public boolean isValidAccountTypeName(String name) {
        try {
            ClientType.Type clientType = ClientType.Type.valueOf(name);
            return clientType != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public void addAccount(String accountTypeName, String displayName, String password) throws Exception {
        if (!this.isValidAccountTypeName(accountTypeName = accountTypeName.toUpperCase())) {
            throw new IllegalArgumentException("Invalid account type name '" + accountTypeName + "'");
        }
        this.checkIsAllowed(Permission.Type.ADD_ACCOUNT, "This login/account is not allowed to add an account");
        ClientType.Type clientType = ClientType.Type.valueOf(accountTypeName);
        ClientId clientId = new ClientId(this.internalContest.getSiteNumber(), clientType, 0);
        if (password == null || password.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid password (null or missing) '" + password + "'");
        }
        if (displayName == null) {
            displayName = clientId.getName();
        }
        Account account = new Account(clientId, password, this.internalContest.getSiteNumber());
        account.setDisplayName(displayName);
        account.clearListAndLoadPermissions(new PermissionGroup().getPermissionList(clientType));
        this.controller.addNewAccount(account);
    }

    public void submitClarification(IProblem problem, String question) throws Exception {
        this.checkWhetherLoggedIn();
        this.checkIsAllowed(Permission.Type.SUBMIT_CLARIFICATION, "User not allowed to submit clarification");
        ProblemImplementation problemImplementation = (ProblemImplementation)problem;
        Problem submittedProblem = this.internalContest.getProblem(problemImplementation.getElementId());
        if (submittedProblem == null) {
            throw new Exception("Could not find any problem matching: '" + problem.getName());
        }
        if (!this.contest.isContestClockRunning()) {
            throw new Exception("Contest is STOPPED - no clarifications accepted.");
        }
        try {
            this.controller.submitClarification(submittedProblem, question);
        }
        catch (Exception e) {
            throw new Exception("Unable to submit clarifications " + e.getLocalizedMessage());
        }
    }

    private void checkWhetherLoggedIn() throws NotLoggedInException {
        if (this.contest == null || this.internalContest == null) {
            throw new NotLoggedInException("Not logged in");
        }
    }

    public void submitRun(IProblem problem, ILanguage language, String mainFileName, String[] additionalFileNames, long overrideSubmissionTimeMS, long overrideRunId) throws Exception {
        this.checkWhetherLoggedIn();
        this.checkIsAllowed(Permission.Type.SUBMIT_RUN, "User not allowed to submit run");
        if (!new File(mainFileName).isFile()) {
            throw new Exception("File '" + mainFileName + "' no such file (not found)");
        }
        SerializedFile[] list = new SerializedFile[additionalFileNames.length];
        int i = 0;
        while (i < additionalFileNames.length) {
            if (!new File(additionalFileNames[i]).isFile()) {
                throw new Exception("File '" + additionalFileNames[i] + "' no such file (not found)");
            }
            list[i] = new SerializedFile(additionalFileNames[i]);
            ++i;
        }
        ProblemImplementation problemImplementation = (ProblemImplementation)problem;
        Problem submittedProblem = this.internalContest.getProblem(problemImplementation.getElementId());
        LanguageImplementation languageImplementation = (LanguageImplementation)language;
        Language submittedLanguage = this.internalContest.getLanguage(languageImplementation.getElementId());
        if (submittedProblem == null) {
            throw new Exception("Could not find any problem matching: '" + problem.getName());
        }
        if (submittedLanguage == null) {
            throw new Exception("Could not find any language matching: '" + language.getName());
        }
        if (!this.contest.isContestClockRunning()) {
            throw new Exception("Contest is STOPPED - no runs accepted.");
        }
        try {
            this.controller.submitRun(submittedProblem, submittedLanguage, mainFileName, list, overrideSubmissionTimeMS, overrideRunId);
        }
        catch (Exception e) {
            throw new Exception("Unable to submit run " + e.getLocalizedMessage());
        }
    }

    public boolean logoff() throws NotLoggedInException {
        if (this.contest == null) {
            throw new NotLoggedInException("Can not log off, not logged in");
        }
        try {
            this.controller.logoffUser(this.internalContest.getClientId());
            this.contest.setLoggedIn(false);
            this.contest = null;
            return true;
        }
        catch (Exception e) {
            throw new NotLoggedInException(e);
        }
    }

    public Contest getContest() throws NotLoggedInException {
        if (this.contest != null) {
            return this.contest;
        }
        throw new NotLoggedInException("Can not get IContest, not logged in");
    }

    public boolean isLoggedIn() {
        return this.contest != null && this.contest.isLoggedIn();
    }

    public IClient getMyClient() throws NotLoggedInException {
        if (this.contest != null) {
            return this.contest.getMyClient();
        }
        throw new NotLoggedInException("Not logged in");
    }

    public void startContestClock() throws Exception {
        this.checkWhetherLoggedIn();
        this.checkIsAllowed(Permission.Type.START_CONTEST_CLOCK, "User not allowed to start contest clock");
        try {
            this.controller.startContest(this.internalContest.getSiteNumber());
        }
        catch (Exception e) {
            throw new Exception("Unable to start Contest " + e.getLocalizedMessage());
        }
    }

    public void stopContestClock() throws Exception {
        this.checkWhetherLoggedIn();
        this.checkIsAllowed(Permission.Type.STOP_CONTEST_CLOCK, "User not allowed to start contest clock");
        try {
            this.controller.stopContest(this.internalContest.getSiteNumber());
        }
        catch (Exception e) {
            throw new Exception("Unable to stop Contest " + e.getLocalizedMessage());
        }
    }

    protected void setPC2Validator(Problem problem) {
        problem.setValidatedProblem(true);
        problem.setValidatorCommandLine("{:validator} {:infile} {:outfile} {:ansfile} {:resfile} ");
        problem.setUsingPC2Validator(true);
        problem.setWhichPC2Validator(1);
        problem.setIgnoreSpacesOnValidation(true);
        problem.setValidatorCommandLine("{:validator} {:infile} {:outfile} {:ansfile} {:resfile}  -pc2 " + problem.getWhichPC2Validator() + " " + problem.isIgnoreSpacesOnValidation());
        problem.setValidatorProgramName("pc2.jar edu.csus.ecs.pc2.validator.Validator");
    }

    public void addProblem(String title, String shortName, File judgesDataFile, File judgesAnswerFile, boolean validated, Properties problemProperties) {
        this.checkNotEmpty("Problem title", title);
        this.checkNotEmpty("Problem short name", shortName);
        this.checkFile("Judges data file", judgesDataFile);
        this.checkIsAllowed(Permission.Type.ADD_PROBLEM);
        Problem problem = new Problem(title);
        problem.setShortName(shortName);
        problem.setDataFileName(judgesDataFile.getName());
        problem.setAnswerFileName(judgesAnswerFile.getName());
        Object[] invalids = this.validateProperties(problemProperties);
        if (invalids.length > 0) {
            throw new IllegalArgumentException("Unknown/Invalid property names: " + Arrays.toString(invalids));
        }
        String judgingType = this.getProperty(problemProperties, "JUDGING_TYPE", null);
        if (judgingType != null) {
            if ("MANUAL_JUDGING_ONLY".equals(judgingType) && validated) {
                throw new IllegalArgumentException("Problem cannot be validated and not judging type computer judged");
            }
        } else {
            judgingType = "MANUAL_JUDGING_ONLY";
        }
        switch (judgingType) {
            case "MANUAL_JUDGING_ONLY": {
                validated = false;
                problem.setManualReview(true);
                break;
            }
            case "COMPUTER_JUDGING_ONLY": {
                validated = true;
                problem.setComputerJudged(true);
                problem.setManualReview(false);
                break;
            }
            case "COMPUTER_AND_MANUAL_JUDGING": {
                validated = true;
                problem.setComputerJudged(true);
                problem.setManualReview(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown JUDGING_TYPE '" + judgingType + "'");
            }
        }
        boolean usingPc2Validator = false;
        String validatorProgram = this.getProperty(problemProperties, "VALIDATOR_PROGRAM", "pc2.jar edu.csus.ecs.pc2.validator.Validator");
        usingPc2Validator = "pc2.jar edu.csus.ecs.pc2.validator.Validator".equals(validatorProgram);
        if (validated) {
            problem.setValidatedProblem(validated);
            String validatorCommandLine = this.getProperty(problemProperties, "VALIDATOR_COMMAND_LINE", "{:validator} {:infile} {:outfile} {:ansfile} {:resfile} ");
            problem.setValidatorCommandLine(validatorCommandLine);
            if (usingPc2Validator) {
                this.setPC2Validator(problem);
            }
        }
        problem.setShowValidationToJudges(false);
        problem.setHideOutputWindow(true);
        ProblemDataFiles problemDataFiles = new ProblemDataFiles(problem);
        problemDataFiles.setJudgesDataFile(new SerializedFile(judgesDataFile.getAbsolutePath()));
        problemDataFiles.setJudgesAnswerFile(new SerializedFile(judgesAnswerFile.getAbsolutePath()));
        if (validated && !usingPc2Validator && new File(validatorProgram).isFile()) {
            SerializedFile validatorFile = new SerializedFile(validatorProgram);
            problemDataFiles.setValidatorFile(validatorFile);
        }
        this.controller.addNewProblem(problem, problemDataFiles);
    }

    protected String getProperty(Properties problemProperties, String key, String defaultValue) {
        String value = null;
        if (problemProperties != null && (value = problemProperties.getProperty(key)) == null) {
            value = defaultValue;
        }
        return value;
    }

    protected String[] validateProperties(Properties properties) {
        if (properties == null) {
            return new String[0];
        }
        ArrayList<String> unknownKeys = new ArrayList<String>();
        String[] names = this.getProblemPropertyNames();
        Set<Object> keys = properties.keySet();
        for (Object object : keys) {
            String key = (String)object;
            boolean found = false;
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals(key)) {
                    found = true;
                }
                ++n2;
            }
            if (found) continue;
            unknownKeys.add(key);
        }
        return unknownKeys.toArray(new String[unknownKeys.size()]);
    }

    private void checkFile(String name, File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " is null");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.valueOf(name) + " does not exist");
        }
        if (file.length() == 0L) {
            throw new IllegalArgumentException(String.valueOf(name) + " must be a non-zero byte (in length) file");
        }
    }

    private void checkNotEmpty(String name, String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(name) + " is null");
        }
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException(String.valueOf(name) + " cannot be an empty string (or all spaces) '" + value + "'");
        }
    }

    public String[] getProblemPropertyNames() {
        return this.problemPropertyNames;
    }

    public boolean isValidAutoFillLangauageName(String name) {
        boolean valid = false;
        String[] stringArray = LanguageAutoFill.getLanguageList();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String langName = stringArray[n2];
            if (langName.equals(name)) {
                valid = true;
            }
            ++n2;
        }
        return valid;
    }

    public String[] getAutoFillLanguageList() {
        return LanguageAutoFill.getLanguageList();
    }

    public void addLanguage(String autoFillTitleName) {
        this.checkNotEmpty("Language Name/title", autoFillTitleName);
        if (!this.isValidAutoFillLangauageName(autoFillTitleName)) {
            throw new IllegalArgumentException("No such language name '" + autoFillTitleName + "'");
        }
        this.checkIsAllowed(Permission.Type.ADD_LANGUAGE);
        Language language = LanguageAutoFill.languageLookup(autoFillTitleName);
        this.controller.addNewLanguage(language);
    }

    private void checkIsAllowed(Permission.Type type) {
        this.checkIsAllowed(type, null);
    }

    private void checkIsAllowed(Permission.Type type, String message) {
        if (!this.internalContest.isAllowed(type)) {
            if (message == null) {
                throw new SecurityException("Not allowed to " + this.getPermissionDescription(type));
            }
            throw new SecurityException("Not allowed to " + message + "(requires " + this.getPermissionDescription(type) + " permission)");
        }
    }

    private void checkIsAnyAllowed(Permission.Type[] types, String message) {
        boolean allowed = false;
        Permission.Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Permission.Type type = typeArray[n2];
            if (this.internalContest.isAllowed(type)) {
                allowed = true;
            }
            ++n2;
        }
        if (!allowed) {
            if (message == null) {
                throw new SecurityException("Not allowed to " + this.getPermissionDescription(types[0]));
            }
            throw new SecurityException("Not allowed to " + message + "(requires " + this.getPermissionDescription(types[0]) + " permission)");
        }
    }

    private String getPermissionDescription(Permission.Type type) {
        return new Permission().getDescription(type);
    }

    public void addLanguage(String title, String compilerCommandLine, String executionCommandLine, boolean interpreted, String executableMask) {
        this.checkNotEmpty("Language Name/title", title);
        this.checkNotEmpty("Language compilation command", compilerCommandLine);
        this.checkNotEmpty("Language executable mask", executableMask);
        this.checkNotEmpty("Language execution comman lLine", executionCommandLine);
        Language language = new Language(title);
        language.setCompileCommandLine(compilerCommandLine);
        language.setInterpreted(interpreted);
        language.setExecutableIdentifierMask(executableMask);
        language.setProgramExecuteCommandLine(executionCommandLine);
        this.checkIsAllowed(Permission.Type.ADD_LANGUAGE);
        this.controller.addNewLanguage(language);
    }

    public void shutdownServer() {
        this.checkIsAllowed(Permission.Type.SHUTDOWN_SERVER, "Shutdown local server");
        this.controller.sendShutdownSite(this.internalContest.getSiteNumber());
    }

    public void shutdownAllServers() {
        Permission.Type[] allowList = new Permission.Type[]{Permission.Type.SHUTDOWN_ALL_SERVERS, Permission.Type.SHUTDOWN_SERVER};
        this.checkIsAnyAllowed(allowList, "Shutdown local server");
        this.controller.sendShutdownAllSites();
    }

    public void setContestTimes(long contestLengthSeconds, long contestElapsedSeconds, long contestRemainingSeconds) throws IllegalContestState {
        this.checkIsAllowed(Permission.Type.EDIT_CONTEST_CLOCK);
        if (this.internalContest.getContestTime().isContestRunning()) {
            throw new IllegalContestState("Cannot set contest times while contest clock is running/started");
        }
        if (contestLengthSeconds != contestElapsedSeconds + contestRemainingSeconds) {
            throw new IllegalArgumentException("Contest Length must equal elapsed plus remaining ( " + contestLengthSeconds + " != " + contestElapsedSeconds + " + " + contestRemainingSeconds + " )");
        }
        ContestTime newContestTime = this.internalContest.getContestTime();
        newContestTime.setContestLengthSecs(contestLengthSeconds);
        newContestTime.setElapsedSecs(contestElapsedSeconds);
        newContestTime.setRemainingSecs(contestRemainingSeconds);
        this.controller.updateContestTime(newContestTime);
    }

    public void setContestLength(long contestLengthSeconds) throws IllegalContestState {
        ContestTime newContestTime = this.internalContest.getContestTime();
        long newRemain = contestLengthSeconds - newContestTime.getElapsedSecs();
        this.setContestTimes(contestLengthSeconds, newContestTime.getElapsedSecs(), newRemain);
    }

    public static void main(String[] args) {
        String[] requireArguementArgs = new String[]{"--login", "--password"};
        ParseArguments parseArguments = new ParseArguments(args, requireArguementArgs);
        if (parseArguments.isOptPresent("--help")) {
            System.out.println("Usage: ServerConnection [--help] --login LOGIN [--passowrd PASS] [--stop]");
            System.out.println("Purpose to start (default) pc2 server contest clock, or stop contest clock");
            System.exit(0);
        }
        boolean stopContest = parseArguments.isOptPresent("--stop");
        String login = parseArguments.getOptValue("--login");
        String password = parseArguments.getOptValue("--password");
        if (login == null) {
            ServerConnection.fatalError("Missing login name, use --help for usage");
        }
        if (password == null) {
            password = "";
        }
        ServerConnection connection = new ServerConnection();
        try {
            IContest contest2 = connection.login(login, password);
            System.out.println("Logged in as " + contest2.getMyClient().getLoginName());
            System.out.println("Contest is running?  " + contest2.isContestClockRunning());
            if (stopContest) {
                System.out.println("Send Stop Contest");
                connection.stopContestClock();
            } else {
                System.out.println("Send Start Contest");
                connection.startContestClock();
            }
            Thread.sleep(1000L);
            System.out.println("Contest is running?  " + contest2.isContestClockRunning());
            connection.logoff();
            System.out.println("Logged off");
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Login failure for login=" + login + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void fatalError(String string) {
        System.err.println(string);
        System.err.println("Program Halted");
        System.exit(43);
    }

    protected class ConnectionEventListener
    implements IConnectionEventListener {
        protected ConnectionEventListener() {
        }

        @Override
        public void connectionDropped() {
            ServerConnection.this.contest = null;
        }
    }
}

