/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.api.IClarification;
import edu.csus.ecs.pc2.api.IClarificationEventListener;
import edu.csus.ecs.pc2.api.IContest;
import edu.csus.ecs.pc2.api.IRun;
import edu.csus.ecs.pc2.api.IRunJudgement;
import edu.csus.ecs.pc2.api.ISite;
import edu.csus.ecs.pc2.api.ISiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.api.ServerConnection;
import edu.csus.ecs.pc2.api.exceptions.LoginFailureException;
import edu.csus.ecs.pc2.api.exceptions.NotLoggedInException;
import edu.csus.ecs.pc2.api.implementation.RunsFrame;
import edu.csus.ecs.pc2.api.implementation.ScrollyFrame;
import edu.csus.ecs.pc2.api.listener.ContestEvent;
import edu.csus.ecs.pc2.api.listener.IConfigurationUpdateListener;
import edu.csus.ecs.pc2.api.listener.IConnectionEventListener;
import edu.csus.ecs.pc2.api.listener.IRunEventListener;
import edu.csus.ecs.pc2.api.reports.APIAbstractTest;
import edu.csus.ecs.pc2.api.reports.APIPrintReports;
import edu.csus.ecs.pc2.api.reports.PrintClarification;
import edu.csus.ecs.pc2.api.reports.PrintClarificationCategories;
import edu.csus.ecs.pc2.api.reports.PrintClarifications;
import edu.csus.ecs.pc2.api.reports.PrintMyClient;
import edu.csus.ecs.pc2.api.reports.PrintProblems;
import edu.csus.ecs.pc2.api.reports.PrintRun;
import edu.csus.ecs.pc2.api.reports.PrintStandings;
import edu.csus.ecs.pc2.api.reports.PrintTeams;
import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.ParseArguments;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ContestTestFrame
extends JFrame {
    private static final long serialVersionUID = -3146831894495294017L;
    private static final String DEFAULT_TITLE = "PC^2 API Test Frame [NOT LOGGED IN]";
    private JPanel mainPain = null;
    private JPanel centerPane = null;
    private JPanel buttonPane = null;
    private JButton exitButton = null;
    private JButton getRunButton = null;
    private JButton loginButton = null;
    private JTextField loginTextField = null;
    private JTextField passwordTextField = null;
    private ServerConnection serverConnection = new ServerConnection();
    private IContest contest = null;
    private JButton logoffButton = null;
    private JCheckBox runListenerCheckBox = null;
    private JCheckBox configListenerCheckBox = null;
    private RunListener runListener = null;
    private ConnectionEventListener connectionEventListener = null;
    private ScrollyFrame scrollyFrame = new ScrollyFrame();
    private String line = "";
    private JButton standingsButton = null;
    private JButton printAllButton = null;
    private JButton oneRunTest = null;
    private JCheckBox clarListenerCheckBox = null;
    private ClarificationListener clarificationListener = null;
    private ConfigUpdateListener configurationUpdateListener = null;
    private JButton runContestButton = null;
    private JScrollPane reportScrollPane = null;
    private JList<APIAbstractTest> reportJList = null;
    private DefaultListModel<APIAbstractTest> listModel = new DefaultListModel();
    private JPanel topPane = null;
    private JLabel loginLabel = null;
    private JLabel passwordLabel = null;
    private JPanel eastPane = null;
    private JPanel mainPanel = null;
    private JTextField numberTextField = null;
    private JLabel jLabel = null;
    private JPanel eastButtonPane = null;
    private APIAbstractTest[] reportsList = new APIPrintReports().getReportsList();
    private JLabel jLabel1 = null;
    private JComboBox<ISiteWrapper> siteComboBox = null;
    private JLabel runsOnSite = null;
    private JButton getClarificationButton = null;
    private JLabel clarificationsOnSite = null;
    private JCheckBox connectionListenerCheckBox = null;
    private JButton viewRunGrid = null;
    private RunsFrame runsFrame = null;

    public ContestTestFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(650, 552));
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getMainPain());
        this.setTitle(DEFAULT_TITLE);
        FrameUtilities.setFramePosition(this, FrameUtilities.HorizontalPosition.LEFT, FrameUtilities.VerticalPosition.CENTER);
        this.loadReportList();
    }

    private void loadReportList() {
        Arrays.sort(this.reportsList, new APIAbstractTestComparator());
        APIAbstractTest[] aPIAbstractTestArray = this.reportsList;
        int n = this.reportsList.length;
        int n2 = 0;
        while (n2 < n) {
            APIAbstractTest abstractTest = aPIAbstractTestArray[n2];
            this.listModel.addElement(abstractTest);
            ++n2;
        }
    }

    protected void printAllJudgements(IRun run) {
        IRunJudgement[] judgements = run.getRunJudgements();
        if (judgements.length == 0) {
            this.println("   No judgements for this run.");
        }
        IRunJudgement[] iRunJudgementArray = judgements;
        int n = judgements.length;
        int n2 = 0;
        while (n2 < n) {
            IRunJudgement judgement = iRunJudgementArray[n2];
            this.println("   Judgement " + judgement.getJudgement().getName() + " compJudged=" + judgement.isComputerJudgement() + " solved=" + judgement.isSolved() + " prelim=" + judgement.isPreliminaryJudgement() + " toTeams=" + judgement.isSendToTeam());
            ++n2;
        }
    }

    private JPanel getMainPain() {
        if (this.mainPain == null) {
            this.mainPain = new JPanel();
            this.mainPain.setLayout(new BorderLayout());
            this.mainPain.add((Component)this.getButtonPane(), "South");
            this.mainPain.add((Component)this.getMainPanel(), "Center");
        }
        return this.mainPain;
    }

    public String getConfigInfo(ContestEvent contestEvent) {
        switch (contestEvent.getEventType()) {
            case CLIENT: {
                return contestEvent.getClient().toString();
            }
            case CONTEST_CLOCK: {
                return "running " + contestEvent.getContestClock().isContestClockRunning();
            }
            case CONTEST_TITLE: {
                return contestEvent.getContestTitle();
            }
            case GROUP: {
                return contestEvent.getGroup().getName();
            }
            case JUDGEMENT: {
                return contestEvent.getJudgement().getName();
            }
            case LANGUAGE: {
                return contestEvent.getLanguage().getName();
            }
            case PROBLEM: {
                return contestEvent.getProblem().getName();
            }
            case SITE: {
                return contestEvent.getSite().getName();
            }
        }
        return "Unknown type " + (Object)((Object)contestEvent.getEventType());
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.clarificationsOnSite = new JLabel();
            this.clarificationsOnSite.setBounds(new Rectangle(164, 239, 157, 16));
            this.clarificationsOnSite.setText("(clars on site count)");
            this.clarificationsOnSite.setHorizontalAlignment(2);
            this.runsOnSite = new JLabel();
            this.runsOnSite.setBounds(new Rectangle(163, 173, 157, 16));
            this.runsOnSite.setText("(runs on site count)");
            this.runsOnSite.setHorizontalAlignment(2);
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(new Rectangle(48, 144, 96, 16));
            this.jLabel1.setText("Site");
            this.jLabel1.setHorizontalAlignment(4);
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(28, 208, 119, 16));
            this.jLabel.setText("Run/Clar Number");
            this.jLabel.setHorizontalAlignment(4);
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.setPreferredSize(new Dimension(350, 350));
            this.centerPane.add((Component)this.getGetRunButton(), null);
            this.centerPane.add((Component)this.getRunListenerCheckBox(), null);
            this.centerPane.add((Component)this.getConfigListenerCheckBox(), null);
            this.centerPane.add((Component)this.getStandingsButton(), null);
            this.centerPane.add((Component)this.getPrintAllButton(), null);
            this.centerPane.add((Component)this.getOneRunTest(), null);
            this.centerPane.add((Component)this.getClarListenerCheckBox(), null);
            this.centerPane.add((Component)this.getNumberTextField(), null);
            this.centerPane.add((Component)this.jLabel, null);
            this.centerPane.add((Component)this.jLabel1, null);
            this.centerPane.add(this.getSiteComboBox(), null);
            this.centerPane.add((Component)this.runsOnSite, null);
            this.centerPane.add((Component)this.getGetClarificationButton(), null);
            this.centerPane.add((Component)this.clarificationsOnSite, null);
            this.centerPane.add((Component)this.getConnectionListenerCheckBox(), null);
            this.centerPane.add((Component)this.getViewRunGrid(), null);
            JButton btnStartClock = new JButton();
            btnStartClock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.stopContest();
                }
            });
            btnStartClock.setToolTipText("Start Contest Clock");
            btnStartClock.setText("Start");
            btnStartClock.setBounds(new Rectangle(246, 61, 94, 29));
            btnStartClock.setBounds(37, 103, 94, 29);
            this.centerPane.add(btnStartClock);
            JButton btnStopClock = new JButton();
            btnStopClock.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.startContest();
                }
            });
            btnStopClock.setToolTipText("Stop Contest Clock");
            btnStopClock.setText("Stop");
            btnStopClock.setBounds(new Rectangle(246, 61, 94, 29));
            btnStopClock.setBounds(143, 102, 94, 29);
            this.centerPane.add(btnStopClock);
        }
        return this.centerPane;
    }

    protected void startContest() {
        if (this.contest == null) {
            this.showMessage("Not logged in");
            return;
        }
        if (this.contest.isContestClockRunning()) {
            this.showMessage("Note: clock already started");
            this.println("Note: clock already started");
        }
        try {
            this.serverConnection.startContestClock();
        }
        catch (Exception e) {
            this.println(e.getMessage());
            this.showMessage(e.getMessage());
        }
    }

    protected void stopContest() {
        if (this.contest == null) {
            this.showMessage("Not logged in");
            return;
        }
        if (!this.contest.isContestClockRunning()) {
            this.showMessage("Note: clock already stopped");
            this.println("Note: clock already stopped");
        }
        try {
            this.serverConnection.stopContestClock();
        }
        catch (Exception e) {
            this.println(e.getMessage());
            this.showMessage(e.getMessage());
        }
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(55);
            this.buttonPane = new JPanel();
            this.buttonPane.setPreferredSize(new Dimension(269, 35));
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getExitButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setToolTipText("Exit this program");
            this.exitButton.setPreferredSize(new Dimension(90, 25));
            this.exitButton.setMnemonic(88);
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
        return this.exitButton;
    }

    private JButton getGetRunButton() {
        if (this.getRunButton == null) {
            this.getRunButton = new JButton();
            this.getRunButton.setBounds(new Rectangle(240, 202, 94, 26));
            this.getRunButton.setToolTipText("Print Run information list");
            this.getRunButton.setText("getRun");
            this.getRunButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.runReport(new PrintRun());
                }
            });
        }
        return this.getRunButton;
    }

    private JButton getLoginButton() {
        if (this.loginButton == null) {
            this.loginButton = new JButton();
            this.loginButton.setToolTipText("Login to contest");
            this.loginButton.setBounds(new Rectangle(318, 8, 125, 26));
            this.loginButton.setMnemonic(76);
            this.loginButton.setText("Login");
            this.loginButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.attachToContest();
                }
            });
        }
        return this.loginButton;
    }

    protected void attachToContest() {
        FrameUtilities.waitCursor(this);
        String login = this.getLoginTextField().getText();
        login = this.getShortCut(login);
        String password = this.getPasswordTextField().getText();
        if (password == null || password.length() == 0) {
            password = login;
        }
        try {
            this.info("Logging in as " + login);
            long startSecs = new Date().getTime();
            this.contest = this.serverConnection.login(login, password);
            long totalMs = new Date().getTime() - startSecs;
            this.info("Logged in at " + login + " took " + totalMs + "ms (" + totalMs / 1000L + " seconds)");
            this.setTitle("Contest " + this.contest.getMyClient().getLoginName() + " " + this.contest.getSiteName());
            this.getLoginButton().setEnabled(false);
            this.setTitle("Info for " + this.contest.getMyClient().getLoginName() + " " + this.contest.getSiteName());
            this.scrollyFrame.setVisible(true);
            VersionInfo versionInfo = new VersionInfo();
            this.println("Version " + versionInfo.getVersionNumber() + " build " + versionInfo.getBuildNumber());
            this.runReport(new PrintMyClient());
            this.println(String.valueOf(this.contest.getRuns().length) + " runs.");
            this.println(String.valueOf(this.contest.getClarifications().length) + " clarifications");
            this.updateSiteComboBox();
        }
        catch (LoginFailureException e) {
            this.contest = null;
            this.showMessage("Unable to login " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            this.contest = null;
            this.showMessage("Unable to login " + e.getMessage());
            e.printStackTrace();
        }
        FrameUtilities.regularCursor(this);
    }

    private String getShortCut(String login) {
        ClientId id = InternalController.loginShortcutExpansion(1, login);
        if (id != null) {
            return id.getName();
        }
        return login;
    }

    private void info(String string) {
        System.out.println(new Date() + " " + Thread.currentThread().getName() + " " + string);
        System.out.flush();
    }

    private void showMessage(String string, String title) {
        JOptionPane.showMessageDialog(null, string, title, 2);
    }

    private void showMessage(String string) {
        this.showMessage(string, "Note");
    }

    private JTextField getLoginTextField() {
        if (this.loginTextField == null) {
            this.loginTextField = new JTextField();
            this.loginTextField.setText("b1");
            this.loginTextField.setBounds(new Rectangle(153, 11, 127, 20));
        }
        return this.loginTextField;
    }

    private JTextField getPasswordTextField() {
        if (this.passwordTextField == null) {
            this.passwordTextField = new JTextField();
            this.passwordTextField.setBounds(new Rectangle(153, 36, 127, 20));
            this.passwordTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ContestTestFrame.this.attachToContest();
                    }
                }
            });
        }
        return this.passwordTextField;
    }

    protected void printTeamsTest() {
        this.runReport(new PrintTeams());
    }

    protected void printProblemsTest() {
        this.runReport(new PrintProblems());
    }

    protected void printClarificationCategoriesTest() {
        this.runReport(new PrintClarificationCategories());
    }

    private JButton getLogoffButton() {
        if (this.logoffButton == null) {
            this.logoffButton = new JButton();
            this.logoffButton.setToolTipText("Logoff of contest");
            this.logoffButton.setBounds(new Rectangle(500, 8, 125, 26));
            this.logoffButton.setMnemonic(79);
            this.logoffButton.setText("Logoff");
            this.logoffButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ContestTestFrame.this.logoff();
                    }
                    catch (NotLoggedInException e1) {
                        JOptionPane.showMessageDialog(null, "unable to logoff " + e1.getMessage());
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.logoffButton;
    }

    protected void logoff() throws NotLoggedInException {
        if (this.contest == null) {
            this.showMessage("Not logged in");
            return;
        }
        this.scrollyFrame.setVisible(false);
        if (this.runsFrame != null) {
            this.runsFrame.setVisible(false);
        }
        this.serverConnection.logoff();
        this.contest = null;
        this.showMessage("No longer logged in");
        this.setTitle(DEFAULT_TITLE);
        this.getLoginButton().setEnabled(true);
    }

    private JCheckBox getRunListenerCheckBox() {
        if (this.runListenerCheckBox == null) {
            this.runListenerCheckBox = new JCheckBox();
            this.runListenerCheckBox.setBounds(new Rectangle(17, 271, 156, 18));
            this.runListenerCheckBox.setToolTipText("Listen for run events");
            this.runListenerCheckBox.setText("View Run Listener");
            this.runListenerCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.runListenerChanged(ContestTestFrame.this.runListenerCheckBox.isSelected());
                }
            });
        }
        return this.runListenerCheckBox;
    }

    protected void runListenerChanged(boolean listenerON) {
        if (this.contest == null) {
            this.showMessage("Not logged in");
            return;
        }
        if (listenerON) {
            if (this.runListener == null) {
                this.runListener = new RunListener();
            }
            this.contest.addRunListener(this.runListener);
            this.println("Run Listener added");
        } else if (this.runListener != null) {
            this.contest.removeRunListener(this.runListener);
            this.println("Run Listener removed");
        }
    }

    protected void connectionListenerChanged(boolean listenerON) {
        if (this.contest == null) {
            this.showMessage("Not logged in");
            return;
        }
        if (listenerON) {
            if (this.connectionEventListener == null) {
                this.connectionEventListener = new ConnectionEventListener();
            }
            this.contest.addConnectionListener(this.connectionEventListener);
            this.println("Connection Listener added");
        } else if (this.connectionEventListener != null) {
            this.contest.removeConnectionListener(this.connectionEventListener);
            this.println("Connection Listener removed");
        }
    }

    private JCheckBox getConfigListenerCheckBox() {
        if (this.configListenerCheckBox == null) {
            this.configListenerCheckBox = new JCheckBox();
            this.configListenerCheckBox.setBounds(new Rectangle(17, 332, 180, 21));
            this.configListenerCheckBox.setToolTipText("Listen for all configuration change events");
            this.configListenerCheckBox.setText("View Config Listener");
            this.configListenerCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.configListenerChanged(ContestTestFrame.this.configListenerCheckBox.isSelected());
                }
            });
        }
        return this.configListenerCheckBox;
    }

    protected void configListenerChanged(boolean listenerON) {
        if (this.contest == null) {
            this.showMessage("Not logged in");
            return;
        }
        if (listenerON) {
            if (this.configurationUpdateListener == null) {
                this.configurationUpdateListener = new ConfigUpdateListener();
            }
            this.contest.addContestConfigurationUpdateListener(this.configurationUpdateListener);
            this.println("Configuration Listener added");
        } else if (this.configurationUpdateListener != null) {
            this.contest.removeContestConfigurationUpdateListener(this.configurationUpdateListener);
            this.println("Configuration Listener removed");
        }
    }

    private JButton getStandingsButton() {
        if (this.standingsButton == null) {
            this.standingsButton = new JButton();
            this.standingsButton.setBounds(new Rectangle(246, 61, 140, 29));
            this.standingsButton.setToolTipText("Print Standings");
            this.standingsButton.setText("Standings");
            this.standingsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.printStandingsTest();
                }
            });
        }
        return this.standingsButton;
    }

    protected void printStandingsTest() {
        this.runReport(new PrintStandings());
    }

    private JButton getPrintAllButton() {
        if (this.printAllButton == null) {
            this.printAllButton = new JButton();
            this.printAllButton.setBounds(new Rectangle(245, 14, 140, 29));
            this.printAllButton.setToolTipText("Print all contest info");
            this.printAllButton.setMnemonic(80);
            this.printAllButton.setText("Print ALL");
            this.printAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.printAll();
                }
            });
        }
        return this.printAllButton;
    }

    protected void printAll() {
        this.runReport(new PrintAllReports());
    }

    private int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private JButton getOneRunTest() {
        if (this.oneRunTest == null) {
            this.oneRunTest = new JButton();
            this.oneRunTest.setBounds(new Rectangle(42, 14, 185, 29));
            this.oneRunTest.setToolTipText("View all Run's Source");
            this.oneRunTest.setText("View All Runs Source");
            this.oneRunTest.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.viewOneRunSource();
                }
            });
        }
        return this.oneRunTest;
    }

    protected void viewOneRunSource() {
        if (this.contest == null) {
            this.showMessage("Not logged in");
            return;
        }
        if (this.contest.getRuns().length == 0) {
            this.println("No runs in system");
            return;
        }
        IRun[] iRunArray = this.contest.getRuns();
        int n = iRunArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRun run = iRunArray[n2];
            this.print("Run " + run.getNumber() + " Site " + run.getSiteNumber());
            this.print(" @ " + run.getSubmissionTime() + " by " + run.getTeam().getLoginName());
            this.print(" problem: " + run.getProblem().getName());
            this.print(" in " + run.getLanguage().getName());
            if (run.isFinalJudged()) {
                this.println("  Final Judgement: " + run.getJudgementName());
            } else if (run.isPreliminaryJudged()) {
                this.println("  Preliminary Judgement: " + run.getJudgementName());
            } else {
                this.println("  Judgement: not judged yet ");
            }
            this.println();
            this.println("Getting source file name(s)");
            byte[][] contents = run.getSourceCodeFileContents();
            String[] names = run.getSourceCodeFileNames();
            int i = 0;
            while (i < names.length) {
                String s = names[i];
                this.println("Name[" + i + "] " + s + " " + contents[i].length);
                ++i;
            }
            ++n2;
        }
        this.println("done");
    }

    protected void printClarTest() {
        this.runReport(new PrintClarifications());
    }

    private JCheckBox getClarListenerCheckBox() {
        if (this.clarListenerCheckBox == null) {
            this.clarListenerCheckBox = new JCheckBox();
            this.clarListenerCheckBox.setBounds(new Rectangle(17, 300, 156, 21));
            this.clarListenerCheckBox.setToolTipText("Listen for Clarification events");
            this.clarListenerCheckBox.setText("View Clar Listener");
            this.clarListenerCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.clarListenerChanged(ContestTestFrame.this.clarListenerCheckBox.isSelected());
                }
            });
        }
        return this.clarListenerCheckBox;
    }

    protected void clarListenerChanged(boolean listenerON) {
        if (this.contest == null) {
            this.showMessage("Not logged in");
            return;
        }
        if (listenerON) {
            if (this.clarificationListener == null) {
                this.clarificationListener = new ClarificationListener();
            }
            this.contest.addClarificationListener(this.clarificationListener);
            this.println("Clarification Listener added");
        } else if (this.clarificationListener != null) {
            this.contest.removeClarificationListener(this.clarificationListener);
            this.println("Clarification Listener removed");
        }
    }

    private JButton getRunContestButton() {
        if (this.runContestButton == null) {
            this.runContestButton = new JButton();
            this.runContestButton.setText("Run");
            this.runContestButton.setMnemonic(82);
            this.runContestButton.setToolTipText("Run Selected API method report");
            this.runContestButton.setPreferredSize(new Dimension(100, 25));
            this.runContestButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ContestTestFrame.this.contest == null) {
                        ContestTestFrame.this.showMessage("Not logged in", "Can not display info");
                        return;
                    }
                    int selected = ContestTestFrame.this.getReportJList().getSelectedIndex();
                    if (selected == -1) {
                        ContestTestFrame.this.showMessage("No Repport Selected");
                    } else {
                        ContestTestFrame.this.println();
                        for (Object object : ContestTestFrame.this.getReportJList().getSelectedValuesList()) {
                            ContestTestFrame.this.println("-- Report " + ((APIAbstractTest)object).getTitle());
                            ContestTestFrame.this.runReport(object);
                        }
                    }
                }
            });
        }
        return this.runContestButton;
    }

    private JScrollPane getReportScrollPane() {
        if (this.reportScrollPane == null) {
            this.reportScrollPane = new JScrollPane();
            this.reportScrollPane.setViewportView(this.getReportJList());
        }
        return this.reportScrollPane;
    }

    protected void runReport(Object source) {
        if (this.contest == null) {
            this.showMessage("Not logged in", "Can not display info");
            return;
        }
        int submissionNumber = this.getIntegerValue(this.getNumberTextField().getText());
        int siteNumber = this.getSelectedSiteNumber();
        try {
            APIAbstractTest test = (APIAbstractTest)source;
            test.setAPISettings(this.scrollyFrame, this.contest, this.serverConnection);
            test.setNumber(submissionNumber);
            test.setSiteNumber(siteNumber);
            test.printTest();
        }
        catch (Exception e) {
            this.println("Exception during report " + e.getLocalizedMessage() + " " + e.getStackTrace()[0].getClassName());
            e.printStackTrace();
        }
    }

    private int getSelectedSiteNumber() {
        Object object = this.getSiteComboBox().getSelectedItem();
        if (object == null) {
            return 0;
        }
        ISite site = ((ISiteWrapper)object).getSite();
        int siteNumber = site.getNumber();
        return siteNumber;
    }

    private JList<APIAbstractTest> getReportJList() {
        if (this.reportJList == null) {
            this.reportJList = new JList<APIAbstractTest>(this.listModel);
            this.reportJList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2) {
                        ContestTestFrame.this.runReport(ContestTestFrame.this.getReportJList().getSelectedValue());
                    }
                }
            });
        }
        return this.reportJList;
    }

    private JPanel getTopPane() {
        if (this.topPane == null) {
            this.passwordLabel = new JLabel();
            this.passwordLabel.setBounds(new Rectangle(45, 38, 100, 16));
            this.passwordLabel.setText("Password");
            this.passwordLabel.setHorizontalAlignment(4);
            this.loginLabel = new JLabel();
            this.loginLabel.setBounds(new Rectangle(45, 13, 100, 16));
            this.loginLabel.setText("Login");
            this.loginLabel.setHorizontalAlignment(4);
            this.topPane = new JPanel();
            this.topPane.setLayout(null);
            this.topPane.setPreferredSize(new Dimension(65, 65));
            this.topPane.add((Component)this.getPasswordTextField(), null);
            this.topPane.add((Component)this.getLoginTextField(), null);
            this.topPane.add((Component)this.loginLabel, null);
            this.topPane.add((Component)this.passwordLabel, null);
            this.topPane.add((Component)this.getLoginButton(), null);
            this.topPane.add((Component)this.getLogoffButton(), null);
        }
        return this.topPane;
    }

    private JPanel getEastPane() {
        if (this.eastPane == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(0);
            borderLayout.setVgap(3);
            this.eastPane = new JPanel();
            this.eastPane.setBorder(BorderFactory.createTitledBorder(null, "API Methods", 2, 0, null, null));
            this.eastPane.setLayout(borderLayout);
            this.eastPane.add((Component)this.getReportScrollPane(), "Center");
            this.eastPane.add((Component)this.getEastButtonPane(), "South");
        }
        return this.eastPane;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getEastPane(), "East");
            this.mainPanel.add((Component)this.getTopPane(), "North");
            this.mainPanel.add((Component)this.getCenterPane(), "Center");
        }
        return this.mainPanel;
    }

    private JTextField getNumberTextField() {
        if (this.numberTextField == null) {
            this.numberTextField = new JTextField();
            this.numberTextField.setDocument(new IntegerDocument());
            this.numberTextField.setToolTipText("Enter a Run Number or Clar Number");
            this.numberTextField.setText("1");
            this.numberTextField.setBounds(new Rectangle(162, 205, 59, 22));
        }
        return this.numberTextField;
    }

    private JPanel getEastButtonPane() {
        if (this.eastButtonPane == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setHgap(2);
            flowLayout1.setVgap(2);
            this.eastButtonPane = new JPanel();
            this.eastButtonPane.setLayout(flowLayout1);
            this.eastButtonPane.setPreferredSize(new Dimension(110, 30));
            this.eastButtonPane.add((Component)this.getRunContestButton(), null);
        }
        return this.eastButtonPane;
    }

    private JComboBox<ISiteWrapper> getSiteComboBox() {
        if (this.siteComboBox == null) {
            this.siteComboBox = new JComboBox();
            this.siteComboBox.setBounds(new Rectangle(162, 142, 159, 21));
            this.siteComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ContestTestFrame.this.updateSiteRunTotals();
                    ContestTestFrame.this.updateSiteClarificationsTotals();
                }
            });
        }
        return this.siteComboBox;
    }

    protected void updateSiteClarificationsTotals() {
        Object object = this.getSiteComboBox().getSelectedItem();
        if (object == null) {
            this.clarificationsOnSite.setText("(no site selected)");
            return;
        }
        ISite site = ((ISiteWrapper)object).getSite();
        int siteNumber = site.getNumber();
        int count = 0;
        int deleted = 0;
        IClarification[] iClarificationArray = this.contest.getClarifications();
        int n = iClarificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClarification clarification = iClarificationArray[n2];
            if (clarification.getSiteNumber() == siteNumber) {
                ++count;
                if (clarification.isDeleted()) {
                    ++deleted;
                }
            }
            ++n2;
        }
        String text = "";
        text = count == 0 ? "No clarifications." : (count == 1 ? "1 clarification." : String.valueOf(count) + " clarifications.");
        if (deleted > 0) {
            text = String.valueOf(count) + " deleted.";
        }
        this.clarificationsOnSite.setText(text);
    }

    protected void updateSiteRunTotals() {
        Object object = this.getSiteComboBox().getSelectedItem();
        if (object == null) {
            this.runsOnSite.setText("(no site selected)");
            return;
        }
        ISite site = ((ISiteWrapper)object).getSite();
        int siteNumber = site.getNumber();
        int count = 0;
        int deleted = 0;
        IRun[] iRunArray = this.contest.getRuns();
        int n = iRunArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRun run = iRunArray[n2];
            if (run.getSiteNumber() == siteNumber) {
                ++count;
                if (run.isDeleted()) {
                    ++deleted;
                }
            }
            ++n2;
        }
        String text = "";
        text = count == 0 ? "No runs." : (count == 1 ? "1 run." : String.valueOf(count) + " runs.");
        if (deleted > 0) {
            text = String.valueOf(count) + " deleted.";
        }
        this.runsOnSite.setText(text);
    }

    private JButton getGetClarificationButton() {
        if (this.getClarificationButton == null) {
            this.getClarificationButton = new JButton();
            this.getClarificationButton.setBounds(new Rectangle(205, 265, 150, 26));
            this.getClarificationButton.setText("getClarification");
            this.getClarificationButton.setToolTipText("Print Run information list");
            this.getClarificationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.runReport(new PrintClarification());
                }
            });
        }
        return this.getClarificationButton;
    }

    private JCheckBox getConnectionListenerCheckBox() {
        if (this.connectionListenerCheckBox == null) {
            this.connectionListenerCheckBox = new JCheckBox();
            this.connectionListenerCheckBox.setBounds(new Rectangle(17, 366, 220, 24));
            this.connectionListenerCheckBox.setText("View Connection Listener");
            this.connectionListenerCheckBox.setToolTipText("Listen for all connection change events");
            this.connectionListenerCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.connectionListenerChanged(ContestTestFrame.this.connectionListenerCheckBox.isSelected());
                }
            });
        }
        return this.connectionListenerCheckBox;
    }

    private JButton getViewRunGrid() {
        if (this.viewRunGrid == null) {
            this.viewRunGrid = new JButton();
            this.viewRunGrid.setBounds(new Rectangle(42, 61, 185, 29));
            this.viewRunGrid.setText("View Runs Grid");
            this.viewRunGrid.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ContestTestFrame.this.showRunsGridFrame();
                }
            });
        }
        return this.viewRunGrid;
    }

    protected void showRunsGridFrame() {
        if (this.contest == null) {
            this.showMessage("Not logged in", "Can not display runs grid");
            return;
        }
        this.getRunsFrame().setVisible(true);
    }

    public RunsFrame getRunsFrame() {
        if (this.runsFrame == null) {
            this.runsFrame = new RunsFrame(this.contest);
        }
        return this.runsFrame;
    }

    public static void usage() {
        String[] lines;
        String[] stringArray = lines = new String[]{"Usage: [--help] ", "", "Purpose: a API test frame", "", "--help    this message", ""};
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(s);
            ++n2;
        }
        VersionInfo info = new VersionInfo();
        System.out.println(info.getSystemVersionInfo());
    }

    public static void main(String[] args) {
        ParseArguments arguments = new ParseArguments(args);
        if (arguments.isOptPresent("--help")) {
            ContestTestFrame.usage();
            System.exit(0);
        }
        VersionInfo info = new VersionInfo();
        System.out.println(info.getSystemVersionInfo());
        new ContestTestFrame().setVisible(true);
    }

    private void println() {
        String s = "";
        if (this.line.length() > 0) {
            s = String.valueOf(this.line) + s;
            this.line = "";
        }
        this.scrollyFrame.addLine(s);
    }

    private void print(String s) {
        this.line = String.valueOf(this.line) + s;
    }

    private void println(String s) {
        if (this.line.length() > 0) {
            s = String.valueOf(this.line) + s;
            this.line = "";
        }
        this.scrollyFrame.addLine(s);
    }

    private void updateSiteComboBox() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int selectedIndex = ContestTestFrame.this.getSiteComboBox().getSelectedIndex();
                ContestTestFrame.this.getSiteComboBox().removeAllItems();
                ISite[] sites = ContestTestFrame.this.contest.getSites();
                Arrays.sort(sites, new ISiteComparatorBySiteNumber());
                int siteNumber = 0;
                int i = 0;
                while (i < sites.length) {
                    if (sites[i].getNumber() == siteNumber && selectedIndex == -1) {
                        selectedIndex = i;
                    }
                    ContestTestFrame.this.getSiteComboBox().addItem(new ISiteWrapper(sites[i]));
                    ++i;
                }
                if (selectedIndex != -1) {
                    ContestTestFrame.this.getSiteComboBox().setSelectedIndex(selectedIndex);
                }
            }
        });
    }

    protected class APIAbstractTestComparator
    implements Comparator<APIAbstractTest>,
    Serializable {
        private static final long serialVersionUID = 2262035579714795746L;

        protected APIAbstractTestComparator() {
        }

        @Override
        public int compare(APIAbstractTest abstractTest1, APIAbstractTest abstractTest2) {
            return abstractTest1.getTitle().compareTo(abstractTest2.getTitle());
        }
    }

    protected class ClarificationListener
    implements IClarificationEventListener {
        protected ClarificationListener() {
        }

        @Override
        public void clarificationAdded(IClarification clarification) {
            ContestTestFrame.this.println("Clar added Site " + clarification.getSiteNumber() + " Clarification " + clarification.getNumber() + " from " + clarification.getTeam().getLoginName() + " at " + clarification.getSubmissionTime() + " Problem " + clarification.getProblem().getName());
        }

        @Override
        public void clarificationRemoved(IClarification clarification) {
            ContestTestFrame.this.println("Clar removed Site " + clarification.getSiteNumber() + " Clarification " + clarification.getNumber() + " from " + clarification.getTeam().getLoginName() + " at " + clarification.getSubmissionTime() + " Problem " + clarification.getProblem().getName());
        }

        @Override
        public void clarificationAnswered(IClarification clarification) {
            ContestTestFrame.this.println("Clar answered Site " + clarification.getSiteNumber() + " Clarification " + clarification.getNumber() + " from " + clarification.getTeam().getLoginName() + " at " + clarification.getSubmissionTime() + " Problem " + clarification.getProblem().getName());
        }

        @Override
        public void clarificationUpdated(IClarification clarification) {
            ContestTestFrame.this.println("Clar updated Site " + clarification.getSiteNumber() + " Clarification " + clarification.getNumber() + " from " + clarification.getTeam().getLoginName() + " at " + clarification.getSubmissionTime() + " Problem " + clarification.getProblem().getName());
        }
    }

    protected class ConfigUpdateListener
    implements IConfigurationUpdateListener {
        protected ConfigUpdateListener() {
        }

        @Override
        public void configurationItemAdded(ContestEvent contestEvent) {
            ContestTestFrame.this.println("Config item added " + (Object)((Object)contestEvent.getEventType()) + " " + ContestTestFrame.this.getConfigInfo(contestEvent));
        }

        @Override
        public void configurationItemUpdated(ContestEvent contestEvent) {
            ContestTestFrame.this.println("Config item updated " + (Object)((Object)contestEvent.getEventType()) + " " + ContestTestFrame.this.getConfigInfo(contestEvent));
            if (contestEvent.getEventType().equals((Object)ContestEvent.EventType.SITE)) {
                ContestTestFrame.this.updateSiteComboBox();
            }
        }

        @Override
        public void configurationItemRemoved(ContestEvent contestEvent) {
            ContestTestFrame.this.println("Config item removed " + (Object)((Object)contestEvent.getEventType()) + " " + ContestTestFrame.this.getConfigInfo(contestEvent));
        }
    }

    protected class ConnectionEventListener
    implements IConnectionEventListener {
        protected ConnectionEventListener() {
        }

        @Override
        public void connectionDropped() {
            ContestTestFrame.this.println("Connection Dropped, logged in " + ContestTestFrame.this.serverConnection.isLoggedIn());
        }
    }

    protected class ISiteWrapper {
        private ISite site = null;

        public ISite getSite() {
            return this.site;
        }

        public ISiteWrapper(ISite site) {
            this.site = site;
        }

        public String toString() {
            return this.site.getName();
        }
    }

    protected class PrintAllReports
    extends APIAbstractTest {
        protected PrintAllReports() {
        }

        @Override
        public void printTest() {
            if (ContestTestFrame.this.contest == null) {
                ContestTestFrame.this.showMessage("Not logged in", "Can not display info");
                return;
            }
            Arrays.sort(ContestTestFrame.this.reportsList, new APIAbstractTestComparator());
            int submissionNumber = ContestTestFrame.this.getIntegerValue(ContestTestFrame.this.getNumberTextField().getText());
            APIAbstractTest[] aPIAbstractTestArray = ContestTestFrame.this.reportsList;
            int n = aPIAbstractTestArray.length;
            int n2 = 0;
            while (n2 < n) {
                APIAbstractTest abstractTest = aPIAbstractTestArray[n2];
                this.println("-- Report " + abstractTest.getTitle());
                abstractTest.setAPISettings(ContestTestFrame.this.scrollyFrame, ContestTestFrame.this.contest, ContestTestFrame.this.serverConnection);
                abstractTest.setNumber(submissionNumber);
                abstractTest.printTest();
                ++n2;
            }
            this.println();
            this.println();
        }

        @Override
        public String getTitle() {
            return "ALL Reports";
        }
    }

    protected class RunListener
    implements IRunEventListener {
        protected RunListener() {
        }

        @Override
        public void runJudged(IRun run, boolean isFinal) {
            ContestTestFrame.this.println("Run judged Site " + run.getSiteNumber() + " Run " + run.getNumber() + " from " + run.getTeam().getLoginName() + " at " + run.getSubmissionTime());
            ContestTestFrame.this.printAllJudgements(run);
        }

        @Override
        public void runUpdated(IRun run, boolean isFinal) {
            ContestTestFrame.this.println("Run updated Site " + run.getSiteNumber() + " Run " + run.getNumber() + " from " + run.getTeam().getLoginName() + " at " + run.getSubmissionTime());
            ContestTestFrame.this.printAllJudgements(run);
        }

        @Override
        public void runExecuting(IRun run, boolean isFinal) {
            ContestTestFrame.this.println("Run executing Site " + run.getSiteNumber() + " Run " + run.getNumber() + " from " + run.getTeam().getLoginName() + " at " + run.getSubmissionTime());
        }

        @Override
        public void runValidating(IRun run, boolean isFinal) {
            ContestTestFrame.this.println("Run validating Site " + run.getSiteNumber() + " Run " + run.getNumber() + " from " + run.getTeam().getLoginName() + " at " + run.getSubmissionTime());
        }

        @Override
        public void runSubmitted(IRun run) {
            ContestTestFrame.this.println("Run submitted Site " + run.getSiteNumber() + " Run " + run.getNumber() + " from " + run.getTeam().getLoginName() + " at " + run.getSubmissionTime());
        }

        @Override
        public void runDeleted(IRun run) {
            ContestTestFrame.this.println("Run deleted Site " + run.getSiteNumber() + " Run " + run.getNumber() + " from " + run.getTeam().getLoginName() + " at " + run.getSubmissionTime());
        }

        @Override
        public void runCompiling(IRun run, boolean isFinal) {
            ContestTestFrame.this.println("Run compiling Site " + run.getSiteNumber() + " Run " + run.getNumber() + " from " + run.getTeam().getLoginName() + " at " + run.getSubmissionTime());
        }

        @Override
        public void runJudgingCanceled(IRun run, boolean isFinal) {
            ContestTestFrame.this.println("Run judging canceled Site " + run.getSiteNumber() + " Run " + run.getNumber() + " from " + run.getTeam().getLoginName() + " at " + run.getSubmissionTime());
        }

        @Override
        public void runCheckedOut(IRun run, boolean isFinal) {
            ContestTestFrame.this.println("Run checked out Site " + run.getSiteNumber() + " Run " + run.getNumber() + " from " + run.getTeam().getLoginName() + " at " + run.getSubmissionTime());
        }
    }
}

