/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.j2mclb;

import com.ibm.webrunner.j2mclb.Viewport;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.ScrollPaneConstants;

public class ScrollerPane
extends JPanel
implements ScrollPaneConstants {
    public static final String VERSION = "1.00";
    private Viewport columnHeader = new Viewport();
    private Viewport rowHeader = new Viewport();
    private Viewport viewport = new Viewport();
    private Hashtable corners = new Hashtable(4);
    private JScrollBar hbar = new JScrollBar(0);
    private JScrollBar vbar = new JScrollBar(1);
    private int hbarPolicy = 30;
    private int vbarPolicy = 20;
    private boolean hbarSnap = false;
    private boolean vbarSnap = false;
    private EventHandler handler = new EventHandler(this);

    public ScrollerPane() {
        this(null, 30, 20);
    }

    public ScrollerPane(int n, int n2) {
        this(null, n, n2);
    }

    public ScrollerPane(Component component) {
        this(component, 30, 20);
    }

    public ScrollerPane(Component component, int n, int n2) {
        super(null);
        this.setLayout(new Layout(this));
        this.init();
        this.add(this.columnHeader);
        this.add(this.rowHeader);
        this.add(this.viewport);
        this.add(this.vbar);
        this.add(this.hbar);
        this.setViewportView(component);
        this.setHorizontalScrollBarPolicy(n);
        this.setVerticalScrollBarPolicy(n2);
    }

    public synchronized Component getColumnHeaderView() {
        return this.columnHeader.getView();
    }

    protected Viewport getColumnHeaderViewport() {
        return this.columnHeader;
    }

    public Component getCorner(String string) {
        return (Component)this.corners.get(string);
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.hbar;
    }

    public int getHorizontalScrollBarPolicy() {
        return this.hbarPolicy;
    }

    public synchronized Component getRowHeaderView() {
        return this.rowHeader.getView();
    }

    protected Viewport getRowHeaderViewport() {
        return this.rowHeader;
    }

    public boolean getSnapToHorizontalUnitIncrement() {
        return this.hbarSnap;
    }

    public boolean getSnapToVerticalUnitIncrement() {
        return this.vbarSnap;
    }

    public String getVersion() {
        return VERSION;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.vbar;
    }

    public int getVerticalScrollBarPolicy() {
        return this.vbarPolicy;
    }

    protected Viewport getViewport() {
        return this.viewport;
    }

    public synchronized Component getViewportView() {
        return this.viewport.getView();
    }

    public Point getViewPosition() {
        return new Point(this.getHorizontalScrollBar().getValue(), this.getVerticalScrollBar().getValue());
    }

    private void init() {
        Component component;
        Component component2;
        this.hbar.removeAdjustmentListener(this.handler);
        this.hbar.addAdjustmentListener(this.handler);
        this.vbar.removeAdjustmentListener(this.handler);
        this.vbar.addAdjustmentListener(this.handler);
        this.removeComponentListener(this.handler);
        this.addComponentListener(this.handler);
        Component component3 = this.columnHeader.getView();
        if (component3 != null) {
            component3.removeComponentListener(this.handler);
            component3.addComponentListener(this.handler);
        }
        if ((component2 = this.rowHeader.getView()) != null) {
            component2.removeComponentListener(this.handler);
            component2.addComponentListener(this.handler);
        }
        if ((component = this.viewport.getView()) != null) {
            component.removeComponentListener(this.handler);
            component.addComponentListener(this.handler);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    public synchronized void setColumnHeaderView(Component component) {
        Component component2 = this.columnHeader.getView();
        if (component2 != null) {
            component2.removeComponentListener(this.handler);
        }
        this.columnHeader.setView(component);
        if (component != null) {
            component.addNotify();
            component.addComponentListener(this.handler);
            Component component3 = this.getViewportView();
            if (component3 != null) {
                component.setSize(component3.getSize().width, component.getSize().height);
            }
        }
        if (component2 != component) {
            this.doLayout();
        }
    }

    public void setCorner(String string, Component component) {
        if (string.equals("UPPER_LEFT_CORNER") || string.equals("UPPER_RIGHT_CORNER") || string.equals("LOWER_LEFT_CORNER") || string.equals("LOWER_RIGHT_CORNER")) {
            if (component == null) {
                this.corners.remove(string);
            } else {
                this.corners.put(string, component);
            }
        } else {
            throw new IllegalArgumentException(string);
        }
        this.doLayout();
    }

    public void setHorizontalScrollBarPolicy(int n) {
        switch (n) {
            case 30: 
            case 31: 
            case 32: {
                this.hbarPolicy = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
    }

    public synchronized void setRowHeaderView(Component component) {
        Component component2 = this.rowHeader.getView();
        if (component2 != null) {
            component2.removeComponentListener(this.handler);
        }
        this.rowHeader.setView(component);
        if (component != null) {
            component.addNotify();
            component.addComponentListener(this.handler);
            Component component3 = this.getViewportView();
            if (component3 != null) {
                component.setSize(component.getSize().width, component3.getSize().height);
            }
        }
        if (component2 != component) {
            this.doLayout();
        }
    }

    public void setSnapToHorizontalUnitIncrement(boolean bl) {
        this.hbarSnap = bl;
    }

    public void setSnapToVerticalUnitIncrement(boolean bl) {
        this.vbarSnap = bl;
    }

    public void setVersion(String string) {
        throw new IllegalArgumentException();
    }

    public void setVerticalScrollBarPolicy(int n) {
        switch (n) {
            case 20: 
            case 21: 
            case 22: {
                this.vbarPolicy = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
    }

    public synchronized void setViewportView(Component component) {
        Component component2 = this.viewport.getView();
        if (component2 != null) {
            component2.removeComponentListener(this.handler);
        }
        this.viewport.setView(component);
        if (component != null) {
            Component component3;
            component.addNotify();
            component.addComponentListener(this.handler);
            Component component4 = this.getColumnHeaderView();
            if (component4 != null) {
                component4.setSize(component.getSize().width, component4.getSize().height);
            }
            if ((component3 = this.getRowHeaderView()) != null) {
                component3.setSize(component3.getSize().width, component.getSize().height);
            }
        }
        if (component2 != component) {
            this.doLayout();
        }
    }

    public void setViewPosition(Point point) {
        int n;
        if (this.getSnapToHorizontalUnitIncrement()) {
            n = this.getHorizontalScrollBar().getUnitIncrement();
            point.x = (point.x % n < n / 2 ? point.x / n : point.x / n + 1) * n;
        }
        if (this.getSnapToVerticalUnitIncrement()) {
            n = this.getVerticalScrollBar().getUnitIncrement();
            point.y = (point.y % n < n / 2 ? point.y / n : point.y / n + 1) * n;
        }
        this.getColumnHeaderViewport().setViewPosition(new Point(point.x, 0));
        this.getRowHeaderViewport().setViewPosition(new Point(0, point.y));
        this.getViewport().setViewPosition(new Point(point.x, point.y));
    }

    class EventHandler
    implements ComponentListener,
    AdjustmentListener,
    Serializable {
        /* synthetic */ ScrollerPane this$0;

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (component == this.this$0) {
                Viewport viewport;
                Viewport viewport2;
                Viewport viewport3 = this.this$0.getViewport();
                if (viewport3 != null) {
                    viewport3.setViewPosition(viewport3.getViewPosition());
                }
                if ((viewport2 = this.this$0.getColumnHeaderViewport()) != null) {
                    viewport2.setViewPosition(viewport2.getViewPosition());
                }
                if ((viewport = this.this$0.getRowHeaderViewport()) != null) {
                    viewport.setViewPosition(viewport.getViewPosition());
                }
            } else {
                if (component == this.this$0.getViewportView()) {
                    Component component2;
                    Dimension dimension = component.getSize();
                    Component component3 = this.this$0.getColumnHeaderView();
                    if (component3 != null) {
                        component3.setSize(dimension.width, component3.getSize().height);
                    }
                    if ((component2 = this.this$0.getRowHeaderView()) != null) {
                        component2.setSize(component2.getSize().width, dimension.height);
                    }
                }
                this.this$0.doLayout();
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Object object = adjustmentEvent.getSource();
            JScrollBar jScrollBar = this.this$0.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.this$0.getVerticalScrollBar();
            if (object == jScrollBar2 || object == jScrollBar) {
                int n;
                int n2 = jScrollBar.getValue();
                int n3 = jScrollBar2.getValue();
                if (this.this$0.getSnapToHorizontalUnitIncrement()) {
                    n = this.this$0.getHorizontalScrollBar().getUnitIncrement();
                    n2 = (n2 % n == 0 ? n2 / n : n2 / n + 1) * n;
                }
                if (this.this$0.getSnapToVerticalUnitIncrement()) {
                    n = this.this$0.getVerticalScrollBar().getUnitIncrement();
                    n3 = (n3 % n == 0 ? n3 / n : n3 / n + 1) * n;
                }
                this.this$0.getColumnHeaderViewport().setViewPosition(new Point(n2, 0));
                this.this$0.getRowHeaderViewport().setViewPosition(new Point(0, n3));
                this.this$0.getViewport().setViewPosition(new Point(n2, n3));
            }
        }

        EventHandler(ScrollerPane scrollerPane) {
            this.this$0 = scrollerPane;
        }
    }

    class Layout
    implements LayoutManager,
    Serializable {
        /* synthetic */ ScrollerPane this$0;

        private void setScrollBarValues() {
            Viewport viewport = this.this$0.getViewport();
            Component component = viewport.getView();
            Dimension dimension = viewport.getSize();
            Point point = viewport.getViewPosition();
            Dimension dimension2 = component != null ? component.getSize() : new Dimension();
            JScrollBar jScrollBar = this.this$0.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.this$0.getVerticalScrollBar();
            jScrollBar.setValues(point.x, dimension.width, 0, dimension2.width);
            jScrollBar.setBlockIncrement(dimension.width);
            if (point.y + dimension.height <= dimension2.height) {
                jScrollBar2.setValues(point.y, dimension.height, 0, dimension2.height);
            } else if (dimension2.height - dimension.height >= 0) {
                jScrollBar2.setValues(dimension2.height - dimension.height, dimension.height, 0, dimension2.height);
            } else {
                jScrollBar2.setValues(0, dimension.height, 0, dimension2.height);
            }
            jScrollBar2.setBlockIncrement(dimension.height);
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(150, 100);
        }

        public void layoutContainer(Container container) {
            Component component;
            Component component2;
            Component component3;
            boolean bl;
            JScrollBar jScrollBar = this.this$0.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.this$0.getVerticalScrollBar();
            Viewport viewport = this.this$0.getColumnHeaderViewport();
            Viewport viewport2 = this.this$0.getRowHeaderViewport();
            Viewport viewport3 = this.this$0.getViewport();
            Component component4 = viewport.getView();
            Component component5 = viewport2.getView();
            Component component6 = viewport3.getView();
            Dimension dimension = container.getSize();
            Dimension dimension2 = component4 != null ? component4.getSize() : new Dimension(0, 0);
            Dimension dimension3 = component5 != null ? component5.getSize() : new Dimension(0, 0);
            Dimension dimension4 = component6 != null ? component6.getPreferredSize() : new Dimension(0, 0);
            Insets insets = container.getInsets();
            int n = insets.left + insets.right;
            int n2 = insets.top + insets.bottom;
            int n3 = dimension4.width + dimension3.width + n;
            int n4 = dimension4.height + dimension2.height + n2;
            boolean bl2 = dimension.width < n3;
            boolean bl3 = dimension.height < n4;
            int n5 = jScrollBar.getPreferredSize().height;
            int n6 = jScrollBar2.getPreferredSize().width;
            boolean bl4 = dimension.width < n3 + n6;
            boolean bl5 = bl = dimension.height < n4 + n5;
            if (bl2 && bl) {
                bl3 = true;
            }
            if (bl3 && bl4) {
                bl2 = true;
            }
            if (bl2 && bl) {
                bl3 = true;
            }
            int n7 = this.this$0.getHorizontalScrollBarPolicy();
            int n8 = this.this$0.getVerticalScrollBarPolicy();
            if (n7 == 31) {
                bl2 = false;
            } else if (n7 == 32) {
                bl2 = true;
            }
            if (n8 == 21) {
                bl3 = false;
            } else if (n8 == 22) {
                bl3 = true;
            }
            viewport.setBounds(insets.left + dimension3.width, insets.top, dimension.width - dimension3.width - n - (bl3 ? n6 : 0), dimension2.height);
            viewport2.setBounds(insets.left, insets.top + dimension2.height, dimension3.width, dimension.height - dimension2.height - n2 - (bl2 ? n5 : 0));
            viewport3.setBounds(insets.left + dimension3.width, insets.top + dimension2.height, dimension.width - dimension3.width - n - (bl3 ? n6 : 0), dimension.height - dimension2.height - n2 - (bl2 ? n5 : 0));
            Component component7 = this.this$0.getCorner("UPPER_LEFT_CORNER");
            if (component7 != null) {
                component7.setBounds(insets.left, insets.top, dimension3.width, dimension2.height);
                component7.setVisible(component4 != null && component5 != null);
            }
            if ((component3 = this.this$0.getCorner("UPPER_RIGHT_CORNER")) != null) {
                component3.setBounds(dimension.width - insets.right - n6, insets.top, n6, dimension2.height);
                component3.setVisible(component4 != null && bl3);
            }
            if ((component2 = this.this$0.getCorner("LOWER_LEFT_CORNER")) != null) {
                component2.setBounds(insets.left, dimension.height - insets.bottom - n5, dimension3.width, n5);
                component2.setVisible(component5 != null && bl2);
            }
            if ((component = this.this$0.getCorner("LOWER_RIGHT_CORNER")) != null) {
                component.setBounds(dimension.width - insets.right - n6, dimension.height - insets.bottom - n5, n6, n5);
                component2.setVisible(bl2 && bl3);
            }
            jScrollBar.setBounds(insets.left + dimension3.width, dimension.height - insets.bottom - n5, dimension.width - dimension3.width - n - (bl3 ? n6 : 0), n5);
            jScrollBar.setVisible(bl2);
            jScrollBar2.setBounds(dimension.width - insets.right - n6, insets.top + dimension2.height, n6, dimension.height - dimension2.height - n2 - (bl2 ? n5 : 0));
            jScrollBar2.setVisible(bl3);
            this.setScrollBarValues();
        }

        Layout(ScrollerPane scrollerPane) {
            this.this$0 = scrollerPane;
        }
    }
}

