/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webrunner.j2mclb;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class Caption
extends JLabel {
    public static final int DEFAULT_LENGTH = 50;
    private boolean fResizable = true;
    private boolean fSelected = false;

    public Caption() {
        this("");
    }

    public Caption(Object object) {
        this.setBorder(Caption.createDefaultBorder());
        this.setFont(UIManager.getFont("TableHeader.font"));
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(2);
        this.setSize(50, 20);
        this.setLabel(object);
    }

    public Caption(String string) {
        this((Object)string);
    }

    public static Border createDefaultBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    public Object getLabel() {
        return this.getText();
    }

    public int getLength() {
        return this.getSize().width;
    }

    public boolean isResizable() {
        return this.fResizable;
    }

    public boolean isSelected() {
        return this.fSelected;
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    public synchronized void paint(Graphics graphics) {
        Font font = UIManager.getFont("TableHeader.font");
        if (this.fSelected) {
            this.setFont(new Font(font.getName(), font.getStyle() | 1, font.getSize()));
        } else {
            this.setFont(new Font(font.getName(), font.getStyle() & 0xFFFFFFFE, font.getSize()));
        }
        super.paint(graphics);
    }

    public void paintBackground(Graphics graphics) {
    }

    public void setLabel(Object object) {
        if (object == null) {
            object = "";
        }
        this.setText(object.toString());
    }

    public void setLength(int n) {
        Rectangle rectangle = this.getBounds();
        this.setBounds(rectangle.x, rectangle.y, n, rectangle.height);
    }

    public void setResizable(boolean bl) {
        this.fResizable = bl;
    }

    public void setSelected(boolean bl) {
        this.fSelected = bl;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append('[');
        stringBuffer.append("label=" + this.getLabel());
        stringBuffer.append(",length=" + this.getLength());
        if (this.isResizable()) {
            stringBuffer.append(",resizable");
        }
        if (this.isVisible()) {
            stringBuffer.append(",showing");
        }
        if (this.isSelected()) {
            stringBuffer.append(",selected");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

