/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ws;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.ws.ResponseHandler;
import edu.csus.ecs.pc2.ws.Worker;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;

public class WebServer {
    private static final int DEAFAULT_PORT = 80;
    private VersionInfo versionInfo = new VersionInfo();
    private static final String VERSION = "$Id$";
    private boolean exitServerFlag = false;
    protected static Properties props = new Properties();
    protected static Vector<Worker> threads = new Vector();
    protected static File root;
    protected static int timeout;
    protected static int workers;
    private int port = 80;
    private ResponseHandler responseHandler = null;

    static {
        timeout = 0;
        workers = 5;
    }

    protected static void printStderr(String s) {
        System.err.println(String.valueOf(Thread.currentThread().getName()) + " " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(int aPort) {
        if (this.responseHandler == null) {
            new Exception("responseHandler not intialized").printStackTrace();
        }
        try {
            int i = 0;
            while (i < workers) {
                Worker w = new Worker(this.responseHandler);
                new Thread((Runnable)w, "worker #" + i).start();
                threads.addElement(w);
                ++i;
            }
            ServerSocket ss = new ServerSocket(aPort);
            System.out.println("Web server on port " + aPort + " STARTED");
            while (!this.exitServerFlag) {
                Socket s = null;
                try {
                    s = ss.accept();
                }
                catch (IOException e) {
                    System.err.println("Could not accept connections on " + aPort);
                    e.printStackTrace();
                    System.exit(4);
                }
                Worker w = null;
                Vector<Worker> vector = threads;
                synchronized (vector) {
                    if (threads.isEmpty()) {
                        Worker ws = new Worker(this.responseHandler);
                        ws.setSocket(s);
                        new Thread((Runnable)ws, "additional worker").start();
                    } else {
                        w = threads.elementAt(0);
                        threads.removeElementAt(0);
                        w.setSocket(s);
                    }
                }
            }
            ss.close();
        }
        catch (BindException bindException) {
            System.err.println("Halting server - port " + aPort + " already in use");
        }
        catch (Exception e) {
            System.err.println("Halting server ");
            e.printStackTrace(System.err);
        }
    }

    public String getVersionNumber() {
        return VERSION;
    }

    public String getVersionString() {
        return "pc2WebServer/" + this.getVersionNumber() + " pc2 build " + this.versionInfo.getBuildNumber();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setResponseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }
}

