/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.validator.ccs;

import edu.csus.ecs.pc2.VersionInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class Validator {
    private String inputFileName;
    private String outputFileName;
    private String answerFileName;
    private String resultFileName;
    private boolean ignoreCaseFlag = false;
    public static final String JUDGEMENT_YES = "accepted";
    public static final String JUDGEMENT_NO_WRONG_ANSWER = "No - Wrong Answer";
    private String extraValidatorDifference = "";
    private boolean debugFlag = false;
    private boolean allowFatalExit = true;
    private boolean verbose = false;

    private void usage() {
        VersionInfo vi = new VersionInfo();
        System.out.println("Usage: java Validator [options] inputfilename answerfilename feedbackdir < teamoutput");
        System.out.println("Team's output is read from stdin");
        System.out.println();
        System.out.println("inputfilename - Judge's input filename");
        System.out.println("answerfilename - Judge's answer filename");
        System.out.println("feedbackdir - location for additional feedback information files");
        System.out.println();
        System.out.println("Where: ");
        System.out.println();
        System.out.println("options: ");
        System.out.println("  --help    this messge ");
        System.out.println("  --verbose more info like EOF: line counts");
        System.out.println("  --debug   a large amount of debugging output");
        System.out.println();
        System.out.println(vi.getSystemVersionInfo());
    }

    void printUsage() {
        this.usage();
    }

    void requireFile(String filename, String descriptionForFile) throws ValidatorException {
        File file = new File(filename);
        if (!file.isFile()) {
            throw new ValidatorException(String.valueOf(descriptionForFile) + " does not exist (" + filename + ")", 7);
        }
    }

    private void checkForOutputFile() throws ValidatorException {
        File checkFile = new File(this.outputFileName);
        if (!checkFile.isFile()) {
            this.extraValidatorDifference = "NO Team output file created - nothing to read ";
            try {
                this.writeResultFile(this.resultFileName, JUDGEMENT_NO_WRONG_ANSWER, this.extraValidatorDifference);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new ValidatorException("Trouble writing result file " + this.resultFileName, 4);
            }
        }
    }

    private String simpleDiff(InputStream in, String filename) throws IOException {
        InputStreamReader reader = new InputStreamReader(in);
        FileReader fileReader = new FileReader(filename);
        return this.simpleDiff(new BufferedReader(reader), new BufferedReader(fileReader));
    }

    private String simpleDiff(BufferedReader outputFile, BufferedReader answerFile) throws IOException {
        int lineNo = 1;
        String outputLine = outputFile.readLine();
        String answerLine = answerFile.readLine();
        while (outputLine != null && answerLine != null) {
            if (this.debugFlag) {
                System.out.println();
                System.out.println("O " + lineNo + ": " + outputLine);
                System.out.println("A " + lineNo + ": " + answerLine);
            }
            if (this.ignoreCaseFlag) {
                if (!outputLine.equalsIgnoreCase(answerLine)) {
                    if (this.debugFlag) {
                        System.out.println("  " + lineNo + "! " + this.compareLine(outputLine, answerLine));
                    }
                    this.extraValidatorDifference = "Answer and output file different (ignore case) at line  " + lineNo;
                    return JUDGEMENT_NO_WRONG_ANSWER;
                }
            } else if (!outputLine.equals(answerLine)) {
                if (this.debugFlag) {
                    System.out.println("  " + lineNo + "! " + this.compareLine(outputLine, answerLine));
                }
                this.extraValidatorDifference = "Answer and output file different at line  " + lineNo;
                return JUDGEMENT_NO_WRONG_ANSWER;
            }
            answerLine = answerFile.readLine();
            outputLine = outputFile.readLine();
            ++lineNo;
        }
        if (outputLine != null && answerLine == null) {
            this.extraValidatorDifference = "Team's output file is longer than answer file, at line " + lineNo;
            return JUDGEMENT_NO_WRONG_ANSWER;
        }
        if (answerLine != null && outputLine == null) {
            this.extraValidatorDifference = "Team output file shorter than answer file, at line " + lineNo;
            return JUDGEMENT_NO_WRONG_ANSWER;
        }
        if (answerLine == null && this.verbose) {
            System.out.println("EOF: answer file " + lineNo + " lines.");
        }
        if (outputLine == null && this.verbose) {
            System.out.println("EOF: output file " + lineNo + " lines.");
        }
        return JUDGEMENT_YES;
    }

    protected void writeResultFile(String filename, String judgement, String description) throws FileNotFoundException {
        if (this.debugFlag) {
            System.out.println();
            System.out.println("<result outcome =  \"" + judgement + "\" security = \"" + this.resultFileName + "\">" + description + "</result>");
        }
        PrintWriter fileWriter = new PrintWriter(new FileOutputStream(filename), true);
        fileWriter.println("<?xml version=\"1.0\"?>");
        fileWriter.println("<result outcome =  \"" + judgement + "\" security = \"" + this.resultFileName + "\">" + description + "</result>");
        fileWriter.close();
    }

    protected String compareLine(String line1, String line2) {
        int len1 = line1.length();
        int len2 = line2.length();
        int maxLength = Math.max(len1, len2);
        int minLength = Math.min(len1, len2);
        StringBuffer outbuf = new StringBuffer();
        int i = 0;
        while (i < maxLength) {
            int ch = 32;
            if (i < minLength) {
                if (line1.charAt(i) != line2.charAt(i)) {
                    ch = 94;
                }
            } else {
                ch = 94;
            }
            outbuf.append((char)ch);
            ++i;
        }
        return new String(outbuf);
    }

    public int runValidator(String[] args) {
        int argNum = 0;
        int numberOfArgs = args.length;
        if (numberOfArgs > 0 && "--nofatal".equals(args[0])) {
            this.allowFatalExit = false;
            ++argNum;
            --numberOfArgs;
        }
        if ("--help".equals(args[0])) {
            this.printUsage();
            if (this.allowFatalExit) {
                System.exit(0);
            }
            return 255;
        }
        if ("--verbose".equals(args[0])) {
            this.verbose = true;
            ++argNum;
            --numberOfArgs;
        }
        if ("--debug".equals(args[0])) {
            this.debugFlag = true;
            ++argNum;
            --numberOfArgs;
        }
        if ("--testYes".equals(args[0])) {
            return 42;
        }
        switch (argNum) {
            case 0: {
                throw new ValidatorException("Missing inputfilename");
            }
            case 1: {
                throw new ValidatorException("Missing answerfilename");
            }
            case 2: {
                throw new ValidatorException("Missing feedbackdir");
            }
        }
        this.inputFileName = args[argNum++];
        this.outputFileName = args[argNum++];
        this.answerFileName = args[argNum++];
        if (!this.inputFileName.equals("-")) {
            this.requireFile(this.inputFileName, "input file");
        }
        if (!this.outputFileName.equals("-")) {
            this.checkForOutputFile();
        }
        if (!this.answerFileName.equals("-")) {
            this.requireFile(this.answerFileName, "answer file");
        }
        if (this.debugFlag) {
            System.out.println("Arguments: ");
            System.out.println("inputFileName = " + this.inputFileName);
            System.out.println("outputFileName = " + this.outputFileName);
            System.out.println("answerFileName = " + this.answerFileName);
            System.out.println("resultFileName = " + this.resultFileName);
            System.out.println();
        }
        try {
            String results = this.simpleDiff(System.in, this.answerFileName);
            if (JUDGEMENT_YES.equals(results)) {
                return 42;
            }
            return 43;
        }
        catch (Exception e) {
            try {
                if (this.verbose) {
                    e.printStackTrace();
                }
            }
            catch (ValidatorException e2) {
                if (this.verbose) {
                    e2.printStackTrace();
                }
                System.err.println("Validator: " + e2.getMessage());
                System.err.println("Validator error code " + e2.getExitCode());
                return e2.getExitCode();
            }
        }
        return 43;
    }

    public boolean isAllowFatalExit() {
        return this.allowFatalExit;
    }

    public void setAllowFatalExit(boolean allowFatalExit) {
        this.allowFatalExit = allowFatalExit;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static void main(String[] args) {
        Validator validator = new Validator();
        int exitCode = validator.runValidator(args);
        System.exit(exitCode);
    }

    protected class ValidatorException
    extends Exception {
        private int exitCode;
        private static final long serialVersionUID = -3945738509765205483L;

        public ValidatorException(String string, int exitCode) {
            super(string);
            this.exitCode = 255;
            this.exitCode = exitCode;
        }

        public ValidatorException(String string) {
            super(string);
            this.exitCode = 255;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

