/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.team;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IContest;
import edu.csus.ecs.pc2.api.ILanguage;
import edu.csus.ecs.pc2.api.IProblem;
import edu.csus.ecs.pc2.api.IRun;
import edu.csus.ecs.pc2.api.IRunComparator;
import edu.csus.ecs.pc2.api.ServerConnection;
import edu.csus.ecs.pc2.api.exceptions.LoginFailureException;
import edu.csus.ecs.pc2.api.listener.IRunEventListener;
import edu.csus.ecs.pc2.core.InternalController;
import edu.csus.ecs.pc2.core.ParseArguments;
import edu.csus.ecs.pc2.core.StringUtilities;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.exception.CommandLineErrorException;
import edu.csus.ecs.pc2.core.model.ClientId;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class Submitter {
    private ServerConnection serverConnection = null;
    private String login;
    private String password;
    private String languageTitle;
    private String problemTitle;
    private IContest contest;
    private IProblem submittedProblem;
    private ILanguage submittedLanguage;
    private IClient submittedUser;
    private String[] otherFiles = new String[0];
    private String mainSubmissionFileName;
    public static final String[] CCS_REQUIRED_OPTIONS_LIST = new String[]{"-l", "-m", "-p", "-u", "-w"};
    private RunEventListener runliEventListener = new RunEventListener();
    private static final int SUCCESS_EXIT_CODE = 5;
    private static final String NL = System.getProperty("line.separator");
    private String[] allCCSOptions = new String[0];
    private boolean showAllMissingOptions = true;
    private boolean checkArg = false;
    private boolean debugMode = false;
    private long timeStamp;
    private long overrideRunId;
    private boolean submittingClarification = false;
    private String questionText;

    protected Submitter() {
    }

    public Submitter(String login) {
        this.setLoginPassword(login, null);
    }

    public Submitter(String login, String password) {
        this.setLoginPassword(login, password);
    }

    public Submitter(String[] args) throws CommandLineErrorException {
        this.loadVariables(args);
    }

    private void setLoginPassword(String loginName, String inPassword) {
        ClientId id = InternalController.loginShortcutExpansion(1, loginName);
        if (id != null) {
            this.login = id.getName();
            this.password = inPassword;
            if (this.password == null) {
                this.password = this.login;
            }
        }
    }

    protected void loadVariables(String[] args) throws CommandLineErrorException {
        if (args.length == 0 || args[0].equals("--help")) {
            this.usage();
            System.exit(4);
        }
        if (args.length == 0 || args[0].equals("--helpCCS")) {
            this.usageCCS();
            System.exit(4);
        }
        if (this.hasAnyCCSArguments(args, this.getAllCCSOptions())) {
            int numberMissingCCSArguments = this.numberMissingArguments(args, this.getAllCCSOptions(), CCS_REQUIRED_OPTIONS_LIST);
            if (numberMissingCCSArguments > 0) {
                if (this.showAllMissingOptions) {
                    this.printMissingArguments(args, CCS_REQUIRED_OPTIONS_LIST);
                }
                throw new CommandLineErrorException("Missing required command line argument(s)");
            }
            this.loadCCSVariables(args, this.getAllCCSOptions());
        } else {
            String[] opts = new String[]{"--login", "--password"};
            this.loadPC2Variables(args, opts);
        }
    }

    private void loadCCSVariables(String[] args, String[] opts) throws CommandLineErrorException {
        ParseArguments arguments = new ParseArguments(args, opts);
        if (args.length == 0) {
            this.usageCCS();
            System.exit(4);
        }
        this.debugMode = arguments.isOptPresent("--debug");
        if (this.debugMode) {
            arguments.dumpArgs(System.err);
        }
        this.timeStamp = 0L;
        this.checkArg = arguments.isOptPresent("--check");
        String cmdLineLogin = arguments.getOptValue("-u");
        String cmdLinePassword = arguments.getOptValue("-w");
        this.setLoginPassword(cmdLineLogin, cmdLinePassword);
        this.problemTitle = arguments.getOptValue("-p");
        if (arguments.isOptPresent("--list")) {
            this.listInfo();
            System.exit(5);
        } else if (arguments.isOptPresent("--listruns")) {
            this.listRuns();
            System.exit(5);
        } else {
            this.problemTitle = arguments.getOptValue("-p");
            if (arguments.isOptPresent("-l")) {
                this.languageTitle = arguments.getOptValue("-l");
            }
            String runTimeString = arguments.getOptValue("-t");
            try {
                if (arguments.isOptPresent("-t")) {
                    this.timeStamp = Long.parseLong(runTimeString);
                }
            }
            catch (Exception e) {
                throw new CommandLineErrorException("Invalid number after -t '" + runTimeString + "'", e);
            }
            String runIdString = arguments.getOptValue("-i");
            try {
                if (arguments.isOptPresent("-i")) {
                    this.overrideRunId = Long.parseLong(runIdString);
                }
            }
            catch (Exception e) {
                throw new CommandLineErrorException("Invalid number after -i '" + runIdString + "'", e);
            }
            this.mainSubmissionFileName = arguments.getOptValue("-m");
            this.otherFiles = this.getOtherFiles(this.mainSubmissionFileName, arguments.getArgList());
            this.requireFile(this.mainSubmissionFileName, "main source filename");
            String[] stringArray = this.otherFiles;
            int n = this.otherFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.requireFile(name, "other source filename");
                ++n2;
            }
        }
        if (this.password == null) {
            this.password = this.login;
        }
    }

    private String[] getOtherFiles(String mainFileName, String[] argList) {
        String[] outList = new String[]{};
        if (argList.length > 0) {
            if (argList[0].equals(mainFileName)) {
                if (argList.length > 1) {
                    outList = new String[argList.length - 1];
                    System.arraycopy(argList, 1, outList, 0, argList.length - 1);
                } else {
                    outList = argList;
                }
            } else {
                outList = argList;
            }
        }
        return outList;
    }

    private void requireFile(String sourceFile, String description) throws CommandLineErrorException {
        if (!new File(sourceFile).isFile()) {
            throw new CommandLineErrorException(String.valueOf(description) + " missing (" + sourceFile + ")");
        }
    }

    private void loadPC2Variables(String[] args, String[] opts) {
        ParseArguments arguments = new ParseArguments(args, opts);
        this.debugMode = arguments.isOptPresent("--debug");
        if (this.debugMode) {
            arguments.dumpArgs(System.err);
        }
        this.checkArg = arguments.isOptPresent("--check");
        this.submittingClarification = arguments.isOptPresent("--clar");
        String cmdLineLogin = null;
        String cmdLinePassword = null;
        if (arguments.isOptPresent("--login")) {
            cmdLineLogin = arguments.getOptValue("--login");
        }
        if (arguments.isOptPresent("--password")) {
            cmdLinePassword = arguments.getOptValue("--password");
        }
        this.setLoginPassword(cmdLineLogin, cmdLinePassword);
        if (this.submittingClarification) {
            this.problemTitle = arguments.getArg(0);
            if (arguments.getArgCount() > 1) {
                this.questionText = arguments.getArg(1);
                if (this.questionText.startsWith("@")) {
                    this.questionText = this.loadQuestionFile(this.questionText.substring(1));
                    if (this.questionText == null) {
                        System.err.println("Error - could not read question from file '" + this.questionText.substring(1));
                        System.exit(4);
                    }
                }
            } else {
                System.err.println("Error - missing question");
                System.exit(4);
            }
        } else if (arguments.isOptPresent("--list")) {
            this.listInfo();
            System.exit(5);
        } else if (arguments.isOptPresent("--listruns")) {
            this.listRuns();
            System.exit(5);
        } else {
            this.mainSubmissionFileName = arguments.getArg(0);
            if (this.mainSubmissionFileName == null) {
                System.err.println("Error - missing filename");
                System.exit(4);
            }
            if (arguments.getArgCount() > 1) {
                this.problemTitle = arguments.getArg(1);
            }
            if (arguments.getArgCount() > 2) {
                this.languageTitle = arguments.getArg(2);
            }
        }
    }

    private String loadQuestionFile(String filename) {
        String[] lines;
        block3: {
            try {
                lines = Utilities.loadFile(filename);
                if (lines.length != 0) break block3;
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return StringUtilities.join(NL, lines);
    }

    protected boolean hasAnyCCSArguments(String[] args, String[] requiredOpts) {
        ParseArguments parseArguments = new ParseArguments(args, requiredOpts);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (parseArguments.isRequiredOptPresent(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected int numberMissingArguments(String[] args, String[] allOptions, String[] requiredOptions) {
        int count = 0;
        ParseArguments parseArguments = new ParseArguments(args, allOptions);
        String[] stringArray = requiredOptions;
        int n = requiredOptions.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!parseArguments.isOptPresent(s)) {
                ++count;
            } else if (!parseArguments.optHasValue(s)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private void printMissingArguments(String[] args, String[] requiredOpts) {
        ParseArguments parseArguments = new ParseArguments(args, requiredOpts);
        String[] stringArray = requiredOpts;
        int n = requiredOpts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!parseArguments.isOptPresent(s)) {
                System.err.println("Missing required command line parameter " + s);
            } else if (!parseArguments.optHasValue(s)) {
                System.err.println("Missing required value after command line parameter " + s);
            }
            ++n2;
        }
    }

    private String getLanguageFromFilename(String filename2) {
        if (filename2.endsWith(".java")) {
            return this.findLanguageName("Java");
        }
        if (filename2.endsWith(".cpp")) {
            return this.findLanguageName("C++");
        }
        if (filename2.endsWith(".c")) {
            return this.findLanguageName("C");
        }
        return this.languageTitle;
    }

    protected String findLanguageName(String string) {
        ILanguage[] iLanguageArray = this.contest.getLanguages();
        int n = iLanguageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILanguage language = iLanguageArray[n2];
            if (language.getName().equalsIgnoreCase(string)) {
                return language.getName();
            }
            if (language.getName().indexOf(string) > -1) {
                return language.getName();
            }
            ++n2;
        }
        return string;
    }

    protected String getProblemNameFromFilename(String filename) {
        IProblem problem;
        String baseName = Utilities.basename(filename);
        int lastIndex = baseName.lastIndexOf(46);
        if (lastIndex > 1) {
            baseName = baseName.substring(0, lastIndex - 1);
        }
        if ((problem = this.matchProblem(baseName)) != null) {
            return problem.getName();
        }
        return baseName;
    }

    private void usageCCS() {
        String[] usage;
        String[] stringArray = usage = new String[]{"", "Usage Submitter [--help|--list|--listruns|--check] options", "Usage Submitter [-t timestamp] [-i runid] -u loginname -w password -p problem -l language -m mainfile filelist", "Usage Submitter [-F propfile] [--help|--list|--listruns|--check] ", "", "Submit filename for problem and language.  ", "", "--helpCCS      - this listing", "", "-p problem     - contest problem letter or name", "", "-l language    - contest language", "", "-u loginname   - user login ", "", "-w password    - user password", "", "-m filename    - main source file name in directory specified by -d option", "", "-i runid       - (optional) run id for submission  ", "", "-t timestamp   - (optional)  contest time for submission  ", "", "--list         - list problem and languages", "", "--listruns     - list run info for the user", "", "filelist       - list of files including main file", "", "On success exit code will be 5", "Any other exit code is an error.", "", "$Id$"};
        int n = usage.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(s);
            ++n2;
        }
    }

    private void usage() {
        String[] usage;
        String[] stringArray = usage = new String[]{"Usage Submitter [--help|--list|--listruns|--check] --login loginname [--password password] filename [problem [language]]", "Usage Submitter [-F propfile] [--help|--list|--listruns|--check] filename [problem [language]]", "Usage Submitter [-F propfile] [--clar] problem question", "Usage Submitter [options] filename1[,filename2[,filename3[,...]]] [problem [language]]", "", "Submit filename for problem and language.  If problem or language", "not specified the program will guess which problem and language", "based on the file name.", "", "--help   this listing", "", "--helpCCS  CCS testing usage info", "", "--clar   submit a clarification (by default submits a run)", "", "--check  login and check parameters: list problem, language and files that would be submitted.", "", "--list   list problem and languages", "", "--listruns list run info for the user", "", "On success exit code will be 5", "Any other exit code is an error.", "", "$Id$"};
        int n = usage.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.println(s);
            ++n2;
        }
    }

    public void submitRun(String mainfilename, String problemName, String languageName) {
        this.mainSubmissionFileName = mainfilename;
        this.problemTitle = problemName;
        this.languageTitle = languageName;
        this.submitRun();
    }

    private String getProblemNameFromLetter(char letter) {
        try {
            letter = Character.toUpperCase(letter);
            int idx = letter - 65;
            IProblem[] problems = this.contest.getProblems();
            return problems[idx].getName();
        }
        catch (Exception exception) {
            return new Character(letter).toString();
        }
    }

    public void submitRun() {
        boolean success;
        block9: {
            success = false;
            try {
                this.checkRequiredParams();
                this.serverConnection = new ServerConnection();
                this.contest = this.serverConnection.login(this.login, this.password);
                this.contest.addRunListener(this.runliEventListener);
                System.out.println("For: " + this.contest.getMyClient().getDisplayName() + " (" + this.contest.getMyClient().getLoginName() + ")");
                System.out.println();
                try {
                    this.submitTheRun(this.problemTitle, this.languageTitle, this.mainSubmissionFileName, this.otherFiles);
                    this.waitForRunSubmissionConfirmation(this.runliEventListener, 2);
                    IRun run = this.runliEventListener.getRun();
                    if (this.runliEventListener.getRun() != null) {
                        success = true;
                        System.out.println("Submission confirmation: Run " + run.getNumber() + ", problem " + run.getProblem().getName() + ", for team " + run.getTeam().getDisplayName() + " (" + run.getTeam().getLoginName() + ")");
                        if (this.debugMode) {
                            System.out.println("Run " + run.getNumber() + " submitted at " + run.getSubmissionTime() + " minutes");
                        }
                    }
                    this.serverConnection.logoff();
                }
                catch (Exception e) {
                    System.err.println("Unable to submit run: " + e.getMessage());
                    if (this.debugMode) {
                        e.printStackTrace();
                    }
                }
            }
            catch (LoginFailureException e) {
                System.out.println("Unable to login: " + e.getMessage());
                if (!this.debugMode) break block9;
                e.printStackTrace();
            }
        }
        if (success) {
            System.exit(5);
        } else {
            System.exit(4);
        }
    }

    private void checkRequiredParams() throws LoginFailureException {
        if (this.login == null) {
            throw new LoginFailureException("No login specified");
        }
        if (this.password == null) {
            throw new LoginFailureException("No password specified");
        }
    }

    private void waitForRunSubmissionConfirmation(RunEventListener listener, int seconds) throws Exception {
        boolean done = false;
        long waittime = seconds * 1000;
        long startTime = new Date().getTime();
        long timeLimit = startTime + waittime;
        while (!done) {
            if (listener.getRun() != null) {
                done = true;
            }
            if (!done && new Date().getTime() > timeLimit) break;
            System.out.print("");
        }
        long totalTime = new Date().getTime() - startTime;
        if (this.debugMode) {
            System.out.println(String.valueOf(totalTime) + " ms");
            System.out.println();
        }
        if (!done) {
            throw new Exception("Timed out (" + totalTime + " ms) waiting for run submission confirm - contact staff ");
        }
    }

    public void listInfo() {
        block5: {
            try {
                this.checkRequiredParams();
                this.serverConnection = new ServerConnection();
                this.contest = this.serverConnection.login(this.login, this.password);
                try {
                    this.listInfo(this.contest);
                    this.serverConnection.logoff();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.debugMode) {
                        e.printStackTrace();
                    }
                }
            }
            catch (LoginFailureException e1) {
                System.out.println("Unable to login: " + e1.getMessage());
                if (!this.debugMode) break block5;
                e1.printStackTrace();
            }
        }
    }

    public void listRuns() {
        block5: {
            try {
                this.checkRequiredParams();
                this.serverConnection = new ServerConnection();
                this.contest = this.serverConnection.login(this.login, this.password);
                System.out.println();
                System.out.println(this.contest.getContestTitle());
                System.out.println();
                System.out.println("For: " + this.contest.getMyClient().getDisplayName() + " (" + this.contest.getMyClient().getLoginName() + ")");
                System.out.println();
                IRun[] runs = this.contest.getRuns();
                if (runs.length == 0) {
                    System.out.println("No runs submitted");
                } else {
                    System.out.println(String.valueOf(runs.length) + " runs for " + this.contest.getMyClient().getDisplayName() + " (" + this.contest.getMyClient().getLoginName() + ")");
                    System.out.println();
                    Arrays.sort(runs, new IRunComparator());
                    IRun[] iRunArray = runs;
                    int n = runs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IRun run = iRunArray[n2];
                        System.out.println("Run " + run.getNumber() + " at " + run.getSubmissionTime() + " by " + this.contest.getMyClient().getLoginName() + " " + run.getJudgementName() + " " + run.getProblem().getName() + " " + run.getLanguage().getName());
                        ++n2;
                    }
                }
            }
            catch (LoginFailureException e1) {
                System.out.println("Unable to login: " + e1.getMessage());
                if (!this.debugMode) break block5;
                e1.printStackTrace();
            }
        }
    }

    private void listInfo(IContest contest2) {
        System.out.println("Logged in as: " + contest2.getMyClient().getDisplayName());
        System.out.println();
        char let = 'A';
        System.out.println("Problems");
        Object[] objectArray = this.contest.getProblems();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = objectArray[n2];
            System.out.println(String.valueOf(let) + " - " + problem.getName());
            let = (char)(let + '\u0001');
            ++n2;
        }
        System.out.println();
        System.out.println("Languages");
        objectArray = this.contest.getLanguages();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object language = objectArray[n2];
            System.out.println(language.getName());
            ++n2;
        }
        System.out.println();
    }

    private void submitTheRun(String problemTitle2, String languageTitle2, String mainFileName, String[] additionalFilenames) throws Exception {
        this.submittedProblem = null;
        this.submittedLanguage = null;
        if (languageTitle2 == null) {
            languageTitle2 = this.getLanguageFromFilename(mainFileName);
        }
        ILanguage language = this.matchLanguage(languageTitle2);
        if (languageTitle2 == null) {
            throw new Exception("Could not determine Language based on filename '" + mainFileName + "'");
        }
        if (language == null) {
            throw new Exception("Could not match language '" + languageTitle2 + "'");
        }
        if (problemTitle2 == null) {
            problemTitle2 = this.getProblemNameFromFilename(mainFileName);
        }
        if (problemTitle2 != null && problemTitle2.length() == 1) {
            problemTitle2 = this.getProblemNameFromLetter(problemTitle2.charAt(0));
        }
        IProblem problem = this.matchProblem(problemTitle2);
        if (problemTitle2 == null) {
            throw new Exception("Could not determine Problem based on filename '" + mainFileName + "'");
        }
        if (problem == null) {
            throw new Exception("Could not match problem '" + problemTitle2 + "'");
        }
        if (this.checkArg) {
            System.out.println("For   : " + this.contest.getMyClient().getLoginName() + " - " + this.contest.getMyClient().getDisplayName());
            System.out.println("File  : " + mainFileName);
            String[] stringArray = additionalFilenames;
            int n = additionalFilenames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                System.out.println(" file : " + name);
                ++n2;
            }
            System.out.println("Prob  : " + problem.getName());
            System.out.println("Lang  : " + language.getName());
            System.out.println();
            boolean success = true;
            if (!new File(mainFileName).isFile()) {
                System.err.println("Error - file does not exist '" + mainFileName + "'");
                success = false;
            }
            String[] stringArray2 = additionalFilenames;
            int n3 = additionalFilenames.length;
            n = 0;
            while (n < n3) {
                String name = stringArray2[n];
                if (!new File(name).isFile()) {
                    System.err.println("Error - file does not exist '" + name + "'");
                    success = false;
                }
                ++n;
            }
            if (success) {
                System.exit(5);
            } else {
                System.exit(3);
            }
        } else {
            this.serverConnection.submitRun(problem, language, mainFileName, additionalFilenames, this.timeStamp, this.overrideRunId);
            this.submittedProblem = problem;
            this.submittedLanguage = language;
            this.submittedUser = this.contest.getMyClient();
        }
    }

    private IProblem matchProblem(String problemTitle2) {
        IProblem[] iProblemArray = this.contest.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.getName().equalsIgnoreCase(problemTitle2)) {
                return problem;
            }
            if (problem.getShortName().equalsIgnoreCase(problemTitle2)) {
                return problem;
            }
            ++n2;
        }
        char let = 'A';
        IProblem[] iProblemArray2 = this.contest.getProblems();
        int n3 = iProblemArray2.length;
        n = 0;
        while (n < n3) {
            IProblem problem = iProblemArray2[n];
            if (problem.getName().equalsIgnoreCase(Character.toString(let))) {
                return problem;
            }
            let = (char)(let + '\u0001');
            ++n;
        }
        iProblemArray2 = this.contest.getProblems();
        n3 = iProblemArray2.length;
        n = 0;
        while (n < n3) {
            IProblem problem = iProblemArray2[n];
            if (problem.getName().toLowerCase().startsWith(problemTitle2.toLowerCase())) {
                return problem;
            }
            ++n;
        }
        return null;
    }

    private ILanguage matchLanguage(String languageTitle2) {
        ILanguage[] iLanguageArray = this.contest.getLanguages();
        int n = iLanguageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILanguage language = iLanguageArray[n2];
            if (language.getName().equalsIgnoreCase(languageTitle2)) {
                return language;
            }
            ++n2;
        }
        return null;
    }

    public ILanguage getSubmittedLanguage() {
        return this.submittedLanguage;
    }

    public IClient getSubmittedUser() {
        return this.submittedUser;
    }

    public IProblem getSubmittedProblem() {
        return this.submittedProblem;
    }

    public static void main(String[] args) {
        try {
            Submitter submitter = new Submitter(args);
            if (submitter.isSubmittingClarification()) {
                submitter.submitClarification();
            } else {
                submitter.submitRun();
            }
        }
        catch (CommandLineErrorException e) {
            System.err.println("Error on command line: " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Error submitting run " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    private boolean isSubmittingClarification() {
        return this.submittingClarification;
    }

    private void submitClarification() {
        boolean success;
        block7: {
            success = false;
            try {
                this.checkRequiredParams();
                this.serverConnection = new ServerConnection();
                this.contest = this.serverConnection.login(this.login, this.password);
                System.out.println("For: " + this.contest.getMyClient().getDisplayName() + " (" + this.contest.getMyClient().getLoginName() + ")");
                System.out.println();
                try {
                    this.submitTheClarification(this.problemTitle, this.questionText);
                    success = true;
                    this.serverConnection.logoff();
                }
                catch (Exception e) {
                    System.err.println("Unable to submit clarification: " + e.getMessage());
                    if (this.debugMode) {
                        e.printStackTrace();
                    }
                }
            }
            catch (LoginFailureException e) {
                System.out.println("Unable to login: " + e.getMessage());
                if (!this.debugMode) break block7;
                e.printStackTrace();
            }
        }
        if (success) {
            System.exit(5);
        } else {
            System.exit(4);
        }
    }

    private void submitTheClarification(String problemTitle2, String question) throws Exception {
        IProblem problem;
        this.submittedProblem = null;
        if (problemTitle2 != null && problemTitle2.length() == 1) {
            problemTitle2 = this.getProblemNameFromLetter(problemTitle2.charAt(0));
        }
        if ((problem = this.matchProblem(problemTitle2)) == null) {
            throw new Exception("Could not match problem '" + problemTitle2 + "'");
        }
        if (this.checkArg) {
            System.out.println("For   : " + this.contest.getMyClient().getLoginName() + " - " + this.contest.getMyClient().getDisplayName());
            System.out.println("Prob  : " + problem.getName());
            System.out.println();
            boolean success = true;
            if (question == null) {
                System.err.println("Error - no question specified ");
                success = false;
            } else {
                System.out.println("Question : " + question);
                System.out.println();
            }
            if (success) {
                System.out.println("Clarification submitted");
                System.exit(5);
            } else {
                System.exit(3);
            }
        } else {
            System.out.println("Prob  : " + problem.getName());
            System.out.println();
            System.out.println("Question : " + StringUtilities.trunc(question, 55));
            System.out.println();
            if (question == null) {
                System.err.println("Error - no question specified ");
            } else {
                this.serverConnection.submitClarification(problem, question);
            }
        }
    }

    public String[] getAllCCSOptions() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(CCS_REQUIRED_OPTIONS_LIST));
        list.add("-t");
        list.add("-i");
        this.allCCSOptions = list.toArray(new String[list.size()]);
        return this.allCCSOptions;
    }

    public void setShowAllMissingOptions(boolean showAllMissingOptions) {
        this.showAllMissingOptions = showAllMissingOptions;
    }

    public boolean isShowAllMissingOptions() {
        return this.showAllMissingOptions;
    }

    protected class RunEventListener
    implements IRunEventListener,
    Runnable {
        private IRun submittedRun = null;

        protected RunEventListener() {
        }

        @Override
        public void runSubmitted(IRun run) {
            this.submittedRun = run;
        }

        @Override
        public void runDeleted(IRun run) {
        }

        @Override
        public void runCheckedOut(IRun run, boolean isFinal) {
        }

        @Override
        public void runJudged(IRun run, boolean isFinal) {
        }

        @Override
        public void runUpdated(IRun run, boolean isFinal) {
        }

        @Override
        public void runCompiling(IRun run, boolean isFinal) {
        }

        @Override
        public void runExecuting(IRun run, boolean isFinal) {
        }

        @Override
        public void runValidating(IRun run, boolean isFinal) {
        }

        @Override
        public void runJudgingCanceled(IRun run, boolean isFinal) {
        }

        @Override
        public void run() {
        }

        public IRun getRun() {
            return this.submittedRun;
        }
    }
}

