/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.server;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ILoginListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ISiteListener;
import edu.csus.ecs.pc2.core.model.LoginEvent;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.model.SiteEvent;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class ServerModule
implements UIPlugin {
    private static final long serialVersionUID = 1L;
    private IInternalContest contest;
    private IInternalController controller;
    private Log log;

    @Override
    public String getPluginTitle() {
        return "Server (non-GUI)";
    }

    public ServerModule() {
        String[] lines;
        VersionInfo versionInfo = new VersionInfo();
        String[] stringArray = lines = versionInfo.getSystemVersionInfoMultiLine();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            System.out.println(line);
            ++n2;
        }
        System.out.println();
        System.out.println("Date: " + this.getL10nDateTime());
        System.out.println("Working directory is " + Utilities.getCurrentDirectory());
        System.out.println();
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.log = this.controller.getLog();
        this.contest.addRunListener(new RunListenerImplementation());
        this.contest.addLoginListener(new LoginListenerImplementation());
        this.contest.addSiteListener(new SiteListenerImplementation());
        this.contest.addContestTimeListener(new ContestTimeListenerImplementation());
        Profile profile = inContest.getProfile();
        if (!inController.isUsingGUI()) {
            System.out.println(new Date() + " Using Profile: " + profile.getName() + " @ " + profile.getProfilePath());
        }
        this.log.info("Using Profile: " + profile.getName() + " @ " + profile.getProfilePath());
        ClientId clientId = this.contest.getClientId();
        Site site = this.contest.getSite(clientId.getSiteNumber());
        this.info(String.valueOf(clientId.getClientType().toString().toLowerCase()) + " (Site " + site.getSiteNumber() + " - " + site.getDisplayName() + ") started");
    }

    private void info(String string) {
        System.out.println(new Date() + " " + string);
        this.log.info(string);
    }

    protected void infoLog(String string) {
        System.out.println(String.valueOf(this.getL10nDateTime()) + ": " + string);
    }

    protected String getL10nDateTime() {
        DateFormat dateFormatter = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        return dateFormatter.format(new Date());
    }

    public class ContestTimeListenerImplementation
    implements IContestTimeListener {
        private void logClockInfo(String string, ContestTime contestTime) {
            ServerModule.this.infoLog("Clock: " + contestTime.getSiteNumber() + " " + string);
        }

        @Override
        public void contestStarted(ContestTimeEvent event) {
            this.logClockInfo(event.getAction().toString(), event.getContestTime());
        }

        @Override
        public void contestStopped(ContestTimeEvent event) {
            this.logClockInfo(event.getAction().toString(), event.getContestTime());
        }

        @Override
        public void contestTimeAdded(ContestTimeEvent event) {
        }

        @Override
        public void contestTimeChanged(ContestTimeEvent event) {
        }

        @Override
        public void contestTimeRemoved(ContestTimeEvent event) {
        }

        @Override
        public void refreshAll(ContestTimeEvent event) {
            this.logClockInfo(event.getAction().toString(), event.getContestTime());
        }
    }

    public class LoginListenerImplementation
    implements ILoginListener {
        @Override
        public void loginAdded(LoginEvent event) {
        }

        @Override
        public void loginDenied(LoginEvent event) {
        }

        @Override
        public void loginRemoved(LoginEvent event) {
        }

        @Override
        public void loginRefreshAll(LoginEvent event) {
        }
    }

    private class RunListenerImplementation
    implements IRunListener {
        private RunListenerImplementation() {
        }

        @Override
        public void runAdded(RunEvent event) {
        }

        @Override
        public void refreshRuns(RunEvent event) {
        }

        @Override
        public void runChanged(RunEvent event) {
        }

        @Override
        public void runRemoved(RunEvent event) {
        }
    }

    public class SiteListenerImplementation
    implements ISiteListener {
        @Override
        public void siteProfileStatusChanged(SiteEvent event) {
        }

        @Override
        public void siteAdded(SiteEvent event) {
            this.logSiteInfo(event.getAction().toString(), event.getSite());
        }

        private void logSiteInfo(String string, Site site) {
            ServerModule.this.infoLog("Site: " + site.getSiteNumber() + " " + string + " " + site.getDisplayName());
        }

        @Override
        public void siteChanged(SiteEvent event) {
        }

        @Override
        public void siteLoggedOff(SiteEvent event) {
            this.logSiteInfo(event.getAction().toString(), event.getSite());
        }

        @Override
        public void siteLoggedOn(SiteEvent event) {
            this.logSiteInfo(event.getAction().toString(), event.getSite());
        }

        @Override
        public void siteRemoved(SiteEvent event) {
            this.logSiteInfo(event.getAction().toString(), event.getSite());
        }

        @Override
        public void sitesRefreshAll(SiteEvent event) {
            ServerModule.this.infoLog("Site: none " + event.getAction().toString());
        }
    }
}

