/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.judge;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.exception.MultipleIssuesException;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.ClarificationsPane;
import edu.csus.ecs.pc2.ui.ContestClockDisplay;
import edu.csus.ecs.pc2.ui.EventFeedServerPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.ImBoredPane;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.OptionsPane;
import edu.csus.ecs.pc2.ui.PacketMonitorPane;
import edu.csus.ecs.pc2.ui.PluginLoadPane;
import edu.csus.ecs.pc2.ui.RunsPane;
import edu.csus.ecs.pc2.ui.SubmissionBiffPane;
import edu.csus.ecs.pc2.ui.SubmitClarificationPane;
import edu.csus.ecs.pc2.ui.SubmitRunPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class JudgeView
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 5365837218548110171L;
    private IInternalContest contest;
    private IInternalController controller;
    private JTabbedPane mainTabbedPane = null;
    private JPanel messagePane = null;
    private JPanel centerPane = null;
    private JPanel mainPane = null;
    private JLabel messageLabel = null;
    private JPanel exitPane = null;
    private JButton exitButton = null;
    private JPanel northPane = null;
    private JPanel judgeBiffPane = null;
    private ContestClockDisplay contestClockDisplay = null;
    private static Boolean alreadyJudgingRun = Boolean.FALSE;
    private JPanel clockPane = null;
    private JLabel clockLabel = null;

    public JudgeView() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(800, 515));
        this.setContentPane(this.getMainPane());
        this.setDefaultCloseOperation(0);
        this.setTitle("PC^2 Judge - Not Logged In ");
        this.overRideLookAndFeel();
        FrameUtilities.centerFrame(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JudgeView.this.promptAndExit();
            }
        });
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
        }
        return this.mainTabbedPane;
    }

    protected void addUIPlugin(JTabbedPane tabbedPane, String tabTitle, JPanePlugin plugin) {
        this.controller.register(plugin);
        plugin.setParentFrame(this);
        plugin.setContestAndController(this.contest, this.controller);
        tabbedPane.add((Component)plugin, tabTitle);
    }

    protected JudgeView getThisFrame() {
        return this;
    }

    private void setFrameTitle(final boolean contestStarted) {
        final JudgeView thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrameUtilities.setFrameTitle(thisFrame, JudgeView.this.contest.getTitle(), contestStarted, new VersionInfo());
                if (contestStarted) {
                    JudgeView.this.contestClockDisplay.fireClockStateChange(JudgeView.this.contest.getContestTime());
                } else {
                    JudgeView.this.clockLabel.setText("STOPPED");
                }
                if (JudgeView.this.contestClockDisplay.getClientFrame() == null) {
                    JudgeView.this.contestClockDisplay.setClientFrame(JudgeView.this.getThisFrame());
                }
            }
        });
        FrameUtilities.regularCursor(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                block14: {
                    JudgeView.access$4(JudgeView.this).startLogWindow(JudgeView.access$1(JudgeView.this));
                    JudgeView.access$1(JudgeView.this).addContestTimeListener(new ContestTimeListenerImplementation());
                    JudgeView.access$0(JudgeView.this, JudgeView.access$1(JudgeView.this).getContestTime().isContestRunning());
                    JudgeView.access$5(JudgeView.this, "");
                    newRunsPane = new RunsPane(false);
                    newRunsPane.setShowNewRunsOnly(true);
                    newRunsPane.setMakeSoundOnOneRun(true);
                    JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "New Runs", newRunsPane);
                    newRunsPane.setFilterFrameTitle("New Runs Filter");
                    runsPanel = new RunsPane();
                    JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "All Runs", runsPanel);
                    runsPanel.setFilterFrameTitle("All Runs Filter");
                    newClarificationsPane = new ClarificationsPane();
                    newClarificationsPane.setShowNewClarificationsOnly(true);
                    JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "New Clars", newClarificationsPane);
                    clarificationsPane = new ClarificationsPane();
                    JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "All clarifications", clarificationsPane);
                    submitRunPane = new SubmitRunPane();
                    JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "Test Run", submitRunPane);
                    submitClarificationPane = new SubmitClarificationPane();
                    JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "Generate Clarification", submitClarificationPane);
                    optionsPanel = new OptionsPane();
                    JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "Options", optionsPanel);
                    boredPane = new ImBoredPane();
                    JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "I'm Bored", boredPane);
                    JudgeView.access$7(JudgeView.this, new ContestClockDisplay(JudgeView.access$4(JudgeView.this).getLog(), JudgeView.access$1(JudgeView.this).getContestTime(), JudgeView.access$1(JudgeView.this).getSiteNumber(), true, null));
                    JudgeView.access$2(JudgeView.this).addLabeltoUpdateList(JudgeView.access$3(JudgeView.this), ContestClockDisplay.DisplayTimes.REMAINING_TIME, JudgeView.access$1(JudgeView.this).getSiteNumber());
                    JudgeView.access$4(JudgeView.this).register(JudgeView.access$2(JudgeView.this));
                    if (Utilities.isDebugMode()) {
                        try {
                            eventFeedServerPane = new EventFeedServerPane();
                            JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "Event Server", eventFeedServerPane);
                        }
                        catch (Exception e) {
                            if (StaticLog.getLog() != null) {
                                StaticLog.getLog().log(Log.WARNING, "Exception", e);
                                e.printStackTrace(System.err);
                            }
                            e.printStackTrace(System.err);
                        }
                        try {
                            pane = new PluginLoadPane();
                            pane.setParentTabbedPane(JudgeView.access$6(JudgeView.this));
                            JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "Plugin Load", pane);
                        }
                        catch (Exception e) {
                            if (StaticLog.getLog() != null) {
                                StaticLog.getLog().log(Log.WARNING, "Exception", e);
                                e.printStackTrace(System.err);
                            }
                            e.printStackTrace(System.err);
                        }
                    }
                    try {
                        ci = JudgeView.access$1(JudgeView.this).getContestInformation();
                        if (ci != null) {
                            cdpPath = ci.getJudgeCDPBasePath();
                            Utilities.validateCDP(JudgeView.access$1(JudgeView.this), cdpPath);
                        }
                        break block14;
                    }
                    catch (MultipleIssuesException e) {
                        issueList = e.getIssueList();
                        message = new StringBuffer();
                        message.append("The following errors exist:\n");
                        i = 0;
                        ** while (i < issueList.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        issueList[i] = issueList[i].replace("\t", " ");
                        message.append(String.valueOf(issueList[i]) + "\n");
                        ++i;
                        continue;
                    }
lbl71:
                    // 1 sources

                    message.append("\nPlease correct and restart");
                    System.err.println(message);
                    JOptionPane.showMessageDialog(JudgeView.this.getParent(), message, "Cannot perform Judging", 0);
                    System.exit(1);
                }
                submissionBiffPane = new SubmissionBiffPane();
                JudgeView.access$8(JudgeView.this).add((Component)submissionBiffPane, "Center");
                submissionBiffPane.setContestAndController(JudgeView.access$1(JudgeView.this), JudgeView.access$4(JudgeView.this));
                JudgeView.access$4(JudgeView.this).register(submissionBiffPane);
                JudgeView.this.setVisible(true);
                if (Utilities.isDebugMode()) {
                    try {
                        pane = new PacketMonitorPane();
                        JudgeView.this.addUIPlugin(JudgeView.access$6(JudgeView.this), "Packets", pane);
                    }
                    catch (Exception e) {
                        JudgeView.access$9(JudgeView.this, e);
                    }
                }
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Judge Main GUI";
    }

    protected void showLog(boolean showLogWindow) {
        this.controller.showLogWindow(showLogWindow);
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("JLabel");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.add((Component)this.messageLabel, "Center");
            this.messagePane.add((Component)this.getExitPane(), "East");
            this.messagePane.add((Component)this.getClockPane(), "West");
        }
        return this.messagePane;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)this.getMainTabbedPane(), "Center");
        }
        return this.centerPane;
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.add((Component)this.getCenterPane(), "Center");
            this.mainPane.add((Component)this.getNorthPane(), "North");
        }
        return this.mainPane;
    }

    private JPanel getExitPane() {
        if (this.exitPane == null) {
            this.exitPane = new JPanel();
            this.exitPane.add((Component)this.getExitButton(), null);
        }
        return this.exitPane;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setToolTipText("Click here to Shutdown PC^2");
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JudgeView.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JudgeView.this.messageLabel.setText(string);
                JudgeView.this.messageLabel.setToolTipText(string);
            }
        });
    }

    protected boolean isThisSite(int siteNumber) {
        return this.contest.getSiteNumber() == siteNumber;
    }

    private JPanel getNorthPane() {
        if (this.northPane == null) {
            this.northPane = new JPanel();
            this.northPane.setLayout(new BorderLayout());
            this.northPane.setPreferredSize(new Dimension(65, 65));
            this.northPane.add((Component)this.getMessagePane(), "North");
            this.northPane.add((Component)this.getJudgeBiffPane(), "Center");
        }
        return this.northPane;
    }

    private JPanel getJudgeBiffPane() {
        if (this.judgeBiffPane == null) {
            this.judgeBiffPane = new JPanel();
            this.judgeBiffPane.setLayout(new BorderLayout());
            this.judgeBiffPane.setPreferredSize(new Dimension(35, 35));
        }
        return this.judgeBiffPane;
    }

    public static boolean isAlreadyJudgingRun() {
        return alreadyJudgingRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAlreadyJudgingRun(boolean alreadyJudgingRun) {
        JudgeView.alreadyJudgingRun = alreadyJudgingRun;
        if (!alreadyJudgingRun) {
            Boolean bl = JudgeView.getAlreadyJudgingRun();
            synchronized (bl) {
                JudgeView.alreadyJudgingRun.notify();
            }
        }
    }

    public static Boolean getAlreadyJudgingRun() {
        return alreadyJudgingRun;
    }

    private JPanel getClockPane() {
        if (this.clockPane == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setHgap(0);
            this.clockLabel = new JLabel();
            this.clockLabel.setFont(new Font("Dialog", 1, 16));
            this.clockLabel.setHorizontalAlignment(0);
            this.clockLabel.setHorizontalTextPosition(0);
            this.clockLabel.setText("STOPPED ");
            this.clockPane = new JPanel();
            this.clockPane.setLayout(borderLayout);
            this.clockPane.setPreferredSize(new Dimension(85, 34));
            this.clockPane.add((Component)this.clockLabel, "Center");
        }
        return this.clockPane;
    }

    private void logException(Exception e) {
        if (StaticLog.getLog() != null) {
            StaticLog.getLog().log(Log.WARNING, "Exception", e);
            e.printStackTrace(System.err);
        } else {
            e.printStackTrace(System.err);
        }
    }

    static /* synthetic */ IInternalController access$4(JudgeView judgeView) {
        return judgeView.controller;
    }

    static /* synthetic */ void access$5(JudgeView judgeView, String string) {
        judgeView.showMessage(string);
    }

    static /* synthetic */ JTabbedPane access$6(JudgeView judgeView) {
        return judgeView.getMainTabbedPane();
    }

    static /* synthetic */ void access$7(JudgeView judgeView, ContestClockDisplay contestClockDisplay) {
        judgeView.contestClockDisplay = contestClockDisplay;
    }

    static /* synthetic */ JPanel access$8(JudgeView judgeView) {
        return judgeView.getJudgeBiffPane();
    }

    static /* synthetic */ void access$9(JudgeView judgeView, Exception exception) {
        judgeView.logException(exception);
    }

    class ContestTimeListenerImplementation
    implements IContestTimeListener {
        ContestTimeListenerImplementation() {
        }

        @Override
        public void contestTimeAdded(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestTimeRemoved(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestTimeChanged(ContestTimeEvent event) {
            ContestTime contestTime = event.getContestTime();
            if (JudgeView.this.isThisSite(contestTime.getSiteNumber())) {
                JudgeView.this.setFrameTitle(contestTime.isContestRunning());
            }
        }

        @Override
        public void contestStarted(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestStopped(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void refreshAll(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }
    }
}

