/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui.board;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.IniFile;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.log.StaticLog;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ContestTimeEvent;
import edu.csus.ecs.pc2.core.model.IContestTimeListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.util.XSLTransformer;
import edu.csus.ecs.pc2.ui.BalloonColorListPane;
import edu.csus.ecs.pc2.ui.BalloonPane;
import edu.csus.ecs.pc2.ui.ContestClockDisplay;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.OptionsPane;
import edu.csus.ecs.pc2.ui.PacketMonitorPane;
import edu.csus.ecs.pc2.ui.PluginLoadPane;
import edu.csus.ecs.pc2.ui.StandingsPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.xml.transform.TransformerConfigurationException;

public class ScoreboardView
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -8071477348056424178L;
    private IInternalContest contest;
    private IInternalController controller;
    private JTabbedPane mainTabbedPane = null;
    private String xslDir;
    private String outputDir = "html";
    private Log log;
    private JPanel mainViewPane = null;
    private JPanel northPane = null;
    private JLabel clockLabel = null;
    private JLabel messageLabel = null;
    private JPanel eastPane = null;
    private JButton exitButton = null;
    private String currentXMLString = "";
    private JButton refreshButton = null;
    private ContestClockDisplay contestClockDisplay = null;
    private JPanel clockPanel = null;

    public ScoreboardView() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(800, 400));
        this.setContentPane(this.getMainViewPane());
        this.setDefaultCloseOperation(0);
        this.setTitle("Scoreboard");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ScoreboardView.this.promptAndExit();
            }
        });
        this.overRideLookAndFeel();
        FrameUtilities.centerFrame(this);
    }

    private void overRideLookAndFeel() {
        String value = IniFile.getValue("client.plaf");
        if (value != null && value.equalsIgnoreCase("java")) {
            FrameUtilities.setJavaLookAndFeel();
        }
        if (value != null && value.equalsIgnoreCase("native")) {
            FrameUtilities.setNativeLookAndFeel();
        }
    }

    protected void promptAndExit() {
        int result = FrameUtilities.yesNoCancelDialog(null, "Are you sure you want to exit PC^2?", "Exit PC^2");
        if (result == 0) {
            System.exit(0);
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.contest.addContestTimeListener(new ContestTimeListenerImplementation());
        this.xslDir = "data" + File.separator + "xsl";
        File xslDirFile = new File(this.xslDir);
        if (!xslDirFile.canRead() || !xslDirFile.isDirectory()) {
            VersionInfo versionInfo = new VersionInfo();
            this.xslDir = String.valueOf(versionInfo.locateHome()) + File.separator + this.xslDir;
        }
        this.log = this.controller.getLog();
        this.log.info("Using XSL from directory " + this.xslDir);
        this.contestClockDisplay = new ContestClockDisplay(this.controller.getLog(), this.contest.getContestTime(), this.contest.getSiteNumber(), true, null);
        this.contestClockDisplay.addLabeltoUpdateList(this.clockLabel, ContestClockDisplay.DisplayTimes.REMAINING_TIME, this.contest.getSiteNumber());
        this.controller.register(this.contestClockDisplay);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScoreboardView.this.setTitle("PC^2 " + ScoreboardView.this.contest.getTitle() + " Build " + new VersionInfo().getBuildNumber());
                ScoreboardView.this.controller.startLogWindow(ScoreboardView.this.contest);
                ScoreboardView.this.setFrameTitle(ScoreboardView.this.contest.getContestTime().isContestRunning());
                StandingsPane standingsPane = new StandingsPane();
                ScoreboardView.this.addUIPlugin(ScoreboardView.this.getMainTabbedPane(), "Standings", standingsPane);
                standingsPane.addPropertyChangeListener("standings", new PropertyChangeListenerImplementation());
                BalloonColorListPane colorsPane = new BalloonColorListPane();
                ScoreboardView.this.addUIPlugin(ScoreboardView.this.getMainTabbedPane(), "Colors", colorsPane);
                BalloonPane balloonHandler = new BalloonPane();
                ScoreboardView.this.addUIPlugin(ScoreboardView.this.getMainTabbedPane(), "Balloon Test", balloonHandler);
                OptionsPane optionsPanel = new OptionsPane();
                ScoreboardView.this.addUIPlugin(ScoreboardView.this.getMainTabbedPane(), "Options", optionsPanel);
                if (Utilities.isDebugMode()) {
                    JPanePlugin pane;
                    try {
                        pane = new PacketMonitorPane();
                        ScoreboardView.this.addUIPlugin(ScoreboardView.this.getMainTabbedPane(), "Packets", pane);
                    }
                    catch (Exception e) {
                        ScoreboardView.this.logException(e);
                    }
                    try {
                        pane = new PluginLoadPane();
                        ((PluginLoadPane)pane).setParentTabbedPane(ScoreboardView.this.getMainTabbedPane());
                        ScoreboardView.this.addUIPlugin(ScoreboardView.this.getMainTabbedPane(), "Plugin Load", pane);
                    }
                    catch (Exception e) {
                        if (StaticLog.getLog() != null) {
                            StaticLog.getLog().log(Log.WARNING, "Exception", e);
                            e.printStackTrace(System.err);
                        }
                        e.printStackTrace(System.err);
                    }
                }
                ScoreboardView.this.showMessage("");
                ScoreboardView.this.setVisible(true);
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Scoreboard View";
    }

    protected void addUIPlugin(JTabbedPane tabbedPane, String tabTitle, JPanePlugin plugin) {
        this.controller.register(plugin);
        plugin.setParentFrame(this);
        plugin.setContestAndController(this.contest, this.controller);
        tabbedPane.add((Component)plugin, tabTitle);
    }

    private void generateOutput(String xmlString) {
        this.currentXMLString = xmlString;
        File inputDir = new File(this.xslDir);
        if (!inputDir.isDirectory()) {
            this.log.warning("xslDir is not a directory");
            return;
        }
        File outputDirFile = new File(this.outputDir);
        if (!outputDirFile.exists() && !outputDirFile.mkdirs()) {
            this.log.warning("Could not create " + outputDirFile.getAbsolutePath() + ", defaulting to current directory");
            this.outputDir = ".";
            outputDirFile = new File(this.outputDir);
        }
        if (!outputDirFile.isDirectory()) {
            this.log.warning(String.valueOf(this.outputDir) + " is not a directory.");
            return;
        }
        this.log.fine("Sending output to " + outputDirFile.getAbsolutePath());
        try {
            File output = File.createTempFile("__t", ".tmp", new File("."));
            FileOutputStream outputXML = new FileOutputStream(output);
            outputXML.write(xmlString.getBytes());
            outputXML.close();
            if (output.length() > 0L) {
                File outputFile = new File("results.xml");
                if (!output.renameTo(outputFile)) {
                    outputFile.delete();
                    if (!output.renameTo(outputFile)) {
                        this.log.warning("Could not create " + outputFile.getCanonicalPath());
                    }
                }
            } else {
                this.log.warning("New results.xml is empty, not updating");
                output.delete();
            }
            output = null;
        }
        catch (FileNotFoundException e1) {
            this.log.log(Log.WARNING, "Could not write to results.xml", e1);
        }
        catch (IOException e) {
            this.log.log(Log.WARNING, "Problem writing to results.xml", e);
        }
        String[] inputFiles = inputDir.list();
        XSLTransformer transformer = new XSLTransformer();
        int i = 0;
        while (i < inputFiles.length) {
            String xslFilename = inputFiles[i];
            if (xslFilename.endsWith(".xsl")) {
                String outputFilename = String.valueOf(xslFilename.substring(0, xslFilename.length() - 4)) + ".html";
                try {
                    File output = File.createTempFile("__t", ".htm", outputDirFile);
                    FileOutputStream outputStream = new FileOutputStream(output);
                    transformer.transform(String.valueOf(this.xslDir) + File.separator + xslFilename, new ByteArrayInputStream(xmlString.getBytes()), outputStream);
                    outputStream.close();
                    if (output.length() > 0L) {
                        File outputFile = new File(String.valueOf(this.outputDir) + File.separator + outputFilename);
                        if (xslFilename.equals("pc2export.xsl")) {
                            outputFile = new File("pc2export.dat");
                        }
                        if (xslFilename.endsWith(".json.xsl") || xslFilename.endsWith(".tsv.xsl") || xslFilename.endsWith(".csv.xsl") || xslFilename.endsWith(".php.xsl")) {
                            outputFile = new File(String.valueOf(this.outputDir) + File.separator + xslFilename.substring(0, xslFilename.length() - 4));
                        }
                        if (!output.renameTo(outputFile)) {
                            outputFile.delete();
                            if (!output.renameTo(outputFile)) {
                                this.log.warning("Could not create " + outputFile.getCanonicalPath());
                            } else {
                                this.log.finest("rename2 to " + outputFile.getCanonicalPath() + " succeeded.");
                            }
                        } else {
                            this.log.finest("rename to " + outputFile.getCanonicalPath() + " succeeded.");
                        }
                    } else {
                        this.log.warning("output from tranformation " + xslFilename + " was empty");
                        output.delete();
                    }
                    output = null;
                }
                catch (IOException e) {
                    this.log.log(Log.WARNING, "Trouble transforming " + xslFilename, e);
                }
                catch (TransformerConfigurationException e) {
                    this.log.log(Log.WARNING, "Trouble transforming " + xslFilename, e);
                }
                catch (Exception e) {
                    this.log.log(Log.WARNING, "Trouble transforming " + xslFilename, e);
                }
            }
            ++i;
        }
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
        }
        return this.mainTabbedPane;
    }

    private JPanel getMainViewPane() {
        if (this.mainViewPane == null) {
            this.mainViewPane = new JPanel();
            this.mainViewPane.setLayout(new BorderLayout());
            this.mainViewPane.add((Component)this.getMainTabbedPane(), "Center");
            this.mainViewPane.add((Component)this.getNorthPane(), "North");
        }
        return this.mainViewPane;
    }

    private JPanel getNorthPane() {
        if (this.northPane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setHorizontalAlignment(0);
            this.messageLabel.setText("JLabel");
            this.clockLabel = new JLabel();
            this.clockLabel.setFont(new Font("Dialog", 1, 16));
            this.clockLabel.setHorizontalAlignment(0);
            this.clockLabel.setHorizontalTextPosition(0);
            this.clockLabel.setText("STOPPED ");
            this.northPane = new JPanel();
            this.northPane.setLayout(new BorderLayout());
            this.northPane.add((Component)this.messageLabel, "Center");
            this.northPane.add((Component)this.getEastPane(), "East");
            this.northPane.add((Component)this.getClockPanel(), "West");
        }
        return this.northPane;
    }

    private JPanel getEastPane() {
        if (this.eastPane == null) {
            this.eastPane = new JPanel();
            this.eastPane.add((Component)this.getRefreshButton(), null);
            this.eastPane.add((Component)this.getExitButton(), null);
        }
        return this.eastPane;
    }

    private JButton getExitButton() {
        if (this.exitButton == null) {
            this.exitButton = new JButton();
            this.exitButton.setText("Exit");
            this.exitButton.setToolTipText("Click here to Shutdown PC^2");
            this.exitButton.setMnemonic(88);
            this.exitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScoreboardView.this.promptAndExit();
                }
            });
        }
        return this.exitButton;
    }

    private void setFrameTitle(final boolean contestStarted) {
        final ScoreboardView thisFrame = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrameUtilities.setFrameTitle(thisFrame, ScoreboardView.this.contest.getTitle(), contestStarted, new VersionInfo());
                if (contestStarted) {
                    ScoreboardView.this.contestClockDisplay.fireClockStateChange(ScoreboardView.this.contest.getContestTime());
                } else {
                    ScoreboardView.this.clockLabel.setText("STOPPED");
                }
                if (ScoreboardView.this.contestClockDisplay.getClientFrame() == null) {
                    ScoreboardView.this.contestClockDisplay.setClientFrame(thisFrame);
                }
            }
        });
        FrameUtilities.regularCursor(this);
    }

    protected boolean isThisSite(int siteNumber) {
        return this.contest.getSiteNumber() == siteNumber;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScoreboardView.this.messageLabel.setText(string);
                ScoreboardView.this.messageLabel.setToolTipText(string);
            }
        });
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setPreferredSize(new Dimension(100, 26));
            this.refreshButton.setToolTipText("Re-generate the HTML");
            this.refreshButton.setMnemonic(82);
            this.refreshButton.setText("Refresh");
            this.refreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ScoreboardView.this.currentXMLString.length() > 0) {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                ScoreboardView.this.generateOutput(ScoreboardView.this.currentXMLString);
                            }
                        }).start();
                    } else {
                        JOptionPane.showMessageDialog(ScoreboardView.this.getParent(), "XML currently unavailable", "Please wait", 2);
                    }
                }
            });
        }
        return this.refreshButton;
    }

    private void logException(Exception e) {
        if (StaticLog.getLog() != null) {
            StaticLog.getLog().log(Log.WARNING, "Exception", e);
            e.printStackTrace(System.err);
        } else {
            e.printStackTrace(System.err);
        }
    }

    private JPanel getClockPanel() {
        if (this.clockPanel == null) {
            this.clockPanel = new JPanel();
            this.clockPanel.setPreferredSize(new Dimension(85, 34));
            this.clockPanel.setLayout(new BorderLayout());
            this.clockPanel.add((Component)this.clockLabel, "Center");
        }
        return this.clockPanel;
    }

    class ContestTimeListenerImplementation
    implements IContestTimeListener {
        ContestTimeListenerImplementation() {
        }

        @Override
        public void contestTimeAdded(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestTimeRemoved(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestTimeChanged(ContestTimeEvent event) {
            ContestTime contestTime = event.getContestTime();
            if (ScoreboardView.this.isThisSite(contestTime.getSiteNumber())) {
                ScoreboardView.this.setFrameTitle(contestTime.isContestRunning());
            }
        }

        @Override
        public void contestStarted(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void contestStopped(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }

        @Override
        public void refreshAll(ContestTimeEvent event) {
            this.contestTimeChanged(event);
        }
    }

    public class PropertyChangeListenerImplementation
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("standings") && evt.getNewValue() != null && !evt.getNewValue().equals(evt.getOldValue())) {
                ScoreboardView.this.generateOutput((String)evt.getNewValue());
            }
        }
    }
}

