/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class TestCaseTableModel
extends DefaultTableModel {
    private static String[] colNames = new String[]{"Test Case", "Data File", "Answer File"};
    private static Vector<String> columnNames = new Vector<String>(Arrays.asList(colNames));
    private ProblemDataFiles files;
    private static final long serialVersionUID = 1L;

    public TestCaseTableModel(ProblemDataFiles files) {
        super(null, columnNames);
        this.setFiles(files);
    }

    public TestCaseTableModel() {
        super(null, columnNames);
        this.setRowCount(0);
    }

    public void setFiles(ProblemDataFiles files) {
        if (files != null) {
            this.setRowCount(files.getJudgesAnswerFiles().length);
            this.files = files;
        } else {
            this.setRowCount(0);
            this.files = null;
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        String obj = "Unknown";
        switch (column) {
            case 0: {
                obj = "" + (row + 1);
                break;
            }
            case 1: {
                if (this.files == null || this.files.getJudgesDataFiles() == null || this.files.getJudgesDataFiles().length <= row) {
                    obj = null;
                    break;
                }
                obj = this.files.getJudgesDataFiles()[row].getName();
                break;
            }
            case 2: {
                if (this.files == null || this.files.getJudgesAnswerFiles() == null || this.files.getJudgesAnswerFiles().length <= row) {
                    obj = null;
                    break;
                }
                obj = this.files.getJudgesAnswerFiles()[row].getName();
                break;
            }
        }
        return obj;
    }

    @Override
    public void removeRow(int row) {
        this.files.removeDataSet(row);
        super.removeRow(row);
    }

    public ProblemDataFiles getFiles() {
        return this.files;
    }
}

