/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.model.RunTestCase;
import edu.csus.ecs.pc2.ui.MultiTestSetOutputViewerPane;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;

public class TestCaseResultsTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;

    public TestCaseResultsTableModel(RunTestCase[] testCases, Object[] columnNames) {
        int col = 0;
        while (col < columnNames.length) {
            super.setColumnIdentifiers(columnNames);
            ++col;
        }
        if (testCases != null) {
            int row = 0;
            while (row < testCases.length) {
                Boolean selected = new Boolean(!testCases[row].isPassed());
                String testCaseNum = new String(Integer.toString(row + 1));
                boolean result = testCases[row].isPassed();
                String resultString = "Fail";
                if (result) {
                    resultString = "Pass";
                }
                JLabel resultLabel = new JLabel(resultString);
                String time = new String(Long.toString(testCases[row].getElapsedMS()));
                JLabel teamOutputViewLabel = new JLabel("View");
                JLabel teamOutputCompareLabel = new JLabel("Compare");
                JLabel judgesOutputViewLabel = new JLabel("View");
                JLabel judgesDataViewLabel = new JLabel("View");
                JLabel validatorOutputViewLabel = new JLabel("View");
                JLabel validatorStderrViewLabel = new JLabel("View");
                Object[] rowData = new Object[]{selected, testCaseNum, resultLabel, time, teamOutputViewLabel, teamOutputCompareLabel, judgesOutputViewLabel, judgesDataViewLabel, validatorOutputViewLabel, validatorStderrViewLabel};
                super.addRow(rowData);
                ++row;
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int col) {
        Vector v = (Vector)this.dataVector.elementAt(0);
        return v.elementAt(col).getClass();
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return ((Vector)this.dataVector.elementAt(rowIndex)).elementAt(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean retVal = columnIndex == MultiTestSetOutputViewerPane.COLUMN.SELECT_CHKBOX.ordinal();
        return retVal;
    }
}

