/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.SwitchProfileStatusPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class SwitchProfileStatusFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -2571995618077528278L;
    private SwitchProfileStatusPane switchProfileStatusPane = null;

    public SwitchProfileStatusFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(705, 264));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getSwitchProfileStatusPane());
        this.setTitle("Switch Profile");
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.getSwitchProfileStatusPane().setContestAndController(inContest, inController);
    }

    @Override
    public String getPluginTitle() {
        return "SwitchProfileConfirmPane";
    }

    public void setProfile(Profile profile) {
        this.setTitle("Profile Change Status, to profile " + profile.getName() + " (" + profile.getDescription() + ")");
        this.getSwitchProfileStatusPane().setProfile(profile);
    }

    private SwitchProfileStatusPane getSwitchProfileStatusPane() {
        if (this.switchProfileStatusPane == null) {
            this.switchProfileStatusPane = new SwitchProfileStatusPane();
            this.switchProfileStatusPane.setParentFrame(this);
        }
        return this.switchProfileStatusPane;
    }

    public void setNewContestPassword(String password) {
        this.getSwitchProfileStatusPane().setNewContestPassword(password);
    }

    public void setCurrentContestPassword(String password) {
        this.getSwitchProfileStatusPane().setCurrentContestPassword(password);
    }

    public void resetProfileStatusList() {
        this.getSwitchProfileStatusPane().resetProfileStatusList();
    }
}

