/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.SwitchProfileStatusFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class SwitchProfileConfirmPane
extends JPanePlugin {
    private static final long serialVersionUID = 7131488143028746955L;
    private JPanel mainPane = null;
    private JPanel promptPane = null;
    private JPanel buttonPane = null;
    private JButton switchButton = null;
    private JButton cancelButton = null;
    private JLabel contestPasswordLabel = null;
    private JPasswordField contestPasswordTextField = null;
    private Profile profile = null;
    private SwitchProfileStatusFrame statusFrame = null;

    public SwitchProfileConfirmPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(385, 186));
        this.add((Component)this.getMainPane(), "Center");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getStatusFrame().setContestAndController(inContest, inController);
    }

    @Override
    public String getPluginTitle() {
        return "Switch Profile Confirm Pane";
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(new BorderLayout());
            this.mainPane.add((Component)this.getButtonPane(), "South");
            this.mainPane.add((Component)this.getPromptPane(), "Center");
        }
        return this.mainPane;
    }

    private JPanel getPromptPane() {
        if (this.promptPane == null) {
            this.contestPasswordLabel = new JLabel();
            this.contestPasswordLabel.setBounds(new Rectangle(17, 12, 348, 31));
            this.contestPasswordLabel.setFont(new Font("Dialog", 1, 14));
            this.contestPasswordLabel.setHorizontalAlignment(0);
            this.contestPasswordLabel.setText("Enter Contest Password");
            this.promptPane = new JPanel();
            this.promptPane.setLayout(null);
            this.promptPane.add((Component)this.contestPasswordLabel, null);
            this.promptPane.add((Component)this.getContestPasswordTextField(), null);
        }
        return this.promptPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            flowLayout.setAlignment(1);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getSwitchButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getSwitchButton() {
        if (this.switchButton == null) {
            this.switchButton = new JButton();
            this.switchButton.setPreferredSize(new Dimension(100, 26));
            this.switchButton.setMnemonic(83);
            this.switchButton.setText("Switch");
            this.switchButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwitchProfileConfirmPane.this.switchProfile();
                }
            });
        }
        return this.switchButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setPreferredSize(new Dimension(100, 26));
            this.cancelButton.setMnemonic(67);
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwitchProfileConfirmPane.this.closeWindow();
                }
            });
        }
        return this.cancelButton;
    }

    protected void closeWindow() {
        this.getParentFrame().setVisible(false);
    }

    private JPasswordField getContestPasswordTextField() {
        if (this.contestPasswordTextField == null) {
            this.contestPasswordTextField = new JPasswordField();
            this.contestPasswordTextField.setBounds(new Rectangle(90, 64, 202, 30));
            this.contestPasswordTextField.setFont(new Font("Dialog", 0, 14));
            this.contestPasswordTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        SwitchProfileConfirmPane.this.switchProfile();
                    }
                }
            });
        }
        return this.contestPasswordTextField;
    }

    protected void switchProfile() {
        String password = new String(this.getContestPasswordTextField().getPassword());
        ClientId[] servers = this.getContest().getAllLoggedInClients(ClientType.Type.SERVER);
        if (servers.length == 0) {
            this.getController().switchProfile(this.getContest().getProfile(), this.profile, password);
            this.closeWindow();
        } else {
            this.getStatusFrame().setProfile(this.profile);
            this.getStatusFrame().setNewContestPassword(password);
            this.getStatusFrame().setCurrentContestPassword(this.getContest().getContestPassword());
            this.getStatusFrame().resetProfileStatusList();
            this.closeWindow();
            this.getStatusFrame().setVisible(true);
            this.getController().switchProfile(this.getContest().getProfile(), this.profile, password);
        }
    }

    public Profile getProfile() {
        return this.profile;
    }

    public void setProfile(Profile profile) {
        this.getContestPasswordTextField().setText("");
        this.profile = profile;
        this.contestPasswordLabel.setText("Enter Contest Password for " + profile.getName());
        this.getContestPasswordTextField().requestFocus();
    }

    public SwitchProfileStatusFrame getStatusFrame() {
        if (this.statusFrame == null) {
            this.statusFrame = new SwitchProfileStatusFrame();
        }
        return this.statusFrame;
    }
}

