/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.MultiColumnListbox;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.BalloonSettingsEvent;
import edu.csus.ecs.pc2.core.model.ContestInformationEvent;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IBalloonSettingsListener;
import edu.csus.ecs.pc2.core.model.IContestInformationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IProblemListener;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.ProblemEvent;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.StringReader;
import java.util.Date;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class StandingsPane
extends JPanePlugin {
    private static final long serialVersionUID = 5947564887534500596L;
    private MCLB standingsListbox = null;
    private JPanel messagePane = null;
    private JLabel messageLabel = null;
    private Log log;
    private String currentXMLString = "";

    public StandingsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(470, 243));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getStandingsListbox(), "Center");
    }

    @Override
    public String getPluginTitle() {
        return "Standings Plugin";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addProblemListener(new ProblemListenerImplementation());
        this.getContest().addRunListener(new RunListenerImplementation());
        this.getContest().addContestInformationListener(new ContestInformationListenerImplementation());
        this.getContest().addBalloonSettingsListener(new BalloonSettingsListenerImplementation());
        this.refreshStandings();
    }

    private String[] fetchStanding(Node node) {
        String[] outArray = new String[4];
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node standingNode = attributes.item(i);
            String value = standingNode.getNodeValue();
            String name = standingNode.getNodeName();
            if (name.equals("rank")) {
                outArray[0] = value;
            } else if (name.equals("teamName")) {
                outArray[1] = value;
            } else if (name.equals("solved")) {
                outArray[2] = value;
            } else if (name.equals("points")) {
                outArray[3] = value;
            }
            ++i;
        }
        return outArray;
    }

    protected void parseAndDisplay() {
        this.standingsListbox.removeAllRows();
        Document document = null;
        String xmlString = null;
        try {
            DefaultScoringAlgorithm defaultScoringAlgorithm = new DefaultScoringAlgorithm();
            Properties properties = this.getScoringProperties();
            xmlString = defaultScoringAlgorithm.getStandings(this.getContest(), properties, this.getController().getLog());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Trouble creating or parsing SA XML ", e);
            this.showMessage("Problem updating scoreboard (parse error), check log");
            return;
        }
        try {
            NodeList list = document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("teamStanding")) {
                    try {
                        String[] standingsRow = this.fetchStanding(node);
                        this.updateStandingsRow(standingsRow);
                    }
                    catch (Exception e) {
                        this.log.log(Log.WARNING, "Exception while adding row ", e);
                    }
                }
                ++i;
            }
            this.showMessage("Last update " + new Date());
            this.firePropertyChange("standings", this.currentXMLString, xmlString);
            this.currentXMLString = xmlString;
        }
        catch (Exception e) {
            this.log.log(Log.WARNING, "Trouble parsing XML ", e);
            this.showMessage("Problem updating scoreboard, check log");
        }
    }

    protected void refreshStandings() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StandingsPane.this.parseAndDisplay();
            }
        });
    }

    private void updateStandingsRow(String[] values) {
        Object[] objects = this.buildSiteRow(values);
        this.standingsListbox.addRow(objects);
        this.standingsListbox.autoSizeAllColumns();
    }

    private MultiColumnListbox getStandingsListbox() {
        if (this.standingsListbox == null) {
            this.standingsListbox = new MCLB();
            Object[] cols = new Object[]{"Rank", "Name", "Solved", "Points"};
            this.standingsListbox.addColumns(cols);
        }
        return this.standingsListbox;
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(25, 25));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StandingsPane.this.messageLabel.setText(string);
            }
        });
    }

    private Object[] buildSiteRow(String[] fields) {
        Object[] obj = new Object[this.standingsListbox.getColumnCount()];
        obj[0] = fields[0];
        obj[1] = fields[1];
        obj[2] = fields[2];
        obj[3] = fields[3];
        return obj;
    }

    protected Properties getScoringProperties() {
        String[] keys;
        Properties properties = this.getContest().getContestInformation().getScoringProperties();
        Properties defProperties = DefaultScoringAlgorithm.getDefaultProperties();
        String[] stringArray = keys = defProperties.keySet().toArray(new String[defProperties.keySet().size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (!properties.containsKey(key)) {
                properties.put(key, defProperties.get(key));
            }
            ++n2;
        }
        return properties;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void accountModified(AccountEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            StandingsPane.this.refreshStandings();
        }
    }

    public class BalloonSettingsListenerImplementation
    implements IBalloonSettingsListener {
        @Override
        public void balloonSettingsAdded(BalloonSettingsEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void balloonSettingsChanged(BalloonSettingsEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void balloonSettingsRemoved(BalloonSettingsEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void balloonSettingsRefreshAll(BalloonSettingsEvent balloonSettingsEvent) {
            StandingsPane.this.refreshStandings();
        }
    }

    class ContestInformationListenerImplementation
    implements IContestInformationListener {
        ContestInformationListenerImplementation() {
        }

        @Override
        public void contestInformationAdded(ContestInformationEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void contestInformationChanged(ContestInformationEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void contestInformationRemoved(ContestInformationEvent event) {
        }

        @Override
        public void contestInformationRefreshAll(ContestInformationEvent contestInformationEvent) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void finalizeDataChanged(ContestInformationEvent contestInformationEvent) {
            StandingsPane.this.refreshStandings();
        }
    }

    public class ProblemListenerImplementation
    implements IProblemListener {
        @Override
        public void problemAdded(ProblemEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void problemChanged(ProblemEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void problemRemoved(ProblemEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void problemRefreshAll(ProblemEvent event) {
            StandingsPane.this.refreshStandings();
        }
    }

    public class RunListenerImplementation
    implements IRunListener {
        @Override
        public void runAdded(RunEvent event) {
        }

        @Override
        public void refreshRuns(RunEvent event) {
            StandingsPane.this.refreshStandings();
        }

        @Override
        public void runChanged(RunEvent event) {
            if (event.getAction().equals((Object)RunEvent.Action.CHANGED)) {
                StandingsPane.this.refreshStandings();
            }
        }

        @Override
        public void runRemoved(RunEvent event) {
            StandingsPane.this.refreshStandings();
        }
    }
}

