/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ResetContestFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 928051966964037016L;
    private JPanel buttonPane = null;
    private JPanel centerPane = null;
    private JButton resetButton = null;
    private JButton cancelButton = null;
    private JCheckBox removeProblemDefsCheckBox = null;
    private JCheckBox removeLanguageDefintions = null;
    private JLabel label1 = null;
    private JLabel label2 = null;
    private JPanel mainPanel = null;
    private IInternalContest contest;
    private IInternalController controller;

    public ResetContestFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(495, 248));
        this.setContentPane(this.getMainPanel());
        this.setTitle("Reset Contest");
        FrameUtilities.centerFrame(this);
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getResetButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.label2 = new JLabel();
            this.label2.setBounds(new Rectangle(35, 16, 411, 26));
            this.label2.setFont(new Font("Dialog", 1, 14));
            this.label2.setHorizontalAlignment(0);
            this.label2.setText(" Reset will erase all runs, clarifications ");
            this.label1 = new JLabel();
            this.label1.setBounds(new Rectangle(36, 58, 411, 26));
            this.label1.setFont(new Font("Dialog", 1, 14));
            this.label1.setHorizontalAlignment(0);
            this.label1.setText("and reset the contest time.");
            this.centerPane = new JPanel();
            this.centerPane.setLayout(null);
            this.centerPane.add((Component)this.getRemoveProblemDefsCheckBox(), null);
            this.centerPane.add((Component)this.getRemoveLanguageDefintions(), null);
            this.centerPane.add((Component)this.label1, null);
            this.centerPane.add((Component)this.label2, null);
        }
        return this.centerPane;
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton();
            this.resetButton.setText("Reset");
            this.resetButton.setMnemonic(82);
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResetContestFrame.this.confirmReset();
                }
            });
        }
        return this.resetButton;
    }

    protected void confirmReset() {
        String title;
        String stopMessage;
        int result;
        boolean resetProblemDefs = this.getRemoveProblemDefsCheckBox().isSelected();
        boolean resetLanguageDefs = this.getRemoveLanguageDefintions().isSelected();
        String problemText = "";
        String languageText = "";
        if (resetProblemDefs) {
            problemText = " problems,";
        }
        if (resetLanguageDefs) {
            languageText = " languages,";
        }
        if ((result = FrameUtilities.yesNoCancelDialog(this, stopMessage = "Reset will erase all runs," + problemText + languageText + " and clarifications, and will reset the contest time.\n" + "Are you sure you want to reset this Contest Active Profile?", title = "Confirm Reset Active Profile: " + this.contest.getProfile().getName())) == 0) {
            this.controller.resetContest(this.contest.getClientId(), resetProblemDefs, resetLanguageDefs);
            this.setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResetContestFrame.this.setVisible(false);
                }
            });
        }
        return this.cancelButton;
    }

    private JCheckBox getRemoveProblemDefsCheckBox() {
        if (this.removeProblemDefsCheckBox == null) {
            this.removeProblemDefsCheckBox = new JCheckBox();
            this.removeProblemDefsCheckBox.setBounds(new Rectangle(116, 100, 272, 21));
            this.removeProblemDefsCheckBox.setText("Remove problem definitions");
        }
        return this.removeProblemDefsCheckBox;
    }

    private JCheckBox getRemoveLanguageDefintions() {
        if (this.removeLanguageDefintions == null) {
            this.removeLanguageDefintions = new JCheckBox();
            this.removeLanguageDefintions.setBounds(new Rectangle(116, 137, 278, 24));
            this.removeLanguageDefintions.setText("Remove language definitions");
        }
        return this.removeLanguageDefintions;
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        Profile profile = this.contest.getProfile();
        final String newTitle = "Reset Profile: " + profile.getName() + " (" + profile.getDescription() + ")";
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResetContestFrame.this.getRemoveLanguageDefintions().setSelected(false);
                ResetContestFrame.this.getRemoveProblemDefsCheckBox().setSelected(false);
                ResetContestFrame.this.setTitle(newTitle);
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Reset Dialog";
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getButtonPane(), "South");
            this.mainPanel.add((Component)this.getCenterPane(), "Center");
        }
        return this.mainPanel;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.getRemoveLanguageDefintions().setSelected(false);
        this.getRemoveProblemDefsCheckBox().setSelected(false);
    }
}

