/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.imports.ContestXML;
import edu.csus.ecs.pc2.core.list.ReportNameByComparator;
import edu.csus.ecs.pc2.core.list.SiteComparatorBySiteNumber;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.report.AccountPermissionReport;
import edu.csus.ecs.pc2.core.report.AccountsReport;
import edu.csus.ecs.pc2.core.report.AccountsTSVReport;
import edu.csus.ecs.pc2.core.report.AccountsTSVReportTeamAndJudges;
import edu.csus.ecs.pc2.core.report.AllReports;
import edu.csus.ecs.pc2.core.report.AutoJudgingSettingsReport;
import edu.csus.ecs.pc2.core.report.BalloonDeliveryReport;
import edu.csus.ecs.pc2.core.report.BalloonSettingsReport;
import edu.csus.ecs.pc2.core.report.BalloonSummaryReport;
import edu.csus.ecs.pc2.core.report.CategoryReport;
import edu.csus.ecs.pc2.core.report.ClarificationsReport;
import edu.csus.ecs.pc2.core.report.ClientSettingsReport;
import edu.csus.ecs.pc2.core.report.ContestAnalysisReport;
import edu.csus.ecs.pc2.core.report.ContestReport;
import edu.csus.ecs.pc2.core.report.ContestSettingsReport;
import edu.csus.ecs.pc2.core.report.ContestSummaryReports;
import edu.csus.ecs.pc2.core.report.EvaluationReport;
import edu.csus.ecs.pc2.core.report.EventFeed2013Report;
import edu.csus.ecs.pc2.core.report.EventFeedReport;
import edu.csus.ecs.pc2.core.report.ExportYamlReport;
import edu.csus.ecs.pc2.core.report.ExtractPlaybackLoadFilesReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedReport;
import edu.csus.ecs.pc2.core.report.FastestSolvedSummaryReport;
import edu.csus.ecs.pc2.core.report.FinalizeReport;
import edu.csus.ecs.pc2.core.report.GroupsReport;
import edu.csus.ecs.pc2.core.report.GroupsTSVReport;
import edu.csus.ecs.pc2.core.report.HTMLReport;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.report.IReportFile;
import edu.csus.ecs.pc2.core.report.InternalDumpReport;
import edu.csus.ecs.pc2.core.report.JSON2016Report;
import edu.csus.ecs.pc2.core.report.JSONReport;
import edu.csus.ecs.pc2.core.report.JudgementNotificationsReport;
import edu.csus.ecs.pc2.core.report.JudgementReport;
import edu.csus.ecs.pc2.core.report.JudgingAnalysisReport;
import edu.csus.ecs.pc2.core.report.LanguagesReport;
import edu.csus.ecs.pc2.core.report.ListRunLanguages;
import edu.csus.ecs.pc2.core.report.LoginReport;
import edu.csus.ecs.pc2.core.report.NotificationsReport;
import edu.csus.ecs.pc2.core.report.OldRunsReport;
import edu.csus.ecs.pc2.core.report.PasswordsReport;
import edu.csus.ecs.pc2.core.report.PlaybackDumpReport;
import edu.csus.ecs.pc2.core.report.PluginsReport;
import edu.csus.ecs.pc2.core.report.ProblemsReport;
import edu.csus.ecs.pc2.core.report.ProfileCloneSettingsReport;
import edu.csus.ecs.pc2.core.report.ProfilesReport;
import edu.csus.ecs.pc2.core.report.ResolverEventFeedReport;
import edu.csus.ecs.pc2.core.report.RunJudgementNotificationsReport;
import edu.csus.ecs.pc2.core.report.RunStatisticsReport;
import edu.csus.ecs.pc2.core.report.RunsByTeamReport;
import edu.csus.ecs.pc2.core.report.RunsReport;
import edu.csus.ecs.pc2.core.report.RunsReport5;
import edu.csus.ecs.pc2.core.report.ScoreboardTSVReport;
import edu.csus.ecs.pc2.core.report.SitesReport;
import edu.csus.ecs.pc2.core.report.SolutionsByProblemReport;
import edu.csus.ecs.pc2.core.report.StandingsReport;
import edu.csus.ecs.pc2.core.report.SubmissionsTSVReport;
import edu.csus.ecs.pc2.core.report.TeamsTSVReport;
import edu.csus.ecs.pc2.core.report.UserdataTSVReport;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.util.IMemento;
import edu.csus.ecs.pc2.core.util.XMLMemento;
import edu.csus.ecs.pc2.ui.EditFilterFrame;
import edu.csus.ecs.pc2.ui.EditFilterPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ReportPane
extends JPanePlugin {
    private static final long serialVersionUID = -5165297328068331675L;
    private JPanel topPane = null;
    private JPanel buttonPane = null;
    private JPanel mainPane = null;
    private JButton viewReportButton = null;
    private JCheckBox breakdownBySiteCheckbox = null;
    private JPanel reportChoicePane = null;
    private JComboBox<String> reportsComboBox = null;
    private JLabel messageLabel = null;
    private IReport[] listOfReports;
    private Log log;
    private String reportDirectory = "reports";
    private JCheckBox thisClientFilterButton = null;
    private JPanel filterPane = null;
    private JPanel filterButtonPane = null;
    private JButton editReportFilter = null;
    private JLabel filterLabel = null;
    private Filter filter = new Filter();
    private EditFilterFrame editFilterFrame = null;
    private JCheckBox xmlOutputCheckbox = null;
    private JButton generateSummaryButton = null;

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public ReportPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(525, 291));
        this.add((Component)this.getTopPane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMainPane(), "Center");
        Vector<IReport> reports = new Vector<IReport>();
        reports.add(new AccountsReport());
        reports.add(new BalloonSummaryReport());
        reports.add(new EventFeedReport());
        reports.add(new EventFeed2013Report());
        reports.add(new NotificationsReport());
        reports.add(new AllReports());
        reports.add(new ContestSettingsReport());
        reports.add(new ContestReport());
        reports.add(new ContestAnalysisReport());
        reports.add(new SolutionsByProblemReport());
        reports.add(new ListRunLanguages());
        reports.add(new FastestSolvedSummaryReport());
        reports.add(new FastestSolvedReport());
        reports.add(new StandingsReport());
        reports.add(new LoginReport());
        reports.add(new ProfilesReport());
        reports.add(new PluginsReport());
        reports.add(new RunsReport());
        reports.add(new ClarificationsReport());
        reports.add(new ProblemsReport());
        reports.add(new LanguagesReport());
        reports.add(new JudgementReport());
        reports.add(new RunsByTeamReport());
        reports.add(new BalloonSettingsReport());
        reports.add(new ClientSettingsReport());
        reports.add(new GroupsReport());
        reports.add(new EvaluationReport());
        reports.add(new OldRunsReport());
        reports.add(new RunsReport5());
        reports.add(new AccountPermissionReport());
        reports.add(new BalloonDeliveryReport());
        reports.add(new ExtractPlaybackLoadFilesReport());
        reports.add(new RunJudgementNotificationsReport());
        reports.add(new JudgementNotificationsReport());
        reports.add(new ProfileCloneSettingsReport());
        reports.add(new SitesReport());
        reports.add(new FinalizeReport());
        reports.add(new InternalDumpReport());
        reports.add(new HTMLReport());
        reports.add(new ExportYamlReport());
        reports.add(new CategoryReport());
        reports.add(new RunStatisticsReport());
        reports.add(new PlaybackDumpReport());
        reports.add(new PasswordsReport());
        reports.add(new AccountsTSVReportTeamAndJudges());
        reports.add(new AccountsTSVReport());
        reports.add(new SubmissionsTSVReport());
        reports.add(new JSONReport());
        reports.add(new UserdataTSVReport());
        reports.add(new GroupsTSVReport());
        reports.add(new TeamsTSVReport());
        reports.add(new ScoreboardTSVReport());
        reports.add(new ResolverEventFeedReport());
        reports.add(new AutoJudgingSettingsReport());
        reports.add(new JudgingAnalysisReport());
        reports.add(new JSON2016Report());
        this.listOfReports = reports.toArray(new IReport[reports.size()]);
        Arrays.sort(this.listOfReports, new ReportNameByComparator());
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        if (this.isServer()) {
            String reportDir = this.getReportDirectory();
            this.setReportDirectory(String.valueOf(inContest.getProfile().getProfilePath()) + File.separator + reportDir);
        }
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReportPane.this.getEditFilterFrame().setContestAndController(ReportPane.this.getContest(), ReportPane.this.getController());
                ReportPane.this.refreshGUI();
                ReportPane.this.updateGUIperPermissions();
            }
        });
    }

    private void updateGUIperPermissions() {
        this.generateSummaryButton.setEnabled(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
        this.viewReportButton.setEnabled(this.isAllowed(Permission.Type.EDIT_ACCOUNT));
    }

    private boolean isServer() {
        return this.getContest().getClientId() != null && this.isServer(this.getContest().getClientId());
    }

    private boolean isServer(ClientId clientId) {
        return clientId.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    protected void refreshGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReportPane.this.refreshReportComboBox();
                ReportPane.this.showXMLCheckbox();
            }
        });
    }

    private void refreshReportComboBox() {
        this.getReportsComboBox().removeAllItems();
        IReport[] iReportArray = this.listOfReports;
        int n = this.listOfReports.length;
        int n2 = 0;
        while (n2 < n) {
            IReport report = iReportArray[n2];
            this.getReportsComboBox().addItem(report.getReportTitle());
            ++n2;
        }
        this.getReportsComboBox().setSelectedIndex(0);
    }

    @Override
    public String getPluginTitle() {
        return "Reports Pane";
    }

    private JPanel getTopPane() {
        if (this.topPane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setHorizontalAlignment(0);
            this.topPane = new JPanel();
            this.topPane.setLayout(new BorderLayout());
            this.topPane.setPreferredSize(new Dimension(30, 30));
            this.topPane.add((Component)this.messageLabel, "Center");
        }
        return this.topPane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(45);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(45, 45));
            this.buttonPane.add((Component)this.getViewReportButton(), null);
            this.buttonPane.add((Component)this.getGenerateSummaryButton(), null);
        }
        return this.buttonPane;
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            this.mainPane = new JPanel();
            this.mainPane.setLayout(null);
            this.mainPane.add((Component)this.getBreakdownBySiteCheckbox(), null);
            this.mainPane.add((Component)this.getReportChoicePane(), null);
            this.mainPane.add((Component)this.getThisClientFilterButton(), null);
            this.mainPane.add((Component)this.getFilterPane(), null);
            this.mainPane.add((Component)this.getXmlOutputCheckbox(), null);
        }
        return this.mainPane;
    }

    private JButton getViewReportButton() {
        if (this.viewReportButton == null) {
            this.viewReportButton = new JButton();
            this.viewReportButton.setText("View Report");
            this.viewReportButton.setToolTipText("View the selected Report");
            this.viewReportButton.setMnemonic(86);
            this.viewReportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ReportPane.this.getBreakdownBySiteCheckbox().isSelected()) {
                        ReportPane.this.generateSelectedReportBySite();
                    } else {
                        ReportPane.this.generateSelectedReport();
                    }
                }
            });
        }
        return this.viewReportButton;
    }

    public String getFileName(IReport selectedReport, String extension) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.SSS");
        String reportName = selectedReport.getReportTitle();
        while (reportName.indexOf(32) > -1) {
            reportName = reportName.replace(" ", "_");
        }
        return "report." + reportName + "." + simpleDateFormat.format(new Date()) + "." + extension;
    }

    private void viewFile(String filename, String title) {
        MultipleFileViewer multipleFileViewer = new MultipleFileViewer(this.log);
        multipleFileViewer.addFilePane(title, filename);
        multipleFileViewer.setTitle("PC^2 Report (Build " + new VersionInfo().getBuildNumber() + ")");
        FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
        multipleFileViewer.setVisible(true);
    }

    protected void createHeader(PrintWriter printWriter, IReport report) {
        printWriter.println(new VersionInfo().getSystemName());
        printWriter.println(new VersionInfo().getSystemVersionInfo());
        ContestInformation contestInformation = this.getContest().getContestInformation();
        String contestTitle = "(Contest title not defined)";
        if (contestInformation != null) {
            contestTitle = contestInformation.getContestTitle();
        }
        printWriter.println("Contest Title: " + contestTitle);
        printWriter.print("On: " + Utilities.getL10nDateTime());
        GregorianCalendar resumeTime = null;
        if (this.getContest() != null) {
            resumeTime = this.getContest().getContestTime().getResumeTime();
        }
        if (resumeTime == null) {
            printWriter.print("  Contest date/time: never started");
        } else {
            printWriter.print("  Contest date/time: " + resumeTime.getTime());
        }
        printWriter.println();
        Profile profile = null;
        if (this.getContest() != null) {
            profile = this.getContest().getProfile();
        }
        if (profile != null) {
            printWriter.println("Profile: " + profile.getName() + " (" + profile.getDescription() + ")");
        } else {
            printWriter.println("Profile: none defined");
        }
        printWriter.println();
        printWriter.println();
        printWriter.println("** " + report.getReportTitle() + " Report");
        printWriter.println();
        if (this.filter != null) {
            String filterInfo = this.filter.toString();
            if (this.filter.isFilterOn() && !filterInfo.equals("")) {
                printWriter.println("Filter: " + filterInfo);
                printWriter.println();
            }
        }
    }

    public void createReportFile(IReport report, boolean suppressHeaderFooter, String filename, Filter inFilter) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        this.filter = inFilter;
        try {
            if (!suppressHeaderFooter) {
                this.createHeader(printWriter, report);
            }
            try {
                if (report instanceof ExtractPlaybackLoadFilesReport) {
                    ((ExtractPlaybackLoadFilesReport)report).setReportFilename(filename);
                    ((ExtractPlaybackLoadFilesReport)report).setReportDirectory(this.getReportDirectory());
                }
                report.writeReport(printWriter);
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            if (!suppressHeaderFooter) {
                report.printFooter(printWriter);
            }
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception creating report", e);
            printWriter.println("Exception creating report " + e.getMessage());
        }
    }

    protected void generateSelectedReport() {
        try {
            try {
                FrameUtilities.waitCursor(this);
                this.showXMLCheckbox();
                IReport selectedReport = null;
                String selectedReportTitle = (String)this.getReportsComboBox().getSelectedItem();
                IReport[] iReportArray = this.listOfReports;
                int n = this.listOfReports.length;
                int n2 = 0;
                while (n2 < n) {
                    IReport report = iReportArray[n2];
                    if (selectedReportTitle.equals(report.getReportTitle())) {
                        selectedReport = report;
                    }
                    ++n2;
                }
                boolean writeXML = this.getXmlOutputCheckbox().isSelected();
                String extension = "txt";
                if (writeXML) {
                    extension = "xml";
                }
                String filename = this.getFileName(selectedReport, extension);
                File reportDirectoryFile = new File(this.getReportDirectory());
                if (reportDirectoryFile.exists()) {
                    if (reportDirectoryFile.isDirectory()) {
                        filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
                    }
                } else if (reportDirectoryFile.mkdirs()) {
                    filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
                }
                selectedReport.setContestAndController(this.getContest(), this.getController());
                selectedReport.setFilter(this.filter);
                if (writeXML) {
                    this.createXMLFile(selectedReport, filename, this.filter);
                } else {
                    boolean suppressHeaderFooter = false;
                    if (selectedReport instanceof IReportFile) {
                        IReportFile reportFile = (IReportFile)selectedReport;
                        suppressHeaderFooter = reportFile.suppressHeaderFooter();
                    }
                    this.createReportFile(selectedReport, suppressHeaderFooter, filename, this.filter);
                }
                this.viewFile(filename, selectedReport.getReportTitle());
            }
            catch (Exception e) {
                this.log.log(Log.WARNING, "Exception outputting a report ", e);
                this.showMessage("Unable to output report, check logs " + e.getMessage());
                FrameUtilities.regularCursor(this);
            }
        }
        finally {
            FrameUtilities.regularCursor(this);
        }
    }

    public String notImplementedXML(IReport report) throws IOException {
        ContestXML contestXML = new ContestXML();
        contestXML.setShowPasswords(this.getContest().isAllowed(Permission.Type.VIEW_PASSWORDS));
        XMLMemento mementoRoot = XMLMemento.createWriteRoot("contest");
        IMemento memento = mementoRoot.createChild("message");
        memento.putString("name", "Not implemented");
        memento.putString("reportName", report.getReportTitle());
        contestXML.addVersionInfo(mementoRoot, this.getContest());
        contestXML.addFileInfo(mementoRoot);
        return mementoRoot.saveToString();
    }

    private void createXMLFile(IReport report, String filename, Filter inFilter) {
        PrintWriter printWriter = null;
        this.filter = inFilter;
        try {
            printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
            try {
                String xmlString = report.createReportXML(inFilter);
                printWriter.println(xmlString);
            }
            catch (SecurityException e) {
                if (e.getMessage().equals("Not implemented")) {
                    printWriter.println(this.notImplementedXML(report));
                } else {
                    printWriter.println("Exception in report: " + e.getMessage());
                    e.printStackTrace(printWriter);
                }
            }
            catch (Exception e) {
                printWriter.println("Exception in report: " + e.getMessage());
                e.printStackTrace(printWriter);
            }
            printWriter.close();
            printWriter = null;
        }
        catch (Exception e) {
            this.log.log(Log.INFO, "Exception creating report", e);
            printWriter.println("Exception creating report " + e.getMessage());
        }
    }

    private void showXMLCheckbox() {
        this.getXmlOutputCheckbox().setVisible(true);
    }

    protected void generateSelectedReportBySite() {
        try {
            try {
                FrameUtilities.waitCursor(this);
                IReport selectedReport = null;
                String selectedReportTitle = (String)this.getReportsComboBox().getSelectedItem();
                IReport[] iReportArray = this.listOfReports;
                int n = this.listOfReports.length;
                int n2 = 0;
                while (n2 < n) {
                    IReport report = iReportArray[n2];
                    if (selectedReportTitle.equals(report.getReportTitle())) {
                        selectedReport = report;
                    }
                    ++n2;
                }
                boolean writeXML = this.getXmlOutputCheckbox().isSelected();
                String extension = "txt";
                if (writeXML) {
                    extension = "xml";
                }
                String filename = this.getFileName(selectedReport, extension);
                File reportDirectoryFile = new File(this.getReportDirectory());
                if (reportDirectoryFile.exists()) {
                    if (reportDirectoryFile.isDirectory()) {
                        filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
                    }
                } else if (reportDirectoryFile.mkdirs()) {
                    filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
                }
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
                printWriter.println();
                printWriter.println(new VersionInfo().getSystemName());
                printWriter.println("Date: " + Utilities.getL10nDateTime());
                printWriter.println(new VersionInfo().getSystemVersionInfo());
                printWriter.println();
                printWriter.println("Report " + selectedReport.getReportTitle() + " Report ");
                printWriter.println();
                selectedReport.setContestAndController(this.getContest(), this.getController());
                Site[] sites = this.getContest().getSites();
                Arrays.sort(sites, new SiteComparatorBySiteNumber());
                Site[] siteArray = sites;
                int n3 = sites.length;
                int n4 = 0;
                while (n4 < n3) {
                    Site site = siteArray[n4];
                    Filter reportFitler = new Filter();
                    try {
                        reportFitler.addSite(site);
                        selectedReport.setFilter(reportFitler);
                        printWriter.println();
                        printWriter.println("Report   " + selectedReport.getReportTitle() + " Report ");
                        printWriter.println("For site " + site.getSiteNumber() + " " + site.getDisplayName());
                        selectedReport.writeReport(printWriter);
                    }
                    catch (Exception e) {
                        printWriter.println("Exception in report: " + e.getMessage());
                        e.printStackTrace(printWriter);
                    }
                    ++n4;
                }
                printWriter.println();
                printWriter.println("end report");
                this.viewFile(filename, selectedReport.getReportTitle());
            }
            catch (Exception e) {
                this.log.log(Log.WARNING, "Exception logged ", e);
                this.showMessage("Unable to output report, check logs");
                FrameUtilities.regularCursor(this);
            }
        }
        finally {
            FrameUtilities.regularCursor(this);
        }
    }

    private void showMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReportPane.this.messageLabel.setText(string);
            }
        });
    }

    private JCheckBox getBreakdownBySiteCheckbox() {
        if (this.breakdownBySiteCheckbox == null) {
            this.breakdownBySiteCheckbox = new JCheckBox();
            this.breakdownBySiteCheckbox.setBounds(new Rectangle(21, 80, 175, 21));
            this.breakdownBySiteCheckbox.setMnemonic(83);
            this.breakdownBySiteCheckbox.setToolTipText("Break down by site");
            this.breakdownBySiteCheckbox.setText("Breakdown by site");
            this.breakdownBySiteCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportPane.this.changeSiteFiltering();
                }
            });
        }
        return this.breakdownBySiteCheckbox;
    }

    protected void changeSiteFiltering() {
    }

    private JPanel getReportChoicePane() {
        if (this.reportChoicePane == null) {
            this.reportChoicePane = new JPanel();
            this.reportChoicePane.setLayout(new BorderLayout());
            this.reportChoicePane.setBounds(new Rectangle(22, 9, 482, 53));
            this.reportChoicePane.setBorder(BorderFactory.createTitledBorder(null, "Reports", 0, 0, null, null));
            this.reportChoicePane.add(this.getReportsComboBox(), "Center");
        }
        return this.reportChoicePane;
    }

    private JComboBox<String> getReportsComboBox() {
        if (this.reportsComboBox == null) {
            this.reportsComboBox = new JComboBox();
            this.reportsComboBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        if (ReportPane.this.getBreakdownBySiteCheckbox().isSelected()) {
                            ReportPane.this.generateSelectedReportBySite();
                        } else {
                            ReportPane.this.generateSelectedReport();
                        }
                    }
                }
            });
        }
        return this.reportsComboBox;
    }

    private JCheckBox getThisClientFilterButton() {
        if (this.thisClientFilterButton == null) {
            this.thisClientFilterButton = new JCheckBox();
            this.thisClientFilterButton.setBounds(new Rectangle(21, 114, 192, 21));
            this.thisClientFilterButton.setMnemonic(67);
            this.thisClientFilterButton.setText("Filter for this client only");
            this.thisClientFilterButton.setVisible(false);
            this.thisClientFilterButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportPane.this.changeThisClientFiltering();
                }
            });
        }
        return this.thisClientFilterButton;
    }

    protected void changeThisClientFiltering() {
        if (this.thisClientFilterButton.isSelected()) {
            this.filter.clearAccountList();
        } else {
            this.filter.setFilterOn();
            this.filter.clearAccountList();
            this.filter.addAccount(this.getContest().getClientId());
        }
        this.refreshFilterLabel();
    }

    private JPanel getFilterPane() {
        if (this.filterPane == null) {
            this.filterLabel = new JLabel();
            this.filterLabel.setText("");
            this.filterLabel.setHorizontalAlignment(0);
            this.filterPane = new JPanel();
            this.filterPane.setLayout(new BorderLayout());
            this.filterPane.setBounds(new Rectangle(223, 76, 279, 128));
            this.filterPane.setBorder(BorderFactory.createTitledBorder(null, "Filter", 0, 0, null, null));
            this.filterPane.add((Component)this.getFilterButtonPane(), "South");
            this.filterPane.add((Component)this.filterLabel, "Center");
        }
        return this.filterPane;
    }

    private JPanel getFilterButtonPane() {
        if (this.filterButtonPane == null) {
            this.filterButtonPane = new JPanel();
            this.filterButtonPane.add((Component)this.getEditReportFilter(), null);
        }
        return this.filterButtonPane;
    }

    private JButton getEditReportFilter() {
        if (this.editReportFilter == null) {
            this.editReportFilter = new JButton();
            this.editReportFilter.setText("Edit Filter");
            this.editReportFilter.setMnemonic(70);
            this.editReportFilter.setToolTipText("Edit Filter");
            this.editReportFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportPane.this.showReportFilter();
                }
            });
        }
        return this.editReportFilter;
    }

    protected void showReportFilter() {
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.LANGUAGES);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.PROBLEMS);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.TEAM_ACCOUNTS);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.RUN_STATES);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.JUDGEMENTS);
        this.getEditFilterFrame().addList(EditFilterPane.ListNames.SITES);
        this.getEditFilterFrame().setFilter(this.filter);
        this.getEditFilterFrame().validate();
        this.getEditFilterFrame().setVisible(true);
    }

    public EditFilterFrame getEditFilterFrame() {
        if (this.editFilterFrame == null) {
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    ReportPane.this.refreshFilterLabel();
                }
            };
            this.editFilterFrame = new EditFilterFrame(this.filter, "Report Filter", callback);
        }
        return this.editFilterFrame;
    }

    private void refreshFilterLabel() {
        this.filterLabel.setText(this.filter.toString());
    }

    private JCheckBox getXmlOutputCheckbox() {
        if (this.xmlOutputCheckbox == null) {
            this.xmlOutputCheckbox = new JCheckBox();
            this.xmlOutputCheckbox.setBounds(new Rectangle(21, 118, 152, 21));
            this.xmlOutputCheckbox.setMnemonic(88);
            this.xmlOutputCheckbox.setText("XML Output");
        }
        return this.xmlOutputCheckbox;
    }

    private JButton getGenerateSummaryButton() {
        if (this.generateSummaryButton == null) {
            this.generateSummaryButton = new JButton();
            this.generateSummaryButton.setText("Generate Summary");
            this.generateSummaryButton.setMnemonic(71);
            this.generateSummaryButton.setToolTipText("Generate Summary Reports");
            this.generateSummaryButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReportPane.this.generateSummaryReport();
                }
            });
        }
        return this.generateSummaryButton;
    }

    protected void generateSummaryReport() {
        try {
            ContestSummaryReports contestReports = new ContestSummaryReports();
            contestReports.setContestAndController(this.getContest(), this.getController());
            contestReports.generateReports();
            System.out.println("Reports Generated to " + Utilities.getCurrentDirectory() + File.separator + contestReports.getReportDirectory());
            JOptionPane.showMessageDialog(this, "Reports Generated to " + contestReports.getReportDirectory());
        }
        catch (Exception e) {
            this.logException("Unable to produce reports", e);
            JOptionPane.showMessageDialog(this, "Unable to produce reports " + e.getMessage());
        }
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (ReportPane.this.getContest().getClientId().equals(account.getClientId())) {
                ReportPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReportPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            Account[] accountArray = accounts = accountEvent.getAccounts();
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (ReportPane.this.getContest().getClientId().equals(account.getClientId())) {
                    ReportPane.this.initializePermissions();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ReportPane.this.updateGUIperPermissions();
                        }
                    });
                }
                ++n2;
            }
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            ReportPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReportPane.this.updateGUIperPermissions();
                }
            });
        }
    }
}

