/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.HeapSorter;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IPropertyUpdater;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class PropertiesEditPane
extends JPanel {
    private static final long serialVersionUID = -8131372758010937976L;
    private JPanel buttonPane = null;
    private JButton updateButton = null;
    private JButton closeButton = null;
    private MCLB propertyListBox = null;
    private Properties originalProperties = new Properties();
    private JFrame parentFrame = null;
    private IPropertyUpdater propertyUpdater = null;

    public PropertiesEditPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(374, 180));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)((Object)this.getPropertyListBox()), "Center");
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCloseButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesEditPane.this.updateProperties(PropertiesEditPane.this.getProperties());
                }
            });
        }
        return this.updateButton;
    }

    protected void updateProperties(Properties properties) {
        this.propertyUpdater.updateProperties(properties);
        this.propertyListBox.removeAllRows();
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setText("Close");
            this.closeButton.setMnemonic(67);
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesEditPane.this.handleCancelButton();
                }
            });
        }
        return this.closeButton;
    }

    protected void handleCancelButton() {
        if (this.propertiesChanged()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Properties modified, save changes?", "Confirm Choice");
            if (result == 0) {
                this.updateProperties(this.getProperties());
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private MCLB getPropertyListBox() {
        if (this.propertyListBox == null) {
            this.propertyListBox = new MCLB();
            this.propertyListBox.setMultipleSelections(true);
            Object[] cols = new Object[]{"Property", "Value"};
            this.propertyListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            this.propertyListBox.setColumnSorter(1, sorter, 1);
            this.propertyListBox.autoSizeAllColumns();
            this.propertyListBox.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    PropertiesEditPane.this.enableButtons();
                }
            });
        }
        return this.propertyListBox;
    }

    protected void enableButtons() {
        boolean changed = this.propertiesChanged();
        this.updateButton.setEnabled(changed);
        if (changed) {
            this.closeButton.setText("Cancel");
        } else {
            this.closeButton.setText("Close");
        }
    }

    public boolean propertiesChanged() {
        return !this.originalProperties.equals(this.getProperties());
    }

    public void setProperties(final Properties properties) {
        if (properties == null) {
            throw new InvalidParameterException("Properties are null");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PropertiesEditPane.this.originalProperties = properties;
                PropertiesEditPane.this.refreshProperties();
            }
        });
    }

    protected void refreshProperties() {
        this.propertyListBox.removeAllRows();
        Set<Object> set = this.originalProperties.keySet();
        Object[] keys = set.toArray(new String[set.size()]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Object[] objects = new Object[]{key, this.createJTextField((String)this.originalProperties.get(key), false)};
            this.propertyListBox.addRow(objects);
            ++n2;
        }
        this.propertyListBox.autoSizeAllColumns();
        this.enableButtons();
    }

    public Properties getProperties() {
        Properties fieldProps = new Properties();
        int i = 0;
        while (i < this.propertyListBox.getRowCount()) {
            Object[] objects = this.propertyListBox.getRow(i);
            JTextField field = (JTextField)objects[1];
            fieldProps.put(objects[0], field.getText());
            ++i;
        }
        return fieldProps;
    }

    private JTextField createJTextField(String text, boolean passwordField) {
        JTextField textField = new JTextField();
        textField.setText(text);
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PropertiesEditPane.this.propertyListBox.autoSizeAllColumns();
                PropertiesEditPane.this.enableButtons();
            }
        });
        return textField;
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(JFrame parentFrame) {
        this.parentFrame = parentFrame;
        this.addWindowCloserListener();
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PropertiesEditPane.this.getParentFrame() != null) {
                    PropertiesEditPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            PropertiesEditPane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    public IPropertyUpdater getPropertyUpdater() {
        return this.propertyUpdater;
    }

    public void setPropertyUpdater(IPropertyUpdater propertyUpdater) {
        this.propertyUpdater = propertyUpdater;
    }
}

