/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IChangePasswordListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.PasswordChangeEvent;
import edu.csus.ecs.pc2.core.security.ISecurityMessageListener;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.SecurityMessageEvent;
import edu.csus.ecs.pc2.ui.ChangePasswordFrame;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.LogWindow;
import edu.csus.ecs.pc2.ui.PacketMonitorFrame;
import edu.csus.ecs.pc2.ui.ReportFrame;
import edu.csus.ecs.pc2.ui.SubmissionBiffFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class OptionsPane
extends JPanePlugin {
    private static final long serialVersionUID = -7331492559860531233L;
    private LogWindow securityLogWindow = null;
    private ReportFrame reportFrame;
    private PacketMonitorFrame packetMonitorFrame = null;
    private JPanel contentPane = null;
    private JButton showLogButton = null;
    private JButton showBiffWindow = null;
    private SubmissionBiffFrame submissionBiffFrame = new SubmissionBiffFrame();
    private JButton showSecurityAlertWindowButton = null;
    private JButton changePasswordButton = null;
    private ChangePasswordFrame changePasswordFrame = null;

    public OptionsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(453, 259));
        this.add((Component)this.getContentPane(), "Center");
    }

    protected void showReportFrame() {
        if (this.reportFrame == null) {
            this.reportFrame = new ReportFrame();
            this.reportFrame.setContestAndController(this.getContest(), this.getController());
        }
        FrameUtilities.setFramePosition(this.reportFrame, FrameUtilities.HorizontalPosition.RIGHT, FrameUtilities.VerticalPosition.CENTER);
        this.reportFrame.setVisible(true);
    }

    void showPacketMonitorFrame() {
        if (this.packetMonitorFrame == null) {
            this.packetMonitorFrame = new PacketMonitorFrame();
            this.packetMonitorFrame.setContestAndController(this.getContest(), this.getController());
        }
        FrameUtilities.setFramePosition(this.packetMonitorFrame, FrameUtilities.HorizontalPosition.CENTER, FrameUtilities.VerticalPosition.CENTER);
        this.packetMonitorFrame.setVisible(true);
    }

    private void updateGUIperPermissions() {
        if (this.getController().isUsingGUI()) {
            this.getShowBiffWindow().setVisible(this.isAllowed(Permission.Type.JUDGE_RUN));
            this.getShowSecurityAlertWindowButton().setVisible(this.isAllowedToViewSecurityWindow());
            this.getChangePasswordButton().setVisible(this.isAllowed(Permission.Type.CHANGE_PASSWORD));
        }
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.getContest().addChangePasswordListener(new ChangePasswordListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionsPane.this.submissionBiffFrame.setShowNoRunsTitle(true);
                OptionsPane.this.submissionBiffFrame.setFontSize(56);
                OptionsPane.this.submissionBiffFrame.setContestAndController(OptionsPane.this.getContest(), OptionsPane.this.getController());
                if (OptionsPane.this.getController().isUsingGUI()) {
                    FrameUtilities.setFramePosition(OptionsPane.this.submissionBiffFrame, FrameUtilities.HorizontalPosition.RIGHT, FrameUtilities.VerticalPosition.TOP);
                }
                OptionsPane.this.getContest().addSecurityMessageListener(new SecurityMessageListenerImplementation());
                OptionsPane.this.updateGUIperPermissions();
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Options Pane";
    }

    protected void showLog(boolean showLogWindow) {
        this.getController().showLogWindow(showLogWindow);
    }

    public void setSecurityLogWindow(LogWindow securityLogWindow) {
        this.securityLogWindow = securityLogWindow;
    }

    protected void showSecurityLog(boolean showLogWindow) {
        try {
            if (this.getController().isUsingGUI()) {
                this.securityLogWindow.setVisible(showLogWindow);
            }
        }
        catch (Exception e) {
            this.getLog().log(Log.WARNING, "Exception showing security log window", e);
        }
    }

    private JPanel getContentPane() {
        if (this.contentPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(20);
            this.contentPane = new JPanel();
            this.contentPane.setLayout(flowLayout);
            this.contentPane.add((Component)this.getShowLogButton(), null);
            this.contentPane.add((Component)this.getShowSecurityAlertWindowButton(), null);
            this.contentPane.add((Component)this.getShowBiffWindow(), null);
            this.contentPane.add((Component)this.getChangePasswordButton(), null);
            this.contentPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1 && e.isControlDown() && e.isShiftDown()) {
                        OptionsPane.this.showReportFrame();
                    } else if (e.getClickCount() > 1 && e.isControlDown()) {
                        OptionsPane.this.showPacketMonitorFrame();
                    }
                }
            });
        }
        return this.contentPane;
    }

    private JButton getShowLogButton() {
        if (this.showLogButton == null) {
            this.showLogButton = new JButton();
            this.showLogButton.setText("Show Log");
            this.showLogButton.setText("Show PC^2 Log");
            this.showLogButton.setMnemonic(76);
            this.showLogButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPane.this.showLog(true);
                }
            });
        }
        return this.showLogButton;
    }

    private JButton getShowBiffWindow() {
        if (this.showBiffWindow == null) {
            this.showBiffWindow = new JButton();
            this.showBiffWindow.setText("Show Unjudged Submissions Count");
            this.showBiffWindow.setToolTipText("Show Unjudged Submissions Count");
            this.showBiffWindow.setMnemonic(85);
            this.showBiffWindow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPane.this.showBiffWindow();
                }
            });
        }
        return this.showBiffWindow;
    }

    protected void showBiffWindow() {
        if (this.getController().isUsingGUI()) {
            this.submissionBiffFrame.setVisible(true);
        }
    }

    private JButton getShowSecurityAlertWindowButton() {
        if (this.showSecurityAlertWindowButton == null) {
            this.showSecurityAlertWindowButton = new JButton();
            this.showSecurityAlertWindowButton.setText("Show Security Alert Log");
            this.showSecurityAlertWindowButton.setToolTipText("Show Security Alert Log");
            this.showSecurityAlertWindowButton.setMnemonic(83);
            this.showSecurityAlertWindowButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPane.this.showSecurityLog(true);
                }
            });
        }
        return this.showSecurityAlertWindowButton;
    }

    protected boolean isAllowedToViewSecurityWindow() {
        return this.isAllowed(Permission.Type.VIEW_SECURITY_ALERTS) || this.isServer();
    }

    private boolean isServer() {
        return this.getContest().getClientId().getClientType().equals((Object)ClientType.Type.SERVER);
    }

    private JButton getChangePasswordButton() {
        if (this.changePasswordButton == null) {
            this.changePasswordButton = new JButton();
            this.changePasswordButton.setText("Change Password");
            this.changePasswordButton.setToolTipText("Click here to change your password");
            this.changePasswordButton.setMnemonic(80);
            this.changePasswordButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsPane.this.showChangePassword();
                }
            });
        }
        return this.changePasswordButton;
    }

    protected void showChangePassword() {
        if (this.isAllowed(Permission.Type.CHANGE_PASSWORD)) {
            if (this.changePasswordFrame == null) {
                this.changePasswordFrame = new ChangePasswordFrame();
                this.changePasswordFrame.setContestAndController(this.getContest(), this.getController());
            }
            this.changePasswordFrame.setVisible(true);
        }
    }

    protected void showPasswordMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, message);
            }
        });
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent event) {
            Account account = event.getAccount();
            if (OptionsPane.this.getContest().getClientId().equals(account.getClientId())) {
                this.updateThisClient();
            }
        }

        private void updateThisClient() {
            OptionsPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionsPane.this.updateGUIperPermissions();
                }
            });
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            Account[] accountArray = accountEvent.getAccounts();
            int n = accountArray.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (OptionsPane.this.getContest().getClientId().equals(account.getClientId())) {
                    this.updateThisClient();
                }
                ++n2;
            }
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            this.accountsModified(accountEvent);
        }
    }

    public class ChangePasswordListenerImplementation
    implements IChangePasswordListener {
        @Override
        public void passwordChanged(PasswordChangeEvent event) {
            OptionsPane.this.showPasswordMessage(event.getMessage());
        }

        @Override
        public void passwordNotChanged(PasswordChangeEvent event) {
            OptionsPane.this.showPasswordMessage(event.getMessage());
        }
    }

    protected class SecurityMessageListenerImplementation
    implements ISecurityMessageListener {
        protected SecurityMessageListenerImplementation() {
        }

        @Override
        public void newMessage(SecurityMessageEvent event) {
            if (OptionsPane.this.isAllowedToViewSecurityWindow()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionsPane.this.showSecurityLog(true);
                    }
                });
            }
        }
    }
}

