/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.JudgementNotification;
import edu.csus.ecs.pc2.core.model.NotificationSetting;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.NotificationsPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.PrintStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class NotificationSettingPaneByClient
extends JPanePlugin {
    private static final long serialVersionUID = -2435063240993379856L;
    private JPanel buttonPane = null;
    private JPanel mainPane = null;
    private JButton addButton = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private boolean populatingGUI = true;
    private NotificationSetting notificationSetting;
    private JPanel preliminaryPane = null;
    private JPanel finalPane = null;
    private JCheckBox yesPrelimCheckBox = null;
    private JCheckBox noPrelimCheckBox = null;
    private JLabel yesPrelimCuttoffLabel = null;
    private JTextField yesPrelimCuttoffMinutesTextField = null;
    private JTextField noPrelimCuttoffMinutesTextField = null;
    private JLabel yesPrelimCutoffLabel = null;
    private JLabel prelimYesMinLabel = null;
    private JLabel prelimNoMinLabel = null;
    private JCheckBox yesFinalCheckBox = null;
    private JCheckBox noFinalCheckBox = null;
    private JLabel yesFinalCutoffLabel = null;
    private JLabel noFinalCutoffLabel = null;
    private JLabel finalYesMinLabel = null;
    private JLabel finalNoMinLabel = null;
    private JTextField yesFinalCuttoffMinutesTextField = null;
    private JTextField noFinalCuttoffMinutesTextField = null;
    private ClientId clientId = null;

    public NotificationSettingPaneByClient() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(526, 225));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMainPane(), "Center");
    }

    @Override
    public String getPluginTitle() {
        return "Edit Notification Setting";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(35);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private JPanel getMainPane() {
        if (this.mainPane == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setColumns(1);
            this.mainPane = new JPanel();
            this.mainPane.setLayout(gridLayout);
            this.mainPane.add((Component)this.getPreliminaryPane(), null);
            this.mainPane.add((Component)this.getFinalPane(), null);
        }
        return this.mainPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationSettingPaneByClient.this.addNotificationSetting();
                }
            });
        }
        return this.addButton;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationSettingPaneByClient.this.updateNotificationSetting();
                }
            });
        }
        return this.updateButton;
    }

    protected void addNotificationSetting() {
        NotificationSetting newNotificationSetting = this.getNotificationSettingsFromFields();
        ClientSettings clientSettings = this.getContest().getClientSettings(this.clientId);
        if (clientSettings == null) {
            clientSettings = new ClientSettings(this.clientId);
            clientSettings.setNotificationSetting(newNotificationSetting);
            this.getController().addNewClientSettings(clientSettings);
        } else {
            clientSettings.setNotificationSetting(newNotificationSetting);
            this.getController().updateClientSettings(clientSettings);
        }
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    protected void updateNotificationSetting() {
        NotificationSetting newNotificationSetting = this.getNotificationSettingsFromFields();
        ClientSettings clientSettings = this.getContest().getClientSettings(this.clientId);
        clientSettings.setNotificationSetting(newNotificationSetting);
        this.getController().updateClientSettings(clientSettings);
        this.cancelButton.setText("Close");
        this.addButton.setEnabled(false);
        this.updateButton.setEnabled(false);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationSettingPaneByClient.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    public void setNotificationSetting(final NotificationSetting notificationSetting) {
        this.notificationSetting = notificationSetting;
        this.clientId = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationSettingPaneByClient.this.getAddButton().setVisible(false);
                NotificationSettingPaneByClient.this.getUpdateButton().setVisible(true);
                NotificationSettingPaneByClient.this.getAddButton().setEnabled(false);
                NotificationSettingPaneByClient.this.getUpdateButton().setEnabled(false);
                NotificationSettingPaneByClient.this.populateGUI(notificationSetting);
                NotificationSettingPaneByClient.this.enableUpdateButtons(false);
            }
        });
    }

    private void populateGUI(NotificationSetting notificationSetting2) {
        this.populatingGUI = true;
        if (this.getParentFrame() != null) {
            this.getParentFrame().setTitle("Edit Notification Setting for " + NotificationsPane.getClientTitle(this.clientId));
        }
        if (notificationSetting2 != null) {
            JudgementNotification judgementNotification = notificationSetting2.getPreliminaryNotificationYes();
            this.getYesPrelimCheckBox().setSelected(judgementNotification.isNotificationSupressed());
            this.getYesPrelimCuttoffMinutesTextField().setText("" + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getPreliminaryNotificationNo();
            this.getNoPrelimCheckBox().setSelected(judgementNotification.isNotificationSupressed());
            this.getNoPrelimCuttoffMinutesTextField().setText("" + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getFinalNotificationYes();
            this.getYesFinalCheckBox().setSelected(judgementNotification.isNotificationSupressed());
            this.getYesFinalCuttoffMinutesTextField().setText("" + judgementNotification.getCuttoffMinutes());
            judgementNotification = notificationSetting2.getFinalNotificationNo();
            this.getNoFinalCheckBox().setSelected(judgementNotification.isNotificationSupressed());
            this.getNoFinalCuttoffMinutesTextField().setText("" + judgementNotification.getCuttoffMinutes());
            this.getAddButton().setVisible(false);
            this.getUpdateButton().setVisible(true);
        } else {
            JudgementNotification judgementNotification = new JudgementNotification(false, 0);
            this.getYesPrelimCheckBox().setSelected(judgementNotification.isNotificationSupressed());
            this.getYesPrelimCuttoffMinutesTextField().setText("" + judgementNotification.getCuttoffMinutes());
            this.getNoPrelimCheckBox().setSelected(judgementNotification.isNotificationSupressed());
            this.getNoPrelimCuttoffMinutesTextField().setText("" + judgementNotification.getCuttoffMinutes());
            this.getYesFinalCheckBox().setSelected(judgementNotification.isNotificationSupressed());
            this.getYesFinalCuttoffMinutesTextField().setText("" + judgementNotification.getCuttoffMinutes());
            this.getNoFinalCheckBox().setSelected(judgementNotification.isNotificationSupressed());
            this.getNoFinalCuttoffMinutesTextField().setText("" + judgementNotification.getCuttoffMinutes());
            this.getAddButton().setVisible(true);
            this.getUpdateButton().setVisible(false);
        }
        this.populatingGUI = false;
    }

    protected void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        if (this.getUpdateButton().isVisible()) {
            this.getUpdateButton().setEnabled(editedText);
        } else {
            this.getAddButton().setEnabled(editedText);
        }
    }

    private JPanel getPreliminaryPane() {
        if (this.preliminaryPane == null) {
            this.prelimNoMinLabel = new JLabel();
            this.prelimNoMinLabel.setBounds(new Rectangle(297, 52, 213, 22));
            this.prelimNoMinLabel.setText("minutes before end of contest");
            this.prelimYesMinLabel = new JLabel();
            this.prelimYesMinLabel.setBounds(new Rectangle(297, 21, 213, 22));
            this.prelimYesMinLabel.setText("minutes before end of contest");
            this.yesPrelimCutoffLabel = new JLabel();
            this.yesPrelimCutoffLabel.setBounds(new Rectangle(139, 52, 96, 22));
            this.yesPrelimCutoffLabel.setHorizontalAlignment(4);
            this.yesPrelimCutoffLabel.setText("Cutoff Time");
            this.yesPrelimCuttoffLabel = new JLabel();
            this.yesPrelimCuttoffLabel.setBounds(new Rectangle(139, 21, 96, 22));
            this.yesPrelimCuttoffLabel.setHorizontalAlignment(4);
            this.yesPrelimCuttoffLabel.setText("Cutoff Time");
            this.preliminaryPane = new JPanel();
            this.preliminaryPane.setLayout(null);
            this.preliminaryPane.setBorder(BorderFactory.createTitledBorder(null, "Preliminary Judgements", 0, 0, null, null));
            this.preliminaryPane.add((Component)this.getYesPrelimCheckBox(), null);
            this.preliminaryPane.add((Component)this.getNoPrelimCheckBox(), null);
            this.preliminaryPane.add((Component)this.yesPrelimCuttoffLabel, null);
            this.preliminaryPane.add((Component)this.getYesPrelimCuttoffMinutesTextField(), null);
            this.preliminaryPane.add((Component)this.getNoPrelimCuttoffMinutesTextField(), null);
            this.preliminaryPane.add((Component)this.yesPrelimCutoffLabel, null);
            this.preliminaryPane.add((Component)this.prelimYesMinLabel, null);
            this.preliminaryPane.add((Component)this.prelimNoMinLabel, null);
        }
        return this.preliminaryPane;
    }

    private JPanel getFinalPane() {
        if (this.finalPane == null) {
            this.finalNoMinLabel = new JLabel();
            this.finalNoMinLabel.setText("minutes before end of contest");
            this.finalNoMinLabel.setSize(new Dimension(213, 22));
            this.finalNoMinLabel.setLocation(new Point(297, 52));
            this.finalYesMinLabel = new JLabel();
            this.finalYesMinLabel.setText("minutes before end of contest");
            this.finalYesMinLabel.setSize(new Dimension(213, 22));
            this.finalYesMinLabel.setLocation(new Point(297, 22));
            this.noFinalCutoffLabel = new JLabel();
            this.noFinalCutoffLabel.setText("Cutoff Time");
            this.noFinalCutoffLabel.setSize(new Dimension(96, 22));
            this.noFinalCutoffLabel.setHorizontalAlignment(4);
            this.noFinalCutoffLabel.setLocation(new Point(139, 52));
            this.yesFinalCutoffLabel = new JLabel();
            this.yesFinalCutoffLabel.setText("Cutoff Time");
            this.yesFinalCutoffLabel.setSize(new Dimension(96, 22));
            this.yesFinalCutoffLabel.setHorizontalAlignment(4);
            this.yesFinalCutoffLabel.setLocation(new Point(139, 22));
            this.finalPane = new JPanel();
            this.finalPane.setLayout(null);
            this.finalPane.setBorder(BorderFactory.createTitledBorder(null, "Final Judgements", 0, 0, null, null));
            this.finalPane.add((Component)this.getYesFinalCheckBox(), null);
            this.finalPane.add((Component)this.getNoFinalCheckBox(), null);
            this.finalPane.add((Component)this.yesFinalCutoffLabel, null);
            this.finalPane.add((Component)this.noFinalCutoffLabel, null);
            this.finalPane.add((Component)this.finalYesMinLabel, null);
            this.finalPane.add((Component)this.finalNoMinLabel, null);
            this.finalPane.add((Component)this.getYesFinalCuttoffMinutesTextField(), null);
            this.finalPane.add((Component)this.getNoFinalCuttoffMinutesTextField(), null);
        }
        return this.finalPane;
    }

    private JCheckBox getYesPrelimCheckBox() {
        if (this.yesPrelimCheckBox == null) {
            this.yesPrelimCheckBox = new JCheckBox();
            this.yesPrelimCheckBox.setBounds(new Rectangle(17, 21, 117, 22));
            this.yesPrelimCheckBox.setText("Send Yes");
            this.yesPrelimCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationSettingPaneByClient.this.enableUpdateButton();
                }
            });
        }
        return this.yesPrelimCheckBox;
    }

    private JCheckBox getNoPrelimCheckBox() {
        if (this.noPrelimCheckBox == null) {
            this.noPrelimCheckBox = new JCheckBox();
            this.noPrelimCheckBox.setText("Send No");
            this.noPrelimCheckBox.setSize(new Dimension(117, 22));
            this.noPrelimCheckBox.setLocation(new Point(17, 52));
            this.noPrelimCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationSettingPaneByClient.this.enableUpdateButton();
                }
            });
        }
        return this.noPrelimCheckBox;
    }

    private JTextField getYesPrelimCuttoffMinutesTextField() {
        if (this.yesPrelimCuttoffMinutesTextField == null) {
            this.yesPrelimCuttoffMinutesTextField = new JTextField();
            this.yesPrelimCuttoffMinutesTextField.setBounds(new Rectangle(246, 22, 45, 21));
            this.yesPrelimCuttoffMinutesTextField.setDocument(new IntegerDocument());
            this.yesPrelimCuttoffMinutesTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    NotificationSettingPaneByClient.this.enableUpdateButton();
                }
            });
        }
        return this.yesPrelimCuttoffMinutesTextField;
    }

    private JTextField getNoPrelimCuttoffMinutesTextField() {
        if (this.noPrelimCuttoffMinutesTextField == null) {
            this.noPrelimCuttoffMinutesTextField = new JTextField();
            this.noPrelimCuttoffMinutesTextField.setBounds(new Rectangle(246, 52, 45, 23));
            this.noPrelimCuttoffMinutesTextField.setDocument(new IntegerDocument());
            this.noPrelimCuttoffMinutesTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    NotificationSettingPaneByClient.this.enableUpdateButton();
                }
            });
        }
        return this.noPrelimCuttoffMinutesTextField;
    }

    private JCheckBox getYesFinalCheckBox() {
        if (this.yesFinalCheckBox == null) {
            this.yesFinalCheckBox = new JCheckBox();
            this.yesFinalCheckBox.setText("Send Yes");
            this.yesFinalCheckBox.setLocation(new Point(17, 22));
            this.yesFinalCheckBox.setSize(new Dimension(117, 22));
            this.yesFinalCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationSettingPaneByClient.this.enableUpdateButton();
                }
            });
        }
        return this.yesFinalCheckBox;
    }

    private JCheckBox getNoFinalCheckBox() {
        if (this.noFinalCheckBox == null) {
            this.noFinalCheckBox = new JCheckBox();
            this.noFinalCheckBox.setText("Send No");
            this.noFinalCheckBox.setLocation(new Point(17, 52));
            this.noFinalCheckBox.setSize(new Dimension(117, 22));
            this.noFinalCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationSettingPaneByClient.this.enableUpdateButton();
                }
            });
        }
        return this.noFinalCheckBox;
    }

    private JTextField getYesFinalCuttoffMinutesTextField() {
        if (this.yesFinalCuttoffMinutesTextField == null) {
            this.yesFinalCuttoffMinutesTextField = new JTextField();
            this.yesFinalCuttoffMinutesTextField.setLocation(new Point(246, 23));
            this.yesFinalCuttoffMinutesTextField.setSize(new Dimension(45, 21));
            this.yesFinalCuttoffMinutesTextField.setDocument(new IntegerDocument());
            this.yesFinalCuttoffMinutesTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    NotificationSettingPaneByClient.this.enableUpdateButton();
                }
            });
        }
        return this.yesFinalCuttoffMinutesTextField;
    }

    private JTextField getNoFinalCuttoffMinutesTextField() {
        if (this.noFinalCuttoffMinutesTextField == null) {
            this.noFinalCuttoffMinutesTextField = new JTextField();
            this.noFinalCuttoffMinutesTextField.setLocation(new Point(246, 53));
            this.noFinalCuttoffMinutesTextField.setPreferredSize(new Dimension(4, 20));
            this.noFinalCuttoffMinutesTextField.setSize(new Dimension(45, 21));
            this.noFinalCuttoffMinutesTextField.setDocument(new IntegerDocument());
            this.noFinalCuttoffMinutesTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    NotificationSettingPaneByClient.this.enableUpdateButton();
                }
            });
        }
        return this.noFinalCuttoffMinutesTextField;
    }

    protected void handleCancelButton() {
        if (this.getAddButton().isEnabled() || this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Notification Settings modified, save changes?", "Confirm Choice");
            if (result == 0) {
                if (this.getAddButton().isEnabled()) {
                    this.addNotificationSetting();
                } else {
                    this.updateNotificationSetting();
                }
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            } else if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private NotificationSetting getNotificationSettingsFromFields() {
        return null;
    }

    private void dumpNotification(PrintStream out, String message, NotificationSetting notificationSetting2) {
        System.out.println();
        System.out.println(message);
        JudgementNotification judgementNotification = null;
        judgementNotification = notificationSetting2.getPreliminaryNotificationYes();
        System.out.println(" Prelim Yes send " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
        judgementNotification = notificationSetting2.getPreliminaryNotificationNo();
        System.out.println(" Prelim No  send " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
        judgementNotification = notificationSetting2.getFinalNotificationYes();
        System.out.println(" Final  Yes send " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
        judgementNotification = notificationSetting2.getFinalNotificationNo();
        System.out.println(" Final  No  send " + judgementNotification.isNotificationSupressed() + " cuttoff at " + judgementNotification.getCuttoffMinutes());
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public void setClientId(ClientId clientId) {
        this.clientId = clientId;
        this.notificationSetting = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationSettingPaneByClient.this.getAddButton().setVisible(true);
                NotificationSettingPaneByClient.this.getUpdateButton().setVisible(false);
                NotificationSettingPaneByClient.this.getAddButton().setEnabled(false);
                NotificationSettingPaneByClient.this.getUpdateButton().setEnabled(false);
                NotificationSettingPaneByClient.this.populateGUI(null);
                NotificationSettingPaneByClient.this.enableUpdateButtons(false);
            }
        });
    }

    public void enableUpdateButton() {
        NotificationSetting checkNotificationSetting;
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        enableButton = this.notificationSetting != null ? !(checkNotificationSetting = this.getNotificationSettingsFromFields()).isSameAs(this.notificationSetting) : true;
        this.enableUpdateButtons(enableButton);
    }
}

