/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.ui.EditProblemPane;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.TestCaseTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MultipleDataSetPaneNew
extends JPanePlugin {
    private static final long serialVersionUID = -5975163495479418935L;
    private JPanel listBoxScrollPaneHolderPanel = null;
    private TestCaseTableModel tableModel = new TestCaseTableModel();
    private JScrollPane testDataSetsListBoxScrollPane = null;
    private ProblemDataFiles problemDataFiles;
    private JButton btnDelete;
    private JButton btnImportFromCDP;
    private JButton btnLoad;
    private EditProblemPane editProblemPane = null;
    private Problem problem;
    private JTable testDataSetsListBox;
    private JPanel problemDataFilesPanel;
    private JPanel inputDataStoragePanel;
    private JRadioButton radioButtonCopyFilesIntoPC2;
    private JRadioButton radioButtonKeepDataFilesExternal;
    private JPanel teamReadsFromPanel;
    private JRadioButton radioButtonStdIn;
    private JRadioButton radioButtonFileInput;
    private JLabel labelTeamFileName;
    private JTextField textFieldteamFileName;
    private JCheckBox checkBoxJudgesHaveProvidedAnswerFiles;
    private JCheckBox checkBoxProblemRequiresInputData;
    private JPanel dataFilesButtonPanel;
    private JButton btnAddButton;
    private JLabel lblDataSetOperations;

    public MultipleDataSetPaneNew() {
        this.setPreferredSize(new Dimension(800, 600));
        this.setAlignmentX(0.5f);
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(800, 460));
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getListBoxScrollPaneHolderPanel());
        this.add(this.getDataFilesButtonPanel());
    }

    private JPanel getDataFilesButtonPanel() {
        if (this.dataFilesButtonPanel == null) {
            this.dataFilesButtonPanel = new JPanel();
            FlowLayout flowLayout = (FlowLayout)this.dataFilesButtonPanel.getLayout();
            flowLayout.setHgap(35);
            this.dataFilesButtonPanel.setPreferredSize(new Dimension(35, 35));
            this.dataFilesButtonPanel.add(this.getLblDataSetOperations());
            this.dataFilesButtonPanel.add(this.getBtnAddButton());
            JButton btnEditButton = new JButton("Edit");
            btnEditButton.setToolTipText("Edit the selected problem data set");
            this.dataFilesButtonPanel.add(btnEditButton);
            this.dataFilesButtonPanel.add(this.getBtnDelete());
            this.dataFilesButtonPanel.add(this.getBtnLoad());
            this.dataFilesButtonPanel.add(this.getBtnImportFromCDP());
        }
        return this.dataFilesButtonPanel;
    }

    @Override
    public String getPluginTitle() {
        return "Mulitple Data Set Pane";
    }

    public void setProblemDataFiles(Problem aProblem, ProblemDataFiles aProblemDataFiles) throws CloneNotSupportedException {
        this.problem = aProblem;
        if (aProblem != null) {
            this.setProblemDataFiles(aProblemDataFiles.copy(aProblem));
        } else {
            this.clearDataFiles();
        }
    }

    public void setProblemDataFiles(ProblemDataFiles datafiles) {
        this.problemDataFiles = datafiles;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultipleDataSetPaneNew.this.populateUI();
            }
        });
    }

    protected void populateUI() {
        this.tableModel.setFiles(this.problemDataFiles);
        this.tableModel.fireTableDataChanged();
        this.resizeColumnWidth(this.getTestDataSetsListBox());
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        int column = 0;
        while (column < table.getColumnCount()) {
            int width = 50;
            int row = 0;
            while (row < table.getRowCount()) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component comp = table.prepareRenderer(renderer, row, column);
                width = Math.max(comp.getPreferredSize().width + 1, width);
                ++row;
            }
            columnModel.getColumn(column).setPreferredWidth(width);
            ++column;
        }
    }

    private void dump(ProblemDataFiles problemDataFiles2, String string) {
        Utilities.dump(problemDataFiles2, string);
    }

    private JPanel getListBoxScrollPaneHolderPanel() {
        if (this.listBoxScrollPaneHolderPanel == null) {
            this.listBoxScrollPaneHolderPanel = new JPanel();
            this.listBoxScrollPaneHolderPanel.setBorder(new LineBorder(new Color(255, 0, 0), 1, true));
            this.listBoxScrollPaneHolderPanel.setLayout(new BorderLayout());
            this.listBoxScrollPaneHolderPanel.add((Component)this.getTestDataSetsListBoxScrollPane(), "Center");
        }
        return this.listBoxScrollPaneHolderPanel;
    }

    private JScrollPane getTestDataSetsListBoxScrollPane() {
        if (this.testDataSetsListBoxScrollPane == null) {
            this.testDataSetsListBoxScrollPane = new JScrollPane();
            this.testDataSetsListBoxScrollPane.add(this.getTestDataSetsListBox());
            this.testDataSetsListBoxScrollPane.setViewportView(this.getTestDataSetsListBox());
            this.getTestDataSetsListBox().getTableHeader().setFont(new Font("Dialog", 1, 12));
            TableColumn column = null;
            int i = 0;
            while (i < this.getTestDataSetsListBox().getColumnCount()) {
                column = this.getTestDataSetsListBox().getColumnModel().getColumn(i);
                switch (column.getModelIndex()) {
                    case 0: {
                        column.setPreferredWidth(20);
                    }
                }
                column.setPreferredWidth((int)((this.testDataSetsListBox.getSize().getWidth() - 20.0) / (double)this.getTestDataSetsListBox().getColumnCount() - 1.0));
                ++i;
            }
        }
        return this.testDataSetsListBoxScrollPane;
    }

    public JTable getTestDataSetsListBox() {
        if (this.testDataSetsListBox == null) {
            this.testDataSetsListBox = new JTable(this.tableModel);
        }
        return this.testDataSetsListBox;
    }

    public ProblemDataFiles getProblemDataFiles() {
        this.dump(this.tableModel.getFiles(), "populateUI debug 22 C");
        return this.tableModel.getFiles();
    }

    public void clearDataFiles() {
        this.problemDataFiles = null;
        this.tableModel.setFiles(null);
        this.tableModel.fireTableDataChanged();
    }

    boolean hasChanged(ProblemDataFiles originalFiles) {
        if (originalFiles == null && this.problemDataFiles == null) {
            return true;
        }
        if (originalFiles == null || this.problemDataFiles == null) {
            return false;
        }
        int comp = this.compare(originalFiles.getJudgesDataFiles(), this.problemDataFiles.getJudgesDataFiles());
        if (comp != 0) {
            return false;
        }
        comp = this.compare(originalFiles.getJudgesAnswerFiles(), this.problemDataFiles.getJudgesAnswerFiles());
        if (comp != 0) {
            return false;
        }
        System.out.println("debug 22 Are problemId's identical ?" + this.problemDataFiles.getProblemId().equals(originalFiles.getProblemId()));
        return true;
    }

    private int compare(SerializedFile[] listOne, SerializedFile[] listTwo) {
        if (listOne == null || listTwo == null) {
            return 2;
        }
        if (listOne.length != listTwo.length) {
            return listTwo.length - listOne.length;
        }
        int i = 0;
        while (i < listTwo.length) {
            if (!listOne[i].equals(listTwo[i])) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton("Delete");
            this.btnDelete.setToolTipText("Delete selected data sets");
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int rowNumber = MultipleDataSetPaneNew.this.testDataSetsListBox.getSelectedRow();
                    if (rowNumber != -1) {
                        MultipleDataSetPaneNew.this.removeRow(rowNumber);
                    }
                }
            });
        }
        return this.btnDelete;
    }

    protected void removeRow(int rowNumber) {
        if (this.tableModel.getRowCount() == 1) {
            this.editProblemPane.setJudgingTestSetOne(this.tableModel.getFiles());
        }
        this.tableModel.removeRow(rowNumber);
    }

    private JButton getBtnImportFromCDP() {
        if (this.btnImportFromCDP == null) {
            this.btnImportFromCDP = new JButton("Import From CDP");
            this.btnImportFromCDP.setToolTipText("Refresh/Reload data sets from an ICPC Contest Data Package (CDP); see https://clics.ecs.baylor.edu/index.php/CDP");
            this.btnImportFromCDP.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultipleDataSetPaneNew.this.reloadDataFiles();
                }
            });
        }
        return this.btnImportFromCDP;
    }

    protected void loadDataFiles() {
        String baseDirectoryName = "workspace";
        String shortProblemName = this.getEditProblemPane().getShortNameTextfield().getText();
        if (shortProblemName == null || shortProblemName.trim().length() == 0) {
            this.showMessage(this, "Must enter short problem name to load", "Enter short problems name (on General tab)");
            return;
        }
        boolean externalFiles = false;
        if (this.problem != null) {
            externalFiles = this.problem.isUsingExternalDataFiles();
        } else {
            this.problem = new Problem(shortProblemName);
        }
        String secretDirPath = Utilities.getSecretDataPath(baseDirectoryName, shortProblemName);
        String[] inputFileNames = Utilities.getFileNames(secretDirPath, ".ans");
        if (inputFileNames.length == 0) {
            System.out.println("debug 22 No .ans files found in " + secretDirPath);
            this.showMessage(this, "No answer files found", "No .ans files found in " + secretDirPath);
            return;
        }
        this.dump(this.problemDataFiles, "debug 22 before load");
        this.problemDataFiles = this.loadDataFiles(this.problem, this.problemDataFiles, secretDirPath, ".in", ".ans", externalFiles);
        this.dump(this.problemDataFiles, "debug 22 after load");
        this.populateUI();
        this.editProblemPane.setJudgingTestSetOne(this.tableModel.getFiles());
        this.getEditProblemPane().enableUpdateButton();
    }

    private JButton getBtnLoad() {
        if (this.btnLoad == null) {
            this.btnLoad = new JButton("Load From Folder");
            this.btnLoad.setToolTipText("Load data sets from directory");
            this.btnLoad.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MultipleDataSetPaneNew.this.loadDataFiles();
                }
            });
        }
        return this.btnLoad;
    }

    protected void reloadDataFiles() {
        this.showMessage(this, "Not implemented Yet", "reloadDataFiles not implemented, yet");
        this.editProblemPane.setJudgingTestSetOne(this.tableModel.getFiles());
    }

    public void setParentPane(EditProblemPane pane) {
        this.editProblemPane = pane;
    }

    public ProblemDataFiles loadDataFiles(Problem aProblem, ProblemDataFiles files, String dataFileBaseDirectory, String dataExtension, String answerExtension, boolean externalDataFiles) {
        if (files == null) {
            files = new ProblemDataFiles(aProblem);
        } else if (aProblem != null && !files.getProblemId().equals(aProblem.getElementId())) {
            throw new RuntimeException("problem and data files are not for the same problem " + aProblem.getElementId() + " vs " + files.getProblemId());
        }
        String[] inputFileNames = Utilities.getFileNames(dataFileBaseDirectory, dataExtension);
        String[] answerFileNames = Utilities.getFileNames(dataFileBaseDirectory, answerExtension);
        if (inputFileNames.length == 0) {
            throw new RuntimeException("No input files with extension " + dataExtension + " in " + dataFileBaseDirectory);
        }
        if (answerFileNames.length == 0) {
            throw new RuntimeException("No answer  files with extension " + answerExtension + " in " + dataFileBaseDirectory);
        }
        if (answerFileNames.length != inputFileNames.length) {
            throw new RuntimeException("Miss match expecting same " + dataExtension + " and " + answerExtension + " files (" + inputFileNames.length + " vs " + answerFileNames.length);
        }
        SerializedFile[] inputFiles = Utilities.createSerializedFiles(dataFileBaseDirectory, inputFileNames, externalDataFiles);
        SerializedFile[] answertFiles = Utilities.createSerializedFiles(dataFileBaseDirectory, answerFileNames, externalDataFiles);
        files.setJudgesDataFiles(inputFiles);
        files.setJudgesAnswerFiles(answertFiles);
        return files;
    }

    public EditProblemPane getEditProblemPane() {
        return this.editProblemPane;
    }

    private JPanel getProblemDataFilesPanel() {
        if (this.problemDataFilesPanel == null) {
            this.problemDataFilesPanel = new JPanel();
            this.problemDataFilesPanel.setPreferredSize(new Dimension(700, 300));
            this.problemDataFilesPanel.setMinimumSize(new Dimension(700, 300));
            this.problemDataFilesPanel.setMaximumSize(new Dimension(700, 300));
            this.problemDataFilesPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Problem Data Files", 4, 2, new Font("Dialog", 1, 12), null));
            this.problemDataFilesPanel.setAlignmentX(0.5f);
            GroupLayout gl_problemDataFilesPanel = new GroupLayout(this.problemDataFilesPanel);
            gl_problemDataFilesPanel.setHorizontalGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_problemDataFilesPanel.createSequentialGroup().addGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(gl_problemDataFilesPanel.createSequentialGroup().addContainerGap().addGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getCheckBoxJudgesHaveProvidedAnswerFiles()).addComponent(this.getCheckBoxProblemRequiresInputData(), -2, -1, -2))).addGroup(gl_problemDataFilesPanel.createSequentialGroup().addGap(30).addGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getTeamReadsFromPanel(), 0, 0, Short.MAX_VALUE).addComponent(this.getInputDataStoragePanel(), -2, 600, -2)))).addContainerGap()));
            gl_problemDataFilesPanel.setVerticalGroup(gl_problemDataFilesPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_problemDataFilesPanel.createSequentialGroup().addContainerGap().addComponent(this.getCheckBoxProblemRequiresInputData(), -2, -1, -2).addGap(9).addComponent(this.getTeamReadsFromPanel(), -2, -1, -2).addGap(18).addComponent(this.getInputDataStoragePanel(), -2, 93, -2).addGap(18).addComponent(this.getCheckBoxJudgesHaveProvidedAnswerFiles()).addContainerGap(23, Short.MAX_VALUE)));
            this.problemDataFilesPanel.setLayout(gl_problemDataFilesPanel);
            this.problemDataFilesPanel.add(this.getCheckBoxProblemRequiresInputData());
            this.problemDataFilesPanel.add(this.getTeamReadsFromPanel());
            this.problemDataFilesPanel.add(this.getInputDataStoragePanel());
            this.problemDataFilesPanel.add(this.getCheckBoxJudgesHaveProvidedAnswerFiles());
        }
        return this.problemDataFilesPanel;
    }

    private JPanel getInputDataStoragePanel() {
        if (this.inputDataStoragePanel == null) {
            this.inputDataStoragePanel = new JPanel();
            this.inputDataStoragePanel.setPreferredSize(new Dimension(470, 80));
            this.inputDataStoragePanel.setMaximumSize(new Dimension(500, 200));
            this.inputDataStoragePanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Input Data Storage", 4, 2, new Font("Dialog", 1, 12), new Color(0, 0, 0)));
            this.inputDataStoragePanel.setAlignmentX(0.0f);
            this.inputDataStoragePanel.setLayout(new BoxLayout(this.inputDataStoragePanel, 1));
            this.inputDataStoragePanel.add(this.getRadioButtonCopyFilesIntoPC2());
            this.inputDataStoragePanel.add(this.getRadioButtonKeepDataFilesExternal());
        }
        return this.inputDataStoragePanel;
    }

    private JRadioButton getRadioButtonCopyFilesIntoPC2() {
        if (this.radioButtonCopyFilesIntoPC2 == null) {
            this.radioButtonCopyFilesIntoPC2 = new JRadioButton("Copy Data Files into PC2 (more efficient, but limited to 5MB total per problem)");
            this.radioButtonCopyFilesIntoPC2.setSelected(true);
            this.radioButtonCopyFilesIntoPC2.setPreferredSize(new Dimension(550, 30));
            this.radioButtonCopyFilesIntoPC2.setMinimumSize(new Dimension(550, 30));
            this.radioButtonCopyFilesIntoPC2.setMaximumSize(new Dimension(550, 30));
            this.radioButtonCopyFilesIntoPC2.setBorder(new EmptyBorder(0, 15, 0, 0));
        }
        return this.radioButtonCopyFilesIntoPC2;
    }

    private JRadioButton getRadioButtonKeepDataFilesExternal() {
        if (this.radioButtonKeepDataFilesExternal == null) {
            this.radioButtonKeepDataFilesExternal = new JRadioButton("Keep Data Files external to PC2 (requires you to copy files to Judge's machines)");
            this.radioButtonKeepDataFilesExternal.setPreferredSize(new Dimension(550, 30));
            this.radioButtonKeepDataFilesExternal.setMinimumSize(new Dimension(550, 30));
            this.radioButtonKeepDataFilesExternal.setMaximumSize(new Dimension(550, 30));
            this.radioButtonKeepDataFilesExternal.setBorder(new EmptyBorder(0, 15, 0, 0));
        }
        return this.radioButtonKeepDataFilesExternal;
    }

    private JPanel getTeamReadsFromPanel() {
        if (this.teamReadsFromPanel == null) {
            FlowLayout fl_teamReadsFromPanel = new FlowLayout();
            fl_teamReadsFromPanel.setAlignment(0);
            fl_teamReadsFromPanel.setHgap(20);
            fl_teamReadsFromPanel.setVgap(0);
            this.teamReadsFromPanel = new JPanel();
            this.teamReadsFromPanel.setMinimumSize(new Dimension(500, 50));
            this.teamReadsFromPanel.setPreferredSize(new Dimension(500, 50));
            this.teamReadsFromPanel.setMaximumSize(new Dimension(500, 50));
            this.teamReadsFromPanel.setAlignmentX(1.0f);
            this.teamReadsFromPanel.setLayout(fl_teamReadsFromPanel);
            this.teamReadsFromPanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Team Reads From", 4, 2, new Font("Dialog", 1, 12), new Color(0, 0, 0)));
            this.teamReadsFromPanel.add((Component)this.getRadioButtonStdIn(), null);
            Component verticalStrut = Box.createVerticalStrut(20);
            this.teamReadsFromPanel.add(verticalStrut);
            this.teamReadsFromPanel.add((Component)this.getRadioButtonFileInput(), null);
            this.teamReadsFromPanel.add(this.getLabelTeamFileName());
            this.teamReadsFromPanel.add(this.getTeamFileNameTextField());
        }
        return this.teamReadsFromPanel;
    }

    private JRadioButton getRadioButtonStdIn() {
        if (this.radioButtonStdIn == null) {
            this.radioButtonStdIn = new JRadioButton();
            this.radioButtonStdIn.setText("Stdin");
            this.radioButtonStdIn.setSelected(true);
        }
        return this.radioButtonStdIn;
    }

    private JRadioButton getRadioButtonFileInput() {
        if (this.radioButtonFileInput == null) {
            this.radioButtonFileInput = new JRadioButton();
            this.radioButtonFileInput.setText("File");
        }
        return this.radioButtonFileInput;
    }

    private JLabel getLabelTeamFileName() {
        if (this.labelTeamFileName == null) {
            this.labelTeamFileName = new JLabel("Name of file which teams open:");
            this.labelTeamFileName.setEnabled(false);
        }
        return this.labelTeamFileName;
    }

    private JTextField getTeamFileNameTextField() {
        if (this.textFieldteamFileName == null) {
            this.textFieldteamFileName = new JTextField();
            this.textFieldteamFileName.setToolTipText("Enter the name of the file which the problem statement specifies the team program should open and read");
            this.textFieldteamFileName.setEnabled(false);
            this.textFieldteamFileName.setColumns(15);
        }
        return this.textFieldteamFileName;
    }

    private JCheckBox getCheckBoxJudgesHaveProvidedAnswerFiles() {
        if (this.checkBoxJudgesHaveProvidedAnswerFiles == null) {
            this.checkBoxJudgesHaveProvidedAnswerFiles = new JCheckBox("Judges Have Provided Answer Files");
        }
        return this.checkBoxJudgesHaveProvidedAnswerFiles;
    }

    private JCheckBox getCheckBoxProblemRequiresInputData() {
        if (this.checkBoxProblemRequiresInputData == null) {
            this.checkBoxProblemRequiresInputData = new JCheckBox();
            this.checkBoxProblemRequiresInputData.setText("Problem Requires Input Data");
            this.checkBoxProblemRequiresInputData.setPreferredSize(new Dimension(200, 30));
            this.checkBoxProblemRequiresInputData.setMinimumSize(new Dimension(200, 30));
            this.checkBoxProblemRequiresInputData.setMaximumSize(new Dimension(200, 30));
            this.checkBoxProblemRequiresInputData.setBorder(new EmptyBorder(0, 10, 0, 0));
            this.checkBoxProblemRequiresInputData.setAlignmentX(1.0f);
        }
        return this.checkBoxProblemRequiresInputData;
    }

    private JButton getBtnAddButton() {
        if (this.btnAddButton == null) {
            this.btnAddButton = new JButton("Add");
            this.btnAddButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            this.btnAddButton.setToolTipText("Add a new data set to the problem");
        }
        return this.btnAddButton;
    }

    private JLabel getLblDataSetOperations() {
        if (this.lblDataSetOperations == null) {
            this.lblDataSetOperations = new JLabel("Data Set Operations:");
        }
        return this.lblDataSetOperations;
    }
}

