/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MultiFileComparator
extends JFrame {
    private static final String JUDGES_ANS_FILENAME = "judges.ans";
    private static final String TEAMS_OUT_FILENAME = "teams.out";
    private static final long serialVersionUID = 1L;
    private IInternalController controller;
    private IInternalContest contest;
    private Log log;
    private JList<String> lstTestCases;
    private JList<String> lstTeamOutput;
    private JList<String> lstJudgesOutput;
    private int currentRunID;
    private JScrollPane scrollPaneTestCaseList;
    private JLabel lblTestCaseDataFile;
    private int[] currentTestCaseNums;
    private String[] currentTeamOutputFileNames;
    private String[] currentJudgesOutputFileNames;
    private String[] currentJudgesDataFileNames;
    private String comparatorCommand = "";
    private Process process = null;

    public MultiFileComparator() {
        this.setTitle("Test Case Outputs for Run ID:  xxx");
        this.setMinimumSize(new Dimension(650, 600));
        this.setPreferredSize(new Dimension(800, 600));
        this.setLocationRelativeTo(null);
        JPanel pnlSouthPanel = new JPanel();
        this.getContentPane().add((Component)pnlSouthPanel, "South");
        final JCheckBox chckbxLockScrolling = new JCheckBox("Lock Scrolling");
        chckbxLockScrolling.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "Sorry; this function isn't implemented yet", "Not Implemented", 1);
                chckbxLockScrolling.setEnabled(false);
                chckbxLockScrolling.setSelected(false);
            }
        });
        pnlSouthPanel.add(chckbxLockScrolling);
        Component horizontalStrut_2 = Box.createHorizontalStrut(20);
        pnlSouthPanel.add(horizontalStrut_2);
        final JButton btnExportFiles = new JButton("Export");
        btnExportFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, "Sorry; this function isn't implemented yet", "Not Implemented", 1);
                btnExportFiles.setEnabled(false);
            }
        });
        pnlSouthPanel.add(btnExportFiles);
        Component horizontalStrut_3 = Box.createHorizontalStrut(20);
        pnlSouthPanel.add(horizontalStrut_3);
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiFileComparator.this.setVisible(false);
            }
        });
        pnlSouthPanel.add(btnClose);
        JPanel northPanel = new JPanel();
        northPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.getContentPane().add((Component)northPanel, "North");
        this.lblTestCaseDataFile = new JLabel("Data file for selected Test Case: <none selected>");
        this.lblTestCaseDataFile.setToolTipText("The Judge's data file associated with the currently selected Test Case");
        northPanel.add(this.lblTestCaseDataFile);
        JPanel westPanel = new JPanel();
        westPanel.setMinimumSize(new Dimension(80, 10));
        westPanel.setPreferredSize(new Dimension(100, 10));
        this.getContentPane().add((Component)westPanel, "West");
        westPanel.setLayout(new BoxLayout(westPanel, 1));
        JLabel lblTestCases = new JLabel("Test Cases");
        westPanel.add(lblTestCases);
        this.scrollPaneTestCaseList = new JScrollPane();
        this.scrollPaneTestCaseList.setPreferredSize(new Dimension(0, 0));
        this.scrollPaneTestCaseList.setMinimumSize(new Dimension(0, 0));
        this.scrollPaneTestCaseList.setViewportBorder(new LineBorder(Color.blue));
        this.scrollPaneTestCaseList.setHorizontalScrollBarPolicy(31);
        this.scrollPaneTestCaseList.setVerticalScrollBarPolicy(20);
        this.scrollPaneTestCaseList.setWheelScrollingEnabled(true);
        westPanel.add(this.scrollPaneTestCaseList);
        this.lstTestCases = new JList();
        this.lstTestCases.setBorder(new EmptyBorder(2, 5, 2, 5));
        this.lstTestCases.setBounds(new Rectangle(10, 0, 0, 0));
        this.lstTestCases.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList source;
                if (e.getSource() instanceof JList && !(source = (JList)e.getSource()).getValueIsAdjusting()) {
                    ListModel model = source.getModel();
                    int index = source.getSelectedIndex();
                    System.out.println("MFC.lstTestCases.valueChanged(): Selected Index = " + index);
                    if (index == -1) {
                        index = 0;
                        source.setSelectedIndex(index);
                    } else {
                        int testCaseNum = new Integer((String)model.getElementAt(index));
                        System.out.println("MFC.lstTestCases.valueChanged(): Test Case Number = " + testCaseNum);
                    }
                    MultiFileComparator.this.updateViewsToSelectedTestCase(index);
                }
            }
        });
        DefaultListModel<String> initialListData = new DefaultListModel<String>();
        initialListData.addElement("?");
        initialListData.addElement("?");
        initialListData.addElement("?");
        initialListData.addElement("...");
        this.lstTestCases.setModel(initialListData);
        this.lstTestCases.setToolTipText("List of selectable Test Cases");
        this.lstTestCases.setSelectionMode(0);
        this.scrollPaneTestCaseList.setViewportView(this.lstTestCases);
        JLabel lblClickHint = new JLabel("(Click to Select)");
        westPanel.add(lblClickHint);
        JPanel pnlOutputViewHolder = new JPanel();
        this.getContentPane().add((Component)pnlOutputViewHolder, "Center");
        pnlOutputViewHolder.setLayout(new BorderLayout(0, 0));
        JPanel pnlOutputViewLabels = new JPanel();
        pnlOutputViewHolder.add((Component)pnlOutputViewLabels, "North");
        JPanel pnlTeamOutputLabel = new JPanel();
        pnlOutputViewLabels.add(pnlTeamOutputLabel);
        JLabel lblTeamOutput = new JLabel("Team Output");
        pnlTeamOutputLabel.add(lblTeamOutput);
        Component horizontalStrut_1 = Box.createHorizontalStrut(20);
        horizontalStrut_1.setPreferredSize(new Dimension(100, 0));
        pnlOutputViewLabels.add(horizontalStrut_1);
        JPanel pnlJudgesOutputLabel = new JPanel();
        pnlOutputViewLabels.add(pnlJudgesOutputLabel);
        JLabel lblJudgesOutput = new JLabel("Judge's Output");
        pnlJudgesOutputLabel.add(lblJudgesOutput);
        JSplitPane splitPaneOutputViews = new JSplitPane();
        splitPaneOutputViews.setContinuousLayout(true);
        splitPaneOutputViews.setResizeWeight(0.5);
        splitPaneOutputViews.setToolTipText("Displays the outputs corresponding to the selected Test Case");
        pnlOutputViewHolder.add((Component)splitPaneOutputViews, "Center");
        String[] noData = new String[]{"<no test case selected>"};
        this.lstTeamOutput = new JList();
        this.lstTeamOutput.setListData((String[])noData);
        splitPaneOutputViews.setLeftComponent(this.lstTeamOutput);
        this.lstJudgesOutput = new JList();
        this.lstJudgesOutput.setListData((String[])noData);
        splitPaneOutputViews.setRightComponent(this.lstJudgesOutput);
    }

    private void updateViewsToSelectedTestCase(int testCaseIndex) {
        if (testCaseIndex >= 0 && testCaseIndex < this.currentTeamOutputFileNames.length) {
            System.out.println("MFC.updateViewsToSelectedTestCase(): received testCaseIndex = " + testCaseIndex + "; list test case number = " + this.currentTestCaseNums[testCaseIndex] + "; currentJudgesDataFileNames.length = " + this.currentJudgesDataFileNames.length);
            if (this.currentJudgesDataFileNames != null) {
                this.lblTestCaseDataFile.setText("Data file for selected Test Case: '" + this.currentJudgesDataFileNames[testCaseIndex] + "'");
            } else if (this.getLog() != null) {
                this.log.log(Log.WARNING, "MultiFileComparator.updateViewsToSelectedTestCase(): judge's data file names array is null!");
            } else {
                System.err.println("WARNING: MultiFileComparator.updateViewsToSelectedTestCase(): judge's data file names array is null!");
            }
            if (this.currentTeamOutputFileNames != null) {
                this.updateOutputDisplay(testCaseIndex, this.currentTeamOutputFileNames, this.lstTeamOutput);
            } else if (this.getLog() != null) {
                this.log.log(Log.WARNING, "MultiFileComparator.updateViewsToSelectedTestCase(): team output file names array is null!");
            } else {
                System.err.println("WARNING: MultiFileComparator.updateViewsToSelectedTestCase(): team output file names array is null!");
            }
            if (this.currentJudgesOutputFileNames != null) {
                this.updateOutputDisplay(testCaseIndex, this.currentJudgesOutputFileNames, this.lstJudgesOutput);
            } else if (this.getLog() != null) {
                this.log.log(Log.WARNING, "MultiFileComparator.updateViewsToSelectedTestCase(): judge's output file names array is null!");
            } else {
                System.err.println("WARNING: MultiFileComparator.updateViewsToSelectedTestCase(): judge's output file names array is null!");
            }
        } else if (this.getLog() != null) {
            this.log.log(Log.WARNING, "MultiFileComparator.updateViewsToSelectedTestCase(): invalid test case number: " + testCaseIndex);
        } else {
            System.err.println("WARNING: MultiFileComparator.updateViewsToSelectedTestCase(): invalid test case number: " + testCaseIndex);
        }
    }

    private int indexOfTestCase(int testCaseNum) {
        int retVal = -1;
        if (this.currentTestCaseNums != null) {
            int i = 0;
            while (i < this.currentTestCaseNums.length) {
                if (this.currentTestCaseNums[i] == testCaseNum) {
                    retVal = i;
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.controller = inController;
        this.contest = inContest;
        if (inController != null) {
            this.log = inController.getLog();
        }
    }

    public void setData(int runID, int[] testCaseNums, String[] teamOutputFileNames, String[] judgesOutputFileNames, String[] judgesDataFileNames) {
        this.setRunID(runID);
        this.setTestCaseList(testCaseNums);
        this.setOutputFileNames(teamOutputFileNames, judgesOutputFileNames);
        this.setJudgesDataFileNames(judgesDataFileNames);
        this.lstTestCases.setSelectedIndex(0);
        this.updateViewsToSelectedTestCase(0);
        if (!this.comparatorCommand.equals("")) {
            try {
                BufferedOutputStream outWriter = new BufferedOutputStream(new FileOutputStream(TEAMS_OUT_FILENAME));
                BufferedOutputStream ansWriter = new BufferedOutputStream(new FileOutputStream(JUDGES_ANS_FILENAME));
                int fileIndex = 0;
                int[] nArray = testCaseNums;
                int n = testCaseNums.length;
                int n2 = 0;
                while (n2 < n) {
                    int caseNum = nArray[n2];
                    String msg = "TESTCASE " + caseNum + " BEGIN ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~";
                    msg = String.valueOf(msg.substring(0, 80)) + "\n";
                    outWriter.write(msg.getBytes());
                    ansWriter.write(msg.getBytes());
                    int c = 0;
                    byte[] cbuf = new byte[32768];
                    if (judgesOutputFileNames != null && judgesOutputFileNames[fileIndex] != null && new File(judgesOutputFileNames[fileIndex]).exists()) {
                        BufferedInputStream ansReader = new BufferedInputStream(new FileInputStream(judgesOutputFileNames[fileIndex]));
                        c = ansReader.read(cbuf);
                        while (c != -1) {
                            ansWriter.write(cbuf, 0, c);
                            c = ansReader.read(cbuf);
                        }
                        ansReader.close();
                        ansReader = null;
                    }
                    if (teamOutputFileNames != null && teamOutputFileNames[fileIndex] != null && new File(teamOutputFileNames[fileIndex]).exists()) {
                        BufferedInputStream outReader = new BufferedInputStream(new FileInputStream(teamOutputFileNames[fileIndex]));
                        c = outReader.read(cbuf);
                        while (c != -1) {
                            outWriter.write(cbuf, 0, c);
                            c = outReader.read(cbuf);
                        }
                        outReader.close();
                        outReader = null;
                    }
                    msg = "TESTCASE " + caseNum + " END ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~";
                    msg = String.valueOf(msg.substring(0, 80)) + "\n";
                    outWriter.write(msg.getBytes());
                    ansWriter.write(msg.getBytes());
                    ++fileIndex;
                    ++n2;
                }
                outWriter.close();
                ansWriter.close();
                outWriter = null;
                ansWriter = null;
            }
            catch (IOException e) {
                this.log.warning(e.getMessage());
            }
        }
    }

    private void setRunID(int runID) {
        this.currentRunID = runID;
        this.setTitle("Test Case Outputs for Run ID:  " + runID);
    }

    private void setJudgesDataFileNames(String[] judgesDataFileNames) {
        this.currentJudgesDataFileNames = judgesDataFileNames;
    }

    private void setTestCaseList(int[] testCaseNums) {
        this.currentTestCaseNums = testCaseNums;
        if (testCaseNums == null || testCaseNums.length <= 0) {
            if (this.getLog() != null) {
                this.log.log(Log.WARNING, "MultiFileComparator.setTestCaseList() called with null or empty list");
            } else {
                System.err.println("Warning: MultiFileComparator.setTestCaseList() called with null or empty list");
            }
        }
        DefaultListModel<String> testCaseListModel = new DefaultListModel<String>();
        int i = 0;
        while (i < testCaseNums.length) {
            testCaseListModel.addElement(String.valueOf(testCaseNums[i]));
            ++i;
        }
        this.lstTestCases.setModel(testCaseListModel);
        int listSize = testCaseListModel.getSize();
        if (listSize < 10) {
            this.lstTestCases.setVisibleRowCount(listSize);
        } else {
            this.lstTestCases.setVisibleRowCount(10);
        }
        this.scrollPaneTestCaseList.setViewportView(this.lstTestCases);
    }

    private void setOutputFileNames(String[] teamOutputFileNames, String[] judgesOutputFileNames) {
        if (teamOutputFileNames == null || judgesOutputFileNames == null || teamOutputFileNames.length != judgesOutputFileNames.length) {
            if (this.getLog() != null) {
                this.log.log(Log.WARNING, "MultiFileComparator.setOutputFileNames() called with invalid arrays (null or different lengths)");
            } else {
                System.err.println("Warning: MultiFileComparator.setOutputFileNames() called with invalid arrays (null or different lengths)");
            }
        }
        this.currentTeamOutputFileNames = teamOutputFileNames;
        System.out.println("MFC.setOutputFilenames(): team output file names:");
        int i = 0;
        while (i < this.currentTeamOutputFileNames.length) {
            System.out.println("  '" + this.currentTeamOutputFileNames[i] + "'");
            ++i;
        }
        this.currentJudgesOutputFileNames = judgesOutputFileNames;
        System.out.println("MFC.setOutputFilenames(): judges output file names:");
        i = 0;
        while (i < this.currentJudgesOutputFileNames.length) {
            System.out.println("  '" + this.currentJudgesOutputFileNames[i] + "'");
            ++i;
        }
    }

    @Override
    public void setVisible(boolean arg0) {
        if (this.comparatorCommand.equals("")) {
            super.setVisible(arg0);
        } else if (arg0) {
            String[] env = null;
            try {
                this.process = Runtime.getRuntime().exec(String.valueOf(this.comparatorCommand) + " " + TEAMS_OUT_FILENAME + " " + JUDGES_ANS_FILENAME, env, new File("."));
            }
            catch (IOException e) {
                this.log.warning("setVisible() " + e.getMessage());
                JOptionPane.showMessageDialog(this, "System Error: " + e.getMessage(), "System Error", 0);
            }
        } else if (this.process != null) {
            this.process.destroy();
        }
    }

    private Log getLog() {
        if (this.controller != null) {
            this.log = this.controller.getLog();
        }
        return this.log;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateOutputDisplay(int listIndex, String[] outputFileNameList, JList<String> outputDisplayList) {
        BufferedReader fileHandle = null;
        if (listIndex >= 0 && outputFileNameList != null && listIndex < outputFileNameList.length) {
            String fileName = outputFileNameList[listIndex];
            try {
                try {
                    fileHandle = this.getFileHandle(fileName);
                    String lineRead = fileHandle.readLine();
                    Vector<String> v = new Vector<String>();
                    while (lineRead != null) {
                        v.addElement(lineRead);
                        lineRead = new String();
                        lineRead = fileHandle.readLine();
                    }
                    outputDisplayList.setListData(v);
                    return;
                }
                catch (Exception e) {
                    if (this.getLog() != null) {
                        this.log.log(Log.WARNING, "MultiFileComparator.updateOutputDisplay(): error processing '" + fileName + "'," + e.getMessage());
                    } else {
                        System.err.println("WARNING: MultiFileComparator.updateOutputDisplay(): error processing '" + fileName + "'," + e.getMessage());
                    }
                    try {
                        if (fileHandle == null) return;
                        fileHandle.close();
                        return;
                    }
                    catch (Exception e2) {
                        if (this.getLog() != null) {
                            this.log.log(Log.WARNING, "MultiFileComparator.updateOutputDisplay(): error closing fileHandle for '" + fileName + "'," + e2.getMessage());
                            return;
                        }
                        System.err.println("WARNING: MultiFileComparator.updateOutputDisplay(): error closing fileHandle for '" + fileName + "'," + e2.getMessage());
                    }
                }
                return;
            }
            finally {
                try {
                    if (fileHandle != null) {
                        fileHandle.close();
                    }
                }
                catch (Exception e) {
                    if (this.getLog() != null) {
                        this.log.log(Log.WARNING, "MultiFileComparator.updateOutputDisplay(): error closing fileHandle for '" + fileName + "'," + e.getMessage());
                    }
                    System.err.println("WARNING: MultiFileComparator.updateOutputDisplay(): error closing fileHandle for '" + fileName + "'," + e.getMessage());
                }
            }
        }
        if (this.getLog() != null) {
            this.log.log(Log.WARNING, "MultiFileComparator.updateOutputDisplay(): bad list index (" + listIndex + ") or bad output file names array");
            return;
        } else {
            System.err.println("WARNING: MultiFileComparator.updateOutputDisplay(): bad list index (" + listIndex + ") or bad output file names array");
        }
    }

    private BufferedReader getFileHandle(String fileName) throws FileNotFoundException {
        BufferedReader br = null;
        try {
            FileReader fr = new FileReader(fileName);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException fe) {
            if (this.getLog() != null) {
                this.log.log(Log.SEVERE, "MultiFileComparator.getFileHandle(): unable to open '" + fileName + "'; " + fe.getMessage());
            } else {
                System.err.println("ERROR: MultiFileComparator.getFileHandle(): unable to open '" + fileName + "'; " + fe.getMessage());
            }
            throw fe;
        }
        return br;
    }

    public String getComparatorCommand() {
        return this.comparatorCommand;
    }

    public void setComparatorCommand(String comparatorCommand) {
        this.comparatorCommand = comparatorCommand == null ? "" : comparatorCommand;
    }

    @Override
    public void dispose() {
        if (this.process != null) {
            this.process.destroy();
        }
        super.dispose();
    }
}

