/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import com.ibm.webrunner.j2mclb.util.TableModel;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IMessageListener;
import edu.csus.ecs.pc2.core.model.MessageEvent;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MessageMonitorPane
extends JPanePlugin {
    private static final long serialVersionUID = 1485047964016484623L;
    private JPanel buttonPane = null;
    private JButton clearButton = null;
    private MCLB messageListBox = null;
    private int sequenceNumber = 1;
    private SimpleDateFormat formatter = new SimpleDateFormat(" HH:mm:ss MM-dd");
    private int maxLines = 500;

    public MessageMonitorPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(453, 214));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)((Object)this.getMessageListBox()), "Center");
    }

    private MCLB getMessageListBox() {
        if (this.messageListBox == null) {
            this.messageListBox = new MCLB();
            Object[] cols = new Object[]{"Seq", "At", "Area", "Message"};
            this.messageListBox.addColumns(cols);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            int idx = 0;
            this.messageListBox.setColumnSorter(idx++, numericStringSorter, 1);
            this.messageListBox.setColumnSorter(idx++, sorter, 2);
            this.messageListBox.setColumnSorter(idx++, sorter, 3);
            this.messageListBox.setColumnSorter(idx++, sorter, 4);
        }
        return this.messageListBox;
    }

    @Override
    public String getPluginTitle() {
        return "Message Monitor Pane";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        inContest.addMessageListener(new MessageListenerImplementation());
    }

    public void addMessageRow(final MessageEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object[] objects = MessageMonitorPane.this.buildMessageRow(event);
                MessageMonitorPane.this.messageListBox.addRow(objects, event);
                MessageMonitorPane.this.truncateTo(MessageMonitorPane.this.maxLines);
                MessageMonitorPane.this.messageListBox.autoSizeAllColumns();
                MessageMonitorPane.this.messageListBox.sort();
            }
        });
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(new FlowLayout());
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getClearButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setText("Clear");
            this.clearButton.setMnemonic(67);
            this.clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessageMonitorPane.this.clearList();
                }
            });
        }
        return this.clearButton;
    }

    protected void clearList() {
        this.messageListBox.removeAllRows();
    }

    protected Object[] buildMessageRow(MessageEvent event) {
        int numberColumns = this.messageListBox.getColumnCount();
        Object[] c = new String[numberColumns];
        c[0] = Integer.toString(this.sequenceNumber);
        c[1] = this.formatter.format(new Date());
        c[2] = event.getArea().toString();
        c[3] = event.getMessage();
        return c;
    }

    private void truncateTo(int numLines) {
        TableModel tableModel = this.getMessageListBox().getModel();
        if (tableModel.getRowCount() > numLines) {
            int lastRow;
            int i = lastRow = tableModel.getRowCount();
            while (i >= numLines) {
                tableModel.removeRow(i);
                --i;
            }
        }
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    class MessageListenerImplementation
    implements IMessageListener {
        MessageListenerImplementation() {
        }

        @Override
        public void messageAdded(MessageEvent event) {
            MessageMonitorPane.this.addMessageRow(event);
        }

        @Override
        public void messageRemoved(MessageEvent event) {
        }
    }
}

