/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.NoteList;
import edu.csus.ecs.pc2.core.NoteMessage;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Filter;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.report.IReport;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import edu.csus.ecs.pc2.ui.ReportPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public abstract class JFramePlugin
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -1059195405486851400L;
    private IInternalController controller;
    private IInternalContest contest;
    private JFrame parentFrame = null;

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.controller = inController;
        this.contest = inContest;
    }

    @Override
    public abstract String getPluginTitle();

    public IInternalController getController() {
        return this.controller;
    }

    public void setController(IInternalController controller) {
        this.controller = controller;
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    public void setContest(IInternalContest contest) {
        this.contest = contest;
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void createAndViewReportFile(IReport report, Filter filter, Log log) throws IOException {
        ReportPane reportPane = new ReportPane();
        reportPane.setContestAndController(this.contest, this.controller);
        String filename = reportPane.getFileName(report, "txt");
        File reportDirectoryFile = new File(reportPane.getReportDirectory());
        if (reportDirectoryFile.exists()) {
            if (reportDirectoryFile.isDirectory()) {
                filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
            }
        } else if (reportDirectoryFile.mkdirs()) {
            filename = String.valueOf(reportDirectoryFile.getCanonicalPath()) + File.separator + filename;
        }
        reportPane.createReportFile(report, false, filename, filter);
        String title = report.getReportTitle();
        MultipleFileViewer multipleFileViewer = new MultipleFileViewer(log);
        multipleFileViewer.addFilePane(title, filename);
        multipleFileViewer.setTitle("PC^2 Report (Build " + new VersionInfo().getBuildNumber() + ")");
        FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
        multipleFileViewer.setVisible(true);
    }

    public void logException(String message, Exception ex) {
        this.controller.getLog().log(Log.WARNING, message, ex);
    }

    public void logNoteList(NoteList noteList) {
        NoteMessage[] noteMessageArray = noteList.getAll();
        int n = noteMessageArray.length;
        int n2 = 0;
        while (n2 < n) {
            NoteMessage noteMessage = noteMessageArray[n2];
            String message = noteMessage.getComment();
            String prefix = "";
            String filename = noteMessage.getFilename();
            if (filename != null && filename.equals("<no filename>")) {
                prefix = String.valueOf(filename) + " " + noteMessage.getLineNumber();
                if (noteMessage.getColumnNumber() != 0) {
                    prefix = String.valueOf(prefix) + " col " + noteMessage.getColumnNumber();
                }
                message = String.valueOf(prefix) + " " + message;
            }
            switch (noteMessage.getType()) {
                case ERROR: {
                    this.controller.getLog().log(Log.SEVERE, message);
                    break;
                }
                case WARNING: {
                    this.controller.getLog().log(Log.WARNING, message);
                    break;
                }
                default: {
                    this.controller.getLog().log(Log.INFO, message);
                }
            }
            ++n2;
        }
    }

    public void initializePermissions() {
    }

    public boolean isAllowed(Permission.Type type) {
        return this.getContest().isAllowed(type);
    }

    public void showMessage(Component component, String title, String message) {
        JOptionPane.showMessageDialog(component, message, title, 1);
    }

    public void showMessage(JFrame frame, String strTitle, String message) {
        final JDialog dialog = new JDialog(frame, strTitle, true);
        final JOptionPane optionPane = new JOptionPane(message, 1);
        dialog.setDefaultCloseOperation(0);
        optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (dialog.isVisible() && e.getSource() == optionPane && prop.equals("value")) {
                    dialog.setVisible(false);
                }
            }
        });
        dialog.setContentPane(optionPane);
        dialog.pack();
        FrameUtilities.centerFrameOver(this.parentFrame, dialog);
        dialog.setVisible(true);
    }
}

