/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.imports.ICPCAccount;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.ICPCAccountPane;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import javax.swing.JFrame;

public class ICPCAccountFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = -6248957592340866836L;
    private IInternalContest contest;
    private IInternalController controller;
    private ICPCAccountPane icpcAccountPane = null;

    public ICPCAccountFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(800, 1200));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getICPCAccountPane());
        this.setTitle("ICPC Accounts");
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getICPCAccountPane().setContestAndController(this.contest, this.controller);
        this.getICPCAccountPane().setParentFrame(this);
        FrameUtilities.centerFrameFullScreenHeight(this);
    }

    public void setICPCAccounts(ICPCAccount[] icpcAccounts) {
        if (icpcAccounts == null) {
            this.setVisible(false);
        } else {
            this.getICPCAccountPane().setIcpcAccounts(icpcAccounts);
        }
    }

    @Override
    public String getPluginTitle() {
        return "ICPC Account Frame";
    }

    private ICPCAccountPane getICPCAccountPane() {
        if (this.icpcAccountPane == null) {
            this.icpcAccountPane = new ICPCAccountPane();
        }
        return this.icpcAccountPane;
    }
}

