/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.VersionInfo;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.export.ExportYAML;
import edu.csus.ecs.pc2.core.report.SubmissionsTSVReport;
import edu.csus.ecs.pc2.exports.ccs.Groupdata;
import edu.csus.ecs.pc2.exports.ccs.ResultsFile;
import edu.csus.ecs.pc2.exports.ccs.ScoreboardFile;
import edu.csus.ecs.pc2.exports.ccs.Teamdata;
import edu.csus.ecs.pc2.exports.ccs.Userdata;
import edu.csus.ecs.pc2.ui.FileNameExtensionFilter;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ExportDataPane
extends JPanePlugin {
    private static final long serialVersionUID = 2608244878052255094L;
    private JPanel buttonPane = null;
    private JButton creatResultsButton = null;
    private JButton saveScoreboardButton = null;
    private JButton saveUserDataButton = null;
    private JButton saveTeamsButton = null;
    private JButton saveGroupButton = null;
    private JPanel centerPane = null;
    private JButton exportYamlButton = null;
    private String lastDirectory = ".";
    private JButton exportRunTSVButton = null;

    public ExportDataPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(548, 291));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getCenterPane(), "Center");
    }

    @Override
    public String getPluginTitle() {
        return "Export Data Pane";
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getCreatResultsButton(), null);
            this.buttonPane.add((Component)this.getSaveScoreboardButton(), null);
            this.buttonPane.add((Component)this.getSaveUserDataButton(), null);
            this.buttonPane.add((Component)this.getSaveTeamsButton(), null);
            this.buttonPane.add((Component)this.getSaveGroupButton(), null);
        }
        return this.buttonPane;
    }

    private JButton getCreatResultsButton() {
        if (this.creatResultsButton == null) {
            this.creatResultsButton = new JButton();
            this.creatResultsButton.setText("Save Results");
            this.creatResultsButton.setToolTipText("Save results TSV file");
            this.creatResultsButton.setMnemonic(82);
            this.creatResultsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDataPane.this.saveResultsTSVFile();
                }
            });
        }
        return this.creatResultsButton;
    }

    protected void saveResultsTSVFile() {
        String outfilename = "results.tsv";
        try {
            ResultsFile resultsFile = new ResultsFile();
            String[] lines = resultsFile.createTSVFileLines(this.getContest());
            this.writeLinesToFile(outfilename, lines);
            this.viewFile(outfilename, outfilename);
        }
        catch (Exception e) {
            FrameUtilities.showMessage(this, "Can not save file", "Unable to save " + outfilename + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private JButton getSaveScoreboardButton() {
        if (this.saveScoreboardButton == null) {
            this.saveScoreboardButton = new JButton();
            this.saveScoreboardButton.setText("Save Scoreboard");
            this.saveScoreboardButton.setToolTipText("Save Scoreboard TSV file");
            this.saveScoreboardButton.setMnemonic(83);
            this.saveScoreboardButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDataPane.this.saveScoreboardTSVFile();
                }
            });
        }
        return this.saveScoreboardButton;
    }

    protected void saveScoreboardTSVFile() {
        String outfilename = "scoreboard.tsv";
        try {
            ScoreboardFile scoreboardFile = new ScoreboardFile();
            String[] lines = scoreboardFile.createTSVFileLines(this.getContest());
            this.writeLinesToFile(outfilename, lines);
            this.viewFile(outfilename, outfilename);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to save " + outfilename + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void writeLinesToFile(String filename, String[] lines) throws FileNotFoundException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(filename, false), true);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            printWriter.println(line);
            ++n2;
        }
        printWriter.close();
    }

    private JButton getSaveUserDataButton() {
        if (this.saveUserDataButton == null) {
            this.saveUserDataButton = new JButton();
            this.saveUserDataButton.setText("Save UserData");
            this.saveUserDataButton.setMnemonic(85);
            this.saveUserDataButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDataPane.this.saveUserDataTSVFile();
                }
            });
        }
        return this.saveUserDataButton;
    }

    protected void saveGroupdataTSVFile() {
        String outfilename = "groups.tsv";
        try {
            Groupdata groupData = new Groupdata();
            String[] lines = groupData.getGroupData(this.getContest());
            this.writeLinesToFile(outfilename, lines);
            this.viewFile(outfilename, outfilename);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to save " + outfilename + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void saveTeamdataTSVFile() {
        String outfilename = "teams.tsv";
        try {
            Teamdata teamdata = new Teamdata();
            String[] lines = teamdata.getTeamData(this.getContest());
            this.writeLinesToFile(outfilename, lines);
            this.viewFile(outfilename, outfilename);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to save " + outfilename + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void saveUserDataTSVFile() {
        String outfilename = "userdata.tsv";
        try {
            Userdata userdata = new Userdata();
            String[] lines = userdata.getUserData(this.getContest());
            this.writeLinesToFile(outfilename, lines);
            this.viewFile(outfilename, outfilename);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to save " + outfilename + " " + e.getMessage());
            e.printStackTrace();
        }
    }

    private JButton getSaveTeamsButton() {
        if (this.saveTeamsButton == null) {
            this.saveTeamsButton = new JButton();
            this.saveTeamsButton.setText("Save Teams");
            this.saveTeamsButton.setToolTipText("Save Teams TSV file");
            this.saveTeamsButton.setMnemonic(84);
            this.saveTeamsButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDataPane.this.saveTeamdataTSVFile();
                }
            });
        }
        return this.saveTeamsButton;
    }

    private void viewFile(String filename, String title) {
        MultipleFileViewer multipleFileViewer = new MultipleFileViewer(this.getController().getLog());
        multipleFileViewer.addFilePane(title, filename);
        multipleFileViewer.setTitle("PC^2 View File (Build " + new VersionInfo().getBuildNumber() + ")");
        FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
        multipleFileViewer.setVisible(true);
    }

    private JButton getSaveGroupButton() {
        if (this.saveGroupButton == null) {
            this.saveGroupButton = new JButton();
            this.saveGroupButton.setText("Save Groups");
            this.saveGroupButton.setToolTipText("Save Groups TSV file");
            this.saveGroupButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDataPane.this.saveGroupdataTSVFile();
                }
            });
        }
        return this.saveGroupButton;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setHgap(25);
            this.centerPane = new JPanel();
            this.centerPane.setLayout(flowLayout1);
            this.centerPane.add((Component)this.getExportYamlButton(), null);
            this.centerPane.add((Component)this.getExportRunTSVButton(), null);
        }
        return this.centerPane;
    }

    private JButton getExportYamlButton() {
        if (this.exportYamlButton == null) {
            this.exportYamlButton = new JButton();
            this.exportYamlButton.setText("Export contest.yaml");
            this.exportYamlButton.setMnemonic(88);
            this.exportYamlButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDataPane.this.exportContestYaml();
                }
            });
        }
        return this.exportYamlButton;
    }

    public File selectDirectoryDialog(Component parent, String startDirectory) {
        JFileChooser chooser = new JFileChooser(startDirectory);
        chooser.setFileSelectionMode(1);
        int action = chooser.showSaveDialog(parent);
        switch (action) {
            case 0: {
                File file = chooser.getSelectedFile();
                this.lastDirectory = chooser.getCurrentDirectory().toString();
                return file;
            }
        }
        return null;
    }

    public File saveAsFileDialog(Component parent, String startDirectory, String defaultFileName) {
        File inFile = new File(String.valueOf(startDirectory) + File.separator + defaultFileName);
        System.out.println("debug 22 filename is " + inFile.getAbsolutePath());
        JFileChooser chooser = new JFileChooser(startDirectory);
        chooser.setSelectedFile(inFile);
        chooser.setFileSelectionMode(0);
        FileNameExtensionFilter filterText = new FileNameExtensionFilter("TSV file (*.tsv)", "tsv");
        chooser.addChoosableFileFilter(filterText);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filterText);
        int action = chooser.showSaveDialog(parent);
        switch (action) {
            case 0: {
                File file = chooser.getSelectedFile();
                this.lastDirectory = chooser.getCurrentDirectory().toString();
                return file;
            }
        }
        return null;
    }

    protected void exportContestYaml() {
        File dir = this.selectDirectoryDialog(this, this.lastDirectory);
        if (dir != null) {
            ExportYAML exportYAML = new ExportYAML();
            try {
                exportYAML.exportFiles(dir.getAbsolutePath(), this.getContest());
                String outfilename = String.valueOf(dir.getCanonicalPath()) + File.separator + "contest.yaml";
                this.viewFile(outfilename, outfilename);
            }
            catch (IOException e) {
                FrameUtilities.showMessage(this, "Error exporting contest.yaml", "Error exporting YAML " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private JButton getExportRunTSVButton() {
        if (this.exportRunTSVButton == null) {
            this.exportRunTSVButton = new JButton();
            this.exportRunTSVButton.setText("Export submissions.tsv");
            this.exportRunTSVButton.setMnemonic(82);
            this.exportRunTSVButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDataPane.this.exportRunTSVFile();
                }
            });
        }
        return this.exportRunTSVButton;
    }

    protected void exportRunTSVFile() {
        File file = this.saveAsFileDialog(this, this.lastDirectory, "submissions.tsv");
        if (file != null) {
            SubmissionsTSVReport runsTSVReport = new SubmissionsTSVReport();
            Utilities.viewReport(runsTSVReport, "submissions.tsv file", this.getContest(), this.getController(), !runsTSVReport.suppressHeaderFooter());
        }
    }
}

