/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import com.ibm.webrunner.j2mclb.util.Comparator;
import com.ibm.webrunner.j2mclb.util.HeapSorter;
import com.ibm.webrunner.j2mclb.util.NumericStringComparator;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.AccountEvent;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.EventFeedDefinition;
import edu.csus.ecs.pc2.core.model.IAccountListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.ui.AccountColumnComparator;
import edu.csus.ecs.pc2.ui.EditEventFeedDefinitionFrame;
import edu.csus.ecs.pc2.ui.EventFeedViewerFrame;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MCLB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class EventFeedsPane
extends JPanePlugin {
    private static final long serialVersionUID = -4930863862533276867L;
    private JPanel buttonPane = null;
    private JPanel centerPane = null;
    private JButton addButton = null;
    private JButton editButton = null;
    private MCLB eventFeedListBox = null;
    private JButton viewerButton = null;
    private EditEventFeedDefinitionFrame eventFeedDefinitionFrame = null;

    public EventFeedsPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(449, 176));
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getCenterPane(), "Center");
    }

    @Override
    public String getPluginTitle() {
        return "Event Feed Pane";
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.getContest().addAccountListener(new AccountListenerImplementation());
        this.initializePermissions();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EventFeedsPane.this.updateGUIperPermissions();
                EventFeedsPane.this.reloadListBox();
            }
        });
    }

    protected void reloadListBox() {
        EventFeedDefinition[] defs = this.getContest().getEventFeedDefinitions();
        this.getEventFeedListBox().removeAllRows();
        EventFeedDefinition[] eventFeedDefinitionArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            EventFeedDefinition definition = eventFeedDefinitionArray[n2];
            this.addEventFeedDefinitonRow(definition);
            ++n2;
        }
    }

    private void addEventFeedDefinitonRow(EventFeedDefinition definition) {
        Object[] objects = this.buildEventFeedDefRow(definition);
        this.getEventFeedListBox().addRow(objects, definition.getElementId());
        this.getEventFeedListBox().autoSizeAllColumns();
    }

    private void updateGUIperPermissions() {
        this.addButton.setVisible(this.isAllowed(Permission.Type.EDIT_EVENT_FEED));
        this.editButton.setVisible(this.isAllowed(Permission.Type.EDIT_EVENT_FEED));
        this.viewerButton.setVisible(this.isAllowed(Permission.Type.VIEW_EVENT_FEED));
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.setPreferredSize(new Dimension(35, 35));
            this.buttonPane.add((Component)this.getAddButton(), null);
            this.buttonPane.add((Component)this.getEditButton(), null);
            this.buttonPane.add((Component)this.getViewerButton(), null);
        }
        return this.buttonPane;
    }

    private JPanel getCenterPane() {
        if (this.centerPane == null) {
            this.centerPane = new JPanel();
            this.centerPane.setLayout(new BorderLayout());
            this.centerPane.add((Component)((Object)this.getEventFeedListBox()), "Center");
        }
        return this.centerPane;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton();
            this.addButton.setText("Add");
            this.addButton.setMnemonic(65);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventFeedsPane.this.addEventFeedDef();
                }
            });
        }
        return this.addButton;
    }

    public EditEventFeedDefinitionFrame getEventFeedDefinitionFrame() {
        if (this.eventFeedDefinitionFrame == null) {
            this.eventFeedDefinitionFrame = new EditEventFeedDefinitionFrame();
        }
        return this.eventFeedDefinitionFrame;
    }

    protected void addEventFeedDef() {
        this.getEventFeedDefinitionFrame().setEventDefinition(null);
        this.getEventFeedDefinitionFrame().setVisible(true);
    }

    private JButton getEditButton() {
        if (this.editButton == null) {
            this.editButton = new JButton();
            this.editButton.setText("Edit");
            this.editButton.setMnemonic(69);
            this.editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventFeedsPane.this.editEventFeedDef();
                }
            });
        }
        return this.editButton;
    }

    protected void editEventFeedDef() {
        if (this.getEventFeedListBox().getRowCount() < 1) {
            this.showMessage("No Event Feed exist");
            return;
        }
        EventFeedDefinition definition = this.getSelectedDefinition();
        if (definition == null) {
            this.showMessage("No Event Feed selected");
            return;
        }
        this.getEventFeedDefinitionFrame().setEventDefinition(definition);
        this.getEventFeedDefinitionFrame().setVisible(true);
    }

    private MCLB getEventFeedListBox() {
        if (this.eventFeedListBox == null) {
            this.eventFeedListBox = new MCLB();
            this.eventFeedListBox.removeAllRows();
            this.eventFeedListBox.removeAllColumns();
            Object[] columns = new Object[]{"Status", "Site", "Port", "Name", "Connected"};
            this.eventFeedListBox.addColumns(columns);
            HeapSorter sorter = new HeapSorter();
            HeapSorter numericStringSorter = new HeapSorter();
            numericStringSorter.setComparator((Comparator)new NumericStringComparator());
            HeapSorter accountNameSorter = new HeapSorter();
            accountNameSorter.setComparator((Comparator)new AccountColumnComparator());
            int idx = 0;
            this.eventFeedListBox.setColumnSorter(idx++, sorter, 1);
            this.eventFeedListBox.setColumnSorter(idx++, numericStringSorter, 2);
            this.eventFeedListBox.setColumnSorter(idx++, numericStringSorter, 2);
            this.eventFeedListBox.setColumnSorter(idx++, accountNameSorter, 2);
            this.eventFeedListBox.autoSizeAllColumns();
        }
        return this.eventFeedListBox;
    }

    private JButton getViewerButton() {
        if (this.viewerButton == null) {
            this.viewerButton = new JButton();
            this.viewerButton.setText("Viewer");
            this.viewerButton.setToolTipText("Start a Event Feed Viewer");
            this.viewerButton.setMnemonic(86);
            this.viewerButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventFeedsPane.this.startViewer();
                }
            });
        }
        return this.viewerButton;
    }

    protected void startViewer() {
        try {
            EventFeedDefinition definition = this.getSelectedDefinition();
            if (definition == null) {
                this.showMessage("Select an event feed to view");
                return;
            }
            EventFeedViewerFrame eventFeedViewerFrame = new EventFeedViewerFrame();
            eventFeedViewerFrame.setEventFeedDefinition(definition);
            eventFeedViewerFrame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string, "Event Feed Definitioin message", 1);
    }

    private EventFeedDefinition getSelectedDefinition() {
        int selectedIndex = this.eventFeedListBox.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        ElementId elementId = (ElementId)this.eventFeedListBox.getKeys()[selectedIndex];
        EventFeedDefinition definition = this.getContest().getEventFeedDefinition(elementId);
        return definition;
    }

    protected Object[] buildEventFeedDefRow(EventFeedDefinition definition) {
        int cols = this.eventFeedListBox.getColumnCount();
        Object[] s = new String[cols];
        s[0] = "STOPPED";
        if (definition.isActive()) {
            s[0] = "Running";
        }
        s[1] = Integer.toString(definition.getSiteNumber());
        s[2] = Integer.toString(definition.getPort());
        s[3] = definition.getDisplayName();
        s[4] = "None";
        return s;
    }

    public class AccountListenerImplementation
    implements IAccountListener {
        @Override
        public void accountAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountModified(AccountEvent accountEvent) {
            Account account = accountEvent.getAccount();
            if (EventFeedsPane.this.getContest().getClientId().equals(account.getClientId())) {
                EventFeedsPane.this.initializePermissions();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EventFeedsPane.this.updateGUIperPermissions();
                    }
                });
            }
        }

        @Override
        public void accountsAdded(AccountEvent accountEvent) {
        }

        @Override
        public void accountsModified(AccountEvent accountEvent) {
            Account[] accounts;
            Account[] accountArray = accounts = accountEvent.getAccounts();
            int n = accounts.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                if (EventFeedsPane.this.getContest().getClientId().equals(account.getClientId())) {
                    EventFeedsPane.this.initializePermissions();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EventFeedsPane.this.updateGUIperPermissions();
                        }
                    });
                }
                ++n2;
            }
        }

        @Override
        public void accountsRefreshAll(AccountEvent accountEvent) {
            EventFeedsPane.this.initializePermissions();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EventFeedsPane.this.updateGUIperPermissions();
                }
            });
        }
    }
}

