/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.exports.ccs.ResolverEventFeedXML;
import edu.csus.ecs.pc2.services.eventFeed.EventFeedServer;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EventFeedServerPane
extends JPanePlugin {
    private static final long serialVersionUID = 4739343418897893446L;
    public static final int DEFAULT_EVENT_FEED_PORT_NUMBER = 4713;
    private JPanel buttonPanel = null;
    private JButton startButton = null;
    private JButton stopButton = null;
    private JPanel centerPanel = null;
    private JLabel portLabel = null;
    private JTextField unFilteredPortTextField = null;
    private EventFeedServer eventFeedServer = new EventFeedServer();
    private JLabel eventFeedServerStatusLabel = null;
    private JButton viewButton = null;

    public EventFeedServerPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(505, 250));
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)this.getCenterPanel(), "Center");
        this.enableButtons();
    }

    @Override
    public String getPluginTitle() {
        return "Event Feed Server Pane";
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(25);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(flowLayout);
            this.buttonPanel.setPreferredSize(new Dimension(35, 35));
            this.buttonPanel.add((Component)this.getStartButton(), null);
            this.buttonPanel.add((Component)this.getStopButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getStartButton() {
        if (this.startButton == null) {
            this.startButton = new JButton();
            this.startButton.setText("Start");
            this.startButton.setMnemonic(83);
            this.startButton.setToolTipText("Start Event Feed Server");
            this.startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventFeedServerPane.this.startEventServer();
                }
            });
        }
        return this.startButton;
    }

    protected void startEventServer() {
        this.startEventServer(this.eventFeedServer, this.unFilteredPortTextField, false);
    }

    private void startEventServer(EventFeedServer server, JTextField textField, boolean filteredFeed) {
        if (textField.getText() == null) {
            this.showMessage("You must enter a port number");
            return;
        }
        if (textField.getText().length() == 0) {
            this.showMessage("You must enter a port number");
            return;
        }
        int port = Integer.parseInt(textField.getText());
        try {
            server.startSocketListener(port, this.getContest(), filteredFeed);
        }
        catch (IOException e) {
            this.showMessage("Unable to start: " + e.getMessage());
            e.printStackTrace();
            this.getLog().log(Log.INFO, e.getMessage(), e);
        }
        this.enableButtons();
    }

    private void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setText("Stop");
            this.stopButton.setMnemonic(84);
            this.stopButton.setToolTipText("Stop Event Feed Server");
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventFeedServerPane.this.stopEventServer();
                }
            });
        }
        return this.stopButton;
    }

    protected void stopEventServer() {
        if (this.eventFeedServer.isListening()) {
            try {
                this.eventFeedServer.halt();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.getLog().log(Log.INFO, e.getMessage(), e);
            }
        }
        if (!this.eventFeedServer.isListening()) {
            this.eventFeedServerStatusLabel.setText("Event Feed NOT running");
        }
        this.enableButtons();
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
            GridBagLayout gblCenterPanel = new GridBagLayout();
            int[] nArray = new int[4];
            nArray[0] = 198;
            nArray[1] = 57;
            nArray[2] = 167;
            gblCenterPanel.columnWidths = nArray;
            int[] nArray2 = new int[5];
            nArray2[0] = 36;
            nArray2[1] = 23;
            nArray2[2] = 32;
            nArray2[3] = 23;
            gblCenterPanel.rowHeights = nArray2;
            gblCenterPanel.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gblCenterPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.centerPanel.setLayout(gblCenterPanel);
            this.eventFeedServerStatusLabel = new JLabel();
            this.eventFeedServerStatusLabel.setFont(new Font("Dialog", 1, 14));
            this.eventFeedServerStatusLabel.setHorizontalAlignment(0);
            this.eventFeedServerStatusLabel.setText("Event Feed NOT running");
            GridBagConstraints gbcEventFeedServerStatusLabel = new GridBagConstraints();
            gbcEventFeedServerStatusLabel.fill = 1;
            gbcEventFeedServerStatusLabel.insets = new Insets(0, 0, 5, 0);
            gbcEventFeedServerStatusLabel.gridwidth = 3;
            gbcEventFeedServerStatusLabel.gridx = 0;
            gbcEventFeedServerStatusLabel.gridy = 0;
            this.centerPanel.add((Component)this.eventFeedServerStatusLabel, gbcEventFeedServerStatusLabel);
            this.portLabel = new JLabel();
            this.portLabel.setPreferredSize(new Dimension(52, 26));
            this.portLabel.setHorizontalAlignment(4);
            this.portLabel.setText("Event feed port");
            GridBagConstraints gbcportLabel = new GridBagConstraints();
            gbcportLabel.fill = 1;
            gbcportLabel.insets = new Insets(0, 0, 5, 5);
            gbcportLabel.gridx = 0;
            gbcportLabel.gridy = 1;
            this.centerPanel.add((Component)this.portLabel, gbcportLabel);
            GridBagConstraints gbcunFilteredPortTextField = new GridBagConstraints();
            gbcunFilteredPortTextField.fill = 2;
            gbcunFilteredPortTextField.insets = new Insets(0, 0, 5, 5);
            gbcunFilteredPortTextField.gridx = 1;
            gbcunFilteredPortTextField.gridy = 1;
            this.centerPanel.add((Component)this.getUnfilteredPortTextField(), gbcunFilteredPortTextField);
            GridBagConstraints gbcviewButton = new GridBagConstraints();
            gbcviewButton.anchor = 18;
            gbcviewButton.insets = new Insets(0, 0, 5, 0);
            gbcviewButton.gridx = 2;
            gbcviewButton.gridy = 1;
            this.centerPanel.add((Component)this.getViewButton(), gbcviewButton);
        }
        return this.centerPanel;
    }

    private JTextField getUnfilteredPortTextField() {
        if (this.unFilteredPortTextField == null) {
            this.unFilteredPortTextField = new JTextField();
            this.unFilteredPortTextField.setDocument(new IntegerDocument());
            this.unFilteredPortTextField.setText(Integer.toString(4713));
        }
        return this.unFilteredPortTextField;
    }

    private void enableButtons() {
        boolean serverRunning = this.eventFeedServer.isListening();
        this.getStartButton().setEnabled(!serverRunning);
        this.getStopButton().setEnabled(serverRunning);
        if (serverRunning) {
            this.eventFeedServerStatusLabel.setText("Event Feed server running");
        } else {
            this.eventFeedServerStatusLabel.setText("Event Feed server STOPPED");
        }
    }

    private JButton getViewButton() {
        if (this.viewButton == null) {
            this.viewButton = new JButton();
            this.viewButton.setToolTipText("Show a copy an event feed");
            this.viewButton.setText("View");
            this.viewButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventFeedServerPane.this.showEventFeedInViewer(false);
                }
            });
        }
        return this.viewButton;
    }

    private void showSnapshotOfEventViewer(boolean showFilteredFeed) {
        ResolverEventFeedXML eventFeedXML = new ResolverEventFeedXML();
        String eventFeed = null;
        if (!showFilteredFeed) {
            eventFeed = eventFeedXML.toXML(this.getContest());
        } else {
            ContestInformation info = this.getContest().getContestInformation();
            String freezeTime = info.getFreezeTime();
            long numberMinutesFreezeTime = this.parseFreezeTime(freezeTime);
            eventFeed = eventFeedXML.toXMLFreeze(this.getContest(), numberMinutesFreezeTime);
        }
        String[] lines = new String[]{eventFeed};
        MultipleFileViewer multipleFileViewer = new MultipleFileViewer(this.getController().getLog());
        multipleFileViewer.addTextintoPane("Event Feed", lines);
        multipleFileViewer.setTitle("PC^2 Event Feed at " + new Date());
        FrameUtilities.centerFrameFullScreenHeight(multipleFileViewer);
        multipleFileViewer.setVisible(true);
    }

    private long parseFreezeTime(String freezeTime) {
        if (freezeTime == null) {
            return 60L;
        }
        long seconds = Utilities.convertStringToSeconds(freezeTime);
        if (seconds == -1L) {
            return 60L;
        }
        return seconds / 60L;
    }

    protected void showEventFeedInViewer(boolean showFilteredFeed) {
        this.showSnapshotOfEventViewer(showFilteredFeed);
    }
}

