/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.execute.Executable;
import edu.csus.ecs.pc2.core.execute.ExecutionData;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunResultFiles;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.report.ExtractRuns;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.IFileViewer;
import edu.csus.ecs.pc2.ui.IntegerDocument;
import edu.csus.ecs.pc2.ui.JPanePlugin;
import edu.csus.ecs.pc2.ui.MultipleFileViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EditRunPane
extends JPanePlugin {
    private static final long serialVersionUID = 8747938709622932819L;
    private JPanel messagePane = null;
    private JPanel buttonPane = null;
    private JButton updateButton = null;
    private JButton cancelButton = null;
    private JLabel messageLabel = null;
    private Run run = null;
    private RunFiles runFiles = null;
    private JTabbedPane mainTabbedPane = null;
    private JPanel generalPane = null;
    private Log log = null;
    private JButton executeButton = null;
    private JButton viewSourceButton = null;
    private JButton extractButton = null;
    private Executable executable;
    private JComboBox<Judgement> judgementComboBox = null;
    private JLabel runInfoLabel = null;
    private JCheckBox deleteCheckBox = null;
    private JLabel judgementLabel = null;
    private JLabel statusLabel = null;
    private JLabel statusTitleLabel = null;
    private JComboBox<Problem> problemComboBox = null;
    private JComboBox<Language> languageComboBox = null;
    private JLabel problemLabel = null;
    private JLabel languageLabel = null;
    private JLabel jLabel = null;
    private JTextField elapsedTimeTextField = null;
    private IFileViewer sourceViewer;
    private JCheckBox notifyTeamCheckBox = null;
    private boolean populatingGUI = true;
    private ExtractRuns extractRuns;

    public EditRunPane() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(536, 307));
        this.add((Component)this.getMessagePane(), "North");
        this.add((Component)this.getButtonPane(), "South");
        this.add((Component)this.getMainTabbedPane(), "East");
        this.add((Component)this.getGeneralPane(), "Center");
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        super.setContestAndController(inContest, inController);
        this.log = this.getController().getLog();
        this.addWindowCloserListener();
        this.extractRuns = new ExtractRuns(inContest);
    }

    private void addWindowCloserListener() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EditRunPane.this.getParentFrame() != null) {
                    EditRunPane.this.getParentFrame().addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            EditRunPane.this.handleCancelButton();
                        }
                    });
                }
            }
        });
    }

    @Override
    public String getPluginTitle() {
        return "Edit Run Pane";
    }

    private JPanel getMessagePane() {
        if (this.messagePane == null) {
            this.messageLabel = new JLabel();
            this.messageLabel.setText("");
            this.messageLabel.setFont(new Font("Dialog", 1, 14));
            this.messageLabel.setHorizontalAlignment(0);
            this.messagePane = new JPanel();
            this.messagePane.setLayout(new BorderLayout());
            this.messagePane.setPreferredSize(new Dimension(35, 35));
            this.messagePane.add((Component)this.messageLabel, "Center");
        }
        return this.messagePane;
    }

    private JPanel getButtonPane() {
        if (this.buttonPane == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(15);
            this.buttonPane = new JPanel();
            this.buttonPane.setLayout(flowLayout);
            this.buttonPane.add((Component)this.getUpdateButton(), null);
            this.buttonPane.add((Component)this.getViewSourceButton(), null);
            this.buttonPane.add((Component)this.getExecuteButton(), null);
            this.buttonPane.add((Component)this.getExtractButton(), null);
            this.buttonPane.add((Component)this.getCancelButton(), null);
        }
        return this.buttonPane;
    }

    private Run getRunFromFields() {
        return this.run;
    }

    private JButton getUpdateButton() {
        if (this.updateButton == null) {
            this.updateButton = new JButton();
            this.updateButton.setText("Update");
            this.updateButton.setEnabled(false);
            this.updateButton.setMnemonic(85);
            this.updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRunPane.this.updateRun();
                }
            });
        }
        return this.updateButton;
    }

    protected void updateRun() {
        ElementId languageId;
        Run newRun = this.getRunFromFields();
        this.cancelButton.setText("Close");
        this.updateButton.setEnabled(false);
        JudgementRecord judgementRecord = null;
        RunResultFiles runResultFiles = null;
        if (this.judgementChanged()) {
            newRun.setStatus(Run.RunStates.JUDGED);
            boolean solved = this.getJudgementComboBox().getSelectedIndex() == 0;
            Judgement judgement = (Judgement)this.getJudgementComboBox().getSelectedItem();
            judgementRecord = new JudgementRecord(judgement.getElementId(), this.getContest().getClientId(), solved, false);
            judgementRecord.setSendToTeam(this.getNotifyTeamCheckBox().isSelected());
        }
        newRun.setDeleted(this.deleteCheckBox.isSelected());
        int elapsed = this.getIntegerValue(this.getElapsedTimeTextField().getText());
        newRun.setElapsedMins(elapsed);
        ElementId problemId = ((Problem)this.getProblemComboBox().getSelectedItem()).getElementId();
        if (problemId != null) {
            this.run.setProblemId(problemId);
        }
        if ((languageId = ((Language)this.getLanguageComboBox().getSelectedItem()).getElementId()) != null) {
            this.run.setLanguageId(languageId);
        }
        newRun.setProblemId(problemId);
        ExecutionData executionData = null;
        if (this.executable != null) {
            executionData = this.executable.getExecutionData();
        }
        runResultFiles = new RunResultFiles(newRun, newRun.getProblemId(), judgementRecord, executionData);
        this.getController().updateRun(newRun, judgementRecord, runResultFiles);
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setText("Cancel");
            this.cancelButton.setMnemonic(67);
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRunPane.this.handleCancelButton();
                }
            });
        }
        return this.cancelButton;
    }

    public void handleCancelButton() {
        if (this.getUpdateButton().isEnabled()) {
            int result = FrameUtilities.yesNoCancelDialog(this.getParentFrame(), "Run modified, save changes?", "Confirm Choice");
            if (result == 0) {
                this.updateRun();
                if (this.getParentFrame() != null) {
                    this.getParentFrame().setVisible(false);
                }
            }
            if (result == 1 && this.getParentFrame() != null) {
                this.getParentFrame().setVisible(false);
            }
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
    }

    public Run getRun() {
        return this.run;
    }

    public void setRun(final Run run) {
        this.run = run;
        this.showMessage("Waiting for run...");
        FrameUtilities.waitCursor(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditRunPane.this.populateGUI(run);
                EditRunPane.this.enableUpdateButtons(false);
            }
        });
    }

    private void populateGUI(Run run2) {
        this.populatingGUI = true;
        if (run2 != null) {
            this.getUpdateButton().setVisible(true);
            ClientId id = run2.getSubmitter();
            String teamName = id.getName();
            this.runInfoLabel.setText("Run " + run2.getNumber() + " (Site " + run2.getSiteNumber() + ") from " + teamName);
            this.deleteCheckBox.setSelected(run2.isDeleted());
            this.statusLabel.setText(this.run.getStatus().toString());
            this.elapsedTimeTextField.setText(new Long(this.run.getElapsedMins()).toString());
            this.getNotifyTeamCheckBox().setSelected(this.notifyTeam());
        } else {
            this.getUpdateButton().setVisible(false);
            this.runInfoLabel.setText("Could not get run");
            this.deleteCheckBox.setSelected(false);
            this.statusLabel.setText("");
            this.elapsedTimeTextField.setText("");
            this.getNotifyTeamCheckBox().setSelected(false);
        }
        this.populateComboBoxes();
        this.populatingGUI = false;
    }

    private void populateComboBoxes() {
        int selectedIndex = -1;
        int index = 0;
        this.getProblemComboBox().removeAllItems();
        this.getLanguageComboBox().removeAllItems();
        this.getJudgementComboBox().removeAllItems();
        if (this.run == null) {
            return;
        }
        IElementObject[] iElementObjectArray = this.getContest().getProblems();
        int n = iElementObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = iElementObjectArray[n2];
            this.getProblemComboBox().addItem(problem);
            if (problem.getElementId().equals(this.run.getProblemId())) {
                selectedIndex = index;
            }
            ++index;
            ++n2;
        }
        this.getProblemComboBox().setSelectedIndex(selectedIndex);
        selectedIndex = -1;
        index = 0;
        iElementObjectArray = this.getContest().getLanguages();
        n = iElementObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            IElementObject language = iElementObjectArray[n2];
            this.getLanguageComboBox().addItem((Language)language);
            if (((Language)language).getElementId().equals(this.run.getLanguageId())) {
                selectedIndex = index;
            }
            ++index;
            ++n2;
        }
        this.getLanguageComboBox().setSelectedIndex(selectedIndex);
        selectedIndex = -1;
        index = 0;
        ElementId judgementId = null;
        if (this.run.isJudged()) {
            judgementId = this.run.getJudgementRecord().getJudgementId();
        }
        Judgement[] judgementArray = this.getContest().getJudgements();
        int n3 = judgementArray.length;
        n = 0;
        while (n < n3) {
            Judgement judgement = judgementArray[n];
            this.getJudgementComboBox().addItem(judgement);
            if (judgement.getElementId().equals(judgementId)) {
                selectedIndex = index;
            }
            ++index;
            ++n;
        }
        this.getJudgementComboBox().setSelectedIndex(selectedIndex);
    }

    protected void enableUpdateButtons(boolean editedText) {
        if (editedText) {
            this.cancelButton.setText("Cancel");
        } else {
            this.cancelButton.setText("Close");
        }
        this.getExecuteButton().setEnabled(this.runFiles != null);
        this.getExecuteButton().setEnabled(this.runFiles != null);
        this.getViewSourceButton().setEnabled(this.runFiles != null);
        this.updateButton.setEnabled(editedText);
    }

    private int getIntegerValue(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void enableUpdateButton() {
        if (this.populatingGUI) {
            return;
        }
        boolean enableButton = false;
        if (this.run != null) {
            int elapsed = this.getIntegerValue(this.getElapsedTimeTextField().getText());
            enableButton |= (long)elapsed != this.run.getElapsedMins();
            ElementId problemId = ((Problem)this.getProblemComboBox().getSelectedItem()).getElementId();
            enableButton |= !this.run.getProblemId().equals(problemId);
            ElementId languageId = ((Language)this.getLanguageComboBox().getSelectedItem()).getElementId();
            enableButton |= !this.run.getLanguageId().equals(languageId);
            enableButton |= this.run.isDeleted() ^ this.getDeleteCheckBox().isSelected();
            enableButton |= this.judgementChanged();
            enableButton |= this.notifyTeamChanged();
        }
        this.getUpdateButton().setEnabled(enableButton);
    }

    private boolean judgementChanged() {
        if (this.run.isJudged()) {
            if (this.notifyTeamChanged()) {
                return true;
            }
            Judgement judgement = (Judgement)this.getJudgementComboBox().getSelectedItem();
            if (judgement != null) {
                return !this.run.getJudgementRecord().getJudgementId().equals(judgement.getElementId());
            }
        } else if (this.getJudgementComboBox().getSelectedIndex() > -1) {
            return true;
        }
        return false;
    }

    private boolean notifyTeam() {
        JudgementRecord judgementRecord;
        if (this.run.isJudged() && (judgementRecord = this.run.getJudgementRecord()) != null) {
            return judgementRecord.isSendToTeam();
        }
        return false;
    }

    private boolean notifyTeamChanged() {
        return this.notifyTeam() ^ this.getNotifyTeamCheckBox().isSelected();
    }

    private JTabbedPane getMainTabbedPane() {
        if (this.mainTabbedPane == null) {
            this.mainTabbedPane = new JTabbedPane();
        }
        return this.mainTabbedPane;
    }

    private JPanel getGeneralPane() {
        if (this.generalPane == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(new Rectangle(73, 67, 142, 16));
            this.jLabel.setText("Elapsed");
            this.jLabel.setHorizontalAlignment(4);
            this.languageLabel = new JLabel();
            this.languageLabel.setBounds(new Rectangle(73, 166, 142, 16));
            this.languageLabel.setText("Language");
            this.languageLabel.setHorizontalAlignment(4);
            this.problemLabel = new JLabel();
            this.problemLabel.setBounds(new Rectangle(73, 133, 142, 16));
            this.problemLabel.setText("Problem");
            this.problemLabel.setHorizontalAlignment(4);
            this.statusTitleLabel = new JLabel();
            this.statusTitleLabel.setBounds(new Rectangle(73, 35, 142, 19));
            this.statusTitleLabel.setHorizontalAlignment(4);
            this.statusTitleLabel.setText("Status");
            this.statusLabel = new JLabel();
            this.statusLabel.setBounds(new Rectangle(224, 35, 271, 19));
            this.statusLabel.setText("JLabel");
            this.judgementLabel = new JLabel();
            this.judgementLabel.setBounds(new Rectangle(73, 99, 142, 19));
            this.judgementLabel.setHorizontalAlignment(4);
            this.judgementLabel.setText("Judgement");
            this.runInfoLabel = new JLabel();
            this.runInfoLabel.setBounds(new Rectangle(6, -1, 511, 25));
            this.runInfoLabel.setHorizontalAlignment(0);
            this.runInfoLabel.setFont(new Font("Dialog", 1, 14));
            this.runInfoLabel.setText("Run Info");
            this.generalPane = new JPanel();
            this.generalPane.setLayout(null);
            this.generalPane.add(this.getJudgementComboBox(), null);
            this.generalPane.add((Component)this.runInfoLabel, null);
            this.generalPane.add((Component)this.getDeleteCheckBox(), null);
            this.generalPane.add((Component)this.judgementLabel, null);
            this.generalPane.add((Component)this.statusLabel, null);
            this.generalPane.add((Component)this.statusTitleLabel, null);
            this.generalPane.add(this.getProblemComboBox(), null);
            this.generalPane.add(this.getLanguageComboBox(), null);
            this.generalPane.add((Component)this.problemLabel, null);
            this.generalPane.add((Component)this.languageLabel, null);
            this.generalPane.add((Component)this.jLabel, null);
            this.generalPane.add((Component)this.getElapsedTimeTextField(), null);
            this.generalPane.add((Component)this.getNotifyTeamCheckBox(), null);
        }
        return this.generalPane;
    }

    public void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditRunPane.this.messageLabel.setText(message);
            }
        });
    }

    private JButton getExecuteButton() {
        if (this.executeButton == null) {
            this.executeButton = new JButton();
            this.executeButton.setText("Execute");
            this.executeButton.setMnemonic(88);
            this.executeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            EditRunPane.this.executeRun();
                        }
                    }).start();
                }
            });
        }
        return this.executeButton;
    }

    private JButton getViewSourceButton() {
        if (this.viewSourceButton == null) {
            this.viewSourceButton = new JButton();
            this.viewSourceButton.setText("View Source");
            this.viewSourceButton.setMnemonic(86);
            this.viewSourceButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRunPane.this.viewSourceFile();
                }
            });
        }
        return this.viewSourceButton;
    }

    protected void viewSourceFile() {
        this.createAndViewFile(this.runFiles.getMainFile(), "Team's source");
    }

    private JButton getExtractButton() {
        if (this.extractButton == null) {
            this.extractButton = new JButton();
            this.extractButton.setText("Extract");
            this.extractButton.setToolTipText("Extract Run contents");
            this.extractButton.setMnemonic(84);
            this.extractButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRunPane.this.extractRun();
                }
            });
        }
        return this.extractButton;
    }

    protected void extractRun() {
        try {
            boolean extracted = this.extractRuns.extractRun(this.getRun().getElementId());
            if (extracted) {
                JOptionPane.showMessageDialog(this, "Extracted 1 run to \"extract\" dir.");
            } else {
                JOptionPane.showMessageDialog(this, "Problem extracting run.");
            }
        }
        catch (IOException e) {
            this.log.throwing("RunPane", "extractRun", e);
            this.showMessage("Problem extracting run.");
        }
        catch (ClassNotFoundException e) {
            JOptionPane.showMessageDialog(this, "Problem extracting run. " + e.getMessage());
            e.printStackTrace();
        }
        catch (FileSecurityException e) {
            JOptionPane.showMessageDialog(this, "Problem extracting run. " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void executeRun() {
        System.gc();
        this.executable = new Executable(this.getContest(), this.getController(), this.run, this.runFiles);
        IFileViewer fileViewer = this.executable.execute();
        fileViewer.setVisible(true);
    }

    public void setRunAndFiles(Run run2, RunFiles runFiles2) {
        FrameUtilities.regularCursor(this);
        this.showMessage("");
        this.log.info("Fetched run " + run2 + " to edit");
        this.run = run2;
        this.runFiles = runFiles2;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditRunPane.this.populateGUI(EditRunPane.this.run);
                EditRunPane.this.enableUpdateButtons(false);
            }
        });
    }

    private JComboBox<Judgement> getJudgementComboBox() {
        if (this.judgementComboBox == null) {
            this.judgementComboBox = new JComboBox();
            this.judgementComboBox.setLocation(new Point(224, 97));
            this.judgementComboBox.setSize(new Dimension(263, 22));
            this.judgementComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRunPane.this.enableUpdateButton();
                }
            });
        }
        return this.judgementComboBox;
    }

    private JCheckBox getDeleteCheckBox() {
        if (this.deleteCheckBox == null) {
            this.deleteCheckBox = new JCheckBox();
            this.deleteCheckBox.setBounds(new Rectangle(224, 196, 114, 21));
            this.deleteCheckBox.setText("Delete Run");
            this.deleteCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRunPane.this.enableUpdateButton();
                }
            });
        }
        return this.deleteCheckBox;
    }

    private JComboBox<Problem> getProblemComboBox() {
        if (this.problemComboBox == null) {
            this.problemComboBox = new JComboBox();
            this.problemComboBox.setBounds(new Rectangle(224, 130, 263, 22));
            this.problemComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRunPane.this.enableUpdateButton();
                }
            });
        }
        return this.problemComboBox;
    }

    private JComboBox<Language> getLanguageComboBox() {
        if (this.languageComboBox == null) {
            this.languageComboBox = new JComboBox();
            this.languageComboBox.setBounds(new Rectangle(224, 163, 263, 22));
            this.languageComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRunPane.this.enableUpdateButton();
                }
            });
        }
        return this.languageComboBox;
    }

    private JTextField getElapsedTimeTextField() {
        if (this.elapsedTimeTextField == null) {
            this.elapsedTimeTextField = new JTextField();
            this.elapsedTimeTextField.setBounds(new Rectangle(224, 65, 65, 21));
            this.elapsedTimeTextField.setDocument(new IntegerDocument());
            this.elapsedTimeTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    EditRunPane.this.enableUpdateButton();
                }
            });
        }
        return this.elapsedTimeTextField;
    }

    private void createAndViewFile(SerializedFile file, String title) {
        Executable tempEexecutable = new Executable(this.getContest(), this.getController(), this.run, this.runFiles);
        String targetDirectory = tempEexecutable.getExecuteDirectoryName();
        Utilities.insureDir(targetDirectory);
        String targetFileName = String.valueOf(targetDirectory) + File.separator + file.getName();
        this.showMessage("Create: " + targetFileName);
        try {
            file.writeFile(targetFileName);
            if (this.sourceViewer != null) {
                this.sourceViewer.dispose();
            }
            this.sourceViewer = new MultipleFileViewer(this.getController().getLog());
            if (new File(targetFileName).isFile()) {
                this.sourceViewer.addFilePane(title, targetFileName);
                this.sourceViewer.setVisible(true);
            } else {
                this.sourceViewer.addTextPane(title, "Could not create file at " + targetFileName);
                this.sourceViewer.setVisible(true);
            }
        }
        catch (IOException e) {
            this.sourceViewer.addTextPane(title, "Could not create file at " + targetFileName + "Exception " + e.getMessage());
            this.sourceViewer.setVisible(true);
        }
    }

    private JCheckBox getNotifyTeamCheckBox() {
        if (this.notifyTeamCheckBox == null) {
            this.notifyTeamCheckBox = new JCheckBox();
            this.notifyTeamCheckBox.setBounds(new Rectangle(347, 197, 134, 19));
            this.notifyTeamCheckBox.setSelected(false);
            this.notifyTeamCheckBox.setText("Notify Team");
            this.notifyTeamCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditRunPane.this.enableUpdateButton();
                }
            });
        }
        return this.notifyTeamCheckBox;
    }
}

