/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.ui;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.ui.EditRunPane;
import edu.csus.ecs.pc2.ui.FrameUtilities;
import edu.csus.ecs.pc2.ui.UIPlugin;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class EditRunFrame
extends JFrame
implements UIPlugin {
    private static final long serialVersionUID = 6716035052687410328L;
    private IInternalContest contest;
    private IInternalController controller;
    private EditRunPane runPane = null;
    private Run run = null;

    public EditRunFrame() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(new Dimension(549, 329));
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.getRunPane());
        this.setTitle("New Run");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditRunFrame.this.getRunPane().handleCancelButton();
            }
        });
        FrameUtilities.centerFrame(this);
    }

    @Override
    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.getRunPane().setContestAndController(this.contest, this.controller);
        this.getRunPane().setParentFrame(this);
        this.contest.addRunListener(new RunListenerImplementation());
    }

    public void setRun(Run theRun) {
        if (theRun == null) {
            this.setTitle("Add New Run");
        } else {
            String seqNumber = "";
            if (theRun.getPlaybackSequenceNumber() > 0) {
                seqNumber = " Playback Seq " + this.run.getPlaybackSequenceNumber();
            }
            this.setTitle("Edit Run " + theRun.getNumber() + " (Site " + theRun.getSiteNumber() + ")" + seqNumber);
            this.run = theRun;
            this.controller.checkOutRun(theRun, true, false);
        }
        this.getRunPane().setRun(theRun);
    }

    @Override
    public String getPluginTitle() {
        return "Edit Run Frame";
    }

    private EditRunPane getRunPane() {
        if (this.runPane == null) {
            this.runPane = new EditRunPane();
        }
        return this.runPane;
    }

    public class RunListenerImplementation
    implements IRunListener {
        @Override
        public void runAdded(RunEvent event) {
        }

        @Override
        public void refreshRuns(RunEvent event) {
        }

        @Override
        public void runChanged(RunEvent event) {
            if (EditRunFrame.this.run != null && event.getRun().getElementId().equals(EditRunFrame.this.run.getElementId())) {
                if (event.getAction().equals((Object)RunEvent.Action.RUN_NOT_AVAILABLE)) {
                    EditRunFrame.this.getRunPane().showMessage("Run " + EditRunFrame.this.run.getNumber() + " not available ");
                } else {
                    EditRunFrame.this.getRunPane().setRunAndFiles(event.getRun(), event.getRunFiles());
                }
            }
        }

        @Override
        public void runRemoved(RunEvent event) {
        }
    }
}

